#
# TABLE STRUCTURE FOR: QR_code_settings
#

DROP TABLE IF EXISTS `QR_code_settings`;

CREATE TABLE `QR_code_settings` (
  `id` int NOT NULL,
  `camera_type` varchar(15) DEFAULT NULL,
  `auto_attendance` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

INSERT INTO `QR_code_settings` (`id`, `camera_type`, `auto_attendance`, `created_at`) VALUES (1, 'environment', 1, '2024-09-30 09:50:28');


#
# TABLE STRUCTURE FOR: addon_versions
#

DROP TABLE IF EXISTS `addon_versions`;

CREATE TABLE `addon_versions` (
  `id` int NOT NULL AUTO_INCREMENT,
  `addon_id` int DEFAULT NULL,
  `version` varchar(10) DEFAULT NULL,
  `version_order` int DEFAULT NULL,
  `folder_path` text,
  `sort_description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `addon_id` (`addon_id`),
  CONSTRAINT `addon_versions_ibfk_1` FOREIGN KEY (`addon_id`) REFERENCES `addons` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: addons
#

DROP TABLE IF EXISTS `addons`;

CREATE TABLE `addons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `image` text NOT NULL,
  `name` varchar(500) DEFAULT NULL,
  `config_name` varchar(200) NOT NULL DEFAULT '',
  `short_name` varchar(100) NOT NULL,
  `directory` varchar(500) NOT NULL,
  `description` text,
  `price` float(10,2) NOT NULL DEFAULT '0.00',
  `current_version` varchar(50) DEFAULT NULL,
  `article_link` text NOT NULL,
  `installation_by` int DEFAULT NULL,
  `uninstall_version` varchar(50) DEFAULT NULL,
  `unistall_by` int DEFAULT NULL,
  `addon_prod` text,
  `addon_ver` text,
  `last_update` datetime DEFAULT NULL,
  `current_stage` int NOT NULL DEFAULT '0' COMMENT '0 for buy addon,1 for folder available ready to install,2 for folder addon installed',
  `product_order` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (1, 50336584, 'uploads/addon_images/shqra_images.jpeg', 'Smart Hospital Multi Branch', 'qrattendance-config', 'shqra', 'qr_code_attendance', 'Multi Branch addon adds Multi Branch module in Smart Hospital. Using this module Superadmin user can add other any number of hospital/branches.', '0.00', '1.0', 'https://go.smart-hospital.in/qr-attendance', 1, '1.0', 1, NULL, NULL, '2025-04-17 12:36:55', 0, 1, '2025-01-13 13:10:06', '2025-04-17 07:06:55');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (2, 44278049, 'uploads/addon_images/shtfa_images.jpeg', 'Smart Hospital Two Factor Authentication', 'google-authenticate-config', 'shtfa', 'two_factor_authentication', 'Two Factor Authentication addon adds Two Factor Authentication module in Smart Hospital. Using this module you can enhance login security of your Smart Hospital users.', '0.00', '1.0', 'https://go.smart-hospital.in/2fa', 1, '1.0', 1, NULL, NULL, '2025-04-08 15:25:34', 0, 2, '2024-09-07 10:45:18', '2025-04-10 10:17:00');
INSERT INTO `addons` (`id`, `product_id`, `image`, `name`, `config_name`, `short_name`, `directory`, `description`, `price`, `current_version`, `article_link`, `installation_by`, `uninstall_version`, `unistall_by`, `addon_prod`, `addon_ver`, `last_update`, `current_stage`, `product_order`, `created_at`, `updated_at`) VALUES (3, 44277916, 'uploads/addon_images/shmb_images.jpeg', 'Smart Hospital Multi Branch', 'multibranch-config', 'shmb', 'multi_branch', 'Multi Branch addon adds Multi Branch module in Smart Hospital. Using this module Superadmin user can add other any number of hospital/branches.', '0.00', '1.0', 'https://go.smart-hospital.in/multi-branch', 1, '1.0', NULL, NULL, NULL, '2025-04-17 12:37:02', 0, 3, '2024-09-07 10:45:18', '2025-04-17 07:07:02');


#
# TABLE STRUCTURE FOR: ambulance_call
#

DROP TABLE IF EXISTS `ambulance_call`;

CREATE TABLE `ambulance_call` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int NOT NULL,
  `case_reference_id` int DEFAULT NULL,
  `vehicle_id` int DEFAULT NULL,
  `contact_no` varchar(20) DEFAULT NULL,
  `address` text,
  `vehicle_model` varchar(20) DEFAULT NULL,
  `driver` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `call_from` varchar(200) NOT NULL,
  `call_to` varchar(200) NOT NULL,
  `charge_category_id` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `standard_charge` int DEFAULT NULL,
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `discount` float(10,2) DEFAULT '0.00',
  `tax_percentage` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT '0.00',
  `net_amount` float(10,2) DEFAULT NULL,
  `transaction_id` int DEFAULT NULL,
  `note` text,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `vehicle_id` (`vehicle_id`),
  KEY `generated_by` (`generated_by`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `transaction_id` (`transaction_id`),
  KEY `charge_id` (`charge_id`),
  KEY `idx_contact_no` (`contact_no`),
  KEY `idx_vehicle_model` (`vehicle_model`),
  KEY `idx_driver` (`driver`),
  KEY `index_date` (`date`),
  KEY `index_call_from` (`call_from`),
  KEY `index_call_to` (`call_to`),
  KEY `index_charge_category_id` (`charge_category_id`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_discount` (`discount`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_net_amount` (`net_amount`),
  CONSTRAINT `ambulance_call_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_2` FOREIGN KEY (`vehicle_id`) REFERENCES `vehicles` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_4` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ambulance_call_ibfk_5` FOREIGN KEY (`transaction_id`) REFERENCES `transactions` (`id`) ON DELETE SET NULL,
  CONSTRAINT `ambulance_call_ibfk_6` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ambulance_call` (`id`, `patient_id`, `case_reference_id`, `vehicle_id`, `contact_no`, `address`, `vehicle_model`, `driver`, `date`, `call_from`, `call_to`, `charge_category_id`, `charge_id`, `standard_charge`, `discount_percentage`, `discount`, `tax_percentage`, `amount`, `net_amount`, `transaction_id`, `note`, `generated_by`, `created_at`) VALUES (50, 7, NULL, 9, NULL, NULL, NULL, 'test', '2025-03-08 16:14:00', '', '', NULL, 4, 150, '0.00', '0.00', '18.00', '150.00', '177.00', 675, '', 1, '2025-03-08 10:44:09');


#
# TABLE STRUCTURE FOR: annual_calendar
#

DROP TABLE IF EXISTS `annual_calendar`;

CREATE TABLE `annual_calendar` (
  `id` int NOT NULL AUTO_INCREMENT,
  `holiday_type` int NOT NULL COMMENT '1 for holiday , 2 for activity , 3 for vacation',
  `from_date` datetime DEFAULT NULL,
  `to_date` datetime DEFAULT NULL,
  `description` text NOT NULL COMMENT 'Holiday Description',
  `is_active` int NOT NULL DEFAULT '1' COMMENT '1 for active 0 for inactive',
  `holiday_color` varchar(200) NOT NULL,
  `front_site` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_holiday_type` (`holiday_type`),
  KEY `idx_created_by` (`created_by`),
  KEY `index_from_date` (`from_date`) USING BTREE,
  KEY `index_to_date` (`to_date`) USING BTREE,
  CONSTRAINT `annual_calendar_ibfk_1` FOREIGN KEY (`created_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3;

INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (1, 1, '2024-09-18 00:00:00', '2024-09-18 23:59:00', 'Ganesh Chaturthi (guh-NESH cha-TUR-thee) is a festival that pays homage to Lord Ganesh, the remover of obstacles, and celebrates the day of his birth.', 1, '#008000', 1, 1, '2024-09-27 15:19:09', NULL);
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (2, 2, '2024-09-27 00:00:00', '2024-09-27 23:59:00', 'Hospital Activities means any activities that received direct or indirect financial support from the Hospital, including Hospital salary support or funding from any outside source awarded to or administered by the Hospital; made substantial use of any space, facilities, materials or other resources of the Hospital', 1, '#008000', 1, 2, '2024-09-28 12:31:25', '2024-09-28');
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (3, 3, '2024-09-23 00:00:00', '2024-09-27 23:59:00', 'Hospital Activities means any activities that received direct or indirect financial support from the Hospital', 1, '#008000', 1, 2, '2024-09-28 18:01:20', NULL);
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (4, 1, '2024-10-02 00:00:00', '2024-10-02 23:59:00', 'gandhi jyanti is a hodiday', 1, '#008000', 0, 1, '2024-09-30 12:16:04', '2024-09-30');
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (5, 1, '2024-10-12 00:00:00', '2024-10-12 23:59:00', 'Dasherra in navratri', 1, '#008000', 1, 1, '2024-10-11 16:20:28', NULL);
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (10, 1, '2025-03-03 00:00:00', '2025-03-03 23:59:00', 'add', 1, '#008000', 0, 1, '2025-03-03 14:07:58', NULL);
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (13, 1, '2025-04-08 00:00:00', '2025-04-08 23:59:00', 'add', 1, '#008000', 1, 1, '2025-04-08 14:48:13', NULL);
INSERT INTO `annual_calendar` (`id`, `holiday_type`, `from_date`, `to_date`, `description`, `is_active`, `holiday_color`, `front_site`, `created_by`, `created_at`, `updated_at`) VALUES (14, 2, '2025-04-16 00:00:00', '2025-04-16 23:59:00', '43443', 1, '#008000', 0, 1, '2025-04-16 15:16:17', NULL);


#
# TABLE STRUCTURE FOR: antenatal_examine
#

DROP TABLE IF EXISTS `antenatal_examine`;

CREATE TABLE `antenatal_examine` (
  `id` int NOT NULL AUTO_INCREMENT,
  `primary_examine_id` int NOT NULL,
  `visit_details_id` int DEFAULT NULL,
  `ipdid` int DEFAULT NULL,
  `uter_size` varchar(250) DEFAULT NULL,
  `uterus_size` varchar(250) DEFAULT NULL,
  `presentation_position` varchar(250) DEFAULT NULL,
  `brim_presentation` varchar(250) DEFAULT NULL,
  `foeta_heart` varchar(250) DEFAULT NULL,
  `blood_pressure` varchar(250) DEFAULT NULL,
  `antenatal_oedema` varchar(250) DEFAULT NULL,
  `antenatal_weight` varchar(250) DEFAULT NULL,
  `urine_sugar` varchar(250) DEFAULT NULL,
  `urine` varchar(250) DEFAULT NULL,
  `remark` text,
  `next_visit` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipdid` (`ipdid`),
  KEY `index_uter_size` (`uter_size`),
  KEY `index_uterus_size` (`uterus_size`),
  KEY `index_presentation_position` (`presentation_position`),
  KEY `index_brim_presentation` (`brim_presentation`),
  KEY `index_foeta_heart` (`foeta_heart`),
  KEY `index_blood_pressure` (`blood_pressure`),
  KEY `index_antenatal_oedema` (`antenatal_oedema`),
  KEY `index_antenatal_weight` (`antenatal_weight`),
  KEY `index_urine_sugar` (`urine_sugar`),
  KEY `index_urine` (`urine`),
  KEY `primary_examine_id` (`primary_examine_id`),
  CONSTRAINT `antenatal_examine_ibfk_1` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `antenatal_examine_ibfk_2` FOREIGN KEY (`ipdid`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `antenatal_examine_ibfk_3` FOREIGN KEY (`primary_examine_id`) REFERENCES `primary_examine` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb3;

INSERT INTO `antenatal_examine` (`id`, `primary_examine_id`, `visit_details_id`, `ipdid`, `uter_size`, `uterus_size`, `presentation_position`, `brim_presentation`, `foeta_heart`, `blood_pressure`, `antenatal_oedema`, `antenatal_weight`, `urine_sugar`, `urine`, `remark`, `next_visit`, `created_at`) VALUES (54, 54, 116, NULL, '', '', '', '', '', '', '', '', '', '', '', '', '2024-11-25 06:16:07');
INSERT INTO `antenatal_examine` (`id`, `primary_examine_id`, `visit_details_id`, `ipdid`, `uter_size`, `uterus_size`, `presentation_position`, `brim_presentation`, `foeta_heart`, `blood_pressure`, `antenatal_oedema`, `antenatal_weight`, `urine_sugar`, `urine`, `remark`, `next_visit`, `created_at`) VALUES (65, 65, 202, NULL, '', '', '', '', '', '', '', '', '', '', '', '', '2025-03-07 11:44:54');
INSERT INTO `antenatal_examine` (`id`, `primary_examine_id`, `visit_details_id`, `ipdid`, `uter_size`, `uterus_size`, `presentation_position`, `brim_presentation`, `foeta_heart`, `blood_pressure`, `antenatal_oedema`, `antenatal_weight`, `urine_sugar`, `urine`, `remark`, `next_visit`, `created_at`) VALUES (66, 66, 222, NULL, '', '', '', '', '', '', '', '', '', '', '', '', '2025-03-12 05:37:42');


#
# TABLE STRUCTURE FOR: appoint_priority
#

DROP TABLE IF EXISTS `appoint_priority`;

CREATE TABLE `appoint_priority` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appoint_priority` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_appoint_priority` (`appoint_priority`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;

INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (6, 'very low', '2024-11-20 08:04:51');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (8, 'Low', '2024-11-20 08:05:37');
INSERT INTO `appoint_priority` (`id`, `appoint_priority`, `created_at`) VALUES (11, 'priority', '2025-04-10 10:46:16');


#
# TABLE STRUCTURE FOR: appointment
#

DROP TABLE IF EXISTS `appointment`;

CREATE TABLE `appointment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `visit_details_id` int DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `priority` varchar(100) NOT NULL,
  `specialist` varchar(100) NOT NULL,
  `doctor` int DEFAULT NULL,
  `amount` varchar(200) NOT NULL,
  `message` text,
  `appointment_status` varchar(11) DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `is_opd` varchar(10) NOT NULL,
  `is_ipd` varchar(10) NOT NULL,
  `doctor_shift_time_id` int DEFAULT NULL,
  `doctor_global_shift_id` int DEFAULT NULL,
  `is_queue` int DEFAULT NULL,
  `created_time` datetime DEFAULT NULL,
  `rejected_time` datetime DEFAULT NULL,
  `live_consult` varchar(50) DEFAULT NULL,
  `live_consult_link` int NOT NULL DEFAULT '1' COMMENT '1 (link created) 0 (not created)',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `created_by` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `doctor` (`doctor`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `doctor_shift_time_id` (`doctor_shift_time_id`),
  CONSTRAINT `appointment_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_2` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_4` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_ibfk_5` FOREIGN KEY (`doctor_shift_time_id`) REFERENCES `doctor_shift_time` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1233 DEFAULT CHARSET=utf8mb3;

INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (4, 3, 10, 10, '2024-10-08 17:31:00', '1', '4', 2, '', '', 'approved', 'Online', '', '', 2, 1, 0, '2024-09-28 15:32:15', '2024-09-28 15:42:15', 'no', 0, '2024-09-28 10:02:15', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (24, 6, 25, 24, '2024-10-08 17:31:00', '2', '4', 2, '', '', 'approved', 'Offline', '', '', 2, 1, 0, NULL, NULL, 'no', 1, '2024-10-07 12:01:39', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (25, 7, 30, 28, '2024-10-09 12:59:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 5, 1, 0, NULL, NULL, 'no', 1, '2024-10-09 07:29:57', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (26, 7, 31, 29, '2024-10-10 13:52:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 3, 1, 0, NULL, NULL, 'no', 1, '2024-10-09 08:23:12', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (28, 7, 34, 33, '2024-10-29 18:14:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 2, 1, 0, NULL, NULL, 'no', 1, '2024-10-28 12:45:16', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (38, 7, 58, 54, '2024-11-12 15:41:00', '2', '4', 2, '', '', 'approved', 'Offline', '', '', 2, 1, 0, NULL, NULL, 'no', 1, '2024-11-11 10:12:33', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (39, 6, 59, 55, '2024-11-12 15:44:00', '2', '4', 2, '', '', 'approved', 'Offline', '', '', 2, 1, 0, NULL, NULL, 'no', 1, '2024-11-11 10:14:30', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (42, 7, 62, 58, '2024-11-13 17:39:00', '1', '4', 2, '', '', 'pending', 'Offline', '', '', 5, 1, 0, NULL, NULL, 'no', 1, '2024-11-11 12:10:04', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (44, 7, 65, 61, '2024-11-15 12:33:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 4, 1, 0, NULL, NULL, 'no', 1, '2024-11-13 07:04:07', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (47, 7, 70, 66, '2024-11-15 18:19:00', '1', '4', 2, '', '', 'pending', 'Offline', '', '', 4, 1, 0, NULL, NULL, 'no', 1, '2024-11-14 12:49:41', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (48, 7, 71, 67, '2024-11-15 18:20:00', '2', '4', 2, '', '', 'pending', 'Offline', '', '', 4, 1, 0, NULL, NULL, 'no', 1, '2024-11-14 12:51:07', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (50, 7, 73, 69, '2024-11-16 14:34:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 6, 1, 0, NULL, NULL, 'no', 1, '2024-11-15 09:06:26', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (54, 6, 116, 120, '2024-11-26 14:39:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 2, 1, 0, NULL, NULL, 'no', 1, '2024-11-25 09:09:29', 7);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (57, 7, 136, 139, '2024-11-27 16:04:00', '2', '4', 2, '', '', 'approved', 'Offline', '', '', 5, 1, 0, NULL, NULL, 'no', 1, '2024-11-26 10:38:25', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (63, 3, NULL, NULL, '2025-02-27 13:04:00', '6', '4', 2, '', 'sfd', 'pending', 'Online', '', '', 3, NULL, 0, '2024-12-02 14:55:18', '2024-12-02 15:05:18', 'no', 0, '2024-12-02 09:25:18', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (73, 7, 158, 158, '2024-12-05 11:51:00', '1', '4', 2, '', '', 'cancel', 'Offline', '', '', 3, 1, 0, NULL, NULL, 'no', 1, '2024-12-03 06:21:58', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (74, 3, NULL, NULL, '2024-12-12 10:48:00', '2', '4', 2, '', 'tset', 'pending', 'Online', '', '', 3, NULL, 0, '2024-12-03 17:21:51', '2024-12-03 17:31:51', 'no', 0, '2024-12-03 11:51:51', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (75, 3, NULL, NULL, '2024-12-07 11:30:00', '1', '4', 2, '', 'ertet', 'pending', 'Online', '', '', 6, NULL, 0, '2024-12-03 17:22:32', '2024-12-03 17:32:32', 'no', 0, '2024-12-03 11:52:32', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (76, 3, NULL, NULL, '2024-12-20 13:22:00', '1', '4', 2, '', 'test', 'pending', 'Online', '', '', 4, NULL, 0, '2024-12-03 17:30:01', '2024-12-03 17:40:01', 'no', 0, '2024-12-03 12:00:01', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (77, 3, NULL, NULL, '2024-12-27 13:22:00', '1', '4', 2, '', 'fdh', 'pending', 'Online', '', '', 4, NULL, 0, '2024-12-03 17:57:04', '2024-12-03 18:07:04', 'no', 0, '2024-12-03 12:27:04', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (78, 3, NULL, NULL, '2024-12-27 13:22:00', '1', '4', 2, '', 'fdh', 'pending', 'Online', '', '', 4, NULL, 0, '2024-12-03 17:57:06', '2024-12-03 18:07:06', 'no', 0, '2024-12-03 12:27:06', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (79, 3, NULL, NULL, '2024-12-27 13:22:00', '1', '4', 2, '', 'fdh', 'pending', 'Online', '', '', 4, NULL, 0, '2024-12-03 17:57:06', '2024-12-03 18:07:06', 'no', 0, '2024-12-03 12:27:06', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (80, 3, NULL, NULL, '2024-12-27 13:22:00', '1', '4', 2, '', 'fdh', 'pending', 'Online', '', '', 4, NULL, 0, '2024-12-03 17:57:13', '2024-12-03 18:07:13', 'no', 0, '2024-12-03 12:27:13', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (87, 6, 172, 175, '2024-12-05 12:36:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 3, 1, 0, NULL, NULL, 'no', 1, '2024-12-05 07:06:36', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (88, 6, 173, 176, '2024-12-05 12:52:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 3, 1, 0, NULL, NULL, 'no', 1, '2024-12-05 07:22:55', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (97, 5, NULL, NULL, '2024-12-16 13:15:00', '1', '4', 2, '', 'dsd', 'pending', 'Online', '', '', 3, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 08:07:38', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (99, 3, NULL, NULL, '2024-12-09 12:00:00', '1', '4', 2, '', 'dfd', 'pending', 'Online', '', '', 3, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:13:40', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (100, 3, NULL, NULL, '2024-12-10 12:15:00', '1', '4', 2, '', 'sdf', 'pending', 'Online', '', '', 6, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:16:23', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (101, 3, NULL, NULL, '2024-12-09 12:15:00', '1', '4', 2, '', 'sf', 'pending', 'Online', '', '', 3, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:23:58', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (103, 3, NULL, NULL, '2024-12-11 11:15:00', '1', '4', 2, '', 'ew', 'pending', 'Online', '', '', 2, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:31:27', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (104, 3, NULL, NULL, '2024-12-09 10:15:00', '1', '4', 2, '', 'dff', 'pending', 'Online', '', '', 3, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:36:57', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (105, 5, NULL, NULL, '2024-12-11 13:15:00', '1', '4', 2, '', 'sf', 'pending', 'Online', '', '', 2, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:38:01', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (106, 5, NULL, NULL, '2024-12-19 13:00:00', '1', '4', 2, '', 'fs', 'pending', 'Online', '', '', 3, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:44:55', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (107, 3, NULL, NULL, '2024-12-11 12:15:00', '1', '4', 2, '', 'sf', 'pending', 'Online', '', '', 2, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:54:49', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (108, 3, NULL, NULL, '2024-12-11 10:15:00', '1', '4', 2, '', 'sf', 'pending', 'Online', '', '', 2, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:57:20', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (109, 5, NULL, NULL, '2024-12-12 11:30:00', '1', '4', 2, '', 'sf', 'pending', 'Online', '', '', 3, NULL, 0, NULL, NULL, 'no', 1, '2024-12-07 10:58:14', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1064, 7, 223, 229, '2025-03-13 13:55:00', '1', '1', 8, '', '', 'approved', 'Offline', '', '', 8, 1, 0, NULL, NULL, 'no', 1, '2025-03-12 08:26:05', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1184, 156, 337, 342, '2025-05-05 16:44:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 15, 2, 0, NULL, NULL, 'no', 1, '2025-05-05 11:15:02', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1185, 160, 340, 344, '2025-05-05 16:00:00', '1', '4', 2, '', 'wer', 'approved', 'Online', '', '', 15, NULL, 0, '2025-05-05 16:56:12', '2025-05-05 17:06:12', 'no', 1, '2025-05-05 11:26:12', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1186, 158, 343, 347, '2025-05-06 12:06:00', '1', '4', 2, '', '', 'cancel', 'Offline', '', '', 2, 1, 0, NULL, NULL, 'no', 1, '2025-05-06 06:36:50', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1187, 158, 345, 348, '2025-05-14 15:32:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 5, 1, 0, NULL, NULL, 'no', 1, '2025-05-06 10:03:04', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1188, 159, 346, 349, '2025-05-28 15:34:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 5, 1, 0, NULL, NULL, 'no', 1, '2025-05-06 10:05:13', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1191, 166, 353, 355, '2025-05-09 17:04:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 4, 1, 1, NULL, NULL, 'no', 1, '2025-05-08 11:38:21', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1193, 166, 354, 356, '2025-05-09 12:00:00', '1', '4', 2, '', 'fghfh', 'approved', 'Online', '', '', 4, NULL, 0, '2025-05-09 14:38:11', '2025-05-09 14:48:11', 'no', 0, '2025-05-09 09:08:11', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1195, 155, NULL, NULL, '2025-05-16 09:30:00', '1', '1', 30, '', 'test', 'pending', 'Online', '', '', 27, NULL, 0, '2025-05-09 14:56:18', '2025-05-09 15:06:18', 'no', 0, '2025-05-09 09:26:18', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1197, 166, 355, 357, '2025-05-09 16:24:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 4, 1, 1, NULL, NULL, 'no', 1, '2025-05-09 10:54:19', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1202, 158, 361, 362, '2025-05-12 11:10:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 1, 1, 0, NULL, NULL, 'no', 1, '2025-05-12 05:40:23', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1203, 160, 362, 363, '2025-05-12 11:10:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 1, 1, 0, NULL, NULL, 'no', 1, '2025-05-12 05:40:49', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1204, 167, 363, 364, '2025-05-12 13:13:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 1, 1, 0, NULL, NULL, 'no', 1, '2025-05-12 07:44:50', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1207, 158, 366, 367, '2025-05-30 15:03:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 4, 1, 0, NULL, NULL, 'no', 1, '2025-05-12 09:33:30', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1208, 159, 367, 368, '2025-05-12 15:45:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 1, 1, 0, NULL, NULL, 'no', 1, '2025-05-12 10:15:52', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1209, 166, 368, 369, '2025-05-12 15:46:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 15, 2, 0, NULL, NULL, 'no', 1, '2025-05-12 10:16:21', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1215, 167, NULL, NULL, '2025-05-17 11:10:00', '1', '1', 30, '', 'dfs', 'pending', 'Online', '', '', 28, NULL, 0, '2025-05-15 13:07:11', '2025-05-15 13:17:11', 'yes', 0, '2025-05-15 07:37:11', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1216, 167, NULL, NULL, '2025-05-17 11:30:00', '1', '1', 30, '', 'gh', 'pending', 'Online', '', '', 28, NULL, 0, '2025-05-15 13:30:36', '2025-05-15 13:40:36', 'no', 0, '2025-05-15 08:00:36', NULL);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1229, 161, 387, 387, '2025-05-15 15:57:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 18, 2, 0, NULL, NULL, 'no', 1, '2025-05-15 10:28:06', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1230, 158, 388, 388, '2025-05-15 16:00:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 18, 2, 0, NULL, NULL, 'no', 1, '2025-05-15 10:30:13', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1231, 172, 389, 389, '2025-05-16 16:50:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 4, 1, 0, NULL, NULL, 'no', 1, '2025-05-15 11:20:33', 1);
INSERT INTO `appointment` (`id`, `patient_id`, `case_reference_id`, `visit_details_id`, `date`, `priority`, `specialist`, `doctor`, `amount`, `message`, `appointment_status`, `source`, `is_opd`, `is_ipd`, `doctor_shift_time_id`, `doctor_global_shift_id`, `is_queue`, `created_time`, `rejected_time`, `live_consult`, `live_consult_link`, `created_at`, `created_by`) VALUES (1232, 172, 390, 390, '2025-05-16 16:52:00', '1', '4', 2, '', '', 'approved', 'Offline', '', '', 4, 1, 0, NULL, NULL, 'no', 1, '2025-05-15 11:22:33', 1);


#
# TABLE STRUCTURE FOR: appointment_payment
#

DROP TABLE IF EXISTS `appointment_payment`;

CREATE TABLE `appointment_payment` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appointment_id` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `standard_amount` float(10,2) NOT NULL DEFAULT '0.00',
  `tax` float(10,2) NOT NULL DEFAULT '0.00',
  `discount_percentage` float(10,2) NOT NULL DEFAULT '0.00',
  `paid_amount` float(10,2) NOT NULL,
  `payment_mode` varchar(50) DEFAULT NULL,
  `payment_type` varchar(100) NOT NULL,
  `transaction_id` varchar(255) DEFAULT NULL,
  `note` varchar(100) DEFAULT NULL,
  `date` datetime NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_id` (`charge_id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `index_standard_amount` (`standard_amount`),
  KEY `index_tax` (`tax`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_paid_amount` (`paid_amount`),
  KEY `index_payment_mode` (`payment_mode`),
  KEY `index_payment_type` (`payment_type`),
  CONSTRAINT `appointment_payment_ibfk_2` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_payment_ibfk_3` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: appointment_queue
#

DROP TABLE IF EXISTS `appointment_queue`;

CREATE TABLE `appointment_queue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `appointment_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `position` int DEFAULT NULL,
  `shift_id` int DEFAULT NULL,
  `date` date NOT NULL DEFAULT '2021-01-11',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `appointment_id` (`appointment_id`),
  KEY `staff_id` (`staff_id`),
  KEY `global_shift_id` (`shift_id`),
  CONSTRAINT `appointment_queue_ibfk_1` FOREIGN KEY (`appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `appointment_queue_ibfk_3` FOREIGN KEY (`shift_id`) REFERENCES `doctor_shift_time` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: bed
#

DROP TABLE IF EXISTS `bed`;

CREATE TABLE `bed` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `bed_type_id` int DEFAULT NULL,
  `bed_group_id` int DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `bed_type_id` (`bed_type_id`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `bed_ibfk_1` FOREIGN KEY (`bed_type_id`) REFERENCES `bed_type` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_2` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bed_ibfk_3` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3;

INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (1, 'general bed', 1, 1, 'no', '2024-09-26 12:01:09');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (2, 'Private bed', 2, 2, 'no', '2024-09-28 08:07:01');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (3, 'ICU Bed ', 2, 1, 'no', '2024-09-28 08:07:32');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (4, 'VVIP bed', 2, 2, 'no', '2024-10-07 10:54:41');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (5, 'General Ward', 1, 1, 'no', '2024-10-30 11:02:40');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (6, 'gw2', 1, 1, 'no', '2024-10-30 11:02:56');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (8, 'PW3', 2, 3, 'no', '2024-10-30 11:03:19');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (9, 'new bed', 2, 1, 'no', '2024-11-09 12:38:23');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (10, 'PW4', 1, 3, 'no', '2024-11-25 06:06:48');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (11, 'PW5', 1, 3, 'no', '2024-11-25 06:06:57');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (12, 'PW6', 2, 5, 'no', '2024-11-25 06:07:09');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (13, 'Pw7', 1, 3, 'yes', '2024-11-25 06:07:55');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (14, 'private', 1, 3, 'yes', '2024-11-28 09:32:52');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (15, 'PW9', 1, 3, 'yes', '2024-11-29 10:10:08');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (16, 'Pw22', 1, 4, 'no', '2024-11-29 10:10:16');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (17, 'PW99', 1, 3, 'no', '2024-11-29 10:10:23');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (18, 'hospital bed', 1, 3, 'no', '2024-12-02 07:21:05');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (19, 'hos bed 2', 1, 7, 'no', '2024-12-03 08:26:36');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (20, 'PW12', 1, 3, 'no', '2024-12-05 11:48:47');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (22, 'Bed5', 1, 7, 'unused', '2025-04-10 09:56:03');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (23, 'added', 1, 3, 'yes', '2025-04-17 10:54:58');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (24, 'bed12313', 1, 3, 'unused', '2025-04-19 10:00:26');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (25, 'rwawar', 1, 3, 'unused', '2025-04-19 10:10:31');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (27, 'ddd', 2, 3, 'unused', '2025-04-19 11:52:35');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (28, 'add', 1, 3, 'unused', '2025-04-19 11:58:26');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (29, 'bed', 1, 3, 'unused', '2025-05-01 08:14:47');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (30, 'patient required', 2, 3, 'no', '2025-05-07 06:51:34');
INSERT INTO `bed` (`id`, `name`, `bed_type_id`, `bed_group_id`, `is_active`, `created_at`) VALUES (31, 'unused', 1, 3, 'unused', '2025-05-07 06:52:50');


#
# TABLE STRUCTURE FOR: bed_group
#

DROP TABLE IF EXISTS `bed_group`;

CREATE TABLE `bed_group` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `color` varchar(50) NOT NULL DEFAULT '#f4f4f4',
  `description` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `floor` int NOT NULL,
  `is_active` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_color` (`color`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;

INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (1, 'normal bed', '#b31414', '', 1, 0, '2024-09-26 12:00:46');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (2, 'Ac Bed', '#f4f4f4', '', 1, 0, '2024-09-28 08:06:06');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (3, 'Private Beds', '#47a136', '', 2, 0, '2024-09-28 08:06:32');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (4, 'vvip bed', '#f4f4f4', '', 2, 0, '2024-10-09 09:46:09');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (5, 'AC room vvip', '#f4f4f4', '', 4, 0, '2024-10-29 11:41:41');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (6, 'General bed rof normal patient', '#e29292', '', 1, 0, '2024-11-05 07:52:01');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (7, 'General new bed', '#ad3838', '2345', 6, 0, '2024-11-18 08:18:02');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (8, 'hospital bed', '#f4f4f4', '', 8, 0, '2024-12-02 07:21:43');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (9, 'Hospital bed2', '#f4f4f4', '', 9, 0, '2024-12-05 11:58:43');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (14, 'addfgggh', '#b07373', '', 12, 0, '2025-04-17 11:07:20');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (15, 'bed group', '#b17272', '', 13, 0, '2025-05-01 08:21:16');
INSERT INTO `bed_group` (`id`, `name`, `color`, `description`, `floor`, `is_active`, `created_at`) VALUES (16, 'General in all patient', '#1d862f', '', 9, 0, '2025-05-07 06:58:42');


#
# TABLE STRUCTURE FOR: bed_type
#

DROP TABLE IF EXISTS `bed_type`;

CREATE TABLE `bed_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;

INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (1, 'general bed', '2024-09-26 11:59:39');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (2, 'Private Beds', '2024-09-28 08:06:41');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (3, 'VIP Bed', '2024-10-07 10:56:08');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (4, 'vvip bed', '2024-10-09 09:44:39');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (5, 'AC Room', '2024-10-29 11:41:18');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (6, 'General bed type', '2024-11-05 07:52:41');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (7, 'NEW BED TYPE', '2024-11-18 08:15:00');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (8, 'HOSPITAL BED', '2024-12-05 11:56:49');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (12, 'advansed room', '2025-04-17 11:05:37');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (13, 'aaaaaaa', '2025-04-19 11:50:27');
INSERT INTO `bed_type` (`id`, `name`, `created_at`) VALUES (15, 'Bed type', '2025-05-07 06:54:38');


#
# TABLE STRUCTURE FOR: bill
#

DROP TABLE IF EXISTS `bill`;

CREATE TABLE `bill` (
  `id` int NOT NULL AUTO_INCREMENT,
  `case_id` int NOT NULL,
  `attachment` mediumtext CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `attachment_name` mediumtext,
  `amount` float(10,2) DEFAULT NULL,
  `payment_mode` varchar(100) DEFAULT NULL,
  `cheque_no` varchar(100) DEFAULT NULL,
  `cheque_date` date DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `note` mediumtext,
  `received_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_id` (`case_id`),
  CONSTRAINT `bill_ibfk_1` FOREIGN KEY (`case_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: birth_report
#

DROP TABLE IF EXISTS `birth_report`;

CREATE TABLE `birth_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `child_name` varchar(200) NOT NULL,
  `child_pic` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `gender` varchar(200) NOT NULL,
  `birth_date` datetime DEFAULT NULL,
  `weight` varchar(200) NOT NULL,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `contact` varchar(20) NOT NULL,
  `mother_pic` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `father_name` varchar(200) NOT NULL,
  `father_pic` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `birth_report` mediumtext,
  `document` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `address` text,
  `is_active` varchar(10) NOT NULL,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  KEY `index_child_name` (`child_name`),
  KEY `index_gender` (`gender`),
  KEY `index_weight` (`weight`),
  KEY `index_contact` (`contact`),
  CONSTRAINT `birth_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `birth_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb3;

INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (5, 'RAM', 'uploads/patient_images/no_image.png', 'Female', '2024-11-06 12:11:00', '3', 3, 9, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', NULL, '2024-11-06 06:41:35');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (6, 'n', 'uploads/patient_images/no_image.png', 'Male', '2024-11-11 17:47:00', '3', 5, 23, '', 'uploads/birth_image/6/1742628646-29060365367de67269ca89!WhatsApp Image 2025-03-21 at 18.22.47 (1) (1).jpeg', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', NULL, '2025-03-22 07:30:46');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (7, 'test', 'uploads/patient_images/no_image.png', 'Female', '2024-11-13 12:46:00', '33', 5, 23, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', NULL, '2024-11-13 07:16:53');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (8, 'gjg', 'uploads/patient_images/no_image.png', 'Female', '2024-11-13 12:47:00', '45', 5, 23, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', NULL, '2024-11-13 07:17:22');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (9, 'niya', 'uploads/patient_images/no_image.png', 'Female', '2024-11-14 15:35:00', '2.5', 3, 9, '3543445677', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', NULL, '2024-11-14 10:16:49');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (12, 'hello', 'uploads/patient_images/no_image.png', 'Male', '2024-11-25 15:54:00', '3', 5, 23, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', 1, '2024-11-25 10:25:11');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (13, 'TEST', 'uploads/birth_image/13/child_img13.png', 'Male', '2024-11-27 13:50:00', '3', 5, 23, '4564788', 'uploads/patient_images/no_image.png', 'TESTTT', 'uploads/patient_images/no_image.png', '', '', '', 'yes', 1, '2024-11-27 08:21:13');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (16, 'doramon', 'uploads/birth_image/16/child_img16.jpg', 'Male', '2024-11-13 16:35:00', '3', 3, 9, '122', 'uploads/birth_image/16/mother_pic16.png', '', 'uploads/birth_image/16/father_pic16.png', '', 'uploads/birth_image/16/document16.xlsx', '', 'yes', 1, '2024-11-28 11:05:56');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (17, 'korusuke', '1732792061-162575807867484efdb1f1e!images.jpg', 'Male', '2024-11-28 16:37:00', '3', 3, 9, '', '1732792061-81563043967484efdb19f8!tset (2).png', '', '1732792061-117818873067484efdb1e7b!K (5).png', '', '1732792061-146054876067484efdb1f6c!Book1 (1).xlsx', '', 'yes', 1, '2024-11-28 11:07:41');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (18, 'gutagorila', 'uploads/birth_image/18/1732792827-1456172407674851fb4b406!1732784039152591684767482fa7b7201.png', 'Male', '2024-10-24 16:41:00', '5kg', 3, 9, '', 'uploads/birth_image/18/1732792792-317766693674851d878493!ki.jpg', '', 'uploads/birth_image/18/1732792843-12433450326748520b05023!images.jpg', '', 'uploads/birth_image/18/1732792325-152109465667485005b49b5!Book1 (1).xlsx', '', 'yes', 1, '2024-11-28 11:20:43');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (19, 'test', 'uploads/patient_images/no_image.png', 'Female', '2021-04-06 16:58:00', '3', 3, 9, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', 1, '2024-11-28 11:29:30');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (22, 'sfdfs', 'uploads/patient_images/no_image.png', 'Female', '2024-12-03 12:00:00', '34', 3, 9, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', 1, '2024-12-03 06:30:21');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (23, 'google', 'uploads/birth_image/23/1733209066-1175539552674eabea70d05!images.jpg', 'Male', '2024-12-03 12:27:00', '64', 3, 9, '', 'uploads/patient_images/no_image.png', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', 1, '2024-12-03 06:57:46');
INSERT INTO `birth_report` (`id`, `child_name`, `child_pic`, `gender`, `birth_date`, `weight`, `patient_id`, `case_reference_id`, `contact`, `mother_pic`, `father_name`, `father_pic`, `birth_report`, `document`, `address`, `is_active`, `generated_by`, `created_at`) VALUES (25, 'test', 'uploads/birth_image/25/1733300083-119016021667500f738de5d!ki (1) (1) (1) (1) (1) (2).jpg', 'Male', '2024-12-04 13:42:00', '3', 5, 23, '', 'uploads/birth_image/25/1733300083-180909698467500f738dd8d!ki (1) (1) (1) (1) (1).jpg', '', 'uploads/patient_images/no_image.png', '', '', '', 'yes', 1, '2024-12-04 08:14:43');


#
# TABLE STRUCTURE FOR: blood_bank_products
#

DROP TABLE IF EXISTS `blood_bank_products`;

CREATE TABLE `blood_bank_products` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `is_blood_group` int DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3;

INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (1, 'A-', 1, '2024-09-26 07:05:49');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (2, 'A+', 1, '2024-09-26 07:05:57');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (3, 'B-', 1, '2024-09-26 07:06:09');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (4, 'B+', 1, '2024-09-26 07:06:16');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (5, 'Red Cells', 2, '2024-09-26 07:06:27');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (6, 'Plazma', 2, '2024-09-26 07:06:37');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (7, 'O+', 1, '2024-09-26 07:06:56');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (8, 'O-', 1, '2024-10-07 12:06:59');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (9, 'AB+', 1, '2024-10-10 11:24:59');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (10, 'AB-', 1, '2024-10-10 11:25:27');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (19, 'PRODUCT', 1, '2024-11-19 09:50:24');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (23, 'Blood cell', 2, '2025-04-25 07:45:35');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (26, 'test blood', 1, '2025-04-25 09:58:32');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (27, 'A+', 1, '2025-05-03 11:55:33');
INSERT INTO `blood_bank_products` (`id`, `name`, `is_blood_group`, `created_at`) VALUES (28, 'AB+', 1, '2025-05-07 08:13:58');


#
# TABLE STRUCTURE FOR: blood_donor
#

DROP TABLE IF EXISTS `blood_donor`;

CREATE TABLE `blood_donor` (
  `id` int NOT NULL AUTO_INCREMENT,
  `donor_name` varchar(100) DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `blood_bank_product_id` int DEFAULT NULL,
  `gender` varchar(11) DEFAULT NULL,
  `father_name` varchar(100) DEFAULT NULL,
  `address` text,
  `contact_no` varchar(20) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `index_donor_name` (`donor_name`),
  KEY `index_gender` (`gender`),
  KEY `index_father_name` (`father_name`),
  KEY `index_contact_no` (`contact_no`),
  CONSTRAINT `blood_donor_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb3;

INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (1, 'John', '2004-06-18', 2, 'Male', 'Smith', '', '9089089789', '2024-09-26 07:47:57');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (2, 'maria', '1999-02-11', 3, 'Female', 'Kalvin', '', '87895675', '2024-09-26 07:48:18');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (3, 'Lokesh', '1994-06-16', 4, 'Male', 'Arjun', '', '788956757', '2024-09-26 07:49:00');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (4, 'Sara', '1999-07-09', 1, 'Female', 'oliver', '', '89068575', '2024-09-26 08:13:32');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (5, 'JAYA VARMA', '1998-10-16', 7, 'Female', '', '', '', '2024-10-10 11:30:20');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (6, 'Vinay', '2009-01-06', 2, 'Male', '', '', '', '2024-10-29 04:30:41');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (7, 'Rishi', '2002-08-15', 2, 'Male', '', '', '', '2024-11-05 12:21:18');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (8, 'HORIBA', '2010-02-10', 2, 'Male', '', '', '', '2024-11-15 09:35:10');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (9, 'ajay', '2000-11-06', 2, 'Male', '', '', '43647485454', '2024-11-27 07:19:34');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (10, 'test', '1999-08-05', 2, 'Male', '', '', '', '2024-11-28 10:50:41');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (11, 'Tarun', '1999-08-05', 1, 'Male', '', '', '', '2024-11-29 11:38:47');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (12, 'test', '2024-09-04', 2, 'Female', '', '', '', '2024-12-02 05:35:06');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (13, 'add', '2001-12-03', 2, 'Male', '', '', '', '2024-12-02 08:28:16');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (14, 'ram rai', '1999-11-21', 2, 'Female', 'rer', 'rar', 'rawr', '2024-12-03 07:25:47');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (15, 'jaya', '2025-03-01', 2, 'Female', '', '', '5667677878', '2025-03-01 07:39:30');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (16, 'czxc', '2025-03-12', 8, 'Male', '', '', '', '2025-03-08 07:10:13');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (17, 'new', '2000-03-13', 7, 'Male', '', '', '', '2025-03-21 10:13:09');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (18, 'jjjjkjkjk', '2002-04-15', 2, 'Male', '', '', '', '2025-04-15 12:38:07');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (19, 'Karun', '1999-06-10', 3, 'Male', 'arun', '', '897896786', '2025-04-21 07:29:37');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (25, 'donor A', '1995-04-18', 26, 'Male', '', '', '', '2025-04-25 09:59:30');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (26, 'Vikram', '2000-06-08', 3, 'Male', 'Arun', 'Mr Road 45', '89075674', '2025-04-26 05:36:38');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (27, 'add', '2025-04-26', 3, 'Male', '', '', '', '2025-04-26 12:43:03');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (28, 'ghhjj', '2025-04-22', 3, 'Male', '', '', '56567677', '2025-04-28 09:54:59');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (29, 'Rakesh', '2000-05-06', 7, 'Male', 'm', '', '', '2025-05-10 11:02:48');
INSERT INTO `blood_donor` (`id`, `donor_name`, `date_of_birth`, `blood_bank_product_id`, `gender`, `father_name`, `address`, `contact_no`, `created_at`) VALUES (30, 'abhi', '2000-05-05', 8, 'Male', '', '', '', '2025-05-12 08:50:52');


#
# TABLE STRUCTURE FOR: blood_donor_cycle
#

DROP TABLE IF EXISTS `blood_donor_cycle`;

CREATE TABLE `blood_donor_cycle` (
  `id` int NOT NULL AUTO_INCREMENT,
  `blood_donor_cycle_id` int NOT NULL,
  `blood_bank_product_id` int DEFAULT NULL,
  `blood_donor_id` int DEFAULT NULL,
  `charge_id` int DEFAULT NULL,
  `donate_date` date DEFAULT NULL,
  `bag_no` varchar(11) DEFAULT NULL,
  `lot` varchar(11) DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `standard_charge` float(10,2) DEFAULT NULL,
  `apply_charge` float(10,2) DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `institution` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `note` text,
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `tax_percentage` float(10,2) DEFAULT '0.00',
  `volume` varchar(100) DEFAULT NULL,
  `unit` int DEFAULT NULL,
  `available` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `blood_bank_product_id` (`blood_bank_product_id`),
  KEY `blood_donor_id` (`blood_donor_id`),
  KEY `charge_id` (`charge_id`),
  KEY `index_bag_no` (`bag_no`),
  KEY `index_lot` (`lot`),
  KEY `index_amount` (`amount`),
  KEY `index_unit` (`unit`),
  KEY `index_volume` (`volume`),
  KEY `index_quantity` (`quantity`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_apply_charge` (`apply_charge`),
  CONSTRAINT `blood_donor_cycle_ibfk_1` FOREIGN KEY (`blood_bank_product_id`) REFERENCES `blood_bank_products` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_2` FOREIGN KEY (`blood_donor_id`) REFERENCES `blood_donor` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_donor_cycle_ibfk_3` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=215 DEFAULT CHARSET=utf8mb3;

INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (6, 2, 5, NULL, NULL, NULL, '5', '2', 1, NULL, NULL, NULL, 'blood bank Center', NULL, '0.00', '0.00', '220', 1, 0, '2024-09-26 07:53:05');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (7, 2, 6, NULL, NULL, NULL, '8', '2', 1, NULL, NULL, NULL, 'blood bank Center', NULL, '0.00', '0.00', '220', 6, 0, '2024-09-26 07:53:05');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (10, 8, 5, NULL, NULL, NULL, '2', '6', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '5', 1, 0, '2024-09-27 12:13:44');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (11, 8, 6, NULL, NULL, NULL, '3', '7', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '6', 3, 0, '2024-09-27 12:13:44');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (16, 14, 5, NULL, NULL, NULL, '5', '6', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '7', 6, 0, '2024-10-10 11:29:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (17, 14, 6, NULL, NULL, NULL, '4', '6', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '6', 3, 0, '2024-10-10 11:29:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (22, 21, 5, NULL, NULL, NULL, '151', '234', 1, NULL, NULL, NULL, '234', NULL, '0.00', '0.00', '33', 1, 0, '2024-10-30 10:51:38');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (30, 29, 5, NULL, NULL, NULL, '10', '20', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '30', 2, 0, '2024-11-05 12:19:52');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (31, 29, 6, NULL, NULL, NULL, '20', '30', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '40', 1, 0, '2024-11-05 12:19:52');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (34, 33, 5, NULL, NULL, NULL, '20', '21', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '5', NULL, 0, '2024-11-05 12:26:25');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (35, 33, 6, NULL, NULL, NULL, '30', '31', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '6', NULL, 0, '2024-11-05 12:26:25');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (49, 0, NULL, 4, 11, '2024-11-28', 'fhg', '', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '', 0, 0, '2024-11-28 09:29:57');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (51, 0, NULL, 4, 11, '2024-11-28', '4535', '435', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '43535', 5, 0, '2024-11-28 09:31:36');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (56, 50, 5, NULL, NULL, NULL, '566465', '5', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, NULL, 0, '2024-12-02 11:04:28');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (57, 50, 6, NULL, NULL, NULL, '532121', '6', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, NULL, 0, '2024-12-02 11:04:28');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (61, 53, 5, NULL, NULL, NULL, '7', '9', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '8', NULL, 0, '2025-03-01 07:37:02');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (73, 68, 5, NULL, NULL, NULL, '64', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, NULL, 0, '2025-03-08 08:12:28');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (75, 52, 5, NULL, NULL, NULL, '231', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 0, '2025-03-10 04:30:00');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (76, 52, 6, NULL, NULL, NULL, '342', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 0, '2025-03-10 04:30:00');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (78, 59, 5, NULL, NULL, NULL, '231', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 0, '2025-03-10 06:57:35');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (79, 59, 6, NULL, NULL, NULL, '2341', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 0, '2025-03-10 06:57:35');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (82, 81, 5, NULL, NULL, NULL, '766', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 0, '2025-03-10 07:58:25');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (83, 74, 5, NULL, NULL, NULL, '23', '34', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '34', 1, 0, '2025-03-12 11:37:00');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (84, 74, 6, NULL, NULL, NULL, '43', '54', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '65', 2, 0, '2025-03-12 11:37:00');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (86, 85, 5, NULL, NULL, NULL, '453', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, NULL, 0, '2025-03-18 05:48:08');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (87, 85, 6, NULL, NULL, NULL, '233', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, NULL, 0, '2025-03-18 05:48:08');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (89, 88, 5, NULL, NULL, NULL, '0002', '3', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '2', 6, 0, '2025-03-18 05:49:43');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (92, 91, 5, NULL, NULL, NULL, '8888', '12345', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '9999', 5, 0, '2025-03-18 10:06:07');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (95, 94, 5, NULL, NULL, NULL, '1402', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 1, 0, '2025-03-19 06:04:32');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (96, 94, 6, NULL, NULL, NULL, '1403', '4', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 1, 0, '2025-03-19 06:04:32');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (99, 97, 6, NULL, NULL, NULL, '51201', '6', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 1, 0, '2025-03-19 06:11:41');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (103, 102, 5, NULL, NULL, NULL, '22', '22', 1, NULL, NULL, NULL, '12345', NULL, '0.00', '0.00', '22', 1, 0, '2025-03-21 05:28:22');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (107, 106, 5, NULL, NULL, NULL, '123123', '321321', 1, NULL, NULL, NULL, 'lkhl', NULL, '0.00', '0.00', '123', 1, 0, '2025-03-21 09:27:39');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (109, 108, 5, NULL, NULL, NULL, 'er', 'ret', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', 'rte', 1, 0, '2025-03-21 09:33:38');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (110, 108, 6, NULL, NULL, NULL, 'et', 'ret', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', 'eert', 1, 0, '2025-03-21 09:33:38');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (116, 115, 5, NULL, NULL, NULL, '12', '43', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '56', 3, 0, '2025-04-07 09:26:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (117, 115, 6, NULL, NULL, NULL, '34', '55', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '78', 3, 1, '2025-04-07 09:26:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (125, 124, 5, NULL, NULL, NULL, '1', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, 1, 0, '2025-04-15 12:33:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (126, 124, 6, NULL, NULL, NULL, '1', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, NULL, 1, '2025-04-15 12:33:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (129, 0, NULL, 4, 11, '2025-04-18', '5633', '2', 1, '200.00', '200.00', '212.40', '', '', '10.00', '18.00', '220', 5, 0, '2025-04-18 06:02:10');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (130, 0, NULL, 11, 11, '2025-04-18', '42', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 1, '2025-04-18 09:41:22');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (131, 0, NULL, 4, 11, '2025-04-19', '54', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 0, '2025-04-18 09:41:37');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (132, 0, NULL, 4, 11, '2025-04-17', '413', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 0, '2025-04-18 09:41:59');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (133, 0, NULL, 11, 11, '2025-04-18', '61', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 6, 1, '2025-04-18 09:42:17');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (134, 0, NULL, 4, 11, '2025-04-19', '50', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 1, '2025-04-18 09:42:32');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (135, 0, NULL, 4, 11, '2025-04-21', '76', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 1, '2025-04-18 09:42:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (136, 0, NULL, 11, 11, '2025-04-24', '220', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 1, '2025-04-18 09:43:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (137, 0, NULL, 4, 11, '2025-04-18', '75', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 1, '2025-04-18 09:43:20');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (138, 0, NULL, 4, 11, '2025-04-22', '452', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 1, '2025-04-18 09:43:38');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (139, 0, NULL, 4, 11, '2025-04-25', '63', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 1, '2025-04-18 09:43:54');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (140, 0, NULL, 4, 11, '2025-04-26', '410', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 1, '2025-04-18 09:44:10');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (141, 0, NULL, 1, 11, '2025-04-18', '232', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 0, '2025-04-18 09:44:40');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (142, 0, NULL, 6, 11, '2025-04-18', '874', '2', 1, '200.00', '200.00', '236.00', 'Blood bank Camp', '', '0.00', '18.00', '220', 6, 1, '2025-04-18 09:46:40');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (143, 0, NULL, 7, 11, '2025-04-24', '422', '2', 1, '200.00', '200.00', '236.00', 'Getting error on the page.', '', '0.00', '18.00', '220', 6, 0, '2025-04-18 09:48:08');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (144, 0, NULL, 8, 11, '2025-04-24', '632', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 1, '2025-04-18 09:48:55');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (145, 0, NULL, 9, 11, '2025-04-28', '412', '2', 1, '200.00', '200.00', '236.00', 'Blood bank Camp', '', '0.00', '18.00', '220', 5, 1, '2025-04-18 09:49:35');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (146, 0, NULL, 15, 11, '2025-04-18', '543', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 1, '2025-04-18 09:51:01');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (147, 0, NULL, 14, 11, '2025-04-18', '633', '2', 1, '200.00', '200.00', '236.00', 'Blood bank Camp', '', '0.00', '18.00', '220', 1, 1, '2025-04-18 09:52:32');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (148, 0, NULL, 6, 11, '2025-04-18', '2001', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 1, '2025-04-18 10:15:14');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (149, 141, 5, NULL, NULL, NULL, '7844', '2', 1, NULL, NULL, NULL, 'Blood bank Camp', NULL, '0.00', '0.00', '220', 5, 0, '2025-04-18 10:15:56');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (150, 141, 6, NULL, NULL, NULL, '97', '2', 1, NULL, NULL, NULL, 'Blood bank Camp', NULL, '0.00', '0.00', '220', 6, 0, '2025-04-18 10:15:56');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (151, 132, 5, NULL, NULL, NULL, '201', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 5, 0, '2025-04-21 04:21:25');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (152, 132, 6, NULL, NULL, NULL, '014', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 0, '2025-04-21 04:21:25');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (153, 0, 3, 19, 11, '2025-04-21', '15000', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 1, '2025-04-21 07:30:24');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (154, 0, 3, 19, 11, '2025-04-21', '411', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 6, 1, '2025-04-21 07:31:07');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (155, 0, 3, 2, 11, '2025-04-21', '302', '2', 1, '200.00', '200.00', '188.80', '', '', '20.00', '18.00', '220', 5, 1, '2025-04-21 07:31:48');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (156, 137, 5, NULL, NULL, NULL, '12', '34', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '23', 1, 0, '2025-04-23 08:27:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (157, 137, 6, NULL, NULL, NULL, '23', '45', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '45', 2, 0, '2025-04-23 08:27:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (162, 161, 23, NULL, NULL, NULL, '5543', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 0, '2025-04-25 07:47:28');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (163, 139, 5, NULL, NULL, NULL, '4333', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 5, 1, '2025-04-25 07:53:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (164, 139, 6, NULL, NULL, NULL, '4433', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 1, '2025-04-25 07:53:50');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (167, 166, 5, NULL, NULL, NULL, 'g', 'fgtt', 1, NULL, NULL, NULL, 'tse', NULL, '0.00', '0.00', 'fg', 1, 0, '2025-04-25 09:54:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (168, 166, 6, NULL, NULL, NULL, 'test', 'setse', 1, NULL, NULL, NULL, 'test', NULL, '0.00', '0.00', 'test', 1, 1, '2025-04-25 09:54:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (169, 166, 23, NULL, NULL, NULL, 'hset', 'test', 1, NULL, NULL, NULL, 'test', NULL, '0.00', '0.00', 'sett', 1, 1, '2025-04-25 09:54:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (170, 153, 5, NULL, NULL, NULL, '555', '001', 1, NULL, NULL, NULL, 'ddd', NULL, '0.00', '0.00', '10', 1, 0, '2025-04-26 04:15:01');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (171, 154, 6, NULL, NULL, NULL, 'Bag ', 'Lot ', 1, NULL, NULL, NULL, 'Institution', NULL, '0.00', '0.00', 'Volume', 3, 0, '2025-04-26 04:17:11');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (181, 172, 6, NULL, NULL, NULL, '1277', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 0, '2025-04-26 05:20:26');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (182, 0, 3, 26, 11, '2025-04-26', '234', '2', 1, '200.00', '200.00', '236.00', 'Blood ccamp', 'Type O negative is often cited as the \"universal donor\" but this only refers to red cell and whole blood transfusions.', '0.00', '18.00', '220', 6, 0, '2025-04-26 05:37:38');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (183, 0, 7, 17, 11, '2025-04-26', '45555', '', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '', 1, 0, '2025-04-26 12:40:07');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (184, 177, 5, NULL, NULL, NULL, '12', '13', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '4', NULL, 0, '2025-04-26 12:48:51');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (185, 177, 23, NULL, NULL, NULL, '34', '56', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '5', NULL, 0, '2025-04-26 12:48:51');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (187, 0, 3, 28, 11, '2025-04-28', '344', '', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '', 1, 0, '2025-04-28 09:55:51');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (188, 0, NULL, 26, 11, '2025-05-03', '3445454', '', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '', 1, 0, '2025-05-03 11:56:34');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (189, 188, 5, NULL, NULL, NULL, '45', '56', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, 1, 0, '2025-05-03 11:58:10');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (190, 188, 6, NULL, NULL, NULL, '67', '87', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, 2, 0, '2025-05-03 11:58:10');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (191, 188, 23, NULL, NULL, NULL, '78', '90', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', NULL, 3, 0, '2025-05-03 11:58:10');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (192, 0, NULL, 27, 16, '2025-05-03', '1256', '5566', 1, '200.00', '200.00', '230.00', '', '', '0.00', '15.00', '', 1, 0, '2025-05-03 12:02:00');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (193, 0, NULL, 26, 11, '2025-05-05', '21', '3', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 0, '2025-05-05 11:39:09');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (194, 0, NULL, 27, 11, '2025-05-05', '673', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 5, 0, '2025-05-05 11:39:24');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (195, 0, NULL, 26, 11, '2025-05-10', '2334', '344', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', 'lit', 1, 0, '2025-05-10 09:53:37');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (196, 195, 5, NULL, NULL, NULL, '12', '23', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', 'lit', 1, 0, '2025-05-10 09:54:03');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (197, 0, 7, 29, 11, '2025-05-10', '66667', '5', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', 'ml', 5, 0, '2025-05-10 11:03:38');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (198, 0, NULL, 26, 11, '2025-05-12', '89', '90', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '', 2, 0, '2025-05-12 08:54:09');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (199, 0, NULL, 26, 11, '2025-05-14', '4510', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 0, '2025-05-14 07:44:32');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (200, 0, NULL, 26, 11, '2025-05-15', '4100', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 0, '2025-05-14 07:44:47');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (201, 0, NULL, 27, 11, '2025-05-17', '4512', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 0, '2025-05-14 07:45:00');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (202, 0, NULL, 26, 11, '2025-05-14', 'sfdsfdsf', '', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '', 1, 0, '2025-05-14 11:48:27');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (203, 0, NULL, 26, 11, '2025-05-14', 'dfsfdffff', '', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '', 5, 0, '2025-05-14 11:48:48');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (204, 0, NULL, 26, 11, '2025-05-14', 'kat', '', 1, '10.00', '10.00', '11.80', '', '', '0.00', '18.00', '', 8, 0, '2025-05-14 11:56:31');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (205, 0, NULL, 26, 11, '2025-05-14', 'kat two', '', 1, '20.00', '20.00', '23.60', '', '', '0.00', '18.00', '', 5, 0, '2025-05-14 11:56:51');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (206, 205, 5, NULL, NULL, NULL, '144', 'yyry', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', 'ry', 5, 0, '2025-05-14 11:59:05');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (207, 205, 6, NULL, NULL, NULL, '4478', 'rtt', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', 'yrtyrty', 5, 0, '2025-05-14 11:59:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (208, 205, 23, NULL, NULL, NULL, '445', 'tt', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', 'yrty', 5, 1, '2025-05-14 11:59:06');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (209, 0, NULL, 26, 11, '2025-05-14', 'trrrrrrrrrr', '', 1, '10.00', '10.00', '11.80', '', '', '0.00', '18.00', '', 5, 1, '2025-05-14 11:59:23');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (210, 0, NULL, 26, 11, '2025-05-15', '2122', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 0, '2025-05-15 04:17:42');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (211, 0, NULL, 26, 11, '2025-05-15', '3421', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 2, 0, '2025-05-15 11:50:03');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (212, 0, NULL, 26, 11, '2025-05-16', '34211', '2', 1, '200.00', '200.00', '236.00', '', '', '0.00', '18.00', '220', 1, 0, '2025-05-15 11:50:18');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (213, 211, 5, NULL, NULL, NULL, '5643', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 1, 0, '2025-05-15 11:50:40');
INSERT INTO `blood_donor_cycle` (`id`, `blood_donor_cycle_id`, `blood_bank_product_id`, `blood_donor_id`, `charge_id`, `donate_date`, `bag_no`, `lot`, `quantity`, `standard_charge`, `apply_charge`, `amount`, `institution`, `note`, `discount_percentage`, `tax_percentage`, `volume`, `unit`, `available`, `created_at`) VALUES (214, 211, 6, NULL, NULL, NULL, '6743', '2', 1, NULL, NULL, NULL, '', NULL, '0.00', '0.00', '220', 6, 1, '2025-05-15 11:50:40');


#
# TABLE STRUCTURE FOR: blood_issue
#

DROP TABLE IF EXISTS `blood_issue`;

CREATE TABLE `blood_issue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int NOT NULL,
  `case_reference_id` int DEFAULT NULL,
  `blood_donor_cycle_id` int DEFAULT NULL,
  `date_of_issue` datetime DEFAULT NULL,
  `hospital_doctor` int DEFAULT NULL,
  `reference` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `charge_id` int DEFAULT NULL,
  `standard_charge` int NOT NULL,
  `tax_percentage` float(10,2) NOT NULL,
  `discount_percentage` float(10,2) DEFAULT '0.00',
  `amount` float(10,2) DEFAULT NULL,
  `net_amount` float(10,2) NOT NULL,
  `institution` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `technician` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `remark` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `organisation_id` int DEFAULT NULL,
  `insurance_validity` date DEFAULT NULL,
  `insurance_id` varchar(250) DEFAULT NULL,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `blood_donor_cycle_id` (`blood_donor_cycle_id`),
  KEY `patient_id` (`patient_id`),
  KEY `charge_id` (`charge_id`),
  KEY `generated_by` (`generated_by`),
  KEY `organisation_id` (`organisation_id`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_tax_percentage` (`tax_percentage`),
  KEY `index_discount_percentage` (`discount_percentage`),
  KEY `index_amount` (`amount`),
  KEY `index_net_amount` (`net_amount`),
  KEY `hospital_doctor` (`hospital_doctor`),
  CONSTRAINT `blood_issue_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_2` FOREIGN KEY (`blood_donor_cycle_id`) REFERENCES `blood_donor_cycle` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_4` FOREIGN KEY (`charge_id`) REFERENCES `charges` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_5` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_6` FOREIGN KEY (`organisation_id`) REFERENCES `organisation` (`id`) ON DELETE CASCADE,
  CONSTRAINT `blood_issue_ibfk_7` FOREIGN KEY (`hospital_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8mb3;

INSERT INTO `blood_issue` (`id`, `patient_id`, `case_reference_id`, `blood_donor_cycle_id`, `date_of_issue`, `hospital_doctor`, `reference`, `charge_id`, `standard_charge`, `tax_percentage`, `discount_percentage`, `amount`, `net_amount`, `institution`, `technician`, `remark`, `organisation_id`, `insurance_validity`, `insurance_id`, `generated_by`, `created_at`) VALUES (11, 7, NULL, 10, '2024-10-08 18:14:00', NULL, 'Ajay Verma (9002)', 11, 200, '18.00', '3.00', '5.00', '5.72', NULL, '', '', 6, '2025-10-29', '100', 1, '2024-10-08 12:46:09');


#
# TABLE STRUCTURE FOR: captcha
#

DROP TABLE IF EXISTS `captcha`;

CREATE TABLE `captcha` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `status` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (1, 'userlogin', 0, '2025-04-11 09:10:24');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (2, 'login', 0, '2021-10-22 05:21:38');
INSERT INTO `captcha` (`id`, `name`, `status`, `created_at`) VALUES (3, 'appointment', 0, '2025-04-09 05:15:06');


#
# TABLE STRUCTURE FOR: case_references
#

DROP TABLE IF EXISTS `case_references`;

CREATE TABLE `case_references` (
  `id` int NOT NULL AUTO_INCREMENT,
  `bill_id` int DEFAULT NULL,
  `discount_percentage` float(10,2) NOT NULL DEFAULT '0.00',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_references_ibfk_1` (`bill_id`),
  CONSTRAINT `case_references_ibfk_1` FOREIGN KEY (`bill_id`) REFERENCES `bill` (`id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=391 DEFAULT CHARSET=utf8mb3;

INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (1, NULL, '0.00', '2024-09-26 07:37:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (2, NULL, '0.00', '2024-09-26 09:54:19');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (3, NULL, '0.00', '2024-09-26 12:02:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (4, NULL, '0.00', '2024-09-27 09:29:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (5, NULL, '0.00', '2024-09-27 09:46:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (6, NULL, '0.00', '2024-09-27 09:48:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (7, NULL, '0.00', '2024-09-28 07:09:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (8, NULL, '0.00', '2024-09-28 07:13:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (9, NULL, '0.00', '2024-09-28 08:08:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (10, NULL, '0.00', '2024-09-28 10:05:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (11, NULL, '0.00', '2024-09-28 10:36:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (12, NULL, '0.00', '2024-09-28 10:36:45');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (13, NULL, '0.00', '2024-09-28 10:37:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (14, NULL, '0.00', '2024-09-28 10:37:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (15, NULL, '0.00', '2024-09-28 10:37:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (16, NULL, '0.00', '2024-09-28 10:37:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (17, NULL, '0.00', '2024-09-28 10:44:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (18, NULL, '0.00', '2024-09-28 10:47:44');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (19, NULL, '0.00', '2024-09-28 10:49:20');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (20, NULL, '0.00', '2024-09-28 10:49:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (21, NULL, '0.00', '2024-09-28 10:50:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (22, NULL, '0.00', '2024-09-30 07:25:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (23, NULL, '0.00', '2024-10-01 04:36:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (24, NULL, '0.00', '2024-10-07 11:48:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (25, NULL, '0.00', '2024-10-07 12:01:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (26, NULL, '0.00', '2024-10-08 07:50:31');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (27, NULL, '0.00', '2024-10-08 07:53:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (28, NULL, '0.00', '2024-10-08 08:17:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (29, NULL, '0.00', '2024-10-08 10:35:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (30, NULL, '0.00', '2024-10-09 07:29:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (31, NULL, '0.00', '2024-10-09 08:23:12');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (32, NULL, '0.00', '2024-10-09 08:32:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (33, NULL, '0.00', '2024-10-28 12:43:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (34, NULL, '0.00', '2024-10-28 12:45:16');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (35, NULL, '0.00', '2024-10-29 04:42:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (36, NULL, '0.00', '2024-10-29 09:01:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (37, NULL, '0.00', '2024-10-30 07:16:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (38, NULL, '0.00', '2024-10-30 12:53:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (39, NULL, '0.00', '2024-11-02 05:06:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (40, NULL, '0.00', '2024-11-04 07:28:09');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (41, NULL, '0.00', '2024-11-04 08:06:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (42, NULL, '0.00', '2024-11-04 08:41:20');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (43, NULL, '0.00', '2024-11-04 12:16:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (44, NULL, '0.00', '2024-11-04 12:36:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (45, NULL, '0.00', '2024-11-04 12:36:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (46, NULL, '0.00', '2024-11-04 12:36:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (47, NULL, '0.00', '2024-11-04 12:49:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (48, NULL, '0.00', '2024-11-05 07:35:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (49, NULL, '0.00', '2024-11-05 09:29:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (50, NULL, '0.00', '2024-11-05 09:30:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (51, NULL, '0.00', '2024-11-05 09:31:09');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (52, NULL, '0.00', '2024-11-05 09:46:00');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (53, NULL, '0.00', '2024-11-05 10:05:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (54, NULL, '0.00', '2024-11-05 10:06:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (55, NULL, '0.00', '2024-11-08 09:46:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (56, NULL, '0.00', '2024-11-08 11:46:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (57, NULL, '0.00', '2024-11-09 12:39:10');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (58, NULL, '0.00', '2024-11-11 10:12:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (59, NULL, '0.00', '2024-11-11 10:14:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (60, NULL, '0.00', '2024-11-11 10:30:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (61, NULL, '0.00', '2024-11-11 10:36:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (62, NULL, '0.00', '2024-11-11 12:10:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (63, NULL, '0.00', '2024-11-13 05:41:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (64, NULL, '0.00', '2024-11-13 07:02:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (65, NULL, '0.00', '2024-11-13 07:04:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (66, NULL, '0.00', '2024-11-13 07:04:54');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (67, NULL, '0.00', '2024-11-13 12:22:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (68, NULL, '0.00', '2024-11-13 13:03:10');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (69, NULL, '0.00', '2024-11-14 05:05:49');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (70, NULL, '0.00', '2024-11-14 12:49:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (71, NULL, '0.00', '2024-11-14 12:51:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (72, NULL, '0.00', '2024-11-15 08:24:23');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (73, NULL, '0.00', '2024-11-15 09:06:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (74, NULL, '0.00', '2024-11-15 11:59:43');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (75, NULL, '0.00', '2024-11-15 12:23:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (76, NULL, '0.00', '2024-11-15 12:38:35');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (77, NULL, '0.00', '2024-11-15 12:41:59');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (78, NULL, '0.00', '2024-11-15 12:44:10');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (79, NULL, '0.00', '2024-11-16 05:55:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (80, NULL, '0.00', '2024-11-16 07:56:18');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (81, NULL, '0.00', '2024-11-16 11:48:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (82, NULL, '0.00', '2024-11-16 12:30:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (83, NULL, '0.00', '2024-11-16 12:37:49');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (84, NULL, '0.00', '2024-11-18 05:12:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (85, NULL, '0.00', '2024-11-18 08:49:36');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (86, NULL, '0.00', '2024-11-18 09:51:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (87, NULL, '0.00', '2024-11-18 10:01:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (88, NULL, '0.00', '2024-11-18 10:43:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (89, NULL, '0.00', '2024-11-19 05:27:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (90, NULL, '0.00', '2024-11-19 05:32:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (91, NULL, '0.00', '2024-11-19 05:40:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (92, NULL, '0.00', '2024-11-19 06:03:35');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (93, NULL, '0.00', '2024-11-19 07:11:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (94, NULL, '0.00', '2024-11-19 07:32:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (95, NULL, '0.00', '2024-11-19 07:43:00');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (96, NULL, '0.00', '2024-11-19 08:04:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (97, NULL, '0.00', '2024-11-19 09:11:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (98, NULL, '0.00', '2024-11-19 09:26:23');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (99, NULL, '0.00', '2024-11-20 12:33:09');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (100, NULL, '0.00', '2024-11-20 12:55:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (101, NULL, '0.00', '2024-11-20 13:20:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (102, NULL, '0.00', '2024-11-21 05:46:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (103, NULL, '0.00', '2024-11-21 05:47:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (104, NULL, '0.00', '2024-11-21 09:33:20');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (105, NULL, '0.00', '2024-11-21 09:36:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (106, NULL, '0.00', '2024-11-21 12:48:27');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (107, NULL, '0.00', '2024-11-21 12:56:16');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (108, NULL, '0.00', '2024-11-25 05:42:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (109, NULL, '0.00', '2024-11-25 05:44:10');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (110, NULL, '0.00', '2024-11-25 05:52:16');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (111, NULL, '0.00', '2024-11-25 06:10:19');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (112, NULL, '0.00', '2024-11-25 06:14:52');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (113, NULL, '0.00', '2024-11-25 06:18:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (114, NULL, '0.00', '2024-11-25 07:05:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (115, NULL, '0.00', '2024-11-25 07:11:36');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (116, NULL, '0.00', '2024-11-25 09:09:29');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (117, NULL, '0.00', '2024-11-25 09:46:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (118, NULL, '0.00', '2024-11-25 10:35:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (119, NULL, '0.00', '2024-11-25 10:45:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (120, NULL, '0.00', '2024-11-25 11:18:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (121, NULL, '0.00', '2024-11-26 04:27:54');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (122, NULL, '0.00', '2024-11-26 05:38:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (123, NULL, '0.00', '2024-11-26 05:56:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (124, NULL, '0.00', '2024-11-26 07:43:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (125, NULL, '0.00', '2024-11-26 07:46:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (126, NULL, '0.00', '2024-11-26 07:55:22');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (127, NULL, '0.00', '2024-11-26 07:58:09');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (128, NULL, '0.00', '2024-11-26 08:00:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (129, NULL, '0.00', '2024-11-26 08:01:27');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (130, NULL, '0.00', '2024-11-26 08:02:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (131, NULL, '0.00', '2024-11-26 08:08:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (132, NULL, '0.00', '2024-11-26 08:12:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (133, NULL, '0.00', '2024-11-26 08:13:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (134, NULL, '0.00', '2024-11-26 08:15:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (135, NULL, '0.00', '2024-11-26 08:45:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (136, NULL, '0.00', '2024-11-26 10:38:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (137, NULL, '0.00', '2024-11-26 10:44:59');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (138, NULL, '0.00', '2024-11-26 10:46:05');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (139, NULL, '0.00', '2024-11-26 10:50:40');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (140, NULL, '0.00', '2024-11-26 11:15:05');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (141, NULL, '0.00', '2024-11-26 11:18:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (142, NULL, '0.00', '2024-11-26 11:41:16');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (143, NULL, '0.00', '2024-11-27 08:06:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (144, NULL, '0.00', '2024-11-28 08:18:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (145, NULL, '0.00', '2024-11-28 09:33:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (146, NULL, '0.00', '2024-11-29 09:31:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (147, NULL, '0.00', '2024-11-29 10:04:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (148, NULL, '0.00', '2024-11-29 10:07:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (149, NULL, '0.00', '2024-11-29 12:51:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (150, NULL, '0.00', '2024-11-30 07:50:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (151, NULL, '0.00', '2024-11-30 08:50:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (152, NULL, '0.00', '2024-11-30 08:55:22');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (153, NULL, '0.00', '2024-11-30 09:46:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (154, NULL, '0.00', '2024-12-02 05:38:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (155, NULL, '0.00', '2024-12-02 07:05:19');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (156, NULL, '0.00', '2024-12-02 13:15:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (157, NULL, '0.00', '2024-12-03 06:21:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (158, NULL, '0.00', '2024-12-03 06:21:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (159, NULL, '0.00', '2024-12-03 07:06:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (160, NULL, '0.00', '2024-12-03 07:36:43');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (161, NULL, '0.00', '2024-12-03 07:39:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (162, NULL, '0.00', '2024-12-03 07:50:29');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (163, NULL, '0.00', '2024-12-03 08:27:34');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (164, NULL, '0.00', '2024-12-03 09:34:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (165, NULL, '0.00', '2024-12-05 05:06:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (166, NULL, '0.00', '2024-12-05 05:07:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (167, NULL, '0.00', '2024-12-05 06:30:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (168, NULL, '0.00', '2024-12-05 06:32:34');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (169, NULL, '0.00', '2024-12-05 06:36:29');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (170, NULL, '0.00', '2024-12-05 06:47:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (171, NULL, '0.00', '2024-12-05 06:52:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (172, NULL, '0.00', '2024-12-05 07:06:36');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (173, NULL, '0.00', '2024-12-05 07:22:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (174, NULL, '0.00', '2024-12-05 07:29:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (175, NULL, '0.00', '2024-12-05 07:36:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (176, NULL, '0.00', '2024-12-05 07:42:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (177, NULL, '0.00', '2024-12-05 08:48:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (178, NULL, '0.00', '2024-12-07 09:37:37');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (179, NULL, '0.00', '2024-12-09 08:30:16');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (180, NULL, '0.00', '2024-12-10 04:31:20');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (181, NULL, '0.00', '2025-02-11 09:57:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (182, NULL, '0.00', '2025-02-18 12:42:31');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (183, NULL, '0.00', '2025-02-19 06:55:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (184, NULL, '0.00', '2025-02-20 09:31:44');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (185, NULL, '0.00', '2025-02-20 12:07:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (186, NULL, '0.00', '2025-02-28 10:15:40');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (187, NULL, '0.00', '2025-02-28 10:44:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (188, NULL, '0.00', '2025-02-28 12:53:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (189, NULL, '0.00', '2025-03-01 05:38:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (190, NULL, '0.00', '2025-03-01 05:39:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (191, NULL, '0.00', '2025-03-01 10:10:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (192, NULL, '0.00', '2025-03-01 10:12:22');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (193, NULL, '0.00', '2025-03-03 12:31:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (194, NULL, '0.00', '2025-03-03 13:02:10');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (195, NULL, '0.00', '2025-03-04 08:00:22');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (196, NULL, '0.00', '2025-03-05 07:54:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (197, NULL, '0.00', '2025-03-06 12:08:20');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (198, NULL, '0.00', '2025-03-07 04:29:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (199, NULL, '0.00', '2025-03-07 05:13:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (200, NULL, '0.00', '2025-03-08 05:36:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (201, NULL, '0.00', '2025-03-08 06:16:29');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (202, NULL, '0.00', '2025-03-08 08:38:16');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (203, NULL, '0.00', '2025-03-08 09:21:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (204, NULL, '0.00', '2025-03-08 09:22:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (205, NULL, '0.00', '2025-03-08 09:56:09');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (206, NULL, '0.00', '2025-03-08 09:59:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (207, NULL, '0.00', '2025-03-08 11:23:23');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (208, NULL, '0.00', '2025-03-10 07:33:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (209, NULL, '0.00', '2025-03-10 09:50:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (210, NULL, '0.00', '2025-03-10 10:36:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (211, NULL, '0.00', '2025-03-10 13:13:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (212, NULL, '0.00', '2025-03-11 05:55:52');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (213, NULL, '0.00', '2025-03-12 04:29:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (214, NULL, '0.00', '2025-03-12 05:12:35');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (215, NULL, '0.00', '2025-03-12 05:32:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (216, NULL, '0.00', '2025-03-12 05:37:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (217, NULL, '0.00', '2025-03-12 07:16:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (218, NULL, '0.00', '2025-03-12 07:52:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (219, NULL, '0.00', '2025-03-12 08:06:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (220, NULL, '0.00', '2025-03-12 08:08:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (221, NULL, '0.00', '2025-03-12 08:17:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (222, NULL, '0.00', '2025-03-12 08:18:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (223, NULL, '0.00', '2025-03-12 08:26:05');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (224, NULL, '0.00', '2025-03-12 08:35:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (225, NULL, '0.00', '2025-03-12 11:31:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (226, NULL, '0.00', '2025-03-17 05:28:52');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (227, NULL, '0.00', '2025-03-17 09:17:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (228, NULL, '0.00', '2025-03-17 09:44:35');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (229, NULL, '0.00', '2025-03-17 10:17:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (230, NULL, '0.00', '2025-03-18 04:33:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (231, NULL, '0.00', '2025-03-18 11:45:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (232, NULL, '0.00', '2025-03-18 12:05:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (233, NULL, '0.00', '2025-03-19 09:47:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (234, NULL, '0.00', '2025-03-19 10:52:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (235, NULL, '0.00', '2025-03-19 10:53:37');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (236, NULL, '0.00', '2025-03-19 12:40:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (237, NULL, '0.00', '2025-03-20 04:38:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (238, NULL, '0.00', '2025-03-20 04:40:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (239, NULL, '0.00', '2025-03-20 04:43:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (240, NULL, '0.00', '2025-03-20 04:45:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (241, NULL, '0.00', '2025-03-20 04:49:41');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (242, NULL, '0.00', '2025-03-20 04:50:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (243, NULL, '0.00', '2025-03-20 05:15:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (244, NULL, '0.00', '2025-03-20 05:45:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (245, NULL, '0.00', '2025-03-20 07:53:19');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (246, NULL, '0.00', '2025-03-20 08:20:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (247, NULL, '0.00', '2025-03-20 09:25:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (248, NULL, '0.00', '2025-03-20 11:25:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (249, NULL, '0.00', '2025-03-21 07:04:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (250, NULL, '0.00', '2025-03-21 07:26:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (251, NULL, '0.00', '2025-03-21 09:05:05');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (252, NULL, '0.00', '2025-03-21 09:11:55');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (253, NULL, '0.00', '2025-03-21 09:45:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (254, NULL, '0.00', '2025-03-21 09:46:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (255, NULL, '0.00', '2025-03-24 08:06:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (256, NULL, '0.00', '2025-04-05 07:22:59');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (257, NULL, '0.00', '2025-04-05 07:23:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (258, NULL, '0.00', '2025-04-05 07:32:54');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (259, NULL, '0.00', '2025-04-05 08:50:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (260, NULL, '0.00', '2025-04-05 11:26:29');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (261, NULL, '0.00', '2025-04-05 11:43:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (262, NULL, '0.00', '2025-04-05 11:57:29');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (263, NULL, '0.00', '2025-04-08 05:12:16');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (264, NULL, '0.00', '2025-04-08 05:26:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (265, NULL, '0.00', '2025-04-10 08:00:12');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (266, NULL, '0.00', '2025-04-11 08:21:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (267, NULL, '0.00', '2025-04-11 11:27:12');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (268, NULL, '0.00', '2025-04-11 11:42:38');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (269, NULL, '0.00', '2025-04-11 11:44:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (270, NULL, '0.00', '2025-04-12 04:58:00');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (271, NULL, '0.00', '2025-04-12 07:51:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (272, NULL, '0.00', '2025-04-12 07:52:34');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (273, NULL, '0.00', '2025-04-12 11:12:29');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (274, NULL, '0.00', '2025-04-14 07:53:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (275, NULL, '0.00', '2025-04-14 08:34:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (276, NULL, '0.00', '2025-04-14 10:10:44');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (277, NULL, '0.00', '2025-04-15 07:31:12');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (278, NULL, '0.00', '2025-04-15 07:46:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (279, NULL, '0.00', '2025-04-15 07:52:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (280, NULL, '0.00', '2025-04-15 10:37:54');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (281, NULL, '0.00', '2025-04-15 11:11:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (282, NULL, '0.00', '2025-04-18 07:31:09');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (283, NULL, '0.00', '2025-04-18 07:32:18');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (284, NULL, '0.00', '2025-04-21 04:17:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (285, NULL, '0.00', '2025-04-21 07:22:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (286, NULL, '0.00', '2025-04-21 10:03:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (287, NULL, '0.00', '2025-04-22 04:46:23');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (288, NULL, '0.00', '2025-04-22 06:08:54');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (289, NULL, '0.00', '2025-04-22 07:43:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (290, NULL, '0.00', '2025-04-22 09:31:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (291, NULL, '0.00', '2025-04-22 09:41:28');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (292, NULL, '0.00', '2025-04-22 12:03:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (293, NULL, '0.00', '2025-04-23 04:14:37');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (294, NULL, '0.00', '2025-04-23 05:32:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (295, NULL, '0.00', '2025-04-23 07:33:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (296, NULL, '0.00', '2025-04-23 08:08:49');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (297, NULL, '0.00', '2025-04-23 10:07:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (298, NULL, '0.00', '2025-04-23 11:42:37');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (299, NULL, '0.00', '2025-04-23 12:06:05');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (300, NULL, '0.00', '2025-04-24 08:26:56');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (301, NULL, '0.00', '2025-04-24 11:22:12');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (302, NULL, '0.00', '2025-04-25 04:53:10');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (303, NULL, '0.00', '2025-04-25 04:56:59');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (304, NULL, '0.00', '2025-04-25 05:03:09');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (305, NULL, '0.00', '2025-04-25 05:22:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (306, NULL, '0.00', '2025-04-26 07:29:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (307, NULL, '0.00', '2025-04-26 07:41:54');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (308, NULL, '0.00', '2025-04-26 07:59:00');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (309, NULL, '0.00', '2025-04-26 09:03:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (310, NULL, '0.00', '2025-04-26 12:02:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (311, NULL, '0.00', '2025-04-26 12:05:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (312, NULL, '0.00', '2025-04-28 07:02:44');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (313, NULL, '0.00', '2025-04-28 07:34:42');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (314, NULL, '0.00', '2025-04-28 07:36:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (315, NULL, '0.00', '2025-04-28 07:57:45');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (316, NULL, '0.00', '2025-04-28 10:40:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (317, NULL, '0.00', '2025-04-28 10:52:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (318, NULL, '0.00', '2025-04-29 07:17:08');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (319, NULL, '0.00', '2025-04-29 09:29:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (320, NULL, '0.00', '2025-05-01 04:32:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (321, NULL, '0.00', '2025-05-01 10:59:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (322, NULL, '0.00', '2025-05-01 11:10:11');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (323, NULL, '0.00', '2025-05-02 07:16:03');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (324, NULL, '0.00', '2025-05-03 07:03:46');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (325, NULL, '0.00', '2025-05-03 08:23:39');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (326, NULL, '0.00', '2025-05-03 11:06:15');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (327, NULL, '0.00', '2025-05-03 11:12:26');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (328, NULL, '0.00', '2025-05-03 12:23:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (329, NULL, '0.00', '2025-05-05 06:04:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (330, NULL, '0.00', '2025-05-05 08:14:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (331, NULL, '0.00', '2025-05-05 08:34:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (332, NULL, '0.00', '2025-05-05 08:37:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (333, NULL, '0.00', '2025-05-05 09:14:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (334, NULL, '0.00', '2025-05-05 10:17:24');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (335, NULL, '0.00', '2025-05-05 10:51:01');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (336, NULL, '0.00', '2025-05-05 11:01:05');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (337, NULL, '0.00', '2025-05-05 11:15:02');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (338, NULL, '0.00', '2025-05-05 11:17:47');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (339, NULL, '0.00', '2025-05-05 11:24:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (340, NULL, '0.00', '2025-05-05 11:26:57');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (341, NULL, '0.00', '2025-05-05 11:27:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (342, NULL, '0.00', '2025-05-05 11:49:27');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (343, NULL, '0.00', '2025-05-06 06:36:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (344, NULL, '0.00', '2025-05-06 08:33:52');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (345, NULL, '0.00', '2025-05-06 10:03:04');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (346, NULL, '0.00', '2025-05-06 10:05:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (347, NULL, '0.00', '2025-05-06 10:15:49');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (348, NULL, '0.00', '2025-05-06 10:40:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (349, NULL, '0.00', '2025-05-07 06:32:32');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (350, NULL, '0.00', '2025-05-07 09:05:25');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (351, NULL, '0.00', '2025-05-07 09:28:14');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (352, NULL, '0.00', '2025-05-08 06:16:48');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (353, NULL, '0.00', '2025-05-08 11:38:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (354, NULL, '0.00', '2025-05-09 09:09:17');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (355, NULL, '0.00', '2025-05-09 10:54:19');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (356, NULL, '0.00', '2025-05-09 12:16:05');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (357, NULL, '0.00', '2025-05-10 07:09:18');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (358, NULL, '0.00', '2025-05-10 07:15:45');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (359, NULL, '0.00', '2025-05-10 10:45:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (360, NULL, '0.00', '2025-05-12 05:08:37');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (361, NULL, '0.00', '2025-05-12 05:40:23');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (362, NULL, '0.00', '2025-05-12 05:40:49');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (363, NULL, '0.00', '2025-05-12 07:44:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (364, NULL, '0.00', '2025-05-12 09:29:31');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (365, NULL, '0.00', '2025-05-12 09:30:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (366, NULL, '0.00', '2025-05-12 09:33:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (367, NULL, '0.00', '2025-05-12 10:15:52');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (368, NULL, '0.00', '2025-05-12 10:16:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (369, NULL, '0.00', '2025-05-12 10:20:37');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (370, NULL, '0.00', '2025-05-13 05:04:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (371, NULL, '0.00', '2025-05-13 05:05:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (372, NULL, '0.00', '2025-05-13 05:17:19');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (373, NULL, '0.00', '2025-05-13 06:05:07');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (374, NULL, '0.00', '2025-05-13 06:20:12');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (375, NULL, '0.00', '2025-05-15 08:11:35');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (376, NULL, '0.00', '2025-05-15 09:41:43');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (377, NULL, '0.00', '2025-05-15 09:43:58');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (378, NULL, '0.00', '2025-05-15 09:48:45');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (379, NULL, '0.00', '2025-05-15 09:49:51');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (380, NULL, '0.00', '2025-05-15 09:54:08');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (381, NULL, '0.00', '2025-05-15 09:57:30');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (382, NULL, '0.00', '2025-05-15 09:57:35');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (383, NULL, '0.00', '2025-05-15 10:05:21');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (384, NULL, '0.00', '2025-05-15 10:06:50');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (385, NULL, '0.00', '2025-05-15 10:21:18');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (386, NULL, '0.00', '2025-05-15 10:25:53');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (387, NULL, '0.00', '2025-05-15 10:28:06');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (388, NULL, '0.00', '2025-05-15 10:30:13');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (389, NULL, '0.00', '2025-05-15 11:20:33');
INSERT INTO `case_references` (`id`, `bill_id`, `discount_percentage`, `created_at`) VALUES (390, NULL, '0.00', '2025-05-15 11:22:33');


#
# TABLE STRUCTURE FOR: certificates
#

DROP TABLE IF EXISTS `certificates`;

CREATE TABLE `certificates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `certificate_name` varchar(100) NOT NULL,
  `certificate_text` text,
  `left_header` varchar(100) NOT NULL,
  `center_header` varchar(100) NOT NULL,
  `right_header` varchar(100) NOT NULL,
  `left_footer` varchar(100) NOT NULL,
  `right_footer` varchar(100) NOT NULL,
  `center_footer` varchar(100) NOT NULL,
  `background_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `created_for` tinyint(1) NOT NULL COMMENT '1 = staff, 2 = patients',
  `status` tinyint(1) NOT NULL,
  `header_height` int NOT NULL,
  `content_height` int NOT NULL,
  `footer_height` int NOT NULL,
  `content_width` int NOT NULL,
  `enable_patient_image` tinyint(1) NOT NULL COMMENT '0=no,1=yes',
  `enable_image_height` int NOT NULL,
  `updated_at` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb3;

INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (12, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', 'certificate.jpg', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2021-10-28 22:58:45');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (13, 'Sample Patient File Cover', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', 'certificate1.jpg', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2024-11-26 06:54:29');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (14, 'File cover', '<td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2024-10-14 08:01:09');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (15, 'FILE COVER', '<td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2024-10-14 08:00:33');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (16, 'Document #$%^ file', '<td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', 'Titel', 'titel', '', '', '', '', '', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2024-11-12 08:35:52');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (18, 'sample /card /', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2024-11-12 08:41:45');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (19, 'test', 'test', '', '', '', '', '', '', 'K_(6).png', 2, 1, 0, 0, 0, 0, 0, 0, NULL, '2024-11-27 10:16:17');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (22, 'test', 'test', '', '', '', '', '', '', '1732704798-14722447616746fa1e3828e!K (6).png', 2, 1, 0, 0, 0, 0, 0, 0, NULL, '2024-11-27 10:53:18');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (23, 'test', '53w5', '', '', '', '', '', '', '1732951374-1719536073674abd4e6732a!tset (7).png', 2, 1, 0, 0, 0, 0, 0, 0, NULL, '2024-11-30 07:22:54');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (24, 'HELLO', 'HELLO', '', '', '', '', '', '', '1733315121-56268668967504a315af0c!7 (1) (2).jpg', 2, 1, 400, 600, 300, 200, 1, 200, NULL, '2024-12-04 12:25:21');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (28, 'testing', 'name-\r\npatient', 'header........', 'admin.........', 'header..............', '', '', '', '1742800070-84860346867e104c613bb2!tset (3) (1) (2) (3).png', 2, 1, 450, 870, 670, 560, 1, 200, NULL, '2025-03-24 07:07:50');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (30, 'template name', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '1744112845-56914223467f50ccd0e518!7 (1) (2) (2).jpg', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2025-04-08 11:47:25');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (31, 'template name', '<table class=\"table table-bordered\" width=\"100%\">\r\n <tr>\r\n  <td width=\"50%\">Patient Name  </td>\r\n  <td width=\"50%\">[name] ([patient_id]) </td>\r\n </tr>\r\n <tr>\r\n  <td>Date of birth</td>\r\n  <td valign=\"top\">[dob]</td>\r\n </tr>\r\n <tr>\r\n  <td>Age</td>\r\n  <td valign=\"top\">[age]</td>\r\n </tr>\r\n <tr>\r\n  <td>Gender</td>\r\n  <td valign=\"top\">[gender]</td>\r\n </tr>\r\n \r\n <tr>\r\n  <td>Phone</td>\r\n  <td valign=\"top\">[phone]</td>\r\n </tr>\r\n <tr>\r\n  <td>Guardian Name</td>\r\n  <td valign=\"top\">[guardian_name]</td>\r\n </tr>\r\n <tr>\r\n  <td>Address</td>\r\n  <td valign=\"top\">[address]</td>\r\n </tr>\r\n <tr>\r\n  <td>Email</td>\r\n  <td valign=\"top\">[email]</td>\r\n </tr>\r\n <tr>\r\n  <td>OPD/IPD NO</td>\r\n  <td valign=\"top\">[opd_ipd_no]</td>\r\n </tr>\r\n  <tr>\r\n  <td>OPD Checkup Id</td>\r\n  <td valign=\"top\">[opd_checkup_id]</td>\r\n </tr>\r\n <tr>\r\n  <td>Consultant Doctor</td>\r\n  <td valign=\"top\">[consultant_doctor]</td>\r\n </tr>\r\n</table>', '<h2>Patient Detail</h2>', '', '', '', '', '', '1744112845-172975267767f50ccd1e5c6!7 (1) (2) (2).jpg', 2, 1, 140, 300, 700, 600, 1, 200, NULL, '2025-04-08 11:47:25');
INSERT INTO `certificates` (`id`, `certificate_name`, `certificate_text`, `left_header`, `center_header`, `right_header`, `left_footer`, `right_footer`, `center_footer`, `background_image`, `created_for`, `status`, `header_height`, `content_height`, `footer_height`, `content_width`, `enable_patient_image`, `enable_image_height`, `updated_at`, `created_at`) VALUES (32, '//template//', 'add', 'add', '', '', '', '', '', '1744892939-2883999386800f40b6a956!ki (1) (1) (1) (1) (1) (3).jpg', 2, 1, 500, 600, 300, 260, 1, 200, NULL, '2025-04-17 12:28:59');


#
# TABLE STRUCTURE FOR: charge_categories
#

DROP TABLE IF EXISTS `charge_categories`;

CREATE TABLE `charge_categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `charge_type_id` int DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `description` mediumtext,
  `short_code` varchar(30) DEFAULT NULL,
  `is_default` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_type_id` (`charge_type_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `charge_categories_ibfk_1` FOREIGN KEY (`charge_type_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (1, 2, 'Opd Charge', 'Opd Charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (2, 1, 'Appointment meeting', 'Appointment meeting', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (3, 3, 'Ipd Charge', 'Ipd Charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (4, 7, 'Ambulance service', 'Ambulance services', NULL, '', '2025-04-10 08:15:15');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (5, 6, 'Blood bank Charge', 'Blood bank Charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (6, 4, 'pathology', 'pathology test', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (8, 12, 'heametology', 'all heametology charges', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (9, 1, 'TPA Appointment', 'TPA Appointment', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (10, 2, 'TPA opd', 'TPA opd', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (11, 3, 'TPA ipd', 'TPA ipd', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (12, 4, 'TPA path', 'TPA path', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (13, 5, 'TPA radiology  charge', 'tpa radiology', NULL, '', '2024-10-08 11:17:40');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (14, 2, 'opd charge fees', 'opd fees', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (15, 4, 'pahtology charge', 'path charge', NULL, '', '2024-11-16 12:27:15');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (18, 12, 'OTHER CHARGE', 'other charge', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (19, 5, 'Charge Category', 'Charge Category', NULL, '', NULL);
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (22, 15, 'adds', 'add', NULL, '', '2025-04-17 10:50:18');
INSERT INTO `charge_categories` (`id`, `charge_type_id`, `name`, `description`, `short_code`, `is_default`, `created_at`) VALUES (23, 1, 'text', 'adds', NULL, '', NULL);


#
# TABLE STRUCTURE FOR: charge_type_master
#

DROP TABLE IF EXISTS `charge_type_master`;

CREATE TABLE `charge_type_master` (
  `id` int NOT NULL AUTO_INCREMENT,
  `charge_type` varchar(200) NOT NULL,
  `is_default` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_charge_type` (`charge_type`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (1, 'Appointment', 'yes', 'yes', '2021-09-24 14:10:32');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (2, 'OPD', 'yes', 'yes', '2021-09-24 14:10:02');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (3, 'IPD', 'yes', 'yes', '2021-09-24 14:10:47');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', 'yes', '2021-10-22 21:40:03');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (5, 'Radiology', 'yes', 'yes', '2021-10-22 22:10:21');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (6, 'Blood Bank', 'yes', 'yes', '2021-10-22 22:10:33');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (7, 'Ambulance', 'yes', 'yes', '2021-10-22 22:10:44');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (8, 'Procedures', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (9, 'Investigations', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (10, 'Supplier', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (11, 'Operations', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (12, 'Others', 'yes', 'yes', '2018-08-17 13:40:07');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (15, 'OTHER CHARGE', 'no', 'yes', '2024-11-18 07:19:05');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (19, 'testings', 'no', 'yes', '2025-04-10 08:30:29');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (20, 'billing', 'no', 'yes', '2025-04-17 10:51:16');
INSERT INTO `charge_type_master` (`id`, `charge_type`, `is_default`, `is_active`, `created_at`) VALUES (21, 'charge type', 'no', 'yes', '2025-05-01 08:08:12');


#
# TABLE STRUCTURE FOR: charge_type_module
#

DROP TABLE IF EXISTS `charge_type_module`;

CREATE TABLE `charge_type_module` (
  `id` int NOT NULL AUTO_INCREMENT,
  `charge_type_master_id` int DEFAULT NULL,
  `module_shortcode` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_type_master_id` (`charge_type_master_id`),
  CONSTRAINT `charge_type_module_ibfk_1` FOREIGN KEY (`charge_type_master_id`) REFERENCES `charge_type_master` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (2, 1, 'appointment', '2021-10-23 03:52:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (4, 2, 'opd', '2021-10-23 03:52:45');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (5, 3, 'ipd', '2021-10-23 03:52:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (6, 4, 'pathology', '2021-10-23 03:52:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (7, 5, 'radiology', '2021-10-23 03:52:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (8, 6, 'blood_bank', '2021-10-23 03:52:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (9, 7, 'ambulance', '2021-10-23 03:52:59');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (10, 8, 'opd', '2021-10-23 03:53:03');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (11, 8, 'ipd', '2021-10-23 03:53:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (13, 9, 'pathology', '2021-10-23 03:53:09');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (14, 9, 'radiology', '2021-10-23 03:53:11');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (15, 10, 'opd', '2021-10-23 03:53:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (16, 10, 'ipd', '2021-10-23 03:53:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (17, 11, 'opd', '2021-10-23 03:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (18, 11, 'ipd', '2021-10-23 03:53:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (19, 12, 'appointment', '2021-10-23 03:53:20');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (20, 12, 'opd', '2021-10-23 03:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (21, 12, 'ipd', '2021-10-23 03:53:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (24, 12, 'pathology', '2021-10-23 03:53:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (25, 12, 'radiology', '2021-10-23 03:53:27');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (26, 12, 'blood_bank', '2021-10-23 03:53:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (27, 12, 'ambulance', '2021-10-23 03:53:31');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (28, 1, 'opd', '2024-09-28 12:10:23');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (29, 1, 'ipd', '2024-09-28 12:10:24');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (30, 1, 'pathology', '2024-09-28 12:10:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (31, 1, 'radiology', '2024-09-28 12:10:28');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (32, 1, 'blood_bank', '2024-09-28 12:10:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (34, 2, 'appointment', '2024-09-28 12:10:33');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (35, 3, 'appointment', '2024-09-28 12:10:34');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (36, 4, 'appointment', '2024-09-28 12:10:35');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (37, 5, 'appointment', '2024-09-28 12:10:36');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (38, 6, 'appointment', '2024-09-28 12:10:37');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (39, 7, 'appointment', '2024-09-28 12:10:38');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (40, 8, 'appointment', '2024-09-28 12:10:39');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (41, 9, 'appointment', '2024-09-28 12:10:40');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (42, 10, 'appointment', '2024-09-28 12:10:41');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (43, 11, 'appointment', '2024-09-28 12:10:42');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (44, 3, 'opd', '2024-09-28 12:10:46');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (45, 4, 'opd', '2024-09-28 12:10:47');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (46, 5, 'opd', '2024-09-28 12:10:48');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (47, 6, 'opd', '2024-09-28 12:10:49');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (48, 7, 'opd', '2024-09-28 12:10:50');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (49, 2, 'ipd', '2024-09-28 12:10:52');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (50, 4, 'ipd', '2024-09-28 12:10:53');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (51, 5, 'ipd', '2024-09-28 12:10:54');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (52, 6, 'ipd', '2024-09-28 12:10:56');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (53, 7, 'ipd', '2024-09-28 12:10:57');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (54, 9, 'ipd', '2024-09-28 12:10:58');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (55, 9, 'opd', '2024-09-28 12:11:00');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (56, 2, 'pathology', '2024-10-07 08:21:04');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (57, 2, 'radiology', '2024-10-07 08:21:05');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (58, 3, 'pathology', '2024-10-07 08:21:10');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (59, 5, 'pathology', '2024-10-07 08:21:12');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (60, 6, 'pathology', '2024-10-07 08:21:13');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (61, 7, 'pathology', '2024-10-07 08:21:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (62, 8, 'pathology', '2024-10-07 08:21:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (63, 10, 'pathology', '2024-10-07 08:21:15');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (64, 11, 'pathology', '2024-10-07 08:21:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (65, 7, 'radiology', '2024-10-07 08:21:18');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (66, 4, 'radiology', '2024-10-07 09:12:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (67, 3, 'radiology', '2024-10-07 09:12:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (68, 6, 'radiology', '2024-10-07 09:12:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (69, 8, 'radiology', '2024-10-07 09:12:32');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (70, 10, 'radiology', '2024-10-07 09:12:34');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (71, 11, 'radiology', '2024-10-07 09:12:35');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (72, 2, 'blood_bank', '2024-10-08 08:52:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (73, 3, 'blood_bank', '2024-10-08 08:52:15');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (74, 4, 'blood_bank', '2024-10-08 08:52:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (75, 5, 'blood_bank', '2024-10-08 08:52:19');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (76, 7, 'blood_bank', '2024-10-08 08:52:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (77, 8, 'blood_bank', '2024-10-08 08:52:23');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (78, 9, 'blood_bank', '2024-10-08 08:52:24');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (79, 10, 'blood_bank', '2024-10-08 08:52:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (80, 11, 'blood_bank', '2024-10-08 08:52:26');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (81, 2, 'ambulance', '2024-10-08 08:52:28');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (82, 3, 'ambulance', '2024-10-08 08:52:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (83, 4, 'ambulance', '2024-10-08 08:52:30');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (84, 5, 'ambulance', '2024-10-08 08:52:31');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (85, 6, 'ambulance', '2024-10-08 08:52:32');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (86, 8, 'ambulance', '2024-10-08 08:52:33');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (87, 10, 'ambulance', '2024-10-08 08:52:35');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (88, 9, 'ambulance', '2024-10-08 08:52:36');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (89, 11, 'ambulance', '2024-10-08 08:52:37');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (90, 1, 'ambulance', '2024-10-21 12:17:15');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (100, 15, 'opd', '2024-11-18 07:19:05');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (101, 15, 'appointment', '2024-11-18 07:19:11');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (102, 15, 'ipd', '2024-11-18 07:19:13');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (103, 15, 'pathology', '2024-11-18 07:19:14');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (104, 15, 'radiology', '2024-11-18 07:19:15');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (105, 15, 'blood_bank', '2024-11-18 07:19:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (106, 15, 'ambulance', '2024-11-18 07:19:17');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (122, 19, 'appointment', '2025-04-10 08:30:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (123, 19, 'opd', '2025-04-10 08:30:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (124, 19, 'ipd', '2025-04-10 08:30:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (125, 19, 'pathology', '2025-04-10 08:30:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (126, 19, 'radiology', '2025-04-10 08:30:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (127, 19, 'blood_bank', '2025-04-10 08:30:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (128, 19, 'ambulance', '2025-04-10 08:30:29');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (129, 20, 'appointment', '2025-04-17 10:51:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (130, 20, 'opd', '2025-04-17 10:51:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (131, 20, 'ipd', '2025-04-17 10:51:16');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (132, 20, 'pathology', '2025-04-17 10:51:21');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (133, 20, 'radiology', '2025-04-17 10:51:23');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (134, 20, 'blood_bank', '2025-04-17 10:51:25');
INSERT INTO `charge_type_module` (`id`, `charge_type_master_id`, `module_shortcode`, `created_at`) VALUES (135, 20, 'ambulance', '2025-04-17 10:51:26');


#
# TABLE STRUCTURE FOR: charge_units
#

DROP TABLE IF EXISTS `charge_units`;

CREATE TABLE `charge_units` (
  `id` int NOT NULL AUTO_INCREMENT,
  `unit` varchar(50) DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_unit` (`unit`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (1, 'litter', 0, '2024-09-26 07:07:21');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (2, 'hour', 0, '2024-09-26 07:07:26');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (3, 'per day', 0, '2024-09-26 07:07:33');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (5, 'ml', 0, '2024-09-26 07:07:40');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (6, 'g/dl', 0, '2024-09-26 07:07:46');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (7, 'gm/day', 0, '2024-10-07 08:56:50');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (8, 'mm', 0, '2024-10-29 11:42:49');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (12, '//day', 0, '2024-11-19 12:29:40');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (14, '/hours', 0, '2024-12-05 11:39:01');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (18, 'mml', 0, '2025-04-17 10:52:56');
INSERT INTO `charge_units` (`id`, `unit`, `is_active`, `created_at`) VALUES (19, '/unit', 0, '2025-05-01 08:11:12');


#
# TABLE STRUCTURE FOR: charges
#

DROP TABLE IF EXISTS `charges`;

CREATE TABLE `charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `charge_category_id` int DEFAULT NULL,
  `tax_category_id` int DEFAULT NULL,
  `charge_unit_id` int DEFAULT NULL,
  `name` varchar(200) NOT NULL,
  `standard_charge` float(10,2) DEFAULT '0.00',
  `date` date DEFAULT NULL,
  `description` mediumtext,
  `status` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `charge_category_id` (`charge_category_id`),
  KEY `tax_category_id` (`tax_category_id`),
  KEY `charge_unit_id` (`charge_unit_id`),
  KEY `index_name` (`name`),
  KEY `index_standard_charge` (`standard_charge`),
  KEY `index_date` (`date`),
  CONSTRAINT `charges_ibfk_1` FOREIGN KEY (`charge_category_id`) REFERENCES `charge_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_2` FOREIGN KEY (`tax_category_id`) REFERENCES `tax_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `charges_ibfk_3` FOREIGN KEY (`charge_unit_id`) REFERENCES `charge_units` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb3;

INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (1, 2, 2, 2, 'Appointment meeting', '200.00', NULL, '', '', '2024-09-26 07:10:20');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (2, 1, 1, 2, 'OPD charge service', '150.00', NULL, '', '', '2024-09-26 07:12:12');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (3, 5, 1, 1, 'Blood test charge', '250.00', NULL, '', '', '2024-09-26 07:13:47');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (4, 4, 2, 2, 'Ambulance service', '150.00', NULL, '', '', '2024-09-26 07:14:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (7, 1, 2, 2, 'tax', '200.00', NULL, '', '', '2024-10-07 09:09:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (8, 2, 1, 2, 'TPA charges', '200.00', NULL, '', '', '2024-10-08 08:11:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (9, 1, 1, 1, 'TPA ', '200.00', NULL, '', '', '2024-10-08 08:22:40');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (10, 6, 2, 2, 'TPA PATH', '250.00', NULL, '', '', '2024-10-08 08:23:37');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (11, 5, 2, 6, 'TPA BLOOD BANK', '200.00', NULL, '', '', '2024-10-08 08:24:31');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (12, 2, 1, 3, 'TPA Appointment', '200.00', NULL, '', '', '2024-10-08 10:32:16');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (13, 10, 1, 2, 'TPA OPD CHECKUP FEES', '1000.00', NULL, '', '', '2024-10-08 10:34:46');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (14, 13, 3, 2, 'tpa radiology fees', '500.00', NULL, '', '', '2024-10-08 11:18:48');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (15, 1, 1, 2, 'OPD charge fees', '500.00', NULL, '', '', '2024-10-09 08:26:57');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (16, 3, 1, 2, 'IPD charge fees', '200.00', NULL, '', '', '2024-10-09 10:47:30');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (27, 14, 7, 2, 'opd Charge', '300.00', NULL, 'add', '', '2025-03-05 08:56:58');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (28, 6, 2, 3, 'Pathology Charge', '500.00', NULL, '', '', '2025-03-10 11:30:43');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (29, 13, 2, 2, 'Radiology Charge', '500.00', NULL, '', '', '2025-03-10 12:20:10');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (32, 22, 1, 1, 'aadd', '200.00', NULL, '', '', '2025-04-17 10:48:14');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (33, 19, 3, 12, 'Test Charge', '400.00', NULL, '', '', '2025-04-25 06:25:28');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (34, 9, 1, 1, 'apply', '500.00', NULL, '', '', '2025-05-01 08:00:08');
INSERT INTO `charges` (`id`, `charge_category_id`, `tax_category_id`, `charge_unit_id`, `name`, `standard_charge`, `date`, `description`, `status`, `created_at`) VALUES (35, 4, 7, 2, '200', '200.00', NULL, '', '', '2025-05-15 05:45:35');


#
# TABLE STRUCTURE FOR: chat_connections
#

DROP TABLE IF EXISTS `chat_connections`;

CREATE TABLE `chat_connections` (
  `id` int NOT NULL AUTO_INCREMENT,
  `chat_user_one` int NOT NULL,
  `chat_user_two` int NOT NULL,
  `ip` varchar(30) DEFAULT NULL,
  `time` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_one` (`chat_user_one`),
  KEY `chat_user_two` (`chat_user_two`),
  CONSTRAINT `chat_connections_ibfk_1` FOREIGN KEY (`chat_user_one`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_connections_ibfk_2` FOREIGN KEY (`chat_user_two`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;

INSERT INTO `chat_connections` (`id`, `chat_user_one`, `chat_user_two`, `ip`, `time`, `created_at`, `updated_at`) VALUES (1, 1, 2, NULL, NULL, '2024-09-26 12:22:05', NULL);
INSERT INTO `chat_connections` (`id`, `chat_user_one`, `chat_user_two`, `ip`, `time`, `created_at`, `updated_at`) VALUES (2, 1, 3, NULL, NULL, '2024-11-04 11:24:33', NULL);
INSERT INTO `chat_connections` (`id`, `chat_user_one`, `chat_user_two`, `ip`, `time`, `created_at`, `updated_at`) VALUES (9, 1, 10, NULL, NULL, '2025-05-10 10:37:25', NULL);


#
# TABLE STRUCTURE FOR: chat_messages
#

DROP TABLE IF EXISTS `chat_messages`;

CREATE TABLE `chat_messages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` text,
  `chat_user_id` int NOT NULL,
  `ip` varchar(30) NOT NULL,
  `time` int NOT NULL,
  `is_first` int DEFAULT '0',
  `is_read` int NOT NULL DEFAULT '0',
  `chat_connection_id` int NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `chat_user_id` (`chat_user_id`),
  KEY `chat_connection_id` (`chat_connection_id`),
  CONSTRAINT `chat_messages_ibfk_1` FOREIGN KEY (`chat_user_id`) REFERENCES `chat_users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_messages_ibfk_2` FOREIGN KEY (`chat_connection_id`) REFERENCES `chat_connections` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb3;

INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (1, 'you are now connected on chat', 2, '', 0, 1, 1, 1, NULL);
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (2, 'hello', 2, '', 0, 0, 0, 1, '2024-10-29 18:01:23');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (3, 'you are now connected on chat', 3, '', 0, 1, 1, 2, NULL);
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (4, 'hello', 3, '', 0, 0, 0, 2, '2024-11-04 16:55:53');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (5, 'hello', 3, '', 0, 0, 0, 2, '2024-11-04 16:56:10');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (6, 'hello', 2, '', 0, 0, 0, 1, '2024-11-05 11:37:22');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (7, 'helo world', 3, '', 0, 0, 0, 2, '2024-11-05 17:03:37');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (8, 'dddgdgd', 3, '', 0, 0, 0, 2, '2024-11-05 17:05:44');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (9, 'fdsfds', 3, '', 0, 0, 0, 2, '2024-11-05 17:05:46');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (10, 'dsfsdf3', 3, '', 0, 0, 0, 2, '2024-11-05 17:08:36');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (11, 'hi', 3, '', 0, 0, 0, 2, '2024-11-11 12:45:41');
INSERT INTO `chat_messages` (`id`, `message`, `chat_user_id`, `ip`, `time`, `is_first`, `is_read`, `chat_connection_id`, `created_at`) VALUES (12, 'hiiiiiiiiiiiiiiii', 2, '', 0, 0, 0, 1, '2024-11-11 12:45:54');


#
# TABLE STRUCTURE FOR: chat_users
#

DROP TABLE IF EXISTS `chat_users`;

CREATE TABLE `chat_users` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_type` varchar(20) DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `create_staff_id` int DEFAULT NULL,
  `create_patient_id` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `create_staff_id` (`create_staff_id`),
  KEY `create_patient_id` (`create_patient_id`),
  CONSTRAINT `chat_users_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_3` FOREIGN KEY (`create_staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `chat_users_ibfk_4` FOREIGN KEY (`create_patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'staff', 1, NULL, NULL, NULL, 0, '2024-09-26 12:22:05', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'staff', 2, NULL, 1, NULL, 0, '2024-09-26 12:22:05', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'staff', 8, NULL, 1, NULL, 0, '2024-11-04 11:24:33', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'patient', NULL, 7, NULL, NULL, 0, '2025-03-20 07:14:56', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'staff', 22, NULL, NULL, 7, 0, '2025-03-20 07:14:56', NULL);
INSERT INTO `chat_users` (`id`, `user_type`, `staff_id`, `patient_id`, `create_staff_id`, `create_patient_id`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'patient', NULL, 167, 1, NULL, 0, '2025-05-10 10:37:25', NULL);


#
# TABLE STRUCTURE FOR: complaint
#

DROP TABLE IF EXISTS `complaint`;

CREATE TABLE `complaint` (
  `id` int NOT NULL AUTO_INCREMENT,
  `complaint_type_id` int DEFAULT NULL,
  `source` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `contact` varchar(20) NOT NULL,
  `email` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `description` text,
  `action_taken` varchar(200) NOT NULL,
  `assigned` varchar(50) NOT NULL,
  `note` text,
  `image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `complaint_type_id` (`complaint_type_id`),
  CONSTRAINT `complaint_ibfk_1` FOREIGN KEY (`complaint_type_id`) REFERENCES `complaint_type` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb3;

INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (11, 1, 'Staff', 'sdfsdfds', '4565656', '', '2025-04-16', '', '', '', '', '1732377591-14877028346741fbf717608!Screenshot 2024-10-25 162458.png', '2025-04-16 07:57:38');
INSERT INTO `complaint` (`id`, `complaint_type_id`, `source`, `name`, `contact`, `email`, `date`, `description`, `action_taken`, `assigned`, `note`, `image`, `created_at`) VALUES (22, 3, 'Staff', 'ASS', '', '', '2025-04-16', '', '', '', '', '', NULL);


#
# TABLE STRUCTURE FOR: complaint_type
#

DROP TABLE IF EXISTS `complaint_type`;

CREATE TABLE `complaint_type` (
  `id` int NOT NULL AUTO_INCREMENT,
  `complaint_type` varchar(100) NOT NULL,
  `description` mediumtext,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_complaint_type` (`complaint_type`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;

INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (1, 'Late checkup', '', '2024-09-30 07:41:18');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (2, 'hair fall', '', '2024-10-07 11:28:28');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (3, 'staff related', '', '2024-10-10 12:03:45');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (4, 'Appointment purpus', '', '2024-11-18 11:48:25');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (5, 'complain purpus', '', '2024-12-05 12:30:08');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (8, 'type', '', '2025-04-17 11:16:03');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (10, 'Add complain1', 'add', '2025-05-07 07:08:03');
INSERT INTO `complaint_type` (`id`, `complaint_type`, `description`, `created_at`) VALUES (11, 'Add complain2', 'add', '2025-05-07 07:08:03');


#
# TABLE STRUCTURE FOR: conference_staff
#

DROP TABLE IF EXISTS `conference_staff`;

CREATE TABLE `conference_staff` (
  `id` int NOT NULL AUTO_INCREMENT,
  `conference_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `conference_staff_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conference_staff_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `conference_staff` (`id`, `conference_id`, `staff_id`, `created_at`) VALUES (1, 1, 2, '2024-11-04 11:21:51');


#
# TABLE STRUCTURE FOR: conferences
#

DROP TABLE IF EXISTS `conferences`;

CREATE TABLE `conferences` (
  `id` int NOT NULL AUTO_INCREMENT,
  `purpose` varchar(200) NOT NULL,
  `staff_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `visit_details_id` int DEFAULT NULL,
  `ipd_id` int DEFAULT NULL,
  `created_id` int DEFAULT NULL,
  `title` text,
  `date` datetime NOT NULL,
  `duration` int NOT NULL,
  `password` varchar(100) NOT NULL,
  `host_video` int NOT NULL,
  `client_video` int NOT NULL,
  `description` mediumtext,
  `timezone` text,
  `return_response` text,
  `api_type` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `live_consult_link` int NOT NULL DEFAULT '1' COMMENT 'appointment zoom link for front user status',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `created_id` (`created_id`),
  CONSTRAINT `conferences_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_3` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_4` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_ibfk_5` FOREIGN KEY (`created_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb3;

INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (1, 'consult', 2, NULL, 10, NULL, NULL, 'Online consult for Checkup ID 8', '2024-11-04 11:00:00', 0, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2024-11-04 11:22:18');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (2, 'consult', 2, NULL, 126, NULL, NULL, 'Online consult for Checkup ID 111', '2024-11-26 09:50:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2024-11-26 05:38:46');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (3, 'consult', 2, NULL, 186, NULL, NULL, 'Online consult for Checkup ID 165', '2025-02-21 10:00:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-02-19 06:55:51');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (4, 'consult', 2, NULL, 187, NULL, NULL, 'Online consult for Checkup ID 166', '2025-02-28 13:00:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-02-20 09:31:44');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (5, 'consult', 2, NULL, 188, NULL, NULL, 'Online consult for Checkup ID 167', '2025-02-26 13:15:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-02-20 12:07:15');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (6, 'consult', 2, NULL, 190, NULL, NULL, 'Online consult for Checkup ID 169', '2025-03-13 10:45:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-02-28 12:53:58');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (7, 'consult', 2, NULL, 191, NULL, NULL, 'Online consult for Checkup ID 170', '2025-03-14 13:15:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-03-01 05:38:14');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (8, 'consult', 2, NULL, 192, NULL, NULL, 'Online consult for Checkup ID 171', '2025-03-27 10:45:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-03-01 05:39:02');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (9, 'consult', 2, NULL, 203, NULL, NULL, 'Online consult for Checkup ID 181', '2025-03-26 13:15:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-03-08 05:36:53');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (10, 'consult', 2, NULL, 204, NULL, NULL, 'Online consult for Checkup ID 182', '2025-03-26 12:45:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-03-08 06:16:29');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (11, 'consult', 2, NULL, 207, NULL, NULL, 'Online consult for Checkup ID 184', '2025-03-26 12:15:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-03-08 09:21:48');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (12, 'consult', 2, NULL, 208, NULL, NULL, 'Online consult for Checkup ID 185', '2025-03-25 11:30:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-03-08 09:22:42');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (13, 'consult', 2, NULL, 213, NULL, NULL, 'Online consult for Checkup ID 188', '2025-03-27 12:30:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-03-08 11:23:23');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (14, 'consult', 2, NULL, 217, NULL, NULL, 'Online consult for Checkup ID 192', '2025-03-28 13:00:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-03-10 13:13:24');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (16, 'consult', 8, NULL, 306, NULL, NULL, 'Online consult for Checkup ID 265', '2025-04-23 11:10:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-04-22 09:31:48');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (17, 'consult', 8, NULL, 307, NULL, NULL, 'Online consult for Checkup ID 266', '2025-04-23 10:10:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-04-22 09:41:28');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (21, 'meeting', NULL, NULL, NULL, NULL, 1, 'General Meeting', '2025-04-28 10:21:00', 35, 'fUtZy', 1, 0, 'General Meeting', 'Asia/Kolkata', '{\"uuid\":\"GWoa9osZQQOkwB1iFq83gA==\",\"id\":82836423930,\"host_id\":\"YvncVHZDRWeSUR09FUUsPw\",\"host_email\":\"qdocss@gmail.com\",\"topic\":\"General Meeting\",\"type\":2,\"status\":\"waiting\",\"start_time\":\"2025-04-28T04:52:07Z\",\"duration\":35,\"timezone\":\"Asia\\/Kolkata\",\"created_at\":\"2025-04-28T04:52:07Z\",\"start_url\":\"https:\\/\\/us05web.zoom.us\\/s\\/82836423930?zak=eyJ0eXAiOiJKV1QiLCJzdiI6IjAwMDAwMiIsInptX3NrbSI6InptX28ybSIsImFsZyI6IkhTMjU2In0.eyJpc3MiOiJ3ZWIiLCJjbHQiOjAsIm1udW0iOiI4MjgzNjQyMzkzMCIsImF1ZCI6ImNsaWVudHNtIiwidWlkIjoiWXZuY1ZIWkRSV2VTVVIwOUZVVXNQdyIsInppZCI6IjRmZjRhYjk5NTE4OTQ0Yzc5ZmQzZTNjNmQ2YWYxMWYxIiwic2siOiIwIiwic3R5IjoxMDAsIndjZCI6InVzMDUiLCJleHAiOjE3NDU4MjMxMjcsImlhdCI6MTc0NTgxNTkyNywiYWlkIjoiNWNVOEt3ZXBRc21xcVNCTHZGdVBwZyIsImNpZCI6IiJ9.v15NElAjVkfcd3GKS8UYDl_1QUjw0ozmPz8NbGNz28w\",\"join_url\":\"https:\\/\\/us05web.zoom.us\\/j\\/82836423930?pwd=ehDjCSfc2B70VCJsaVI06nekPQBG1O.1\",\"password\":\"fUtZy\",\"h323_password\":\"811956\",\"pstn_password\":\"811956\",\"encrypted_password\":\"ehDjCSfc2B70VCJsaVI06nekPQBG1O.1\",\"settings\":{\"host_video\":true,\"participant_video\":false,\"cn_meeting\":false,\"in_meeting\":false,\"join_before_host\":false,\"jbh_time\":0,\"mute_upon_entry\":false,\"watermark\":false,\"use_pmi\":false,\"approval_type\":2,\"audio\":\"voip\",\"auto_recording\":\"none\",\"enforce_login\":false,\"enforce_login_domains\":\"\",\"alternative_hosts\":\"\",\"alternative_host_update_polls\":false,\"close_registration\":false,\"show_share_button\":false,\"allow_multiple_devices\":false,\"registrants_confirmation_email\":true,\"waiting_room\":false,\"request_permission_to_unmute_participants\":false,\"registrants_email_notification\":true,\"meeting_authentication\":false,\"encryption_type\":\"enhanced_encryption\",\"approved_or_denied_countries_or_regions\":{\"enable\":false},\"breakout_room\":{\"enable\":false},\"internal_meeting\":false,\"continuous_meeting_chat\":{\"enable\":true,\"auto_add_invited_external_users\":false,\"auto_add_meeting_participants\":false,\"channel_id\":\"web_sch_6736a2ab2f324fc88bb8f576aae25af4\"},\"participant_focused_meeting\":false,\"push_change_to_calendar\":false,\"resources\":[],\"allow_host_control_participant_mute_state\":false,\"alternative_hosts_email_notification\":true,\"show_join_info\":false,\"device_testing\":false,\"focus_mode\":false,\"meeting_invitees\":[],\"private_meeting\":false,\"email_notification\":true,\"host_save_video_order\":false,\"sign_language_interpretation\":{\"enable\":false},\"email_in_attendee_report\":false},\"creation_source\":\"open_api\",\"pre_schedule\":false}', 'global', 2, 1, '2025-04-28 04:56:33');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (22, 'consult', 30, NULL, 328, NULL, NULL, 'Online consult for Checkup ID 288', '2025-05-04 11:30:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-05-01 04:32:25');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (23, 'consult', 2, NULL, 344, NULL, NULL, 'Online consult for Checkup ID 303', '2025-05-05 16:00:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-05-05 11:26:57');
INSERT INTO `conferences` (`id`, `purpose`, `staff_id`, `patient_id`, `visit_details_id`, `ipd_id`, `created_id`, `title`, `date`, `duration`, `password`, `host_video`, `client_video`, `description`, `timezone`, `return_response`, `api_type`, `status`, `live_consult_link`, `created_at`) VALUES (24, 'consult', 2, NULL, 356, NULL, NULL, 'Online consult for Checkup ID 315', '2025-05-09 12:00:00', 5, '', 1, 1, NULL, 'Asia/Kolkata', NULL, 'global', 0, 0, '2025-05-09 09:09:17');


#
# TABLE STRUCTURE FOR: conferences_history
#

DROP TABLE IF EXISTS `conferences_history`;

CREATE TABLE `conferences_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `conference_id` int DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `patient_id` int DEFAULT NULL,
  `total_hit` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `conference_id` (`conference_id`),
  KEY `staff_id` (`staff_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `conferences_history_ibfk_1` FOREIGN KEY (`conference_id`) REFERENCES `conferences` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `conferences_history_ibfk_3` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: consult_charges
#

DROP TABLE IF EXISTS `consult_charges`;

CREATE TABLE `consult_charges` (
  `id` int NOT NULL AUTO_INCREMENT,
  `doctor` int DEFAULT NULL,
  `standard_charge` float(10,2) NOT NULL,
  `date` date NOT NULL,
  `status` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `doctor` (`doctor`),
  CONSTRAINT `consult_charges_ibfk_1` FOREIGN KEY (`doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: consultant_register
#

DROP TABLE IF EXISTS `consultant_register`;

CREATE TABLE `consultant_register` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipd_id` int DEFAULT NULL,
  `date` datetime DEFAULT NULL,
  `ins_date` date DEFAULT NULL,
  `instruction` text,
  `cons_doctor` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `cons_doctor` (`cons_doctor`),
  CONSTRAINT `consultant_register_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `consultant_register_ibfk_2` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: content_for
#

DROP TABLE IF EXISTS `content_for`;

CREATE TABLE `content_for` (
  `id` int NOT NULL AUTO_INCREMENT,
  `role` varchar(50) DEFAULT NULL,
  `content_id` int DEFAULT NULL,
  `user_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `content_id` (`content_id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `content_for_ibfk_1` FOREIGN KEY (`content_id`) REFERENCES `contents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `content_for_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: content_types
#

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) DEFAULT NULL,
  `description` text,
  `is_active` int DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;

INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (5, 'medical list', '', 1, '2024-10-01 07:46:34');
INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (6, 'Hospital record', '', 1, '2024-10-05 09:22:06');
INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (7, 'All medical inventory record', 'All medical inventory record', 1, '2024-10-14 07:19:57');
INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (11, 'content', 'content', 1, '2024-11-15 11:51:13');
INSERT INTO `content_types` (`id`, `name`, `description`, `is_active`, `created_at`) VALUES (16, 'content', '', 1, '2025-04-08 11:42:15');


#
# TABLE STRUCTURE FOR: contents
#

DROP TABLE IF EXISTS `contents`;

CREATE TABLE `contents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(100) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `is_public` varchar(10) DEFAULT 'No',
  `file` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `note` text,
  `date` date DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'no',
  `created_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_title` (`title`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: custom_field_values
#

DROP TABLE IF EXISTS `custom_field_values`;

CREATE TABLE `custom_field_values` (
  `id` int NOT NULL AUTO_INCREMENT,
  `belong_table_id` int DEFAULT NULL,
  `custom_field_id` int DEFAULT NULL,
  `field_value` varchar(500) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  KEY `index_field_value` (`field_value`),
  KEY `index_belong_table_id` (`belong_table_id`),
  KEY `index_custom_field_id` (`custom_field_id`),
  CONSTRAINT `custom_field_values_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4290 DEFAULT CHARSET=utf8mb3;

INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (19, 4, 7, '', '2024-10-08 11:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (27, 0, 7, '', '2024-10-10 11:21:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (29, 5, 7, '', '2024-10-10 11:21:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (32, 5, 13, '', '2024-10-11 12:01:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (43, 6, 7, '', '2024-10-18 09:57:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (50, 7, 7, '', '2024-10-29 04:16:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (53, 6, 13, '', '2024-10-29 05:54:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (88, 9, 7, '', '2024-11-04 05:21:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (90, 10, 7, '', '2024-11-04 05:22:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (92, 11, 7, '', '2024-11-04 05:24:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (94, 12, 7, '', '2024-11-04 05:26:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (96, 13, 7, '', '2024-11-04 05:43:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (98, 14, 7, '', '2024-11-04 09:18:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (100, 15, 7, '', '2024-11-04 09:26:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (102, 16, 7, '', '2024-11-04 10:13:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (104, 0, 7, '', '2024-11-04 10:20:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (106, 0, 7, '', '2024-11-04 10:21:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (108, 17, 7, '', '2024-11-04 10:21:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (110, 18, 7, '', '2024-11-04 10:45:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (112, 19, 7, '', '2024-11-04 10:58:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (126, 8, 13, '', '2024-11-05 06:04:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (128, 20, 7, '', '2024-11-05 08:07:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (132, 7, 12, '2.3', '2024-11-05 12:21:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (134, 5, 8, '16/04/2025 01:49 PM', '2025-04-16 08:20:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (136, 21, 7, '', '2024-11-07 10:23:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (174, 6, 8, '11/11/2024 05:47 PM', '2024-11-11 12:18:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (179, 10, 11, '3', '2024-11-13 12:08:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (183, 7, 8, '', '2024-11-13 07:16:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (184, 8, 8, '30/11/2024 01:47 PM', '2024-11-13 07:17:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (185, 9, 13, '#b32a2a', '2024-11-13 10:17:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (189, 44, 31, '2', '2024-11-13 12:52:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (190, 11, 11, '3', '2024-11-14 06:58:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (193, 138, 23, '2', '2024-11-14 06:53:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (194, 9, 11, '2', '2024-11-14 06:57:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (195, 0, 23, '2', '2024-11-14 07:07:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (196, 0, 23, '2', '2024-11-14 07:13:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (197, 139, 23, '2', '2024-11-14 07:13:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (198, 140, 23, '2', '2024-11-14 07:14:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (199, 9, 8, '14/11/2024 03:36 PM', '2024-11-14 10:06:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (200, 12, 11, '2', '2024-11-14 10:18:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (203, 10, 13, '', '2024-11-14 12:46:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (207, 12, 13, '#d76868', '2024-11-14 12:52:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (211, 13, 13, '#b39d9d', '2024-11-15 07:21:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (255, 14, 13, '#b72f2f', '2024-11-15 09:01:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (263, 15, 13, '#4a0303', '2024-11-15 09:20:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (270, 0, 23, '2', '2024-11-15 10:58:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (271, 0, 23, '2', '2024-11-15 11:01:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (272, 141, 23, '2', '2024-11-15 11:01:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (275, 142, 23, '2', '2024-11-15 11:36:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (276, 0, 23, '2', '2024-11-15 11:53:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (277, 0, 23, '2', '2024-11-15 11:53:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (278, 143, 23, '2', '2024-11-15 11:53:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (280, 0, 23, '2', '2024-11-15 12:01:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (281, 0, 23, '2', '2024-11-15 12:02:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (282, 0, 23, '2', '2024-11-15 12:03:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (283, 144, 23, '2', '2024-11-15 12:03:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (285, 145, 23, '2', '2024-11-15 12:36:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (286, 146, 23, '2', '2024-11-15 12:37:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (288, 147, 23, '2', '2024-11-15 12:38:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (290, 148, 23, '2', '2024-11-15 12:42:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (292, 0, 23, '2', '2024-11-15 12:45:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (293, 0, 23, '2', '2024-11-15 12:46:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (295, 22, 7, '15/11/2024', '2024-11-15 12:46:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (296, 0, 23, '2', '2024-11-15 13:09:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (297, 21, 35, '', '2024-11-15 12:49:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (300, 0, 23, '2', '2024-11-15 13:11:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (301, 0, 23, '2', '2024-11-16 05:23:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (302, 0, 23, '2', '2024-11-16 05:26:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (303, 0, 23, '2', '2024-11-16 05:35:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (304, 0, 23, '2', '2024-11-16 05:35:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (305, 0, 23, '2', '2024-11-16 05:37:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (306, 0, 23, '2', '2024-11-16 05:38:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (307, 0, 23, '2', '2024-11-16 05:38:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (308, 0, 23, '2', '2024-11-16 05:40:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (309, 0, 23, '2', '2024-11-16 05:41:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (310, 0, 23, '2', '2024-11-16 05:41:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (311, 0, 23, '2', '2024-11-16 05:41:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (312, 0, 23, '2', '2024-11-16 05:43:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (313, 0, 23, '2', '2024-11-16 05:44:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (314, 0, 23, '2', '2024-11-16 05:47:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (315, 0, 23, '2', '2024-11-16 05:48:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (316, 0, 23, '2', '2024-11-16 05:48:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (317, 0, 23, '2', '2024-11-16 05:50:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (318, 0, 23, '2', '2024-11-16 05:50:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (319, 0, 23, '2', '2024-11-16 05:51:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (320, 0, 23, '2', '2024-11-16 05:51:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (321, 0, 23, '2', '2024-11-16 05:51:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (322, 0, 23, '2', '2024-11-16 05:52:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (323, 0, 23, '2', '2024-11-16 05:52:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (324, 149, 23, '2', '2024-11-16 05:52:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (326, 0, 23, '2', '2024-11-16 05:57:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (327, 0, 23, '2', '2024-11-16 05:57:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (328, 0, 23, '2', '2024-11-16 05:58:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (329, 0, 23, '2', '2024-11-16 06:48:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (330, 0, 23, '2', '2024-11-16 07:45:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (331, 0, 23, '2', '2024-11-16 07:45:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (332, 0, 23, '2', '2024-11-16 07:45:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (333, 0, 23, '2', '2024-11-16 07:46:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (334, 0, 23, '2', '2024-11-16 07:48:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (335, 0, 23, '2', '2024-11-16 07:52:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (336, 0, 23, '2', '2024-11-16 07:52:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (337, 0, 23, '2', '2024-11-16 07:55:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (338, 150, 23, '2', '2024-11-16 07:55:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (340, 0, 23, '2', '2024-11-16 07:57:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (341, 0, 23, '1,2', '2024-11-16 07:59:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (342, 0, 23, '2', '2024-11-16 11:09:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (343, 37, 29, 'hello', '2024-11-16 08:46:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (344, 0, 23, '2', '2024-11-16 11:13:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (345, 0, 23, '2', '2024-11-16 11:28:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (346, 0, 23, '2', '2024-11-16 11:29:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (347, 0, 23, '2', '2024-11-16 11:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (348, 0, 23, '2', '2024-11-16 11:30:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (349, 151, 23, '2', '2024-11-16 11:30:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (350, 0, 23, '2', '2024-11-16 11:34:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (351, 0, 23, '1', '2024-11-16 11:35:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (352, 0, 23, '2', '2024-11-16 11:39:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (353, 0, 23, '2', '2024-11-16 11:44:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (354, 152, 23, '2', '2024-11-16 11:44:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (357, 0, 23, '2', '2024-11-16 11:49:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (358, 0, 23, '2', '2024-11-16 11:50:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (359, 0, 23, '2', '2024-11-16 11:50:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (360, 0, 23, '2', '2024-11-16 11:54:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (361, 0, 23, '2', '2024-11-16 11:55:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (362, 0, 23, '2', '2024-11-16 11:56:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (363, 0, 23, '2', '2024-11-16 12:27:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (365, 0, 23, '2', '2024-11-16 12:28:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (366, 0, 23, '2', '2024-11-16 12:28:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (367, 0, 23, '2', '2024-11-16 12:28:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (368, 0, 23, '2', '2024-11-16 12:29:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (369, 153, 23, '2', '2024-11-16 12:29:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (371, 154, 23, '2', '2024-11-16 12:30:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (373, 155, 23, '2', '2024-11-16 12:39:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (374, 0, 23, '1', '2024-11-18 08:54:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (375, 0, 23, '2', '2024-11-18 09:50:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (377, 0, 23, '2', '2024-11-18 05:12:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (378, 0, 23, '2', '2024-11-18 05:12:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (379, 0, 23, '2', '2024-11-18 05:13:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (380, 0, 23, '2', '2024-11-18 05:13:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (381, 0, 23, '2', '2024-11-18 05:15:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (382, 0, 23, '2', '2024-11-18 05:47:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (383, 0, 23, '2', '2024-11-18 05:24:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (384, 0, 23, '2', '2024-11-18 05:26:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (385, 0, 23, '2', '2024-11-18 05:44:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (386, 0, 23, '2', '2024-11-18 05:51:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (387, 0, 23, '2', '2024-11-18 06:41:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (388, 0, 23, '2', '2024-11-18 05:51:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (389, 0, 23, '2', '2024-11-18 05:57:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (390, 0, 23, '2', '2024-11-18 05:58:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (391, 0, 23, '2', '2024-11-18 05:58:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (392, 0, 23, '2', '2024-11-18 05:58:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (393, 0, 23, '2', '2024-11-18 05:59:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (394, 0, 23, '2', '2024-11-18 06:02:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (395, 0, 23, '2', '2024-11-18 06:06:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (396, 0, 23, '2', '2024-11-18 06:06:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (397, 0, 23, '2', '2024-11-18 06:09:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (398, 0, 23, '2', '2024-11-18 06:09:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (399, 0, 23, '2', '2024-11-18 06:10:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (400, 0, 23, '2', '2024-11-18 06:10:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (401, 0, 23, '2', '2024-11-18 06:10:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (402, 0, 23, '2', '2024-11-18 06:11:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (403, 0, 23, '2', '2024-11-18 06:11:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (404, 0, 23, '2', '2024-11-18 06:35:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (405, 0, 23, '2', '2024-11-18 06:28:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (406, 0, 23, '2', '2024-11-18 06:28:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (407, 0, 23, '2', '2024-11-18 06:28:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (408, 0, 23, '2', '2024-11-18 06:29:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (409, 0, 23, '2', '2024-11-18 06:29:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (410, 0, 23, '2', '2024-11-18 06:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (411, 160, 23, '2', '2024-11-18 06:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (412, 0, 23, '2', '2024-11-18 06:35:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (413, 161, 23, '2', '2024-11-18 06:35:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (414, 0, 23, '2', '2024-11-19 06:27:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (415, 0, 23, '1', '2024-11-18 06:38:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (416, 162, 23, '1', '2024-11-18 06:38:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (417, 0, 23, '2', '2024-11-18 06:39:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (418, 0, 23, '2', '2024-11-18 06:39:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (419, 0, 23, '2', '2024-11-18 06:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (420, 163, 23, '2', '2024-11-18 06:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (421, 0, 23, '2', '2024-11-18 06:42:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (422, 0, 23, '2', '2024-11-18 06:44:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (423, 158, 23, '2', '2024-11-18 06:44:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (424, 10, 8, '', '2024-11-18 06:57:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (425, 0, 23, '2', '2024-11-18 07:10:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (426, 0, 23, '2', '2024-11-18 07:11:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (427, 0, 23, '2', '2024-11-18 07:11:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (428, 0, 23, '2', '2024-11-18 07:11:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (429, 0, 23, '2', '2024-11-18 07:13:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (430, 0, 23, '2', '2024-11-18 07:13:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (431, 0, 23, '2', '2024-11-18 07:14:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (432, 0, 23, '2', '2024-11-18 07:14:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (433, 0, 23, '2', '2024-11-18 07:14:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (434, 0, 23, '2', '2024-11-18 07:14:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (435, 164, 23, '2', '2024-11-18 07:14:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (436, 81, 29, 'test', '2024-11-18 07:17:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (437, 0, 23, '2', '2024-11-18 07:17:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (438, 0, 23, '2', '2024-11-18 07:17:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (439, 0, 23, '2', '2024-11-18 07:18:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (440, 0, 23, '2', '2024-11-18 07:18:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (441, 0, 23, '2', '2024-11-18 07:18:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (442, 0, 23, '2', '2024-11-18 07:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (443, 0, 23, '2', '2024-11-18 07:19:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (444, 0, 23, '2', '2024-11-18 07:20:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (445, 0, 23, '2', '2024-11-18 07:20:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (446, 0, 23, '2', '2024-11-18 07:21:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (447, 0, 23, '2', '2024-11-18 07:21:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (448, 0, 23, '2', '2024-11-18 07:22:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (449, 0, 23, '2', '2024-11-18 07:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (450, 165, 23, '2', '2024-11-18 07:23:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (452, 156, 23, '1', '2024-11-18 08:54:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (453, 0, 23, '2', '2024-11-18 09:12:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (454, 0, 23, '2', '2024-11-18 09:13:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (455, 0, 23, '2', '2024-11-18 09:14:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (456, 0, 23, '2', '2024-11-18 09:15:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (457, 166, 23, '2', '2024-11-18 09:15:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (458, 83, 29, 'asd', '2024-11-18 09:16:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (459, 0, 23, '2', '2024-11-18 09:20:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (460, 0, 23, '2', '2024-11-18 09:27:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (461, 168, 23, '2', '2024-11-18 09:24:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (462, 169, 23, '2', '2024-11-18 09:24:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (463, 170, 23, '2', '2024-11-18 09:24:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (464, 0, 23, '2', '2024-11-18 09:26:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (465, 0, 23, '2', '2024-11-18 09:28:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (466, 167, 23, '2', '2024-11-18 09:27:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (467, 0, 23, '2', '2024-11-18 09:46:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (468, 0, 23, '2', '2024-11-18 09:50:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (469, 0, 23, '2', '2024-11-19 06:21:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (470, 0, 23, '2', '2024-11-19 06:10:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (474, 172, 23, '2', '2024-11-18 10:40:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (476, 173, 23, '2', '2024-11-18 10:43:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (477, 174, 23, '2', '2024-11-19 05:20:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (479, 175, 23, '2', '2024-11-19 05:29:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (481, 176, 23, '2', '2024-11-19 05:32:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (483, 0, 23, '2', '2024-11-19 05:41:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (484, 0, 23, '2', '2024-11-19 05:42:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (485, 0, 23, '2', '2024-11-19 05:43:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (486, 0, 23, '2', '2024-11-19 05:45:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (487, 0, 23, '2', '2024-11-19 05:45:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (488, 0, 23, '1', '2024-11-19 05:53:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (489, 0, 23, '2', '2024-11-19 05:58:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (490, 0, 23, '2', '2024-11-19 05:58:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (491, 0, 23, '2', '2024-11-19 06:00:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (492, 0, 23, '2', '2024-11-19 06:02:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (493, 177, 23, '2', '2024-11-19 06:02:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (495, 0, 23, '2', '2024-11-19 06:04:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (496, 0, 23, '2', '2024-11-19 06:04:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (497, 0, 23, '2', '2024-11-19 06:05:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (498, 0, 23, '2', '2024-11-19 06:06:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (499, 0, 23, '2', '2024-11-19 07:03:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (500, 0, 23, '2', '2024-11-19 06:14:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (501, 0, 23, '2', '2024-11-19 06:15:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (502, 0, 23, '2', '2024-11-19 06:35:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (503, 171, 23, '2', '2024-11-19 06:21:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (504, 0, 23, '2', '2024-11-19 06:27:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (505, 0, 23, '2', '2024-11-19 06:28:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (506, 0, 23, '2', '2024-11-25 05:27:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (507, 0, 23, '2', '2024-11-19 06:36:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (508, 0, 23, '2', '2024-11-19 06:36:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (509, 0, 23, '2', '2024-11-19 06:37:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (510, 0, 23, '2', '2024-11-19 06:37:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (511, 0, 23, '2', '2024-11-19 08:17:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (512, 0, 23, '2', '2024-11-19 06:40:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (513, 0, 23, '2', '2024-11-19 06:40:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (514, 0, 23, '2', '2024-11-19 06:41:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (515, 0, 23, '2', '2024-11-19 06:41:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (516, 38, 23, '2', '2024-11-19 06:41:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (517, 0, 23, '2', '2024-11-19 07:25:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (519, 0, 23, '2', '2024-11-19 07:14:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (520, 0, 23, '2', '2024-11-19 07:15:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (521, 0, 23, '2', '2024-11-19 07:16:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (522, 0, 23, '2', '2024-11-19 07:16:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (523, 0, 23, '2', '2024-11-19 07:17:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (524, 0, 23, '2', '2024-11-19 07:17:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (525, 179, 23, '2', '2024-11-19 07:17:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (526, 0, 23, '2', '2024-11-19 07:25:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (527, 0, 23, '2', '2024-11-19 07:26:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (528, 178, 23, '2', '2024-11-19 07:26:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (530, 0, 23, '2', '2024-11-19 07:34:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (531, 0, 23, '2', '2024-11-19 07:35:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (532, 0, 23, '2', '2024-11-19 07:35:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (533, 0, 23, '2', '2024-11-19 07:35:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (534, 0, 23, '2', '2024-11-19 07:36:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (535, 0, 23, '2', '2024-11-19 07:36:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (536, 0, 23, '2', '2024-11-19 08:00:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (537, 95, 29, 'ff', '2024-11-19 07:39:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (538, 0, 23, '2', '2024-11-19 07:40:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (539, 0, 23, '2', '2024-11-19 07:41:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (540, 0, 23, '2', '2024-11-19 07:42:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (541, 181, 23, '2', '2024-11-19 07:42:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (543, 0, 23, '2', '2024-11-19 07:44:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (544, 0, 23, '2', '2024-11-19 07:45:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (545, 0, 23, '2', '2024-11-19 07:46:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (546, 182, 23, '2', '2024-11-19 07:46:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (547, 0, 23, '2', '2024-11-19 07:57:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (548, 0, 23, '2', '2024-11-19 07:58:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (549, 0, 23, '2', '2024-11-19 07:58:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (550, 0, 23, '2', '2024-11-19 07:59:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (551, 0, 23, '2', '2024-11-19 08:00:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (552, 183, 23, '2', '2024-11-19 08:00:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (553, 180, 23, '2', '2024-11-19 08:00:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (554, 97, 29, 'test', '2024-11-19 08:02:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (555, 0, 23, '1,2', '2024-11-19 08:03:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (556, 0, 23, '2', '2024-11-19 08:03:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (557, 0, 23, '2', '2024-11-19 08:03:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (558, 184, 23, '2', '2024-11-19 08:03:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (560, 0, 23, '2', '2024-11-19 08:05:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (561, 0, 23, '2', '2024-11-19 08:05:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (562, 0, 23, '2', '2024-11-19 08:05:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (563, 0, 23, '2', '2024-11-19 08:06:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (564, 0, 23, '2', '2024-11-19 08:06:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (565, 185, 23, '2', '2024-11-19 08:06:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (566, 186, 23, '2', '2024-11-19 08:17:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (567, 0, 23, '2', '2024-11-19 08:19:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (568, 0, 23, '2', '2024-11-19 08:19:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (569, 0, 23, '2', '2024-11-22 09:07:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (570, 0, 23, '2', '2024-11-19 09:06:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (571, 0, 23, '2', '2024-11-19 09:06:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (572, 187, 23, '2', '2024-11-19 09:06:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (573, 0, 23, '2', '2024-11-19 09:09:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (574, 0, 23, '2', '2024-11-19 09:09:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (575, 188, 23, '2', '2024-11-19 09:09:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (577, 0, 23, '2', '2024-11-19 09:13:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (578, 0, 23, '2', '2024-11-19 09:18:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (579, 0, 23, '2', '2024-11-19 09:18:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (580, 0, 23, '2', '2024-11-19 09:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (581, 0, 23, '2', '2024-11-19 09:21:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (582, 0, 23, '2', '2024-11-19 09:21:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (583, 0, 23, '2', '2024-11-19 09:21:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (584, 189, 23, '2', '2024-11-19 09:21:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (585, 100, 29, 'hfhf', '2024-11-19 09:22:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (586, 0, 23, '2', '2024-11-19 09:22:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (587, 0, 23, '2', '2024-11-19 09:24:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (588, 0, 23, '2', '2024-11-19 09:25:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (589, 190, 23, '2', '2024-11-19 09:25:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (591, 0, 23, '2', '2024-11-19 09:28:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (592, 0, 23, '2', '2024-11-19 09:28:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (593, 0, 23, '2', '2024-11-19 09:31:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (594, 0, 23, '2', '2024-11-19 09:31:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (595, 0, 23, '2', '2024-11-19 09:31:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (596, 0, 23, '2', '2024-11-19 09:31:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (597, 191, 23, '2', '2024-11-19 09:31:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (604, 0, 23, '1', '2024-11-20 13:04:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (605, 0, 23, '2', '2024-11-21 05:44:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (606, 0, 23, '2', '2024-11-21 05:45:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (607, 194, 23, '1', '2024-11-20 13:07:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (611, 192, 23, '2', '2024-11-21 05:44:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (612, 193, 23, '2', '2024-11-21 05:45:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (614, 195, 23, '2', '2024-11-21 05:46:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (617, 11, 8, '', '2024-11-21 06:38:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (624, 0, 23, '2', '2024-11-21 09:30:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (625, 0, 23, '2', '2024-11-21 12:41:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (629, 0, 23, '2', '2024-11-21 10:31:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (630, 0, 23, '2', '2024-11-21 10:51:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (631, 0, 23, '2', '2024-11-21 10:40:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (632, 197, 23, '2', '2024-11-21 10:40:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (633, 0, 23, '2', '2024-11-21 11:24:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (634, 109, 29, 'fgh', '2024-11-21 10:56:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (635, 0, 23, '1', '2024-11-21 11:00:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (636, 0, 23, '2', '2024-11-21 11:01:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (637, 0, 23, '1', '2024-11-21 11:03:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (638, 0, 23, '2', '2024-11-21 11:04:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (639, 0, 23, '2', '2024-11-21 11:08:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (640, 0, 23, '1,2', '2024-11-21 11:28:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (642, 198, 23, '2', '2024-11-21 11:24:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (645, 199, 23, '1,2', '2024-11-21 11:28:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (647, 200, 23, '1,2', '2024-11-21 11:40:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (649, 201, 23, '2', '2024-11-21 11:43:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (655, 196, 23, '2', '2024-11-21 12:41:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (660, 202, 23, '1,2', '2024-11-21 12:51:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (665, 0, 23, '2', '2024-11-21 13:14:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (669, 203, 23, '2', '2024-11-21 13:14:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (676, 0, 23, '2', '2024-11-26 11:50:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (690, 8, 12, '2.3', '2024-11-23 06:30:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (691, 22, 35, '28/11/2024', '2024-11-23 11:20:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (692, 23, 35, '29/11/2024', '2024-11-23 11:23:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (693, 204, 23, '2', '2024-11-23 11:35:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (698, 44, 35, '29/11/2024', '2024-11-25 05:10:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (699, 205, 23, '2', '2024-11-25 05:11:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (703, 45, 31, '3', '2024-11-25 05:25:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (707, 159, 23, '2', '2024-11-25 05:27:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (712, 23, 7, '21/11/2024', '2024-11-25 05:27:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (714, 206, 23, '2', '2024-11-25 05:43:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (719, 207, 23, '2', '2024-11-25 05:44:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (726, 208, 23, '2', '2024-11-25 06:01:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (730, 209, 23, '2', '2024-11-25 06:01:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (734, 210, 23, '2', '2024-11-25 06:01:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (738, 211, 23, '2', '2024-11-25 06:06:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (745, 212, 23, '2', '2024-11-25 06:15:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (753, 213, 23, '2', '2024-11-25 06:18:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (758, 214, 23, '2', '2024-11-25 07:06:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (763, 215, 23, '1', '2024-11-25 08:51:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (768, 216, 23, '2', '2024-11-25 09:09:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (772, 217, 23, '2', '2024-11-25 09:16:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (776, 218, 23, '2', '2024-11-25 09:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (780, 0, 23, '2', '2024-11-25 09:34:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (784, 219, 23, '2', '2024-11-25 09:34:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (789, 220, 23, '2', '2024-11-25 09:44:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (794, 221, 23, '1', '2024-11-25 09:51:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (800, 24, 7, '25/11/2024', '2024-11-25 09:55:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (801, 46, 31, '3', '2024-11-25 09:56:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (806, 12, 8, '25/11/2024 03:55 PM', '2024-11-25 10:25:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (809, 222, 23, '1', '2024-11-25 10:41:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (813, 223, 23, '1', '2024-11-25 10:43:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (818, 224, 23, '1', '2024-11-25 10:52:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (823, 225, 23, '1', '2024-11-25 11:23:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (827, 47, 31, '3', '2024-11-25 12:02:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (828, 48, 31, '3', '2024-11-25 12:04:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (829, 0, 23, '2', '2024-11-25 12:36:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (833, 0, 23, '2', '2024-11-29 12:35:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (838, 25, 7, '30/11/2024', '2024-11-25 12:36:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (840, 26, 7, '30/11/2024', '2024-11-25 12:49:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (841, 38, 29, 'hhh', '2024-11-25 12:51:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (842, 125, 29, 'test', '2024-11-25 12:53:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (843, 227, 23, '2', '2024-11-25 12:56:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (867, 17, 13, '#c12c2c', '2024-11-26 07:17:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (870, 48, 35, '14/11/2024', '2024-11-26 07:35:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (873, 0, 23, '2', '2024-11-26 07:58:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (879, 228, 23, '2', '2024-11-26 07:58:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (886, 0, 23, '2', '2024-11-26 09:11:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (896, 49, 31, '3', '2024-11-26 09:10:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (897, 50, 31, '3', '2024-11-26 09:11:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (898, 229, 23, '2', '2024-11-26 09:11:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (902, 15, 27, '2', '2024-11-26 09:14:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (903, 230, 23, '1', '2024-11-26 09:17:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (907, 231, 23, '1', '2024-11-26 09:19:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (911, 51, 31, '3', '2024-11-26 09:19:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (912, 52, 31, '3', '2024-11-26 09:20:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (913, 53, 31, '3', '2024-11-26 09:24:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (914, 54, 31, '3', '2024-11-26 09:27:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (916, 55, 31, '3', '2024-11-26 09:29:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (918, 56, 31, '3', '2024-11-26 09:35:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (921, 57, 31, '3', '2024-11-26 09:41:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (922, 58, 31, '3', '2024-11-26 09:43:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (924, 27, 7, '27/11/2024', '2024-11-26 09:51:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (926, 28, 7, '30/11/2024', '2024-11-26 09:58:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (927, 16, 27, '1', '2024-11-26 10:32:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (928, 232, 23, '1', '2024-11-26 10:34:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (939, 0, 23, '2', '2024-11-26 11:09:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (943, 49, 35, '26/11/2024', '2024-11-26 11:08:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (944, 0, 23, '2', '2024-11-26 11:13:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (948, 233, 23, '2', '2024-11-26 11:13:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (954, 0, 31, '3', '2024-11-26 11:47:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (956, 9, 37, '2', '2024-11-26 11:43:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (957, 59, 31, '3', '2024-11-26 11:47:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (958, 0, 23, '2', '2024-11-26 11:51:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (962, 157, 23, '2', '2024-11-26 11:50:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (966, 234, 23, '2', '2024-11-26 11:51:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (972, 29, 7, '26/11/2024', '2024-11-26 12:01:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (976, 15, 11, '3', '2024-11-27 06:15:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (977, 17, 11, '3', '2024-11-27 06:34:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (985, 0, 7, '27/11/2024', '2025-04-15 09:45:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (989, 9, 12, '2.3', '2024-11-27 07:19:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (993, 13, 8, '27/11/2024 01:50 PM', '2024-11-27 08:20:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (994, 14, 11, '3', '2024-11-27 08:22:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1002, 50, 35, '29/11/2024', '2024-11-28 06:27:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1003, 51, 35, '', '2024-11-28 06:29:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1004, 52, 35, '', '2024-11-28 06:30:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1007, 53, 35, '', '2024-11-28 06:37:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1008, 54, 35, '', '2024-11-28 06:57:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1009, 55, 35, '', '2024-11-28 07:00:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1010, 0, 35, '', '2024-11-28 07:09:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1011, 0, 35, '', '2024-11-28 07:10:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1012, 56, 35, '', '2024-11-28 07:10:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1013, 57, 35, '', '2024-11-28 07:11:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1014, 235, 23, '2', '2024-11-28 07:19:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1018, 14, 8, '28/11/2024 12:55 PM', '2024-11-28 07:25:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1022, 236, 23, '2', '2024-11-28 08:49:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1026, 147, 29, '2', '2024-11-28 09:05:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1030, 237, 23, '2', '2024-11-28 09:34:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1035, 58, 35, '', '2024-11-28 09:48:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1036, 238, 23, '2', '2024-11-28 09:57:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1042, 59, 35, '', '2024-11-28 10:07:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1043, 60, 31, '2', '2024-11-28 10:12:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1044, 0, 31, '3', '2024-11-28 10:28:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1045, 61, 31, '3', '2024-11-28 10:28:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1046, 10, 12, '2.3', '2024-11-28 10:50:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1048, 16, 8, '19/12/2024 04:35 PM', '2024-11-28 11:05:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1049, 17, 8, '28/11/2024 04:37 PM', '2024-11-28 11:07:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1050, 18, 8, '28/11/2024 04:42 PM', '2024-11-28 11:12:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1051, 19, 8, '28/11/2024 04:59 PM', '2024-11-28 11:29:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1053, 62, 31, '3', '2024-11-28 11:58:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1054, 63, 31, '3', '2024-11-28 12:28:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1055, 64, 31, '3', '2024-11-28 12:44:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1057, 0, 7, '29/11/2024', '2025-04-14 11:35:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1062, 20, 8, '29/11/2024 03:03 PM', '2024-11-29 09:33:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1066, 239, 23, '2', '2024-11-29 10:11:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1071, 240, 23, '2', '2024-11-29 10:20:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1075, 65, 31, '3', '2024-11-29 10:40:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1076, 11, 12, '2.3', '2024-11-29 11:38:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1082, 60, 35, '', '2024-11-29 12:35:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1084, 226, 23, '2', '2024-11-29 12:35:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1088, 61, 35, '', '2024-11-29 12:37:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1090, 241, 23, '2', '2024-11-29 12:56:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1096, 0, 23, '2', '2024-11-30 08:18:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1100, 242, 23, '2', '2024-11-30 08:18:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1104, 152, 29, '23', '2024-11-30 08:20:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1109, 17, 27, '1', '2024-11-30 08:56:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1110, 243, 23, '1', '2024-11-30 08:57:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1114, 244, 23, '1', '2024-11-30 09:13:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1122, 67, 31, '3', '2024-11-30 10:00:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1124, 0, 7, '30/11/2024', '2025-04-14 11:33:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1125, 62, 35, '', '2024-11-30 12:19:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1126, 68, 31, '3', '2024-11-30 12:22:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1134, 19, 11, '3', '2024-12-02 05:34:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1135, 12, 12, '2.3', '2024-12-02 05:35:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1139, 18, 27, '3', '2024-12-02 05:46:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1140, 14, 45, 'setst4234234!@#$%^', '2024-12-02 06:08:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1142, 15, 45, 'test', '2024-12-02 06:37:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1146, 245, 23, 'sfsfsf', '2024-12-02 07:17:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1147, 0, 31, 'hospital', '2024-12-02 08:15:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1149, 63, 35, '', '2024-12-02 07:53:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1150, 69, 31, 'hospital', '2024-12-02 08:15:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1151, 10, 37, '1', '2024-12-02 08:19:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1152, 0, 7, 'eetey', '2025-04-07 09:18:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1155, 13, 12, '2.3', '2024-12-02 08:28:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1161, 63, 47, 'dgdg', '2024-12-02 09:25:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1165, 59, 47, '2', '2024-12-02 09:31:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1166, 246, 23, 'tes tes ttes2424 #@@##', '2024-12-02 09:40:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1168, 247, 23, 'dfg4535', '2024-12-02 09:43:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1169, 71, 31, 'fgh645646', '2024-12-02 09:46:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1170, 67, 47, 'dssdf', '2024-12-02 10:33:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1172, 69, 47, 'dssdf', '2024-12-02 10:33:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1175, 0, 23, 'test,.', '2024-12-02 12:25:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1176, 248, 23, 'test,.', '2024-12-02 12:25:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1184, 63, 50, '546klj', '2024-12-03 06:11:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1186, 73, 47, 'ram', '2024-12-04 12:35:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1188, 22, 8, '02/12/2024 12:00 PM', '2024-12-03 06:30:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1189, 23, 8, '03/12/1995 12:00 AM', '2024-12-03 06:57:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1190, 23, 51, 'https://www.google.com/', '2024-12-03 06:58:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1195, 0, 23, '2', '2024-12-03 07:09:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1196, 249, 23, '2', '2024-12-03 07:09:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1197, 159, 29, '1', '2024-12-03 07:14:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1198, 160, 29, '2', '2024-12-03 07:14:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1199, 250, 23, '1', '2024-12-03 07:16:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1202, 20, 11, '26/12/2024 12:51 PM', '2024-12-03 07:22:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1204, 14, 12, '2.3', '2024-12-03 07:25:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1209, 0, 23, '2', '2024-12-03 07:52:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1211, 251, 23, '2', '2024-12-03 07:52:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1212, 16, 45, 'no', '2024-12-03 07:53:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1214, 19, 27, '2', '2024-12-03 08:04:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1215, 0, 23, 'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk', '2024-12-03 08:19:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1216, 252, 23, 'kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk', '2024-12-03 08:19:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1219, 166, 29, 'k.', '2024-12-03 09:23:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1221, 0, 23, '2', '2024-12-03 09:39:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1222, 0, 23, 'yrd yrd yrdy yrdy yrdy yrdy yrdyyrdyrdyrdyyrd', '2024-12-03 09:45:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1223, 253, 23, '2', '2024-12-03 09:39:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1226, 255, 23, 'YES', '2024-12-03 09:45:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1227, 0, 23, 'HHHHHHHHHHHHHHHHHHHHHHHHHHHH', '2024-12-03 09:47:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1228, 0, 23, 'HHHHHHHHHHHHHHHHHHHHHHHHHHHHUUUUUUUUUUUUUUUUUUUUUU', '2024-12-03 09:47:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1229, 0, 23, 'FDGD', '2024-12-03 09:49:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1230, 0, 23, 'FDGD*//-', '2024-12-03 09:49:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1231, 0, 23, 'FDGD*//-', '2024-12-03 09:49:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1232, 254, 23, 'FDGD*//-', '2024-12-03 09:49:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1233, 256, 23, 'Medicina taken or not by patient on time ??<< ? *', '2024-12-03 09:52:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1234, 0, 23, '131', '2024-12-03 10:03:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1235, 0, 23, '131', '2025-03-08 11:11:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1236, 0, 23, '66.36', '2024-12-03 10:11:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1237, 258, 23, '66.36', '2024-12-03 10:11:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1240, 64, 35, '27/12/2024', '2024-12-03 10:29:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1241, 65, 35, '31/12/2024', '2024-12-03 10:31:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1242, 66, 35, '25/12/2024', '2024-12-03 10:33:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1246, 20, 54, 'dfsf!@#%$^&', '2024-12-03 11:24:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1247, 74, 47, 'ram', '2024-12-03 11:51:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1248, 75, 47, 'riya', '2024-12-03 11:52:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1250, 76, 47, 'ram', '2024-12-03 12:00:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1251, 24, 13, '#ae2c2c', '2024-12-03 12:06:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1252, 0, 7, '2342', '2024-12-03 12:41:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1253, 77, 47, 'riya', '2024-12-03 12:27:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1254, 78, 47, 'riya', '2024-12-03 12:27:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1255, 79, 47, 'riya', '2024-12-03 12:27:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1256, 80, 47, 'riya', '2024-12-03 12:27:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1257, 46, 49, '665-9-]|', '2024-12-03 12:36:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1260, 64, 50, 'test', '2024-12-03 13:16:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1261, 47, 49, 'hello', '2024-12-04 07:31:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1262, 25, 8, '04/12/2024 01:42 PM', '2024-12-04 08:14:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1263, 25, 51, '2', '2024-12-04 08:14:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1269, 81, 47, 'rani', '2024-12-05 05:06:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1270, 82, 47, 'rani', '2024-12-05 05:07:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1271, 83, 47, 'rani', '2024-12-05 06:30:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1272, 84, 47, 'ram', '2024-12-05 06:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1273, 85, 47, 'rani', '2024-12-05 06:36:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1276, 87, 47, 'ram', '2024-12-05 07:06:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1277, 88, 47, 'ram', '2024-12-05 07:22:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1278, 89, 47, 'rani', '2024-12-05 07:29:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1281, 0, 31, '2', '2024-12-05 07:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1282, 75, 31, '2', '2024-12-05 07:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1286, 259, 23, '2', '2024-12-05 08:50:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1288, 90, 47, 'ram', '2024-12-07 04:36:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1289, 91, 47, 'rani', '2024-12-07 04:53:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1290, 48, 49, 'ghjghj', '2024-12-07 05:26:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1291, 48, 55, 'hi', '2024-12-07 05:26:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1292, 92, 47, 'rani', '2024-12-07 05:47:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1293, 93, 47, 'ram', '2024-12-07 06:12:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1294, 94, 47, 'siya', '2024-12-07 06:14:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1296, 95, 47, 'riya', '2024-12-07 07:53:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1297, 96, 47, 'rani', '2024-12-07 07:57:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1298, 97, 47, 'rani', '2024-12-07 08:07:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1299, 76, 31, '1', '2024-12-07 08:11:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1300, 0, 31, '2', '2024-12-07 08:31:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1301, 0, 31, '1', '2024-12-07 08:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1302, 77, 31, '1', '2024-12-07 08:34:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1303, 78, 31, '1', '2024-12-07 08:45:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1304, 79, 31, '2', '2024-12-07 08:47:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1305, 80, 31, '1', '2024-12-07 09:10:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1306, 81, 31, '2', '2024-12-07 09:11:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1307, 82, 31, '2', '2024-12-07 09:12:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1308, 83, 31, '2', '2024-12-07 09:13:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1309, 0, 31, '2', '2024-12-07 09:19:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1310, 84, 31, '2', '2024-12-07 09:19:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1312, 98, 47, 'ram', '2024-12-07 09:46:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1313, 0, 31, '1', '2024-12-07 09:48:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1314, 0, 31, '1', '2024-12-07 09:49:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1315, 0, 31, '1', '2024-12-07 09:52:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1316, 85, 31, '1', '2024-12-07 09:52:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1317, 99, 47, 'rani', '2024-12-07 10:13:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1318, 100, 47, 'riya', '2024-12-07 10:16:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1319, 101, 47, 'riya', '2024-12-07 10:23:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1320, 102, 47, 'rani', '2024-12-07 10:27:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1321, 103, 47, 'riya', '2024-12-07 10:31:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1322, 104, 47, 'ram', '2024-12-07 10:36:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1323, 105, 47, 'riya', '2024-12-07 10:38:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1324, 106, 47, 'rani', '2024-12-07 10:44:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1325, 0, 31, 'sss', '2024-12-07 10:47:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1326, 86, 31, 'sss', '2024-12-07 10:47:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1327, 107, 47, 'rani', '2024-12-07 10:54:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1328, 108, 47, 'siya', '2024-12-07 10:57:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1329, 109, 47, 'riya', '2024-12-07 10:58:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1331, 110, 47, 'ram', '2024-12-07 11:06:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1332, 0, 31, '2', '2024-12-07 11:13:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1333, 0, 31, '2', '2024-12-07 11:15:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1334, 0, 31, '2', '2024-12-07 11:16:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1335, 0, 31, '2', '2024-12-07 11:17:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1336, 0, 31, '2', '2024-12-07 11:29:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1337, 0, 31, '1', '2024-12-07 11:30:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1338, 0, 31, '1', '2024-12-07 11:51:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1339, 0, 31, '2', '2024-12-07 12:04:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1340, 0, 31, '1', '2024-12-07 12:08:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1341, 88, 31, '1', '2024-12-07 12:08:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1342, 111, 47, 'ram', '2024-12-09 08:30:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1343, 67, 35, '28/12/2024', '2024-12-09 10:15:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1344, 89, 31, 'dfg', '2024-12-09 10:34:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1345, 90, 31, 'sdg', '2024-12-09 10:34:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1346, 49, 49, 'ddffgfg', '2025-03-01 08:14:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1347, 49, 55, 'hello', '2024-12-09 11:54:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1349, 0, 35, '26/12/2024', '2024-12-13 05:34:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1350, 68, 35, '26/12/2024', '2024-12-13 05:34:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1351, 91, 31, 'sdff', '2025-01-15 10:11:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1352, 0, 31, '324234', '2025-03-10 10:49:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1353, 0, 31, '23ddfs', '2025-01-15 12:00:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1354, 0, 31, '23ddfs', '2025-01-15 12:02:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1355, 93, 31, '23ddfs', '2025-01-15 12:02:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1357, 0, 31, 'dsds', '2025-01-15 12:04:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1358, 94, 31, 'dsds', '2025-01-15 12:04:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1359, 0, 31, 'asd', '2025-02-28 09:52:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1360, 0, 31, '43335', '2025-01-15 12:24:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1361, 0, 31, '43335', '2025-02-28 09:51:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1363, 112, 47, 'ram', '2025-02-18 12:42:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1368, 117, 47, 'ram', '2025-02-19 06:42:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1369, 118, 47, 'ram', '2025-02-19 06:45:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1453, 202, 47, 'rani', '2025-02-19 12:20:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1454, 203, 47, 'rani', '2025-02-19 12:20:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1455, 204, 47, 'rani', '2025-02-19 12:20:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1456, 205, 47, 'rani', '2025-02-19 12:20:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1457, 206, 47, 'rani', '2025-02-19 12:20:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1458, 207, 47, 'rani', '2025-02-19 12:20:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1459, 208, 47, 'rani', '2025-02-19 12:20:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1460, 209, 47, 'rani', '2025-02-19 12:20:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1461, 210, 47, 'rani', '2025-02-19 12:20:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1462, 211, 47, 'rani', '2025-02-19 12:20:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1463, 212, 47, 'rani', '2025-02-19 12:20:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1464, 213, 47, 'rani', '2025-02-19 12:20:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1465, 214, 47, 'rani', '2025-02-19 12:20:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1466, 215, 47, 'rani', '2025-02-19 12:20:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1467, 216, 47, 'rani', '2025-02-19 12:20:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1504, 253, 47, 'rani', '2025-02-20 09:30:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1511, 260, 47, 'ram', '2025-02-20 09:44:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1521, 270, 47, 'riya', '2025-02-20 11:10:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1522, 271, 47, 'riya', '2025-02-20 11:10:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1545, 294, 47, 'ram', '2025-02-20 12:06:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1546, 295, 47, 'ram', '2025-02-20 12:06:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1555, 304, 47, 'rani', '2025-02-20 12:45:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1597, 0, 31, '43335', '2025-02-28 09:52:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1598, 0, 31, '43335', '2025-02-28 09:53:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1599, 0, 31, 'asd', '2025-02-28 09:57:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1600, 0, 31, '43335', '2025-02-28 10:03:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1601, 95, 31, 'asd', '2025-02-28 09:57:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1602, 0, 31, '43335', '2025-02-28 10:05:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1603, 0, 31, '43335', '2025-02-28 10:08:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1604, 96, 31, '43335', '2025-02-28 10:08:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1606, 260, 23, 'add', '2025-02-28 10:28:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1607, 0, 23, 'add', '2025-02-28 10:31:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1608, 0, 23, 'add', '2025-02-28 12:18:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1611, 0, 23, '12', '2025-02-28 11:12:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1612, 0, 23, '1', '2025-03-10 08:43:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1613, 262, 23, '12', '2025-02-28 11:12:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1617, 69, 35, '28/02/2025', '2025-02-28 11:53:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1618, 70, 35, '28/02/2025', '2025-02-28 11:54:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1635, 97, 31, 'add', '2025-02-28 12:15:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1636, 261, 23, 'add', '2025-02-28 12:18:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1637, 12, 37, '1', '2025-02-28 12:25:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1658, 380, 47, 'ram', '2025-02-28 12:51:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1687, 408, 47, 'rani', '2025-03-01 05:37:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1697, 418, 47, 'rani', '2025-03-01 05:38:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1716, 0, 7, 'add', '2025-03-01 07:22:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1717, 0, 7, 'add', '2025-03-01 10:35:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1719, 15, 12, '2.3', '2025-03-01 07:39:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1724, 26, 13, '#b08e8e', '2025-03-01 09:03:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1754, 98, 31, 'add', '2025-03-01 10:32:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1755, 0, 7, 'add', '2025-03-10 11:44:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1756, 99, 31, 'add', '2025-03-01 10:37:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1764, 22, 11, '01/03/2025 06:09 PM', '2025-03-01 12:39:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1765, 22, 54, 'add', '2025-03-03 07:34:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1836, 0, 35, '20/03/2025', '2025-03-05 07:07:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (1837, 0, 35, '20/03/2025', '2025-03-10 09:20:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2055, 667, 47, '', '2025-03-06 08:10:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2260, 100, 31, 'aa', '2025-03-07 08:27:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2261, 100, 73, '2', '2025-03-07 08:27:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2262, 101, 31, '12', '2025-03-07 08:29:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2263, 101, 73, '2', '2025-03-07 08:29:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2296, 264, 23, 'fdgfdg', '2025-03-07 11:28:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2297, 264, 72, '07/03/2025 12:58 PM', '2025-03-07 11:28:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2298, 202, 29, 'fghfgh', '2025-03-07 11:43:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2299, 65, 50, 'gdfgd', '2025-03-07 11:44:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2353, 810, 47, '', '2025-03-08 06:15:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2391, 16, 12, '2.3', '2025-03-08 07:10:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2408, 836, 47, '', '2025-03-08 08:13:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2412, 0, 23, 'add', '2025-03-08 08:44:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2413, 0, 72, '08/03/2025 02:10 PM', '2025-03-08 08:44:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2414, 266, 23, 'add', '2025-03-08 08:41:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2415, 266, 72, '08/03/2025 02:11 PM', '2025-03-08 08:41:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2416, 265, 23, 'add', '2025-03-08 08:44:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2417, 265, 72, '08/03/2025 02:10 PM', '2025-03-08 08:44:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2418, 206, 29, 'add', '2025-03-08 08:54:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2433, 844, 47, '', '2025-03-08 09:22:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2455, 205, 29, 'add', '2025-03-08 09:31:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2456, 209, 29, 'add', '2025-03-08 09:42:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2469, 210, 29, 'test', '2025-03-08 09:45:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2471, 211, 29, '12', '2025-03-08 09:57:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2487, 39, 49, '', '2025-03-08 10:34:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2488, 39, 55, 'hi', '2025-03-08 10:34:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2490, 11, 49, '', '2025-03-08 10:34:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2491, 11, 55, 'hello', '2025-03-08 10:34:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2493, 50, 49, '', '2025-03-08 10:44:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2494, 50, 55, 'hi', '2025-03-08 10:44:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2513, 22, 27, '1', '2025-03-08 11:08:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2515, 0, 72, '08/03/2025 04:40 PM', '2025-03-08 11:11:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2516, 257, 23, '131', '2025-03-08 11:11:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2517, 257, 72, '08/03/2025 04:40 PM', '2025-03-08 11:11:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2519, 20, 45, 'add', '2025-03-08 11:14:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2520, 20, 68, '1.2', '2025-03-08 11:14:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2536, 882, 47, '', '2025-03-08 11:19:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2562, 895, 47, '', '2025-03-08 12:47:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2590, 51, 49, '', '2025-03-10 04:31:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2591, 51, 55, 'hello', '2025-03-10 04:31:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2638, 267, 23, 'add', '2025-03-10 07:42:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2639, 267, 72, '10/03/2025 01:11 PM', '2025-03-10 07:42:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2640, 27, 67, 'dd', '2025-03-10 07:46:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2641, 214, 29, 'add', '2025-03-10 07:57:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2647, 268, 23, '12', '2025-03-10 08:17:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2648, 268, 72, '10/03/2025 01:47 PM', '2025-03-10 08:17:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2651, 23, 27, '12', '2025-03-10 08:38:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2653, 0, 72, '10/03/2025 02:12 PM', '2025-03-10 08:43:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2654, 263, 23, '1', '2025-03-10 08:43:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2655, 263, 72, '10/03/2025 02:12 PM', '2025-03-10 08:43:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2656, 0, 23, 'add', '2025-04-15 11:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2657, 0, 72, '10/03/2025 02:21 PM', '2025-04-15 11:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2664, 0, 23, 'dsfdsf', '2025-03-10 09:15:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2665, 0, 72, '10/03/2025 02:38 PM', '2025-03-10 09:15:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2668, 928, 47, '', '2025-03-10 09:13:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2684, 0, 23, 'dsfdsf', '2025-03-10 09:15:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2685, 0, 72, '10/03/2025 02:38 PM', '2025-03-10 09:15:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2686, 0, 23, 'dsfdsf', '2025-03-10 09:29:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2687, 0, 72, '10/03/2025 02:38 PM', '2025-03-10 09:29:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2688, 0, 75, '1', '2025-03-10 09:20:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2689, 71, 35, '20/03/2025', '2025-03-10 09:20:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2690, 71, 75, '1', '2025-03-10 09:20:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2703, 0, 23, 'dsfdsf', '2025-03-10 09:42:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2704, 0, 72, '10/03/2025 02:38 PM', '2025-03-10 09:42:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2705, 270, 23, 'dsfdsf', '2025-03-10 09:42:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2706, 270, 72, '10/03/2025 02:38 PM', '2025-03-10 09:42:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2718, 271, 23, 'add', '2025-03-10 10:34:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2719, 271, 72, '10/03/2025 04:04 PM', '2025-03-10 10:34:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2720, 946, 47, 'ram', '2025-03-10 10:36:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2722, 0, 73, '12', '2025-03-10 10:49:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2723, 92, 31, '324234', '2025-03-10 10:49:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2724, 92, 73, '12', '2025-03-10 10:49:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2727, 102, 31, 'add', '2025-03-10 10:54:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2728, 102, 73, '12', '2025-03-10 10:54:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2771, 41, 7, '12', '2025-03-10 11:42:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2772, 41, 76, '#c47d7d', '2025-03-10 11:42:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2773, 0, 76, '#bc7373', '2025-03-10 11:44:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2774, 40, 7, 'add', '2025-03-10 11:44:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2775, 40, 76, '#bc7373', '2025-03-10 11:44:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2780, 52, 49, '', '2025-03-10 11:59:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2781, 52, 55, 'hello', '2025-03-10 11:59:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2793, 12, 66, '1', '2025-03-10 12:14:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2806, 42, 7, 'asdsad', '2025-03-10 12:22:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2807, 42, 76, '#db2020', '2025-03-10 12:22:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2944, 1043, 47, '', '2025-03-11 09:31:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2964, 43, 7, 'sdfdf', '2025-03-11 10:39:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2965, 43, 76, '#000000', '2025-03-11 10:39:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2966, 0, 31, 'ert', '2025-03-12 12:35:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2967, 0, 73, '12', '2025-03-12 12:35:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2981, 25, 67, '123123', '2025-03-12 04:56:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2982, 23, 67, '12', '2025-03-12 04:57:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2983, 24, 67, '1 2 3 5 6  8', '2025-03-12 04:57:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2987, 66, 50, 'dfgfdg', '2025-03-12 05:37:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2995, 0, 23, 'add', '2025-03-12 07:39:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2996, 0, 72, '12/03/2025 12:50 PM', '2025-03-12 07:39:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2997, 223, 29, 'add', '2025-03-12 07:37:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2998, 0, 23, 'add', '2025-03-12 07:39:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (2999, 0, 72, '12/03/2025 12:50 PM', '2025-03-12 07:39:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3000, 0, 23, 'add', '2025-03-12 08:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3001, 0, 72, '12/03/2025 12:50 PM', '2025-03-12 08:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3002, 1059, 47, '', '2025-03-12 07:52:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3004, 1060, 47, '', '2025-03-12 08:06:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3006, 0, 23, 'add', '2025-03-12 08:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3007, 0, 72, '12/03/2025 12:50 PM', '2025-03-12 08:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3008, 0, 23, 'add', '2025-03-12 08:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3009, 0, 72, '12/03/2025 12:50 PM', '2025-03-12 08:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3010, 272, 23, 'add', '2025-03-12 08:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3011, 272, 72, '12/03/2025 12:50 PM', '2025-03-12 08:08:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3012, 1061, 47, '', '2025-03-12 08:08:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3016, 1062, 47, '', '2025-03-12 08:17:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3018, 1063, 47, '', '2025-03-12 08:18:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3020, 1064, 47, 'ram', '2025-03-12 11:27:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3025, 1066, 47, '', '2025-03-12 09:17:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3027, 1067, 47, '', '2025-03-12 09:17:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3029, 1068, 47, '', '2025-03-12 09:17:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3031, 1069, 47, '', '2025-03-12 09:17:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3033, 1070, 47, '', '2025-03-12 09:17:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3035, 1071, 47, '', '2025-03-12 09:17:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3037, 1072, 47, '', '2025-03-12 09:17:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3039, 1073, 47, '', '2025-03-12 09:17:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3041, 229, 29, 'cx', '2025-03-12 09:35:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3042, 26, 67, 'add', '2025-03-12 11:02:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3045, 23, 45, 'add', '2025-03-12 11:13:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3046, 23, 68, '1.2', '2025-03-12 11:13:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3047, 1074, 47, 'ram', '2025-03-12 11:31:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3055, 0, 31, 'ert', '2025-03-12 12:36:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3056, 0, 73, '12', '2025-03-12 12:36:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3057, 104, 31, 'ert', '2025-03-12 12:36:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3058, 104, 73, '12', '2025-03-12 12:36:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3059, 0, 7, '1', '2025-03-13 07:06:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3060, 0, 76, '#782e2e', '2025-03-13 07:06:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3061, 1075, 47, '', '2025-03-13 05:32:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3063, 1076, 47, '', '2025-03-13 05:32:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3065, 1077, 47, '', '2025-03-13 05:32:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3067, 1078, 47, '', '2025-03-13 05:32:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3069, 1079, 47, '', '2025-03-13 05:32:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3071, 1080, 47, '', '2025-03-13 05:33:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3073, 1081, 47, '', '2025-03-13 05:36:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3075, 0, 7, '1', '2025-03-13 07:06:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3076, 0, 76, '#782e2e', '2025-03-13 07:06:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3079, 0, 35, '13/03/2025', '2025-03-13 07:25:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3080, 0, 75, '2', '2025-03-13 07:25:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3081, 72, 35, '13/03/2025', '2025-03-13 07:25:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3082, 72, 75, '2', '2025-03-13 07:25:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3086, 13, 37, '1', '2025-03-13 11:03:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3089, 45, 7, 'add', '2025-03-13 11:19:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3090, 45, 76, '#884848', '2025-03-13 11:19:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3092, 53, 49, 'add', '2025-03-13 11:29:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3093, 53, 55, 'hello', '2025-03-13 11:29:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3101, 1082, 47, 'ram', '2025-03-17 09:17:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3104, 1083, 47, 'rani', '2025-03-17 09:44:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3107, 1084, 47, '', '2025-03-17 10:17:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3115, 71, 83, 'tyutu', '2025-03-18 10:52:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3116, 1085, 47, '', '2025-03-18 11:45:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3119, 1086, 47, '', '2025-03-18 12:05:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3124, 72, 83, 'cvcxv', '2025-03-19 06:01:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3126, 73, 83, 'dfgdfg', '2025-03-19 06:05:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3128, 74, 83, 'cgsdfg', '2025-03-19 06:12:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3131, 28, 67, 'ggtettest test test', '2025-03-19 09:48:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3132, 28, 88, '19/03/2025', '2025-03-19 09:48:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3135, 273, 23, 'thtry', '2025-03-19 10:53:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3136, 273, 72, '19/03/2025 04:23 PM', '2025-03-19 10:53:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3139, 274, 23, 'rydydy', '2025-03-19 10:54:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3140, 274, 72, '19/03/2025 04:24 PM', '2025-03-19 10:54:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3142, 75, 83, 'asdasd', '2025-03-19 12:10:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3146, 1087, 47, '', '2025-03-19 12:40:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3153, 78, 83, 'asd', '2025-03-20 04:34:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3154, 1088, 47, 'rani', '2025-03-20 04:38:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3157, 1089, 47, 'rani', '2025-03-20 04:40:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3160, 1090, 47, '', '2025-03-20 04:43:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3163, 1091, 47, '', '2025-03-20 04:45:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3166, 1092, 47, 'rani', '2025-03-20 04:49:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3169, 1093, 47, 'ram', '2025-03-20 04:50:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3172, 1094, 47, '', '2025-03-20 05:15:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3176, 99, 96, 'asd', '2025-03-20 05:44:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3179, 73, 35, '01/04/2025', '2025-03-20 06:20:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3180, 73, 75, '2', '2025-03-20 06:20:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3181, 73, 97, '28/03/2025 11:50 AM', '2025-03-20 06:20:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3182, 74, 35, '27/03/2025', '2025-03-20 06:31:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3183, 74, 75, '5', '2025-03-20 06:31:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3184, 74, 97, '20/03/2025 12:01 PM', '2025-03-20 06:31:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3186, 100, 96, '34', '2025-03-20 07:48:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3187, 1095, 47, 'rani', '2025-03-20 07:53:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3190, 0, 31, '12', '2025-03-20 08:27:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3191, 0, 73, '1', '2025-03-20 08:27:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3193, 106, 31, '12', '2025-03-20 08:27:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3194, 106, 73, '1', '2025-03-20 08:27:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3196, 46, 7, 'ass', '2025-03-20 08:30:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3197, 46, 76, '#714c4c', '2025-03-20 08:30:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3203, 1096, 47, 'ram', '2025-03-20 09:25:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3206, 0, 35, '28/03/2025', '2025-03-20 09:45:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3207, 0, 75, '6', '2025-03-20 09:45:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3208, 0, 97, '20/03/2025 03:02 PM', '2025-03-20 09:45:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3209, 0, 35, '28/03/2025', '2025-03-20 09:45:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3210, 0, 75, '6', '2025-03-20 09:45:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3211, 0, 97, '20/03/2025 03:02 PM', '2025-03-20 09:45:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3212, 75, 35, '28/03/2025', '2025-03-20 09:45:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3213, 75, 75, '6', '2025-03-20 09:45:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3214, 75, 97, '20/03/2025 03:02 PM', '2025-03-20 09:45:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3215, 0, 35, '02/04/2025', '2025-03-20 09:50:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3216, 0, 75, '546', '2025-03-20 09:50:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3217, 0, 97, '19/03/2025 03:19 PM', '2025-03-20 09:50:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3218, 0, 35, '02/04/2025', '2025-03-20 09:50:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3219, 0, 75, '546', '2025-03-20 09:50:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3220, 0, 97, '19/03/2025 03:19 PM', '2025-03-20 09:50:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3221, 76, 35, '02/04/2025', '2025-03-20 09:50:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3222, 76, 75, '546', '2025-03-20 09:50:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3223, 76, 97, '19/03/2025 03:19 PM', '2025-03-20 09:50:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3226, 0, 23, '12', '2025-03-20 11:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3227, 0, 72, '20/03/2025 04:56 PM', '2025-03-20 11:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3228, 275, 23, '12', '2025-03-20 11:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3229, 275, 72, '20/03/2025 04:56 PM', '2025-03-20 11:26:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3230, 276, 23, 'ass', '2025-03-20 11:37:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3231, 276, 72, '20/03/2025 05:07 PM', '2025-03-20 11:37:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3234, 277, 23, '12', '2025-03-20 11:45:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3235, 277, 72, '20/03/2025 05:15 PM', '2025-03-20 11:45:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3236, 249, 29, '12', '2025-03-20 11:46:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3238, 255, 29, '12', '2025-03-20 11:47:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3248, 278, 23, 'add', '2025-03-21 07:03:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3249, 278, 72, '21/03/2025 12:33 PM', '2025-03-21 07:03:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3253, 82, 83, '1', '2025-03-21 07:21:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3254, 29, 67, '23', '2025-03-21 07:26:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3255, 29, 88, '21/03/2025', '2025-03-21 07:26:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3256, 24, 27, '2', '2025-03-21 07:44:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3259, 0, 23, 'add', '2025-03-21 07:51:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3260, 0, 72, '21/03/2025 01:19 PM', '2025-03-21 07:51:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3261, 279, 23, 'add', '2025-03-21 07:51:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3262, 279, 72, '21/03/2025 01:19 PM', '2025-03-21 07:51:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3266, 25, 45, '12', '2025-03-21 08:36:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3267, 25, 68, '1.2', '2025-03-21 08:36:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3269, 0, 35, '21/03/2025', '2025-03-21 09:05:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3270, 0, 75, '2', '2025-03-21 09:05:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3271, 0, 97, '21/03/2025 02:31 PM', '2025-03-21 09:05:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3272, 1097, 47, 'riya', '2025-03-21 09:05:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3275, 0, 35, '21/03/2025', '2025-03-21 09:28:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3276, 0, 75, '2', '2025-03-21 09:28:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3277, 0, 97, '21/03/2025 02:31 PM', '2025-03-21 09:28:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3278, 1098, 47, 'riya', '2025-03-21 09:11:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3285, 84, 83, '1', '2025-03-21 09:17:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3287, 85, 83, '1', '2025-03-21 09:21:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3288, 77, 35, '21/03/2025', '2025-03-21 09:28:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3289, 77, 75, '2', '2025-03-21 09:28:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3290, 77, 97, '21/03/2025 02:31 PM', '2025-03-21 09:28:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3291, 0, 31, '12', '2025-03-21 09:47:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3292, 0, 73, '2', '2025-03-21 09:47:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3295, 86, 83, 'fgf', '2025-03-21 09:37:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3297, 87, 83, '2', '2025-03-21 09:38:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3299, 88, 83, 'as', '2025-03-21 09:40:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3300, 1099, 47, 'ram', '2025-03-21 09:45:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3303, 1100, 47, 'rani', '2025-03-21 09:46:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3306, 107, 31, '12', '2025-03-21 09:47:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3307, 107, 73, '2', '2025-03-21 09:47:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3309, 14, 37, '1', '2025-03-21 09:49:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3314, 47, 7, 'add', '2025-03-21 09:58:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3315, 47, 76, '#774646', '2025-03-21 09:58:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3319, 17, 12, '2.3', '2025-03-21 10:13:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3325, 101, 96, 'test', '2025-03-21 10:19:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3339, 94, 83, '2', '2025-03-21 10:32:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3340, 54, 49, '', '2025-03-21 11:04:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3341, 54, 55, 'hi', '2025-03-21 11:04:05');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3344, 0, 31, 'fghfg', '2025-03-22 05:10:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3345, 0, 73, '1', '2025-03-22 05:10:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3347, 108, 31, 'fghfg', '2025-03-22 05:10:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3348, 108, 73, '1', '2025-03-22 05:10:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3350, 48, 7, 'sdf', '2025-03-22 05:13:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3351, 48, 76, '#bf5757', '2025-03-22 05:13:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3352, 109, 31, 'df', '2025-03-22 06:20:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3353, 109, 73, '12', '2025-03-22 06:20:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3355, 55, 49, '', '2025-03-22 06:47:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3356, 55, 55, 'hi', '2025-03-22 06:47:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3358, 6, 51, 'add', '2025-03-22 07:30:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3361, 8, 11, '22/03/2025 01:04 PM', '2025-03-22 07:34:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3362, 8, 63, '2', '2025-03-22 07:34:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3369, 24, 54, 'asdasd', '2025-03-22 07:59:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3376, 29, 13, '#6e3434', '2025-03-22 11:16:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3377, 29, 65, 'add', '2025-03-22 11:16:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3381, 9, 77, '02/04/2025', '2025-03-24 04:32:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3382, 9, 98, '26/03/2025', '2025-03-24 04:32:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3383, 7, 77, '03/04/2025', '2025-03-24 04:32:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3384, 7, 98, '31/03/2025', '2025-03-24 04:32:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3385, 49, 7, 'fgfdg', '2025-03-24 05:09:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3386, 49, 76, '#b70707', '2025-03-24 05:09:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3387, 0, 31, 'asd', '2025-03-24 05:25:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3388, 0, 73, '12', '2025-03-24 05:25:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3392, 111, 31, 'fgdf', '2025-03-24 05:26:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3393, 111, 73, '12', '2025-03-24 05:26:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3394, 78, 35, '04/04/2025', '2025-03-24 06:21:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3395, 78, 75, '12', '2025-03-24 06:21:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3396, 78, 97, '02/04/2025 11:51 AM', '2025-03-24 06:21:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3397, 30, 67, 'fdg', '2025-03-24 08:06:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3398, 30, 88, '29/03/2025', '2025-03-24 08:06:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3399, 67, 50, 'cxdf', '2025-03-24 08:06:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3408, 1101, 47, 'ram', '2025-04-05 07:23:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3415, 280, 23, 'add', '2025-04-05 07:45:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3416, 280, 72, '05/04/2025 01:15 PM', '2025-04-05 07:45:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3417, 263, 29, '12', '2025-04-05 07:50:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3418, 264, 29, '12', '2025-04-05 07:57:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3420, 281, 23, 'add', '2025-04-05 08:26:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3421, 281, 72, '05/04/2025 01:56 PM', '2025-04-05 08:26:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3432, 25, 27, '12', '2025-04-05 09:00:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3435, 0, 23, 'add', '2025-04-05 09:10:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3436, 0, 72, '05/04/2025 02:37 PM', '2025-04-05 09:10:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3437, 0, 23, 'add', '2025-04-15 11:58:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3438, 0, 72, '05/04/2025 02:37 PM', '2025-04-15 11:58:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3439, 26, 45, '23', '2025-04-05 09:11:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3440, 26, 68, '1.2', '2025-04-05 09:11:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3444, 1102, 47, '', '2025-04-05 11:26:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3454, 268, 29, 'add', '2025-04-05 12:14:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3455, 96, 96, 'r', '2025-04-07 04:17:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3456, 269, 29, 'sf', '2025-04-07 04:21:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3460, 0, 31, '12', '2025-04-07 07:41:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3461, 0, 73, '2', '2025-04-07 07:41:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3464, 0, 7, '12', '2025-04-07 08:04:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3465, 0, 76, '#902121', '2025-04-07 08:04:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3466, 0, 7, '12', '2025-04-07 08:04:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3467, 0, 76, '#af4141', '2025-04-07 08:04:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3468, 0, 7, '12', '2025-04-07 08:07:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3469, 0, 76, '#af4141', '2025-04-07 08:07:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3470, 50, 7, '12', '2025-04-07 08:07:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3471, 50, 76, '#af4141', '2025-04-07 08:07:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3472, 0, 35, '07/04/2025', '2025-04-07 08:42:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3473, 0, 75, '1', '2025-04-07 08:42:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3474, 0, 97, '07/04/2025 02:10 PM', '2025-04-07 08:42:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3475, 0, 35, '07/04/2025', '2025-04-07 08:51:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3476, 0, 75, '1', '2025-04-07 08:51:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3477, 0, 97, '07/04/2025 02:10 PM', '2025-04-07 08:51:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3478, 79, 35, '07/04/2025', '2025-04-07 08:51:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3479, 79, 75, '1', '2025-04-07 08:51:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3480, 79, 97, '07/04/2025 02:10 PM', '2025-04-07 08:51:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3481, 0, 31, '1', '2025-04-07 09:04:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3482, 0, 73, '2', '2025-04-07 09:04:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3483, 113, 31, '1', '2025-04-07 09:04:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3484, 113, 73, '2', '2025-04-07 09:04:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3488, 15, 37, '2', '2025-04-07 09:09:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3492, 0, 76, '#110d0d', '2025-04-07 09:18:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3493, 34, 7, 'eetey', '2025-04-07 09:18:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3494, 34, 76, '#110d0d', '2025-04-07 09:18:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3495, 6, 77, '07/04/2025', '2025-04-07 09:21:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3496, 6, 98, '07/04/2025', '2025-04-07 09:21:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3498, 14, 77, '07/04/2025', '2025-04-07 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3499, 14, 98, '07/04/2025', '2025-04-07 09:24:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3502, 56, 49, 'add', '2025-04-07 11:05:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3503, 56, 55, 'hello', '2025-04-07 11:05:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3506, 103, 96, 'hh', '2025-04-08 05:09:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3511, 270, 29, 'asd', '2025-04-08 05:22:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3517, 271, 29, 'fgfdg', '2025-04-08 05:27:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3518, 28, 8, '08/04/2025 10:59 AM', '2025-04-08 05:29:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3519, 28, 51, 'asdas', '2025-04-08 05:29:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3520, 31, 67, 'sdfdsf', '2025-04-08 05:41:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3521, 31, 88, '24/04/2025', '2025-04-08 05:41:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3522, 283, 23, 'dsfds', '2025-04-08 05:47:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3523, 283, 72, '08/04/2025 11:17 AM', '2025-04-08 05:47:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3524, 5, 37, '2', '2025-04-08 05:54:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3528, 0, 31, 'dsf', '2025-04-14 10:38:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3529, 0, 73, '23', '2025-04-14 10:38:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3530, 57, 49, '', '2025-04-08 05:57:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3531, 57, 55, 'hi', '2025-04-08 05:57:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3534, 96, 83, 'sdf', '2025-04-08 06:02:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3538, 115, 31, 'sdf', '2025-04-08 06:34:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3539, 115, 73, '24', '2025-04-08 06:34:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3542, 25, 11, '08/04/2025 12:59 PM', '2025-04-08 07:29:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3543, 25, 63, '3', '2025-04-08 07:30:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3545, 29, 54, '23', '2025-04-08 07:50:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3552, 30, 54, 'sdsad', '2025-04-08 10:21:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3554, 31, 54, 'sad', '2025-04-08 10:27:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3564, 80, 35, '08/04/2025', '2025-04-08 12:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3565, 80, 75, '20', '2025-04-08 12:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3566, 80, 97, '30/04/2025 05:51 PM', '2025-04-08 12:22:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3569, 1105, 47, '', '2025-04-09 05:25:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3571, 1106, 47, '', '2025-04-09 05:25:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3573, 1107, 47, '', '2025-04-09 05:25:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3575, 1108, 47, '', '2025-04-09 05:25:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3577, 1109, 47, 'ram', '2025-04-09 06:58:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3579, 1110, 47, 'ram', '2025-04-09 06:58:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3581, 1111, 47, 'ram', '2025-04-09 06:58:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3583, 116, 31, 'gfdg', '2025-04-10 06:37:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3584, 116, 73, '23', '2025-04-10 06:37:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3585, 0, 31, 'fgdfg', '2025-04-10 06:50:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3586, 0, 73, '123', '2025-04-10 06:50:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3587, 117, 31, 'fgdfg', '2025-04-10 06:50:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3588, 117, 73, '123', '2025-04-10 06:50:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3589, 51, 7, 'fgdfg', '2025-04-10 06:51:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3590, 51, 76, '#c64949', '2025-04-10 06:51:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3591, 97, 103, 'A blood unit typically refers to a standard volume of blood, usually around 450 mL', '2025-04-17 10:22:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3592, 97, 104, 'A \"blood unit\" typically refers to a standard volume of blood, usually around 450 mL, ', '2025-04-17 10:21:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3594, 109, 96, '12', '2025-04-10 07:34:47');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3596, 110, 96, '12', '2025-04-10 07:42:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3597, 3, 96, 'add', '2025-04-10 07:47:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3599, 38, 96, 'ad', '2025-04-10 07:55:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3600, 52, 7, 'dfgdfg', '2025-04-10 07:56:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3601, 52, 76, '#c16c6c', '2025-04-10 07:56:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3606, 284, 23, 'as', '2025-04-10 08:01:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3607, 284, 72, '10/04/2025 01:31 PM', '2025-04-10 08:01:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3608, 53, 7, 'FDSF', '2025-04-10 08:02:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3609, 53, 76, '#c41313', '2025-04-10 08:02:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3610, 118, 31, 'FDSF', '2025-04-10 08:03:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3611, 118, 73, '12', '2025-04-10 08:03:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3613, 111, 96, 'Testing', '2025-04-10 10:07:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3615, 112, 96, 'Testing', '2025-04-10 10:10:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3617, 113, 96, 'sdsf', '2025-04-10 10:16:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3618, 40, 54, 'dfsf', '2025-04-10 10:31:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3621, 116, 96, '2', '2025-04-10 10:38:30');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3622, 1112, 47, 'ram', '2025-04-10 11:06:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3626, 97, 105, '2333', '2025-04-11 04:51:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3628, 54, 7, 'gdfg', '2025-04-11 05:01:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3629, 54, 76, '#bf4646', '2025-04-11 05:01:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3630, 81, 35, '30/04/2025', '2025-04-11 05:02:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3631, 81, 75, '13213', '2025-04-11 05:02:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3632, 81, 97, '29/04/2025 10:32 AM', '2025-04-11 05:02:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3633, 1113, 47, 'rani', '2025-04-11 05:05:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3640, 98, 103, 'A \"blood unit\" typically refers to a standard volume of blood, usually around 450 mL,', '2025-04-12 04:14:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3641, 98, 104, 'A \"blood unit\" typically refers to a standard volume of blood, usually around 450 mL,', '2025-04-11 11:29:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3642, 98, 105, '234', '2025-04-11 11:29:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3645, 245, 121, '30/04/2025', '2025-04-11 08:21:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3647, 43, 123, '#bb4f4f', '2025-04-11 09:03:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3648, 1115, 47, 'ram', '2025-04-11 09:18:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3650, 1116, 47, 'ram', '2025-04-11 09:20:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3652, 274, 29, 'add', '2025-04-11 09:20:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3654, 1117, 47, '', '2025-04-11 09:28:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3656, 1118, 47, '', '2025-04-11 09:31:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3658, 1119, 47, 'ram', '2025-04-11 09:55:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3660, 1120, 47, 'ram', '2025-04-11 09:55:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3662, 1121, 47, 'riya', '2025-04-11 10:29:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3664, 1122, 47, 'riya', '2025-04-11 10:29:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3666, 1123, 47, 'riya', '2025-04-11 10:35:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3668, 1124, 47, 'riya', '2025-04-11 10:36:01');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3670, 1125, 47, 'ram', '2025-04-11 10:37:48');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3684, 1132, 47, 'ram', '2025-04-11 11:25:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3686, 1133, 47, 'ram', '2025-04-11 11:25:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3688, 1134, 47, 'ram', '2025-04-11 11:25:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3692, 1136, 47, 'ram', '2025-04-11 11:25:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3703, 246, 121, '11/04/2025', '2025-04-11 11:27:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3704, 285, 23, '12', '2025-04-11 11:34:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3705, 285, 72, '11/04/2025 05:04 PM', '2025-04-11 11:34:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3706, 285, 124, '#b66262', '2025-04-11 11:34:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3708, 247, 121, '11/04/2025', '2025-04-11 11:42:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3710, 248, 121, '11/04/2025', '2025-04-11 11:44:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3711, 286, 23, 'dsfsdf', '2025-04-11 12:29:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3712, 286, 72, '11/04/2025 05:59 PM', '2025-04-11 12:29:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3713, 286, 124, '#d86c6c', '2025-04-11 12:29:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3714, 1141, 47, 'ram', '2025-04-11 12:37:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3725, 99, 103, 'aaaaaaaaaaaaaaa', '2025-04-12 11:50:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3726, 99, 104, 'A \"blood unit\" typically refers to a standard volume of blood, usually around 450 mL,llllllllll\r\n', '2025-04-12 11:50:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3727, 99, 105, '239888', '2025-04-12 11:50:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3729, 0, 35, '30/04/2025', '2025-04-12 04:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3730, 0, 75, '231', '2025-04-12 04:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3731, 0, 97, '12/04/2025 10:03 AM', '2025-04-12 04:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3732, 82, 35, '30/04/2025', '2025-04-12 04:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3733, 82, 75, '231', '2025-04-12 04:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3734, 82, 97, '12/04/2025 10:03 AM', '2025-04-12 04:33:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3735, 58, 49, 'sdf', '2025-04-12 04:34:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3736, 58, 55, 'hi', '2025-04-12 04:34:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3742, 100, 103, 'sd g gfdgfer rtr dfgdfg gf gdfgfd dfg', '2025-04-12 12:15:43');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3743, 100, 104, 'testing 12345678', '2025-04-12 04:42:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3744, 100, 105, '12345678', '2025-04-12 04:41:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3746, 1145, 47, 'ram', '2025-04-12 04:58:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3748, 1145, 109, '12/04/2025', '2025-04-12 04:58:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3749, 83, 35, '11/04/2025', '2025-04-12 06:07:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3750, 83, 75, '5', '2025-04-12 06:07:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3751, 83, 97, '12/04/2025 11:37 AM', '2025-04-12 06:07:55');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3752, 84, 35, '18/04/2025', '2025-04-12 06:08:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3753, 84, 75, '1', '2025-04-12 06:08:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3754, 84, 97, '12/04/2025 11:38 AM', '2025-04-12 06:08:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3755, 119, 31, '4', '2025-04-12 06:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3756, 119, 73, '4', '2025-04-12 06:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3757, 119, 125, '#d61919', '2025-04-12 06:18:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3758, 281, 29, 'sdsd', '2025-04-12 07:04:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3760, 85, 35, '12/04/2025', '2025-04-12 07:12:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3761, 85, 75, '2', '2025-04-12 07:12:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3762, 85, 97, '12/04/2025 12:42 PM', '2025-04-12 07:12:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3763, 282, 29, 'sfdsf', '2025-04-12 07:15:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3765, 283, 29, 'fsdf', '2025-04-12 07:16:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3767, 284, 29, 'fdsfsdf', '2025-04-12 07:16:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3769, 59, 49, '', '2025-04-12 07:43:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3770, 59, 55, 'hi', '2025-04-12 07:43:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3773, 120, 31, 'g', '2025-04-12 07:49:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3774, 120, 73, '56', '2025-04-12 07:49:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3775, 120, 125, '#db3b3b', '2025-04-12 07:49:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3777, 250, 121, '11/04/2025', '2025-04-12 07:51:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3779, 251, 121, '26/04/2025', '2025-04-12 07:52:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3780, 287, 29, 'sdfsdf', '2025-04-12 07:59:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3782, 288, 29, 'add', '2025-04-12 08:20:08');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3784, 1146, 47, 'rani', '2025-04-12 11:20:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3786, 1146, 109, '12/04/2025', '2025-04-12 11:12:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3793, 26, 27, '2', '2025-04-14 09:21:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3796, 287, 23, '12', '2025-04-12 11:45:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3797, 287, 72, '12/04/2025 05:15 PM', '2025-04-12 11:45:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3798, 287, 124, '#715757', '2025-04-12 11:45:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3803, 253, 121, '14/04/2025', '2025-04-14 07:53:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3804, 288, 23, 'add', '2025-04-14 08:06:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3805, 288, 72, '14/04/2025 11:57 PM', '2025-04-14 08:06:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3806, 288, 124, '#662d2d', '2025-04-14 08:06:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3808, 254, 121, '14/04/2025', '2025-04-14 08:34:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3809, 289, 23, 'ass', '2025-04-14 08:40:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3810, 289, 72, '14/04/2025 02:11 PM', '2025-04-14 08:40:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3811, 289, 124, '#3a2626', '2025-04-14 08:40:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3812, 292, 29, 'add', '2025-04-14 09:06:35');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3815, 44, 123, '#864747', '2025-04-14 09:09:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3816, 28, 45, 'add', '2025-04-14 09:24:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3817, 28, 68, '1.2', '2025-04-14 09:24:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3820, 45, 123, '#cc5757', '2025-04-14 09:26:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3822, 46, 123, '#ed0909', '2025-04-14 09:39:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3823, 0, 35, '14/04/2025', '2025-04-14 10:11:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3824, 0, 75, '1', '2025-04-14 10:11:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3825, 0, 97, '14/04/2025 03:34 PM', '2025-04-14 10:11:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3827, 121, 96, 'sdf', '2025-04-14 10:09:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3828, 32, 67, 'bvn', '2025-04-14 10:10:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3829, 32, 88, '01/05/2025', '2025-04-14 10:10:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3830, 86, 35, '14/04/2025', '2025-04-14 10:11:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3831, 86, 75, '1', '2025-04-14 10:11:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3832, 86, 97, '14/04/2025 03:34 PM', '2025-04-14 10:11:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3833, 0, 35, '14/04/2025', '2025-04-14 10:14:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3834, 0, 75, '1', '2025-04-14 10:14:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3835, 0, 97, '14/04/2025 03:44 PM', '2025-04-14 10:14:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3839, 121, 31, 'ass', '2025-04-14 10:33:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3840, 121, 73, '1', '2025-04-14 10:33:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3841, 121, 125, '#a62e2e', '2025-04-14 10:33:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3842, 0, 125, '#3f1b1b', '2025-04-14 10:38:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3843, 114, 31, 'dsf', '2025-04-14 10:38:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3844, 114, 73, '23', '2025-04-14 10:38:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3845, 114, 125, '#3f1b1b', '2025-04-14 10:38:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3846, 122, 31, 'add', '2025-04-14 11:09:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3847, 122, 73, '2', '2025-04-14 11:09:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3848, 122, 125, '#3b1616', '2025-04-14 11:09:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3849, 16, 37, '1', '2025-04-14 11:23:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3850, 16, 126, '14/04/2025', '2025-04-14 11:23:51');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3851, 0, 7, 'add', '2025-04-14 11:52:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3852, 0, 76, '#aa2d2d', '2025-04-14 11:52:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3853, 0, 76, '#764b4b', '2025-04-14 11:33:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3854, 33, 7, '30/11/2024', '2025-04-14 11:33:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3855, 33, 76, '#764b4b', '2025-04-14 11:33:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3856, 0, 76, '#7e2929', '2025-04-14 11:35:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3857, 31, 7, '29/11/2024', '2025-04-14 11:35:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3858, 31, 76, '#7e2929', '2025-04-14 11:35:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3860, 15, 77, '14/04/2025', '2025-04-14 11:49:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3861, 15, 98, '14/04/2025', '2025-04-14 11:49:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3862, 55, 7, 'add', '2025-04-14 11:52:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3863, 55, 76, '#aa2d2d', '2025-04-14 11:52:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3864, 62, 103, '', '2025-04-14 12:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3865, 62, 104, '', '2025-04-14 12:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3866, 62, 105, '', '2025-04-14 12:10:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3868, 60, 49, 'add', '2025-04-14 12:16:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3869, 60, 55, 'hi', '2025-04-14 12:16:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3872, 12, 87, '2', '2025-04-14 12:20:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3878, 31, 13, '#862525', '2025-04-14 12:22:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3879, 31, 65, 'ssddf', '2025-04-14 12:22:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3885, 122, 96, 'dsf', '2025-04-15 07:46:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3886, 33, 67, 'sdf', '2025-04-15 07:46:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3887, 33, 88, '30/04/2025', '2025-04-15 07:46:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3890, 294, 29, 'ttyty', '2025-04-15 07:54:23');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3892, 295, 29, '34', '2025-04-15 07:55:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3894, 123, 31, 'add', '2025-04-15 08:31:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3895, 123, 73, '2', '2025-04-15 08:31:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3896, 123, 125, '#853333', '2025-04-15 08:31:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3897, 56, 7, 'add', '2025-04-15 09:44:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3898, 56, 76, '#a42929', '2025-04-15 09:44:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3899, 0, 76, '#9d8686', '2025-04-15 09:45:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3900, 30, 7, '27/11/2024', '2025-04-15 09:45:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3901, 30, 76, '#9d8686', '2025-04-15 09:45:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3905, 101, 103, '12', '2025-04-15 10:11:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3906, 101, 104, '', '2025-04-15 10:11:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3907, 101, 105, '', '2025-04-15 10:11:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3909, 11, 83, 'add', '2025-04-15 10:32:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3911, 11, 112, '34', '2025-04-15 10:32:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3912, 1151, 47, 'rani', '2025-04-15 10:37:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3914, 1151, 109, '15/04/2025', '2025-04-15 10:37:54');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3917, 258, 121, '15/04/2025', '2025-04-15 11:11:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3918, 290, 23, 'add', '2025-04-15 11:12:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3919, 290, 72, '15/04/2025 04:42 PM', '2025-04-15 11:12:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3920, 290, 124, '#b25959', '2025-04-15 11:12:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3921, 0, 35, '15/04/2025', '2025-04-15 11:28:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3922, 0, 75, '2', '2025-04-15 11:28:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3923, 0, 97, '15/04/2025 04:55 PM', '2025-04-15 11:28:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3924, 87, 35, '15/04/2025', '2025-04-15 11:28:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3925, 87, 75, '2', '2025-04-15 11:28:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3926, 87, 97, '15/04/2025 04:55 PM', '2025-04-15 11:28:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3927, 0, 23, 'gdfg', '2025-04-15 11:40:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3928, 0, 72, '15/04/2025 05:08 PM', '2025-04-15 11:40:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3929, 0, 124, '#9a4a4a', '2025-04-15 11:40:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3930, 291, 23, 'gdfg', '2025-04-15 11:40:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3931, 291, 72, '15/04/2025 05:08 PM', '2025-04-15 11:40:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3932, 291, 124, '#9a4a4a', '2025-04-15 11:40:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3933, 0, 23, 'dsf', '2025-04-16 07:43:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3934, 0, 72, '15/04/2025 05:14 PM', '2025-04-16 07:43:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3935, 0, 124, '#e93f3f', '2025-04-16 07:43:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3936, 0, 124, '#e32424', '2025-04-15 11:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3937, 269, 23, 'add', '2025-04-15 11:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3938, 269, 72, '10/03/2025 02:21 PM', '2025-04-15 11:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3939, 269, 124, '#e32424', '2025-04-15 11:45:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3940, 0, 124, '#bc4f4f', '2025-04-15 11:58:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3941, 282, 23, 'add', '2025-04-15 11:58:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3942, 282, 72, '05/04/2025 02:37 PM', '2025-04-15 11:58:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3943, 282, 124, '#bc4f4f', '2025-04-15 11:58:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3944, 0, 35, '16/04/2025', '2025-04-15 12:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3945, 0, 75, '2', '2025-04-15 12:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3946, 0, 97, '15/04/2025 05:34 PM', '2025-04-15 12:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3949, 88, 35, '16/04/2025', '2025-04-15 12:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3950, 88, 75, '2', '2025-04-15 12:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3951, 88, 97, '15/04/2025 05:34 PM', '2025-04-15 12:19:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3952, 293, 23, '12', '2025-04-15 12:22:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3953, 293, 72, '15/04/2025 05:52 PM', '2025-04-15 12:22:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3954, 293, 124, '#924949', '2025-04-15 12:22:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3956, 18, 12, '2.3', '2025-04-15 12:38:07');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3958, 102, 83, 'as', '2025-04-15 12:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3960, 102, 112, '12', '2025-04-15 12:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3967, 0, 35, '18/04/2025', '2025-04-16 06:00:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3968, 0, 75, '5464', '2025-04-16 06:00:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3969, 0, 97, '16/04/2025 11:30 AM', '2025-04-16 06:00:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3970, 0, 35, '18/04/2025', '2025-04-16 06:01:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3971, 0, 75, '5464', '2025-04-16 06:01:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3972, 0, 97, '16/04/2025 11:30 AM', '2025-04-16 06:01:17');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3973, 0, 35, '18/04/2025', '2025-04-16 06:01:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3974, 0, 75, '5464', '2025-04-16 06:01:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3975, 0, 97, '16/04/2025 11:30 AM', '2025-04-16 06:01:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3979, 61, 49, '', '2025-04-16 07:15:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3980, 61, 55, 'hi', '2025-04-16 07:15:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3983, 92, 35, '29/04/2025', '2025-04-16 07:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3984, 92, 75, '12', '2025-04-16 07:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3985, 92, 97, '16/04/2025 01:06 PM', '2025-04-16 07:40:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3986, 292, 23, 'dsf', '2025-04-16 07:43:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3987, 292, 72, '15/04/2025 05:14 PM', '2025-04-16 07:43:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3988, 292, 124, '#e93f3f', '2025-04-16 07:43:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3989, 5, 51, 'add', '2025-04-16 08:20:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3991, 26, 11, '16/04/2025 01:54 PM', '2025-04-16 08:24:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3992, 26, 63, '2', '2025-04-16 08:24:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3994, 42, 54, '12', '2025-04-16 08:52:21');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3996, 29, 66, '1', '2025-04-16 10:18:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (3997, 29, 87, '2', '2025-04-16 10:18:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4001, 32, 13, '#941e1e', '2025-04-16 10:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4002, 32, 65, '23', '2025-04-16 10:23:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4004, 124, 31, 'asd', '2025-04-17 04:41:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4005, 124, 73, '10', '2025-04-17 04:41:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4006, 124, 125, '#d34c4c', '2025-04-17 04:41:22');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4010, 103, 103, 'Go, often referred to as Golang, is an open-source programming language developed by Google, designed to be simple, efficient, and readable. It\'s a compiled, statically-typed language widely used in backend development, cloud infrastructure, and other areas. Go is known for its concurrency features, making it suitable for building scalable and high-performance systems. ', '2025-04-17 10:20:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4011, 103, 104, 'test', '2025-04-17 06:33:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4012, 103, 105, '3', '2025-04-17 06:33:52');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4014, 43, 54, 'asd', '2025-04-17 09:02:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4016, 124, 96, '12', '2025-04-17 09:31:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4017, 124, 127, '1', '2025-04-17 09:31:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4030, 104, 103, 'gf', '2025-04-18 06:02:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4031, 104, 104, 'fgh', '2025-04-18 06:02:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4032, 104, 105, '23', '2025-04-18 06:02:38');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4034, 0, 35, '25/04/2025', '2025-04-18 06:30:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4035, 0, 75, '4534', '2025-04-18 06:30:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4036, 0, 97, '18/04/2025 11:57 AM', '2025-04-18 06:30:33');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4037, 0, 35, '25/04/2025', '2025-04-18 06:30:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4038, 0, 75, '4534', '2025-04-18 06:30:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4039, 0, 97, '18/04/2025 11:57 AM', '2025-04-18 06:30:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4043, 294, 23, 'asd', '2025-04-18 06:35:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4044, 294, 72, '18/04/2025 12:05 PM', '2025-04-18 06:35:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4045, 294, 124, '#e81b1b', '2025-04-18 06:35:57');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4046, 0, 35, '24/04/2025', '2025-04-18 06:38:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4047, 0, 75, '43', '2025-04-18 06:38:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4048, 0, 97, '30/04/2025 12:07 PM', '2025-04-18 06:38:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4049, 0, 35, '24/04/2025', '2025-04-18 06:38:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4050, 0, 75, '43', '2025-04-18 06:38:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4051, 0, 97, '30/04/2025 12:07 PM', '2025-04-18 06:38:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4052, 0, 35, '24/04/2025', '2025-04-18 06:41:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4053, 0, 75, '43', '2025-04-18 06:41:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4054, 0, 97, '30/04/2025 12:07 PM', '2025-04-18 06:41:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4058, 0, 35, '', '2025-04-18 07:03:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4059, 0, 75, '', '2025-04-18 07:03:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4060, 0, 97, '', '2025-04-18 07:03:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4061, 0, 35, '', '2025-04-18 07:03:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4062, 0, 75, '', '2025-04-18 07:03:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4063, 0, 97, '', '2025-04-18 07:03:16');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4064, 0, 35, '', '2025-04-18 07:11:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4065, 0, 75, '', '2025-04-18 07:11:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4066, 0, 97, '', '2025-04-18 07:11:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4070, 0, 35, '', '2025-04-18 07:16:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4071, 0, 75, '', '2025-04-18 07:16:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4072, 0, 97, '', '2025-04-18 07:16:10');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4073, 0, 35, '', '2025-04-18 07:16:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4074, 0, 75, '', '2025-04-18 07:16:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4075, 0, 97, '', '2025-04-18 07:16:19');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4076, 0, 35, '', '2025-04-18 07:16:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4077, 0, 75, '', '2025-04-18 07:16:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4078, 0, 97, '', '2025-04-18 07:16:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4086, 259, 121, '24/04/2025', '2025-04-18 07:31:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4088, 260, 121, '25/04/2025', '2025-04-18 07:32:18');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4089, 0, 35, '', '2025-04-18 07:34:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4090, 0, 75, '', '2025-04-18 07:34:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4091, 0, 97, '', '2025-04-18 07:34:09');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4092, 0, 35, '', '2025-04-18 07:35:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4093, 0, 75, '', '2025-04-18 07:35:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4094, 0, 97, '', '2025-04-18 07:35:39');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4099, 105, 103, 'A \"unit\" of blood typically refers to one standardized volume of whole blood or a specific blood component, like packed red blood cells, fresh frozen plasma, or platelets.', '2025-04-19 11:47:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4100, 105, 104, 'A \"unit\" of blood typically refers to one standardized volume of whole blood or a specific blood component, like packed red blood cells, fresh frozen plasma, or platelets.', '2025-04-18 10:01:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4101, 105, 105, '23', '2025-04-18 10:01:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4102, 105, 132, '#963f3f', '2025-04-18 09:54:42');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4106, 106, 83, 'A \"unit\" of blood typically refers to one standardized volume of whole blood or a specific blood', '2025-04-18 10:18:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4108, 106, 112, '2', '2025-04-18 10:17:12');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4109, 106, 133, 'A \"unit\" of blood typically refers to one standardized volume of whole blood or a specific blood', '2025-04-21 04:13:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4110, 0, 35, '', '2025-04-18 10:18:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4111, 0, 75, '', '2025-04-18 10:18:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4112, 0, 97, '', '2025-04-18 10:18:27');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4113, 0, 35, '', '2025-04-18 10:19:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4114, 0, 75, '', '2025-04-18 10:19:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4115, 0, 97, '', '2025-04-18 10:19:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4122, 0, 35, '', '2025-04-18 10:22:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4123, 0, 75, '', '2025-04-18 10:22:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4124, 0, 97, '', '2025-04-18 10:22:24');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4125, 0, 35, '', '2025-04-18 10:57:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4126, 0, 75, '', '2025-04-18 10:57:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4127, 0, 97, '', '2025-04-18 10:57:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4128, 0, 35, '', '2025-04-18 10:59:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4129, 0, 75, '', '2025-04-18 10:59:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4130, 0, 97, '', '2025-04-18 10:59:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4131, 0, 35, '', '2025-04-18 11:07:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4132, 0, 75, '', '2025-04-18 11:07:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4133, 0, 97, '', '2025-04-18 11:07:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4134, 0, 35, '', '2025-04-18 11:21:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4135, 0, 75, '', '2025-04-18 11:21:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4136, 0, 97, '', '2025-04-18 11:21:58');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4137, 30, 66, '1', '2025-04-18 11:18:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4138, 30, 87, '2', '2025-04-18 11:18:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4139, 30, 137, '2', '2025-04-18 11:18:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4143, 0, 35, '', '2025-04-18 11:26:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4144, 0, 75, '', '2025-04-18 11:26:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4145, 0, 97, '', '2025-04-18 11:26:25');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4146, 0, 35, '', '2025-04-18 11:28:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4147, 0, 75, '', '2025-04-18 11:28:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4148, 0, 97, '', '2025-04-18 11:28:53');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4149, 0, 35, '', '2025-04-18 11:29:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4150, 0, 75, '', '2025-04-18 11:29:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4151, 0, 97, '', '2025-04-18 11:29:13');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4152, 0, 35, '', '2025-04-18 11:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4153, 0, 75, '', '2025-04-18 11:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4154, 0, 97, '', '2025-04-18 11:32:34');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4155, 0, 35, '', '2025-04-18 11:34:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4156, 0, 75, '', '2025-04-18 11:34:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4157, 0, 97, '', '2025-04-18 11:34:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4158, 0, 35, '', '2025-04-18 11:37:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4159, 0, 75, '', '2025-04-18 11:37:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4160, 0, 97, '', '2025-04-18 11:37:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4161, 27, 96, 'test test test test', '2025-04-18 12:55:29');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4162, 27, 127, '2', '2025-04-18 11:37:03');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4163, 106, 35, '', '2025-04-18 11:37:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4164, 106, 75, '', '2025-04-18 11:37:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4165, 106, 97, '', '2025-04-18 11:37:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4166, 0, 35, '', '2025-04-18 11:47:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4167, 0, 75, '', '2025-04-18 11:47:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4168, 0, 97, '', '2025-04-18 11:47:15');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4169, 0, 35, '', '2025-04-18 11:47:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4170, 0, 75, '', '2025-04-18 11:47:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4171, 0, 97, '', '2025-04-18 11:47:31');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4172, 0, 35, '', '2025-04-18 11:50:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4173, 0, 75, '', '2025-04-18 11:50:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4174, 0, 97, '', '2025-04-18 11:50:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4175, 107, 35, '', '2025-04-18 11:50:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4176, 107, 75, '', '2025-04-18 11:50:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4177, 107, 97, '', '2025-04-18 11:50:40');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4178, 0, 35, '', '2025-04-18 11:52:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4179, 0, 75, '', '2025-04-18 11:52:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4180, 0, 97, '', '2025-04-18 11:52:06');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4190, 0, 35, '', '2025-04-18 12:54:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4191, 0, 75, '', '2025-04-18 12:54:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4192, 0, 97, '', '2025-04-18 12:54:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4208, 0, 35, '', '2025-04-19 05:56:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4209, 0, 75, '', '2025-04-19 05:56:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4210, 0, 97, '', '2025-04-19 05:56:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4217, 0, 35, '', '2025-04-19 06:09:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4218, 0, 75, '', '2025-04-19 06:09:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4219, 0, 97, '', '2025-04-19 06:09:00');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4223, 125, 31, 'dsf', '2025-04-19 06:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4224, 125, 73, '45', '2025-04-19 06:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4225, 125, 125, '#e03a3a', '2025-04-19 06:10:41');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4226, 126, 31, 'gfdg', '2025-04-19 06:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4227, 126, 73, '456', '2025-04-19 06:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4228, 126, 125, '#ce1c1c', '2025-04-19 06:11:02');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4229, 127, 31, '535', '2025-04-19 06:16:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4230, 127, 73, '34535', '2025-04-19 06:16:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4231, 127, 125, '#fc0c0c', '2025-04-19 06:16:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4232, 128, 31, '35435', '2025-04-19 06:17:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4233, 128, 73, '4535', '2025-04-19 06:17:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4234, 128, 125, '#cc1c1c', '2025-04-19 06:17:44');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4235, 129, 31, '3545', '2025-04-19 06:18:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4236, 129, 73, '34535', '2025-04-19 06:18:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4237, 129, 125, '#e01111', '2025-04-19 06:18:20');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4245, 57, 128, 'd', '2025-04-21 04:28:32');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4249, 122, 35, '', '2025-04-19 12:34:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4250, 122, 75, '', '2025-04-19 12:34:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4251, 122, 97, '', '2025-04-19 12:34:28');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4253, 107, 103, 'A \"unit\" of blood typically refers to one standardized volume of whole blood or a specific blood', '2025-04-21 04:10:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4254, 107, 104, '23', '2025-04-21 04:10:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4255, 107, 105, '34', '2025-04-21 04:10:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4256, 107, 132, '#b42f2f', '2025-04-21 04:10:50');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4257, 125, 96, 'ghj', '2025-04-21 04:16:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4258, 125, 127, '2', '2025-04-21 04:16:56');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4259, 261, 121, '21/04/2025', '2025-04-21 04:17:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4260, 261, 141, '#d61919', '2025-04-21 04:17:11');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4261, 301, 29, 'sdf', '2025-04-21 04:17:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4262, 301, 142, '1', '2025-04-21 04:17:45');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4263, 108, 83, 'gdfg', '2025-04-21 04:21:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4265, 108, 112, 'sf', '2025-04-21 04:21:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4266, 108, 133, 'dfs', '2025-04-21 04:21:59');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4267, 126, 96, '12', '2025-04-21 07:21:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4268, 126, 127, '1', '2025-04-21 07:21:26');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4269, 262, 121, '21/04/2025', '2025-04-21 07:22:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4270, 262, 141, '#b44646', '2025-04-21 07:22:14');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4271, 0, 23, '12', '2025-04-21 07:27:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4272, 0, 72, '21/04/2025 12:55 PM', '2025-04-21 07:27:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4273, 0, 124, '#745d5d', '2025-04-21 07:27:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4274, 295, 23, '12', '2025-04-21 07:27:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4275, 295, 72, '21/04/2025 12:55 PM', '2025-04-21 07:27:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4276, 295, 124, '#745d5d', '2025-04-21 07:27:46');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4277, 19, 12, '2.3', '2025-04-21 07:29:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4278, 19, 135, '68', '2025-04-21 07:29:37');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4279, 303, 29, 'add', '2025-04-21 07:34:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4280, 303, 142, '1', '2025-04-21 07:34:04');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4281, 296, 23, '12', '2025-04-21 07:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4282, 296, 72, '21/04/2025 01:05 PM', '2025-04-21 07:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4283, 296, 124, '#996464', '2025-04-21 07:35:36');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4284, 109, 83, 'hgjhg', '2025-04-21 07:36:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4286, 109, 112, '4', '2025-04-21 07:36:49');
INSERT INTO `custom_field_values` (`id`, `belong_table_id`, `custom_field_id`, `field_value`, `created_at`) VALUES (4287, 109, 133, 'g', '2025-04-21 07:36:49');


#
# TABLE STRUCTURE FOR: custom_fields
#

DROP TABLE IF EXISTS `custom_fields`;

CREATE TABLE `custom_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `belong_to` varchar(100) DEFAULT NULL,
  `type` varchar(100) DEFAULT NULL,
  `bs_column` int DEFAULT NULL,
  `validation` int DEFAULT '0',
  `field_values` mediumtext,
  `visible_on_print` int DEFAULT NULL,
  `visible_on_report` int DEFAULT NULL,
  `visible_on_table` int DEFAULT NULL,
  `visible_on_patient_panel` int DEFAULT NULL,
  `weight` int DEFAULT NULL,
  `is_active` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_belong_to` (`belong_to`),
  KEY `index_type` (`type`),
  KEY `index_visible_on_table` (`visible_on_table`),
  KEY `index_visible_on_print` (`visible_on_print`),
  KEY `index_visible_on_report` (`visible_on_report`)
) ENGINE=InnoDB AUTO_INCREMENT=153 DEFAULT CHARSET=utf8mb3;

INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (1, 'Previous Details CUSTOM', 'antenatal', 'input', 12, 1, '', 1, 1, 1, 1, NULL, 0, '2024-09-30 06:24:55');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (2, 'Health Report CUSTOM', 'antenatal', 'select', 12, 1, 'Good, bad', 1, 1, 1, 1, NULL, 0, '2024-09-30 10:53:38');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (3, 'custom fields CUSTOM', 'antenatal', 'input', 12, 1, '', 1, 1, 1, 1, NULL, 0, '2024-09-30 06:25:09');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (4, 'caustom radiology', 'radiology', 'input', 12, 1, 'dfgdfgdg', 1, 1, 1, 1, NULL, 0, '2024-09-28 12:23:08');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (5, 'ambulances', 'ambulance_call', 'checkbox', 12, 0, '2,3', 0, 1, 0, 0, NULL, 0, '2024-10-07 12:15:13');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (6, 'appoinment', 'appointment', 'date_picker', 12, 0, '2,3', 0, 1, 0, 0, NULL, 0, '2024-10-07 12:16:04');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (7, 'radiology testing special character /*-+=-3924(@)', 'radiology', 'input', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2024-12-03 11:04:47');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (8, 'date of birth ?', 'birth_report', 'date_picker_time', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2024-12-03 06:24:20');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (9, 'blood issue', 'blood_issue', 'date_picker', 12, 0, '2,3', 0, 0, 1, 0, NULL, 0, '2024-10-07 12:18:31');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (10, 'component issue', 'component_issue', 'checkbox', 12, 0, '2,3', 1, 0, 0, 0, NULL, 0, '2024-10-07 12:19:07');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (11, 'death-date- ?', 'death_report', 'date_picker_time', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2024-12-03 07:21:33');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (12, 'doner\'s address and next visit ?', 'donor', 'checkbox', 12, 1, '2.3', 1, 1, 1, 1, NULL, 0, '2024-12-03 07:25:14');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (13, 'expense name and Rs $', 'expenses', 'colorpicker', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2024-12-03 07:30:24');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (20, 'OPDtest_?', 'blood_issue', 'checkbox', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2024-12-03 07:12:00');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (23, 'medicina taken or not by patient on time ??&lt;&lt; ?', 'prescription', 'input', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2024-12-03 09:34:01');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (27, 'it is an optional fields you can ignored it?', 'ipdnursenote', 'number', 12, 1, '1,2,3', 1, 1, 1, 1, NULL, 0, '2024-12-03 07:59:19');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (29, 'recheckup_testing?!', 'opdrecheckup', 'input', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2024-12-03 09:10:40');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (31, 'acinus (acini = pl.)', 'pathology', 'input', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2024-12-03 10:14:15');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (34, 'test 4314@!@!@#@$#Afs', 'radiologytest', 'input', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2024-12-03 11:07:16');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (35, 'pharmacy bill ****', 'pharmacy', 'date_picker', 8, 0, '', 1, 1, 1, 1, NULL, 0, '2025-04-18 06:46:04');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (37, 'OPDtest&', 'pathologytest', 'select', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2024-12-03 10:20:08');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (45, 'do you want to register consultant ? (optional).', 'ipdconsultinstruction', 'input', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:19:13');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (47, 'opd appoint ment taken by Custom', 'appointment', 'select', 12, 0, 'ram,rani,riya,siya\r\n', 1, 1, 1, 1, NULL, 0, '2025-04-15 12:45:32');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (49, 'TESTING//@#$', 'ambulance_call', 'input', 12, 0, '', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:03:30');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (50, 'TESTING\'!@#$%^&*()', 'antenatal', 'input', 12, 1, '', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:04:40');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (51, 'testing hyperlink-custom_?', 'birth_report', 'link', 12, 1, 'www.google.com\r\n', 1, 1, 1, 1, NULL, 0, '2024-12-03 06:56:38');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (54, 'tes staff-?&gt;', 'staff', 'input', 12, 1, '', 1, 1, 1, 1, NULL, 0, '2024-12-03 11:21:58');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (55, 'testing_validation', 'ambulance_call', 'select', 12, 1, 'hi,hello', 1, 1, 1, 1, NULL, 0, '2024-12-05 06:13:17');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (63, 'DEATH RATE', 'death_report', 'multiselect', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2025-03-05 11:33:43');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (65, 'expenses in electricity', 'expenses', 'link', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2025-03-05 11:39:21');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (66, 'income head12234', 'income', 'select', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:17:23');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (67, 'testing fiel#$%', 'ipd', 'input', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-04-18 07:57:09');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (68, 'hospital register', 'ipdconsultinstruction', 'select', 12, 1, '1.2', 1, 1, 1, 1, NULL, 0, '2025-03-05 11:49:22');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (72, 'presciption field', 'prescription', 'date_picker_time', 12, 1, '2,3', 1, 1, 1, 1, NULL, 0, '2025-03-05 12:24:14');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (73, 'path test', 'pathology', 'number', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-03-05 12:38:39');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (75, 'testing', 'pharmacy', 'number', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:31:05');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (76, 'xray', 'radiology', 'colorpicker', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-03-05 12:52:43');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (77, 'radio test', 'radiologytest', 'date_picker', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-03-05 12:55:55');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (80, 'adding', 'antenatal', 'colorpicker', 12, 1, '1,2', 1, 0, 1, 0, NULL, 0, '2025-04-10 11:04:00');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (83, 'issue@#$%', 'component_issue', 'input', 12, 1, '2,1', 1, 1, 1, 1, NULL, 0, '2025-03-15 07:15:00');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (87, 'income feild@#$', 'income', 'select', 12, 1, '2,1', 1, 1, 1, 1, NULL, 0, '2025-03-15 07:32:29');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (88, 'ipd purpose', 'ipd', 'date_picker', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-03-15 07:35:45');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (96, 'Testing //', 'patient', 'input', 12, 1, 'Abc', 1, 1, 1, 1, NULL, 0, '2025-04-17 09:45:36');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (97, 'Hello $@#&', 'pharmacy', 'date_picker_time', 12, 0, '1\'2', 1, 1, 1, 1, NULL, 0, '2025-04-18 06:45:48');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (98, 'Anyone #$@', 'radiologytest', 'date_picker', 12, 1, '2\'3', 1, 1, 1, 1, NULL, 0, '2025-03-15 10:08:09');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (103, 'Blood data', 'blood_issue', 'input', 12, 0, '', 0, 0, 1, 0, NULL, 0, '2025-04-10 07:01:21');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (104, 'Plasma Unit', 'blood_issue', 'textarea', 12, 0, '', 0, 0, 1, 0, NULL, 0, '2025-04-10 07:05:05');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (105, 'Blood Count', 'blood_issue', 'link', 12, 0, '1,2', 0, 0, 1, 0, NULL, 0, '2025-04-18 07:27:32');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (106, '\"plasma unit\"', 'component_issue', 'textarea', 12, 1, '', 0, 0, 1, 0, NULL, 0, '2025-04-10 07:19:34');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (108, '/call/2@#', 'ambulance_call', 'checkbox', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-04-10 10:55:28');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (109, 'APPOIN#$', 'appointment', 'date_picker', 12, 1, '', 1, 0, 1, 0, NULL, 0, '2025-04-10 11:07:46');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (112, 'COMPONANT#$', 'component_issue', 'input', 12, 1, '1,2', 1, 0, 1, 1, NULL, 0, '2025-05-07 11:35:52');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (121, 'OPD ADD#$%^**', 'opd', 'date_picker', 12, 1, '1,2', 1, 0, 1, 0, NULL, 0, '2025-04-10 12:14:33');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (123, 'OT ADD', 'operationtheatre', 'colorpicker', 12, 1, '2,1', 1, 0, 1, 0, NULL, 0, '2025-04-10 12:18:16');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (124, 'Prescription@#$%', 'prescription', 'colorpicker', 12, 1, '1,1', 1, 0, 1, 0, NULL, 0, '2025-04-10 12:36:42');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (125, 'path@#$5', 'pathology', 'colorpicker', 12, 1, '2.3', 1, 0, 1, 0, NULL, 0, '2025-04-10 12:38:25');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (126, 'path/test/', 'pathologytest', 'date_picker', 12, 1, '1,2', 1, 0, 1, 0, NULL, 0, '2025-04-10 12:40:19');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (127, 'parient add', 'patient', 'checkbox', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-04-17 09:18:24');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (128, 'ambulance test//', 'ambulance_call', 'link', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-04-19 09:20:52');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (129, '// antenatal', 'antenatal', 'colorpicker', 12, 1, '2,1', 1, 0, 1, 0, NULL, 0, '2025-04-18 07:11:44');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (130, 'patient appointment', 'appointment', 'date_picker', 12, 1, '1,2', 1, 0, 1, 1, NULL, 0, '2025-05-07 12:05:09');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (131, 'add birth//@#$%', 'birth_report', 'link', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:08:12');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (132, 'blood//$$%^', 'blood_issue', 'colorpicker', 12, 1, '2,1', 1, 1, 1, 0, NULL, 0, '2025-04-18 07:30:30');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (133, 'issue compo#$%', 'component_issue', 'input', 12, 1, '', 1, 0, 1, 1, NULL, 0, '2025-05-07 11:35:10');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (134, 'record@#$//', 'death_report', 'textarea', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-04-18 07:46:45');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (135, 'donor345//', 'donor', 'input', 12, 1, '1,2', 1, 1, 1, 0, NULL, 0, '2025-04-18 07:49:27');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (136, 'EXPEN//#$%', 'expenses', 'date_picker_time', 12, 1, '1,2', 1, 1, 1, 0, NULL, 0, '2025-04-18 07:52:15');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (137, 'INCOME@#$//', 'income', 'checkbox', 12, 0, '1,2', 1, 1, 1, 0, NULL, 0, '2025-04-18 07:55:50');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (138, 'IPD//', 'ipd', 'colorpicker', 12, 0, '1,2', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:18:48');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (139, 'register@#$//', 'ipdconsultinstruction', 'date_picker', 12, 1, '3,4', 1, 1, 1, 0, NULL, 0, '2025-04-18 08:01:56');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (140, 'note$%^/', 'ipdnursenote', 'date_picker', 12, 1, '1,2', 1, 1, 1, 0, NULL, 0, '2025-04-18 08:19:01');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (141, 'opd//', 'opd', 'colorpicker', 12, 1, '1,2', 1, 1, 1, 0, NULL, 0, '2025-04-18 08:22:04');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (142, 'opd rechec//', 'opdrecheckup', 'multiselect', 12, 1, '1,2', 1, 1, 1, 0, NULL, 0, '2025-04-18 08:27:43');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (143, 'ot field', 'operationtheatre', 'checkbox', 12, 1, '2,3', 1, 1, 1, 0, NULL, 0, '2025-04-18 08:39:43');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (144, '//staff', 'staff', 'date_picker_time', 12, 1, '1,2', 1, 1, 1, 0, NULL, 0, '2025-04-18 10:58:03');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (146, 'death//record@#$', 'death_report', 'date_picker', 12, 1, '2,1', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:11:58');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (147, 'donor//@#$', 'donor', 'date_picker_time', 12, 1, '2,1', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:16:05');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (148, 'opd1@#$$//', 'opd', 'checkbox', 12, 1, '1,1', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:21:30');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (149, 'recheckup', 'opdrecheckup', 'link', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:24:16');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (150, 'adding staff///', 'staff', 'colorpicker', 12, 1, '2,1', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:26:24');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (151, '@#$ test/', 'radiologytest', 'textarea', 12, 1, '2,1', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:28:47');
INSERT INTO `custom_fields` (`id`, `name`, `belong_to`, `type`, `bs_column`, `validation`, `field_values`, `visible_on_print`, `visible_on_report`, `visible_on_table`, `visible_on_patient_panel`, `weight`, `is_active`, `created_at`) VALUES (152, 'patient@#$%%', 'patient', 'date_picker_time', 12, 1, '1,2', 1, 1, 1, 1, NULL, 0, '2025-05-07 12:32:34');


#
# TABLE STRUCTURE FOR: death_report
#

DROP TABLE IF EXISTS `death_report`;

CREATE TABLE `death_report` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `attachment` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `attachment_name` text,
  `death_date` datetime NOT NULL,
  `guardian_name` varchar(200) NOT NULL,
  `death_report` text,
  `is_active` varchar(10) NOT NULL,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `patient_id` (`patient_id`),
  CONSTRAINT `death_report_ibfk_1` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `death_report_ibfk_2` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3;

INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (8, 3, 43, '', NULL, '2024-11-05 11:29:00', 'Garry Paul', '64e6', 'yes', NULL, '2024-11-05 06:00:03');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (9, 5, 23, '', NULL, '2024-11-06 12:12:00', 'Karan', 'hello', 'yes', NULL, '2024-11-14 06:57:25');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (10, 5, 23, '', NULL, '2024-11-12 13:52:00', 'Karan', '', 'yes', NULL, '2024-11-12 08:22:33');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (11, 5, 23, '', NULL, '2024-11-13 18:07:00', 'Karan', '', 'yes', NULL, '2024-11-13 12:38:04');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (12, 5, 23, '', NULL, '2024-11-14 15:47:00', 'Karan', '', 'yes', NULL, '2024-11-14 10:18:06');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (16, 3, 9, '1732688646-9038511836746bb0633f87!test.jpg', 'test.jpg', '2024-11-27 11:51:00', 'Garry Paul', 'a -> test ', 'yes', 1, '2024-11-27 06:24:06');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (17, 3, 9, '1732689312-21369727546746bda0d8b1d!K (6) (1).png', 'K (6) (1).png', '2024-11-27 12:03:00', 'Garry Paul', '', 'yes', 1, '2024-11-27 06:35:12');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (19, 3, 9, '', NULL, '2024-12-02 11:04:00', 'Garry Paul', '', 'yes', 1, '2024-12-02 05:34:09');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (20, 3, 9, '', NULL, '2024-12-02 15:51:00', 'Garry Paul', '', 'yes', 1, '2024-12-03 07:21:34');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (22, 5, 23, '', NULL, '2025-03-01 18:09:00', 'Karan', '', 'yes', 1, '2025-03-01 12:39:55');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (25, 5, 23, '1744097355-138112473267f4d04b4adc0!3 (2).JPG', '3 (2).JPG', '2025-04-08 12:58:00', 'Karan', '', 'yes', 1, '2025-04-08 07:29:15');
INSERT INTO `death_report` (`id`, `patient_id`, `case_reference_id`, `attachment`, `attachment_name`, `death_date`, `guardian_name`, `death_report`, `is_active`, `generated_by`, `created_at`) VALUES (26, 3, 10, '1744791890-55036217367ff69528f025!3 (2) (2).JPG', '3 (2) (2).JPG', '2025-04-16 13:54:00', 'Garry Paul', '', 'yes', 1, '2025-04-16 08:24:50');


#
# TABLE STRUCTURE FOR: department
#

DROP TABLE IF EXISTS `department`;

CREATE TABLE `department` (
  `id` int NOT NULL AUTO_INCREMENT,
  `department_name` varchar(200) NOT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_department_name` (`department_name`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3;

INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (1, 'Opd', 'yes', '2024-09-26 07:18:39');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (2, 'IPD', 'yes', '2024-09-26 07:18:45');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (3, 'Radiology', 'yes', '2024-09-26 07:18:53');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (4, 'Pathology', 'yes', '2024-09-26 07:19:00');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (6, 'Pharma', 'yes', '2024-09-30 11:08:44');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (7, 'Blood bank', 'yes', '2024-10-11 10:27:08');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (8, 'pharmacy', 'yes', '2024-11-19 12:38:15');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (13, 'Finance', 'yes', '2025-04-25 09:59:06');
INSERT INTO `department` (`id`, `department_name`, `is_active`, `created_at`) VALUES (14, 'Ambulance', 'yes', '2025-05-07 08:44:45');


#
# TABLE STRUCTURE FOR: discharge_card
#

DROP TABLE IF EXISTS `discharge_card`;

CREATE TABLE `discharge_card` (
  `id` int NOT NULL AUTO_INCREMENT,
  `case_reference_id` int DEFAULT NULL,
  `opd_details_id` int DEFAULT NULL,
  `ipd_details_id` int DEFAULT NULL,
  `discharge_by` int DEFAULT NULL,
  `discharge_date` datetime DEFAULT NULL,
  `discharge_status` int NOT NULL,
  `death_date` datetime DEFAULT NULL,
  `refer_date` datetime DEFAULT NULL,
  `refer_to_hospital` varchar(255) DEFAULT NULL,
  `reason_for_referral` varchar(255) DEFAULT NULL,
  `operation` varchar(225) NOT NULL,
  `diagnosis` varchar(255) NOT NULL,
  `investigations` text,
  `treatment_home` varchar(255) NOT NULL,
  `note` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `opd_details_id` (`opd_details_id`),
  KEY `ipd_details_id` (`ipd_details_id`),
  KEY `discharge_by` (`discharge_by`),
  CONSTRAINT `discharge_card_ibfk_1` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_2` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_4` FOREIGN KEY (`opd_details_id`) REFERENCES `opd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_5` FOREIGN KEY (`ipd_details_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `discharge_card_ibfk_6` FOREIGN KEY (`discharge_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: dispatch_receive
#

DROP TABLE IF EXISTS `dispatch_receive`;

CREATE TABLE `dispatch_receive` (
  `id` int NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(50) NOT NULL,
  `to_title` varchar(100) NOT NULL,
  `address` text,
  `note` text,
  `from_title` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `image` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_reference_no` (`reference_no`),
  KEY `index_to_title` (`to_title`),
  KEY `index_from_title` (`from_title`),
  KEY `index_date` (`date`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3;

INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (1, '1234', '', '', '', 'Electricity bill', '2024-09-30', '', 'receive', '2024-09-30 07:50:31');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (2, '234', 'Report', ' ', '', '', '2024-09-30', '', 'dispatch', '2024-09-30 08:53:42');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (3, '', '', '', '', 'Income tex', '2024-10-10', '', 'receive', '2024-11-06 06:34:00');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (4, '', 'Document in hospital', '', '', '', '2024-10-10', '', 'dispatch', '2024-10-10 12:01:39');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (5, '567567', 'Hospital Report', '', '', 'Hospital Report', '2024-10-29', '', 'receive', '2024-10-29 04:40:16');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (6, '32432', 'Hospital Report', '', '', 'Hospital Report', '2024-10-29', '', 'dispatch', '2024-10-29 04:40:46');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (7, '56777', '', '', '', 'GST BILL', '2024-11-06', '', 'receive', '2024-11-06 06:33:36');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (8, '2454556', 'Patient document', '', '', '', '2024-11-06', '', 'dispatch', '2024-11-06 06:34:38');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (14, 'TEST', 'TEST', 'TEST', 'TEST', 'TEST', '2024-11-27', '1732686197-6192867756746b175d801f!test.jpg', 'dispatch', '2024-11-27 05:43:17');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (17, '', '', 'add', '', 'document', '2024-12-04', '1733298712-142925382567500a1856c54!Screenshot 2024-11-08 204618 (1).png', 'receive', '2025-03-01 11:39:29');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (18, '', 'document test', '', 'fghghh', '', '2024-12-04', '1733298854-61263809867500aa6649ed!Screenshot 2024-11-08 204618 (1).png', 'dispatch', '2024-12-04 07:54:42');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (20, '', 'adding', '', '', '', '2025-03-01', '', 'dispatch', '2025-03-01 11:40:55');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (25, '', '', '', '', 'RECEIVE', '2025-04-16', '1744789834-93486001867ff614a9ba60!Your-Hospital-Name-04-16-2025_01_15_PM.png', 'receive', '2025-04-16 07:50:34');
INSERT INTO `dispatch_receive` (`id`, `reference_no`, `to_title`, `address`, `note`, `from_title`, `date`, `image`, `type`, `created_at`) VALUES (26, '', 'DIDPATCH', '', '', '', '2025-04-16', '1744790211-76906100467ff62c363e47!Screenshot 2024-11-08 204618 (1) (3).png', 'dispatch', '2025-04-16 07:56:51');


#
# TABLE STRUCTURE FOR: doctor_absent
#

DROP TABLE IF EXISTS `doctor_absent`;

CREATE TABLE `doctor_absent` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int DEFAULT NULL,
  `date` date NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `index_date` (`date`),
  CONSTRAINT `doctor_absent_ibfk_1` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: doctor_global_shift
#

DROP TABLE IF EXISTS `doctor_global_shift`;

CREATE TABLE `doctor_global_shift` (
  `id` int NOT NULL AUTO_INCREMENT,
  `staff_id` int DEFAULT NULL,
  `global_shift_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `global_shift_id` (`global_shift_id`),
  KEY `staff_id` (`staff_id`),
  CONSTRAINT `doctor_global_shift_ibfk_1` FOREIGN KEY (`global_shift_id`) REFERENCES `global_shift` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_global_shift_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=93 DEFAULT CHARSET=utf8mb3;

INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (1, 2, 1, '2024-09-26 07:30:09');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (2, 2, 2, '2024-09-26 07:30:10');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (4, 2, 4, '2024-09-27 09:27:54');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (5, 2, 5, '2024-09-27 09:27:57');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (6, 8, 1, '2024-10-15 12:51:11');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (7, 8, 2, '2024-10-15 12:51:12');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (9, 8, 4, '2024-10-15 12:51:16');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (10, 8, 5, '2024-10-15 12:51:17');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (11, 2, 6, '2024-10-29 12:09:32');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (13, 8, 6, '2024-11-20 07:30:50');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (16, 9, 6, '2024-11-20 07:30:56');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (17, 9, 5, '2024-11-20 07:30:58');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (18, 9, 4, '2024-11-20 07:31:00');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (19, 9, 2, '2024-11-20 07:31:01');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (20, 9, 1, '2024-11-20 07:31:05');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (21, 2, 8, '2024-11-20 07:36:22');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (22, 8, 8, '2024-11-20 07:36:23');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (23, 9, 8, '2024-11-20 07:36:24');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (40, 12, 1, '2024-12-03 10:04:52');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (41, 12, 2, '2024-12-03 10:04:53');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (42, 12, 4, '2024-12-03 10:04:54');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (43, 12, 5, '2024-12-03 10:04:55');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (44, 12, 6, '2024-12-03 10:04:57');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (45, 12, 8, '2024-12-03 10:04:58');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (51, 19, 1, '2024-12-05 05:05:25');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (52, 22, 1, '2025-03-05 10:28:21');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (53, 22, 2, '2025-03-05 10:28:22');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (54, 22, 4, '2025-03-05 10:28:24');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (55, 22, 5, '2025-03-05 10:28:25');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (56, 22, 6, '2025-03-05 10:28:26');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (57, 22, 8, '2025-03-05 10:28:28');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (58, 19, 2, '2025-03-05 10:28:33');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (59, 19, 4, '2025-03-05 10:28:36');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (67, 19, 5, '2025-03-13 10:52:25');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (68, 19, 6, '2025-03-13 10:52:26');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (69, 19, 8, '2025-03-13 10:52:27');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (73, 30, 1, '2025-04-10 10:42:58');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (74, 30, 2, '2025-04-10 10:42:59');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (75, 30, 4, '2025-04-10 10:43:01');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (76, 30, 5, '2025-04-10 10:43:03');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (77, 30, 6, '2025-04-10 10:43:04');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (78, 30, 8, '2025-04-10 10:43:05');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (84, 44, 1, '2025-05-01 10:29:25');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (85, 44, 2, '2025-05-01 10:29:27');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (86, 44, 4, '2025-05-01 10:29:29');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (87, 44, 5, '2025-05-01 10:29:30');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (88, 44, 6, '2025-05-01 10:29:31');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (89, 44, 8, '2025-05-01 10:29:33');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (90, 2, 19, '2025-05-01 10:29:36');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (91, 9, 19, '2025-05-01 10:29:38');
INSERT INTO `doctor_global_shift` (`id`, `staff_id`, `global_shift_id`, `created_at`) VALUES (92, 12, 19, '2025-05-01 10:29:38');


#
# TABLE STRUCTURE FOR: doctor_shift_time
#

DROP TABLE IF EXISTS `doctor_shift_time`;

CREATE TABLE `doctor_shift_time` (
  `id` int NOT NULL AUTO_INCREMENT,
  `day` varchar(20) DEFAULT NULL,
  `staff_id` int DEFAULT NULL,
  `doctor_global_shift_id` int DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `staff_id` (`staff_id`),
  KEY `doctor_global_shift_id` (`doctor_global_shift_id`),
  KEY `index_day` (`day`),
  CONSTRAINT `doctor_shift_time_ibfk_2` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `doctor_shift_time_ibfk_3` FOREIGN KEY (`doctor_global_shift_id`) REFERENCES `doctor_global_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb3;

INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (1, 'Monday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:30:33');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (2, 'Tuesday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:30:45');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (3, 'Thursday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:30:56');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (4, 'Friday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:31:05');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (5, 'Wednesday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:31:17');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (6, 'Saturday', 2, 1, '09:30:00', '13:30:00', '2024-09-26 07:31:25');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (7, 'Monday', 8, 6, '09:30:00', '13:00:00', '2024-10-29 12:15:29');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (8, 'Thursday', 8, 6, '09:30:00', '13:30:00', '2024-12-05 05:05:50');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (9, 'Friday', 8, 6, '09:30:00', '13:30:00', '2024-12-05 05:06:02');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (10, 'Wednesday', 8, 6, '09:30:00', '13:00:00', '2025-03-12 07:51:21');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (11, 'Tuesday', 8, 6, '09:30:00', '13:00:00', '2025-03-12 07:51:36');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (12, 'Saturday', 8, 6, '09:30:00', '13:00:00', '2025-03-12 07:51:49');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (14, 'Monday', 2, 11, '18:00:00', '19:00:00', '2025-03-17 10:16:36');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (15, 'Monday', 2, 2, '15:00:00', '20:00:00', '2025-03-19 12:43:22');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (16, 'Tuesday', 2, 2, '15:00:00', '18:00:00', '2025-03-18 11:43:23');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (17, 'Wednesday', 2, 2, '15:00:00', '20:00:00', '2025-03-19 12:43:27');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (18, 'Thursday', 2, 2, '15:00:00', '18:00:00', '2025-03-18 11:43:44');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (19, 'Friday', 2, 2, '13:00:00', '20:00:00', '2025-03-21 09:10:05');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (20, 'Saturday', 2, 2, '13:00:00', '20:00:00', '2025-03-21 09:09:38');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (21, 'Sunday', 2, 2, '13:00:00', '20:00:00', '2025-03-21 09:08:59');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (22, 'Monday', 8, 7, '17:50:00', '17:51:00', '2025-04-17 12:21:03');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (23, 'Monday', 30, 73, '09:30:00', '13:30:00', '2025-05-01 04:20:37');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (24, 'Tuesday', 30, 73, '09:30:00', '13:30:00', '2025-05-01 04:20:48');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (25, 'Wednesday', 30, 73, '09:30:00', '13:30:00', '2025-05-01 04:20:56');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (26, 'Thursday', 30, 73, '09:30:00', '13:30:00', '2025-05-01 04:21:07');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (27, 'Friday', 30, 73, '09:30:00', '13:30:00', '2025-05-01 04:21:15');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (28, 'Saturday', 30, 73, '09:30:00', '13:30:00', '2025-05-01 04:21:38');
INSERT INTO `doctor_shift_time` (`id`, `day`, `staff_id`, `doctor_global_shift_id`, `start_time`, `end_time`, `created_at`) VALUES (29, 'Sunday', 30, 73, '09:30:00', '13:29:00', '2025-05-01 04:23:18');


#
# TABLE STRUCTURE FOR: dose_duration
#

DROP TABLE IF EXISTS `dose_duration`;

CREATE TABLE `dose_duration` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (2, '3 time', '2024-10-07 11:37:53');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (3, '2 times', '2024-10-10 09:04:40');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (5, '1 tym', '2024-11-12 10:01:29');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (7, 'Three tym after meel', '2024-11-19 08:55:13');
INSERT INTO `dose_duration` (`id`, `name`, `created_at`) VALUES (8, '1tym before meal', '2024-12-05 12:49:13');


#
# TABLE STRUCTURE FOR: dose_interval
#

DROP TABLE IF EXISTS `dose_interval`;

CREATE TABLE `dose_interval` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (1, '2time', '2024-09-26 12:07:36');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (2, 'morning-night', '2024-10-07 11:37:34');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (3, 'After meal', '2024-10-10 09:04:16');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (5, 'Empty stomach', '2024-11-12 10:00:06');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (6, 'after meel tym', '2024-11-19 08:04:23');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (7, 'two tym after meal', '2024-12-05 12:46:08');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (9, '2-3 tyms', '2025-04-17 11:30:55');
INSERT INTO `dose_interval` (`id`, `name`, `created_at`) VALUES (10, '3 times', '2025-05-07 07:39:04');


#
# TABLE STRUCTURE FOR: duty_roster_assign
#

DROP TABLE IF EXISTS `duty_roster_assign`;

CREATE TABLE `duty_roster_assign` (
  `id` int NOT NULL AUTO_INCREMENT,
  `code` int NOT NULL,
  `roster_duty_date` date DEFAULT NULL,
  `floor_id` int DEFAULT NULL,
  `department_id` int DEFAULT NULL,
  `staff_id` int NOT NULL,
  `duty_roster_list_id` int NOT NULL,
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `duty_roster_list_id` (`duty_roster_list_id`),
  KEY `department_id` (`department_id`),
  KEY `staff_id` (`staff_id`),
  KEY `floor_id` (`floor_id`),
  KEY `index_roster_duty_date` (`roster_duty_date`),
  CONSTRAINT `duty_roster_assign_ibfk_1` FOREIGN KEY (`duty_roster_list_id`) REFERENCES `duty_roster_list` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_2` FOREIGN KEY (`department_id`) REFERENCES `department` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_3` FOREIGN KEY (`staff_id`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `duty_roster_assign_ibfk_4` FOREIGN KEY (`floor_id`) REFERENCES `floor` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=748 DEFAULT CHARSET=utf8mb3;

INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `generated_by`, `created_at`) VALUES (732, 4, '2024-10-12', 3, NULL, 3, 5, 1, '2025-03-06 10:51:51');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `generated_by`, `created_at`) VALUES (733, 4, '2024-10-13', 3, NULL, 3, 5, 1, '2025-03-06 10:51:51');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `generated_by`, `created_at`) VALUES (734, 4, '2024-10-14', 3, NULL, 3, 5, 1, '2025-03-06 10:51:51');
INSERT INTO `duty_roster_assign` (`id`, `code`, `roster_duty_date`, `floor_id`, `department_id`, `staff_id`, `duty_roster_list_id`, `generated_by`, `created_at`) VALUES (735, 4, '2024-10-15', 3, NULL, 3, 5, 1, '2025-03-06 10:51:51');


#
# TABLE STRUCTURE FOR: duty_roster_list
#

DROP TABLE IF EXISTS `duty_roster_list`;

CREATE TABLE `duty_roster_list` (
  `id` int NOT NULL AUTO_INCREMENT,
  `duty_roster_shift_id` int NOT NULL,
  `duty_roster_start_date` date NOT NULL,
  `duty_roster_end_date` date NOT NULL,
  `duty_roster_total_day` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `duty_roster_shift_id` (`duty_roster_shift_id`),
  KEY `index_duty_roster_start_date` (`duty_roster_start_date`),
  KEY `index_duty_roster_end_date` (`duty_roster_end_date`),
  CONSTRAINT `duty_roster_list_ibfk_1` FOREIGN KEY (`duty_roster_shift_id`) REFERENCES `duty_roster_shift` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3;

INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (2, 2, '2024-09-08', '2024-09-14', 7, '2024-09-27 04:57:56');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (4, 4, '2024-10-01', '2024-10-02', 2, '2024-09-30 11:45:46');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (5, 5, '2024-10-12', '2024-10-15', 4, '2024-10-11 10:44:27');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (6, 3, '2024-10-11', '2024-10-15', 5, '2024-10-11 10:45:35');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (11, 1, '2025-03-01', '2025-03-05', 5, '2025-03-06 06:12:17');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (12, 4, '2025-02-05', '2025-02-16', 12, '2025-03-06 06:22:14');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (13, 2, '2025-03-22', '2025-03-24', 3, '2025-03-22 10:37:59');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (17, 16, '2025-04-30', '2025-05-09', 10, '2025-04-29 10:19:44');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (18, 5, '2025-05-05', '2025-05-30', 26, '2025-05-05 08:53:51');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (19, 4, '2025-05-05', '2025-05-09', 5, '2025-05-09 07:44:57');
INSERT INTO `duty_roster_list` (`id`, `duty_roster_shift_id`, `duty_roster_start_date`, `duty_roster_end_date`, `duty_roster_total_day`, `created_at`) VALUES (20, 2, '2025-05-12', '2025-05-31', 20, '2025-05-12 11:11:31');


#
# TABLE STRUCTURE FOR: duty_roster_shift
#

DROP TABLE IF EXISTS `duty_roster_shift`;

CREATE TABLE `duty_roster_shift` (
  `id` int NOT NULL AUTO_INCREMENT,
  `shift_name` varchar(255) NOT NULL,
  `shift_start` time NOT NULL,
  `shift_end` time NOT NULL,
  `shift_hour` time NOT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_shift_name` (`shift_name`),
  KEY `index_shift_start` (`shift_start`),
  KEY `index_shift_end` (`shift_end`),
  KEY `index_shift_hour` (`shift_hour`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb3;

INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (1, 'Morning ', '10:30:00', '13:30:00', '03:00:00', 1, '2024-09-27 04:56:13');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (2, 'Evening', '16:30:00', '19:00:00', '02:30:00', 1, '2024-09-27 04:56:48');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (3, 'Night ', '20:00:00', '23:30:00', '03:30:00', 1, '2024-09-27 04:57:18');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (4, 'afternoon', '12:00:00', '15:00:00', '03:00:00', 1, '2024-09-30 11:45:18');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (5, 'MORNNING', '10:00:00', '14:00:00', '04:00:00', 1, '2024-10-11 10:43:04');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (7, 'EARLY MORNING', '05:33:00', '09:33:00', '04:00:00', 1, '2024-11-14 11:04:30');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (11, 'Nurse morning', '09:30:00', '19:00:00', '09:30:00', 1, '2024-12-04 09:13:44');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (12, '//morning', '09:00:00', '18:00:00', '09:00:00', 1, '2025-03-03 08:27:27');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (15, 'shift', '15:08:00', '20:08:00', '05:00:00', 1, '2025-04-16 09:39:07');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (16, 'half day', '15:45:00', '18:45:00', '03:00:00', 1, '2025-04-29 10:15:28');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (17, 'add sift', '14:01:00', '19:01:00', '05:00:00', 1, '2025-05-05 08:31:52');
INSERT INTO `duty_roster_shift` (`id`, `shift_name`, `shift_start`, `shift_end`, `shift_hour`, `is_active`, `created_at`) VALUES (18, 'shift', '16:38:00', '20:38:00', '04:00:00', 1, '2025-05-12 11:08:31');


#
# TABLE STRUCTURE FOR: email_config
#

DROP TABLE IF EXISTS `email_config`;

CREATE TABLE `email_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `email_type` varchar(100) DEFAULT NULL,
  `smtp_server` varchar(100) DEFAULT NULL,
  `smtp_port` varchar(100) DEFAULT NULL,
  `smtp_username` varchar(100) DEFAULT NULL,
  `smtp_password` varchar(100) DEFAULT NULL,
  `ssl_tls` varchar(100) DEFAULT NULL,
  `smtp_auth` varchar(10) NOT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `email_config` (`id`, `email_type`, `smtp_server`, `smtp_port`, `smtp_username`, `smtp_password`, `ssl_tls`, `smtp_auth`, `is_active`, `created_at`) VALUES (1, 'smtp', 'smtp.gmail.com', '587', 'ascent.jbp@gmail.com', 'ascent.jbp@gmail.com', 'tls', 'true', 'yes', '2024-09-30 05:00:18');


#
# TABLE STRUCTURE FOR: events
#

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `id` int NOT NULL AUTO_INCREMENT,
  `event_title` varchar(200) NOT NULL,
  `event_description` text,
  `start_date` datetime NOT NULL,
  `end_date` datetime NOT NULL,
  `event_type` varchar(100) NOT NULL,
  `event_color` varchar(200) NOT NULL,
  `event_for` varchar(100) NOT NULL,
  `role_id` int DEFAULT NULL,
  `is_active` varchar(10) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `start_date` (`start_date`),
  KEY `index_end_date` (`end_date`),
  KEY `index_event_type` (`event_type`) USING BTREE,
  KEY `index_event_color` (`event_color`) USING BTREE,
  KEY `index_event_title` (`event_title`),
  KEY `role_id` (`role_id`),
  CONSTRAINT `events_ibfk_1` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;

INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (2, 'holiday', '', '2024-11-08 00:00:00', '2024-11-08 00:00:00', 'task', '#000', '7', 1, 'no', '2024-10-05 07:13:51');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (3, 'event', '', '2024-10-16 00:00:00', '2024-10-16 00:00:00', 'task', '#000', '7', 1, 'no', '2024-10-07 09:02:58');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (5, 'holidays', 'holidays', '2024-10-28 09:36:00', '2024-10-31 09:36:00', 'public', '#fb8c00', '0', NULL, '', '2024-10-30 04:06:33');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (6, 'Diwali celebration', '', '2024-10-30 00:00:00', '2024-10-30 00:00:00', 'task', '#000', '1', 7, 'no', '2024-10-30 04:14:45');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (7, 'Medical camp for patient', 'Medical camp for patient', '2024-10-28 16:14:00', '2024-11-01 16:14:00', 'public', '#d81b60', '0', NULL, '', '2024-10-30 10:44:55');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (8, 'Medical Health camping', '', '2024-10-27 16:25:00', '2024-10-31 16:25:00', 'public', '#8e24aa', '0', NULL, '', '2024-10-30 10:55:29');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (9, 'diwali celebration', '', '2024-12-31 16:51:00', '2024-12-02 16:51:00', 'sameforall', '#337ab7', '7', NULL, '', '2024-11-04 11:21:25');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (10, 'Sunday is holiday', '', '2024-11-10 00:00:00', '2024-11-10 00:00:00', 'task', '#000', '1', 7, 'no', '2024-11-05 06:06:47');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (12, 'hello', '', '2025-03-10 00:00:00', '2025-03-10 00:00:00', 'task', '#000', '1', 7, 'no', '2025-03-10 07:24:18');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (13, 'testing', '', '2025-04-14 00:00:00', '2025-04-14 00:00:00', 'task', '#000', '1', 7, 'no', '2025-04-14 07:49:59');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (14, 'test', '', '2025-04-18 00:00:00', '2025-04-18 00:00:00', 'task', '#000', '81', NULL, 'no', '2025-04-18 05:54:16');
INSERT INTO `events` (`id`, `event_title`, `event_description`, `start_date`, `end_date`, `event_type`, `event_color`, `event_for`, `role_id`, `is_active`, `created_at`) VALUES (15, 'title', '', '2025-04-21 00:00:00', '2025-04-21 00:00:00', 'task', '#000', '1', 7, 'no', '2025-04-21 07:17:21');


#
# TABLE STRUCTURE FOR: expense_head
#

DROP TABLE IF EXISTS `expense_head`;

CREATE TABLE `expense_head` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exp_category` varchar(50) DEFAULT NULL,
  `description` text,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_exp_category` (`exp_category`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;

INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'tax', 'income tax', 'yes', 'no', '2024-09-28 12:52:41');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'electricity', '', 'yes', 'no', '2024-10-05 08:37:17');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'Income tex', '', 'yes', 'no', '2024-10-07 12:09:01');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 'Staff expence', '', 'yes', 'no', '2024-10-11 12:04:52');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (6, 'Othter head', '', 'yes', 'no', '2024-11-19 12:06:48');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (7, 'tex', '', 'yes', 'no', '2025-03-05 10:22:00');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (10, 'tax', '', 'yes', 'no', '2025-05-01 10:24:17');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (11, 'electricity', '', 'yes', 'no', '2025-05-01 10:24:17');
INSERT INTO `expense_head` (`id`, `exp_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (12, 'Expense Head', '', 'yes', 'no', '2025-05-07 08:41:14');


#
# TABLE STRUCTURE FOR: expenses
#

DROP TABLE IF EXISTS `expenses`;

CREATE TABLE `expenses` (
  `id` int NOT NULL AUTO_INCREMENT,
  `exp_head_id` int DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT NULL,
  `documents` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `note` text,
  `is_active` varchar(10) DEFAULT 'yes',
  `is_deleted` varchar(10) DEFAULT 'no',
  `generated_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `exp_head_id` (`exp_head_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_invoice_no` (`invoice_no`),
  KEY `index_name` (`name`),
  KEY `index_date` (`date`) USING BTREE,
  KEY `index_amount` (`amount`) USING BTREE,
  CONSTRAINT `expenses_ibfk_1` FOREIGN KEY (`exp_head_id`) REFERENCES `expense_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `expenses_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb3;

INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (2, 1, 'income tex', '', '2024-09-30', '10000.00', NULL, '', 'yes', 'no', 1, '2024-09-30 12:21:41');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (5, 2, 'Electricity bill expence', '', '2024-10-11', '3000.00', NULL, '', 'yes', 'no', 1, '2024-10-11 12:01:05');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (6, 2, 'MP power house', '6545', '2024-10-29', '150.00', NULL, '', 'yes', 'no', 1, '2024-10-29 05:54:15');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (8, 1, 'GST Tex', '566786778', '2024-11-05', '3000.00', NULL, '', 'yes', 'no', 1, '2024-11-05 06:05:29');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (9, 1, 'hos', '', '2024-11-13', '2000.00', NULL, '', 'yes', 'no', 1, '2024-11-13 10:17:29');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (10, 4, 'test', '', '2024-11-14', '4.00', NULL, '', 'yes', 'no', 1, '2024-11-14 12:46:58');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (12, 1, 'hello', '244', '2024-11-14', '2000.00', NULL, '', 'yes', 'no', 1, '2024-11-15 07:22:08');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (13, 2, 'TEST', '', '2024-11-15', '200.00', NULL, '', 'yes', 'no', 1, '2024-11-15 07:21:55');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (14, 2, 'TEST', '', '2024-11-15', '100.00', NULL, '', 'yes', 'no', 1, '2024-11-15 09:01:47');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (15, 1, 'test', '', '2024-11-15', '2345.00', NULL, '', 'yes', 'no', 1, '2024-11-15 09:20:13');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (17, 2, '56', '', '2024-11-26', '56.00', NULL, 'add', 'yes', 'no', 1, '2025-03-03 09:33:24');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (24, 1, 'expence tex', '', '2024-12-03', '3000.00', 'uploads/hospital_expense/1733227567-517786856674ef42f2df05!ki (1) (1) (1) (1).jpg', '', 'yes', 'no', 1, '2024-12-03 12:06:07');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (26, 1, 'Expense', '', '2025-03-01', '2000.00', NULL, 'add', 'yes', 'no', 1, '2025-03-01 09:03:59');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (29, 2, '4554556', '', '2025-03-22', '2000.00', NULL, '', 'yes', 'no', 1, '2025-03-22 11:16:23');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (31, 1, 'gfghhjjh', '', '2025-04-14', '200.00', NULL, '', 'yes', 'no', 1, '2025-04-14 12:22:54');
INSERT INTO `expenses` (`id`, `exp_head_id`, `name`, `invoice_no`, `date`, `amount`, `documents`, `note`, `is_active`, `is_deleted`, `generated_by`, `created_at`) VALUES (32, 1, '6ytyyrry', '', '2025-04-16', '200.00', NULL, '', 'yes', 'no', 1, '2025-04-16 10:23:49');


#
# TABLE STRUCTURE FOR: filetypes
#

DROP TABLE IF EXISTS `filetypes`;

CREATE TABLE `filetypes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `file_extension` text,
  `file_mime` text,
  `file_size` int NOT NULL,
  `image_extension` text,
  `image_mime` text,
  `image_size` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: finding
#

DROP TABLE IF EXISTS `finding`;

CREATE TABLE `finding` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL,
  `description` text,
  `finding_category_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `finding_category_id` (`finding_category_id`),
  KEY `index_name` (`name`),
  CONSTRAINT `finding_ibfk_1` FOREIGN KEY (`finding_category_id`) REFERENCES `finding_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (1, 'Elevated temperature (above 100.4°)', 'The medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 1, '2024-09-30 04:37:15');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (2, 'Eczema.', 'Eczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 2, '2024-09-30 04:37:44');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (3, 'Osteoporosis', 'Bone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 3, '2024-09-30 04:38:07');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (4, 'Damaged Hair', 'Damaged Hair	', 4, '2024-09-30 04:38:19');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (5, 'fevers', '', 1, '2025-04-17 11:57:22');
INSERT INTO `finding` (`id`, `name`, `description`, `finding_category_id`, `created_at`) VALUES (7, 'hello', 'testsett', 1, '2024-11-20 11:36:25');


#
# TABLE STRUCTURE FOR: finding_category
#

DROP TABLE IF EXISTS `finding_category`;

CREATE TABLE `finding_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category` varchar(100) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_category` (`category`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;

INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (1, 'Fever', '2024-09-30 04:36:36');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (2, 'Skin Problem', '2024-09-30 04:36:36');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (3, 'Bone Density Problems', '2024-09-30 04:36:36');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (4, 'Hair Problems', '2024-09-30 04:36:36');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (9, 'finding', '2025-04-10 10:25:52');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (10, 'add', '2025-04-17 12:07:47');
INSERT INTO `finding_category` (`id`, `category`, `created_at`) VALUES (11, 'adding category', '2025-05-07 08:33:47');


#
# TABLE STRUCTURE FOR: floor
#

DROP TABLE IF EXISTS `floor`;

CREATE TABLE `floor` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3;

INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (1, '1st floor', '', '2024-09-26 12:00:24');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (2, '2nd Floor', '', '2024-09-28 08:06:17');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (3, '3rd floor', '', '2024-10-07 10:58:22');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (4, '4th floor', '', '2024-10-09 09:46:32');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (5, '5th floor', '', '2024-10-09 09:46:46');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (6, '6th Floor', '', '2024-10-29 11:42:02');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (7, 'general bed 1st floor', '', '2024-11-05 07:53:13');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (9, '1st floor', '', '2024-11-18 08:20:59');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (10, '7th floor', '', '2024-12-05 12:03:15');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (11, 'testing', '', '2025-03-05 09:05:55');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (13, 'extra floor', '', '2025-04-17 11:08:01');
INSERT INTO `floor` (`id`, `name`, `description`, `created_at`) VALUES (14, 'Add floor', 'add', '2025-05-07 06:59:46');


#
# TABLE STRUCTURE FOR: front_cms_media_gallery
#

DROP TABLE IF EXISTS `front_cms_media_gallery`;

CREATE TABLE `front_cms_media_gallery` (
  `id` int NOT NULL AUTO_INCREMENT,
  `image` varchar(300) DEFAULT NULL,
  `thumb_path` varchar(300) DEFAULT NULL,
  `dir_path` varchar(300) DEFAULT NULL,
  `img_name` varchar(300) DEFAULT NULL,
  `thumb_name` varchar(300) DEFAULT NULL,
  `file_type` varchar(100) NOT NULL,
  `file_size` varchar(100) NOT NULL,
  `vid_url` mediumtext,
  `vid_title` varchar(250) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=94 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (48, NULL, '', '', '1730271402-12228025606721d8aa5179b!class.pdf', '1730271402-12228025606721d8aa5179b!class.pdf', 'application/pdf', '266144', NULL, '', '2024-10-30 06:56:42');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (49, NULL, '', '', '1730271402-8126238656721d8aa51cde!dfgdfg.pdf', '1730271402-8126238656721d8aa51cde!dfgdfg.pdf', 'application/pdf', '141414', NULL, '', '2024-10-30 06:56:42');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (51, NULL, '', '', '1730272120-11816887586721db782800d!1.png', '1730272120-11816887586721db782800d!1.png', 'image/png', '403610', NULL, '', '2024-10-30 07:08:40');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (52, NULL, '', '', '1730272120-2561979596721db78333e9!class.pdf', '1730272120-2561979596721db78333e9!class.pdf', 'application/pdf', '266144', NULL, '', '2024-10-30 07:08:40');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (53, NULL, '', '', '1730272120-15341460156721db7833772!dfgdfg.pdf', '1730272120-15341460156721db7833772!dfgdfg.pdf', 'application/pdf', '141414', NULL, '', '2024-10-30 07:08:40');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (54, NULL, '', '', '1730272120-16704489186721db7833b67!download.jpg', '1730272120-16704489186721db7833b67!download.jpg', 'image/jpeg', '10875', NULL, '', '2024-10-30 07:08:40');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (55, NULL, '', '', '1730272427-5403345796721dcab0b66a!1.png', '1730272427-5403345796721dcab0b66a!1.png', 'image/png', '403610', NULL, '', '2024-10-30 07:13:47');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (56, NULL, '', '', '1730272461-13780356886721dccd205d4!360_.jpg', '1730272461-13780356886721dccd205d4!360_.jpg', 'image/jpeg', '34578', NULL, '', '2024-10-30 07:14:21');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (57, NULL, '', '', '1730272494-19852650566721dceeea622!Aabhusan_IES10437-6 (1).pdf', '1730272494-19852650566721dceeea622!Aabhusan_IES10437-6 (1).pdf', 'application/pdf', '153107', NULL, '', '2024-10-30 07:14:54');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (58, NULL, '', '', '1730272534-9235770486721dd16bd39f!dfgdfg.pdf', '1730272534-9235770486721dd16bd39f!dfgdfg.pdf', 'application/pdf', '141414', NULL, '', '2024-10-30 07:15:34');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (59, NULL, '', '', '1730272534-1739368466721dd16bd782!ttttttt.pdf', '1730272534-1739368466721dd16bd782!ttttttt.pdf', 'application/pdf', '33814', NULL, '', '2024-10-30 07:15:34');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (66, NULL, '', '', '1730288220-64159360767221a5cb99fa!images (1).jpg', '1730288220-64159360767221a5cb99fa!images (1).jpg', 'image/jpeg', '6202', NULL, '', '2024-10-30 11:37:00');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (67, NULL, '', '', '1730786050-19439240946729b30247693!images (1).jpg', '1730786050-19439240946729b30247693!images (1).jpg', 'image/jpeg', '6202', NULL, '', '2024-11-05 05:54:10');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (68, NULL, '', '', '1730786055-4390150006729b3079c41d!images.jpg', '1730786055-4390150006729b3079c41d!images.jpg', 'image/jpeg', '7160', NULL, '', '2024-11-05 05:54:15');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (69, NULL, '', '', '1730786067-14991449666729b3134fb40!geography of India.jpg', '1730786067-14991449666729b3134fb40!geography of India.jpg', 'image/jpeg', '74043', NULL, '', '2024-11-05 05:54:27');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (70, NULL, 'uploads/gallery/youtube_video/thumb/', 'uploads/gallery/youtube_video/', '6729b34499c2e.jpg', '6729b34499c2e.jpg', 'video', '0', 'https://www.youtube.com/watch?v=at19OmH2Bg4&list=PLu0W_9lII9aikXkRE0WxDt1vozo3hnmtR', 'Installing XAMPP, VS Code + Environment Setup | PHP Tutorial #1', '2024-11-05 05:55:16');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (71, NULL, '', '', '1731665770-195005885667371f6a43fad!download.jpg', '1731665770-195005885667371f6a43fad!download.jpg', 'image/jpeg', '10875', NULL, '', '2024-11-15 10:16:10');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (72, NULL, 'uploads/gallery/youtube_video/thumb/', 'uploads/gallery/youtube_video/', '673741b5a8922.jpg', '673741b5a8922.jpg', 'video', '0', 'https://youtu.be/tZ5Jc8ZRjR0?si=FgjvWhHOT4kiNctq', 'Efficient Inventory Management: Enhancing Safety & Savings in Healthcare', '2024-11-15 12:42:29');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (73, NULL, '', '', '1732703856-8474949426746f67085398!duty roster (1).docx', '1732703856-8474949426746f67085398!duty roster (1).docx', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', '145441', NULL, '', '2024-11-27 10:37:36');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (74, NULL, '', '', '1732770020-13109750556747f8e4d4e4f!tset (7).png', '1732770020-13109750556747f8e4d4e4f!tset (7).png', 'image/png', '307188', NULL, '', '2024-11-28 05:00:20');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (75, NULL, '', '', '1732770072-8820217076747f918b5f72!K (5).png', '1732770072-8820217076747f918b5f72!K (5).png', 'image/png', '66205', NULL, '', '2024-11-28 05:01:12');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (77, NULL, '', '', '1732771342-7046558506747fe0ea4c23!K (6) (1).png', '1732771342-7046558506747fe0ea4c23!K (6) (1).png', 'image/png', '66205', NULL, '', '2024-11-28 05:22:22');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (78, NULL, '', '', '1732772042-434516648674800cac361c!test.jpg', '1732772042-434516648674800cac361c!test.jpg', 'image/jpeg', '466145', NULL, '', '2024-11-28 05:34:02');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (79, NULL, '', '', '1732772341-971485270674801f510d31!K (6) (1).png', '1732772341-971485270674801f510d31!K (6) (1).png', 'image/png', '66205', NULL, '', '2024-11-28 05:39:01');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (80, NULL, 'uploads/gallery/youtube_video/thumb/', 'uploads/gallery/youtube_video/', '674802670b6ca.jpg', '674802670b6ca.jpg', 'video', '0', 'https://www.youtube.com/watch?v=6EukZDFE_Zg', 'PHP Full Course | PHP Tutorial For Beginners | PHP Tutorial | PHP Course | PHP | Simplilearn', '2024-11-28 05:40:55');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (81, NULL, '', '', '1732951791-954593105674abeefd60ee!16 (1).png', '1732951791-954593105674abeefd60ee!16 (1).png', 'image/png', '66205', NULL, '', '2024-11-30 07:29:51');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (82, NULL, '', '', '1732951866-446953065674abf3a13886!visitor-new (1).jpg', '1732951866-446953065674abf3a13886!visitor-new (1).jpg', 'image/jpeg', '49027', NULL, '', '2024-11-30 07:31:06');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (83, NULL, '', '', '1732951866-2173907674abf3a160a8!16 (1).png', '1732951866-2173907674abf3a160a8!16 (1).png', 'image/png', '66205', NULL, '', '2024-11-30 07:31:06');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (84, NULL, '', '', '1732951866-1058999505674abf3a22789!images (3).jpg', '1732951866-1058999505674abf3a22789!images (3).jpg', 'image/jpeg', '7509', NULL, '', '2024-11-30 07:31:06');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (85, NULL, '', '', '1732951866-1324331623674abf3a23661!ki.jpg', '1732951866-1324331623674abf3a23661!ki.jpg', 'image/jpeg', '18052', NULL, '', '2024-11-30 07:31:06');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (86, NULL, '', '', '1732951866-652121941674abf3a2455a!1 (3).png', '1732951866-652121941674abf3a2455a!1 (3).png', 'image/png', '5783', NULL, '', '2024-11-30 07:31:06');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (87, NULL, '', '', '1732951866-1496466323674abf3a26205!course_thumbnail52.png', '1732951866-1496466323674abf3a26205!course_thumbnail52.png', 'image/png', '80218', NULL, '', '2024-11-30 07:31:06');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (88, NULL, '', '', '1732951866-1786407068674abf3a2810a!tset (2) (2).png', '1732951866-1786407068674abf3a2810a!tset (2) (2).png', 'image/png', '307188', NULL, '', '2024-11-30 07:31:06');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (89, NULL, '', '', '1733481087-5209199696752d27f7c326!tset (3) (1) (2).png', '1733481087-5209199696752d27f7c326!tset (3) (1) (2).png', 'image/png', '307188', NULL, '', '2024-12-06 10:31:27');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (90, NULL, '', '', '1733486342-19366142176752e706d7012!visitor-new (4).jpg', '1733486342-19366142176752e706d7012!visitor-new (4).jpg', 'image/jpeg', '49027', NULL, '', '2024-12-06 11:59:02');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (91, NULL, '', '', '1741004550-196692368967c59f0684e4c!Your-Hospital-Name-03-01-2025_02_11_PM.png', '1741004550-196692368967c59f0684e4c!Your-Hospital-Name-03-01-2025_02_11_PM.png', 'image/png', '120826', NULL, '', '2025-03-03 12:22:30');
INSERT INTO `front_cms_media_gallery` (`id`, `image`, `thumb_path`, `dir_path`, `img_name`, `thumb_name`, `file_type`, `file_size`, `vid_url`, `vid_title`, `created_at`) VALUES (93, NULL, '', '', '1744893881-10802985816800f7b90ae64!ki (1) (1) (1) (1) (1) (3).jpg', '1744893881-10802985816800f7b90ae64!ki (1) (1) (1) (1) (1) (3).jpg', 'image/jpeg', '18052', NULL, '', '2025-04-17 12:44:41');


#
# TABLE STRUCTURE FOR: front_cms_menu_items
#

DROP TABLE IF EXISTS `front_cms_menu_items`;

CREATE TABLE `front_cms_menu_items` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menu_id` int DEFAULT NULL,
  `menu` varchar(100) DEFAULT NULL,
  `page_id` int NOT NULL,
  `parent_id` int NOT NULL,
  `ext_url` mediumtext,
  `open_new_tab` int DEFAULT '0',
  `ext_url_link` mediumtext,
  `slug` varchar(200) DEFAULT NULL,
  `weight` int DEFAULT NULL,
  `publish` int NOT NULL DEFAULT '0',
  `description` mediumtext,
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (1, 2, 'Home', 1, 0, NULL, NULL, NULL, 'home-1', NULL, 0, NULL, 'no', '2018-07-14 03:14:12');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (2, 1, 'Appointment', 0, 0, '1', NULL, 'https://dev1.webfeb.com/shqratfa/form/appointment', 'appointment', 2, 0, NULL, 'no', '2024-09-26 05:35:36');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (3, 1, 'Home', 1, 0, NULL, NULL, NULL, 'home', NULL, 0, NULL, 'no', '2019-01-24 03:18:17');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (4, 2, 'Appointment', 0, 0, '1', NULL, 'http://yourdomainname.com/form/appointment', 'appointment-1', NULL, 0, NULL, 'no', '2019-11-02 10:54:41');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (5, 1, 'Annual Calendar', 0, 0, '1', NULL, 'https://dev1.webfeb.com/shqratfa/page/annual_calendar', 'annual-calendar', NULL, 0, NULL, 'no', '2024-09-30 12:04:11');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (6, 1, 'messeges', 1, 0, NULL, NULL, NULL, 'messeges', NULL, 0, NULL, 'no', '2024-10-14 09:11:04');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (7, 1, 'gallery new', 0, 0, NULL, NULL, NULL, 'gallery-new', NULL, 0, NULL, 'no', '2024-10-30 06:15:18');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (8, 7, 'menu2', 0, 0, NULL, NULL, NULL, 'menu2', NULL, 0, NULL, 'no', '2024-11-27 10:38:14');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (10, 10, 'menu', 2, 0, '1', 1, 'url', 'menu-1', NULL, 0, NULL, 'no', '2025-03-24 07:45:55');
INSERT INTO `front_cms_menu_items` (`id`, `menu_id`, `menu`, `page_id`, `parent_id`, `ext_url`, `open_new_tab`, `ext_url_link`, `slug`, `weight`, `publish`, `description`, `is_active`, `created_at`) VALUES (11, 9, 'addd', 1, 0, '1', NULL, 'url', 'addd', NULL, 0, NULL, 'no', '2025-04-17 12:45:57');


#
# TABLE STRUCTURE FOR: front_cms_menus
#

DROP TABLE IF EXISTS `front_cms_menus`;

CREATE TABLE `front_cms_menus` (
  `id` int NOT NULL AUTO_INCREMENT,
  `menu` varchar(100) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `description` mediumtext,
  `open_new_tab` int NOT NULL DEFAULT '0',
  `ext_url` mediumtext,
  `ext_url_link` mediumtext,
  `publish` int NOT NULL DEFAULT '0',
  `content_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (1, 'Main Menu', 'main-menu', 'Main menu', 0, '', '', 0, 'default', 'no', '2018-04-20 03:54:49');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (2, 'Bottom Menu', 'bottom-menu', 'Bottom Menu', 0, '', '', 0, 'default', 'no', '2018-04-20 03:54:55');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (4, 'SIDE MENU', 'side-menu', '', 0, NULL, NULL, 0, 'manual', 'no', '2024-10-01 09:31:38');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (5, 'Side menu2', 'side-menu2', '', 0, NULL, NULL, 0, 'manual', 'no', '2024-10-14 09:09:44');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (8, 'menu2', 'menu2', '', 0, NULL, NULL, 0, 'manual', 'no', '2024-11-27 10:38:44');
INSERT INTO `front_cms_menus` (`id`, `menu`, `slug`, `description`, `open_new_tab`, `ext_url`, `ext_url_link`, `publish`, `content_type`, `is_active`, `created_at`) VALUES (9, 'TESTING', 'testing', '', 0, NULL, NULL, 0, 'manual', 'no', '2025-03-03 12:23:14');


#
# TABLE STRUCTURE FOR: front_cms_page_contents
#

DROP TABLE IF EXISTS `front_cms_page_contents`;

CREATE TABLE `front_cms_page_contents` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_id` int DEFAULT NULL,
  `content_type` varchar(50) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `front_cms_page_contents_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `front_cms_pages` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: front_cms_pages
#

DROP TABLE IF EXISTS `front_cms_pages`;

CREATE TABLE `front_cms_pages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `page_type` varchar(10) NOT NULL DEFAULT 'manual',
  `is_homepage` int DEFAULT '0',
  `title` varchar(250) DEFAULT NULL,
  `url` varchar(250) DEFAULT NULL,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(200) DEFAULT NULL,
  `meta_title` mediumtext,
  `meta_description` mediumtext,
  `meta_keyword` mediumtext,
  `feature_image` varchar(200) NOT NULL,
  `description` longtext,
  `publish_date` date DEFAULT NULL,
  `publish` int DEFAULT '0',
  `sidebar` int DEFAULT '0',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (1, 'default', 1, 'Home page first new', 'page/home-page-first-new', 'page', 'home-page-first-new', '', '', '', '', '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/kbvHM2S2_bk?rel=0\" width=\"420\"></iframe><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/4kFg2EqEIv8?rel=0\" width=\"420\"></iframe>Home page firstghfrf</p>', '0000-00-00', 1, 1, 'no', '2024-10-05 09:49:18');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (2, 'default', 0, 'Complain', 'page/complain', 'page', 'complain', 'Complain form', '                                                                                                                                                                                    complain form                                                                                                                                                                                                                                ', 'complain form', '', '<div class=\"col-md-12 col-sm-12\">\r\n<h2 class=\"text-center\">&nbsp;</h2>\r\n\r\n<p class=\"text-center\">[form-builder:complain]</p>\r\n</div>', '0000-00-00', 1, 1, 'no', '2019-01-24 03:00:12');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (3, 'default', 0, '404 page', 'page/404-page', 'page', '404-page', '', '                                ', '', '', '<title></title>\r\n<p>404 page found</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 11:35:15');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (4, 'default', 0, 'Contact us', 'page/contact-us', 'page', 'contact-us', '', '', '', '', '<p>[form-builder:contact_us]</p>', '0000-00-00', 0, NULL, 'no', '2021-09-24 06:27:54');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (6, 'manual', 0, 'complain', 'page/complain-1', 'page', 'complain-1', '', '', '', '', '<iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/4kFg2EqEIv8?rel=0\" width=\"420\"></iframe><img src=\"https://dev1.webfeb.com/shphp8ga/uploads/gallery/media/free-medical-camp-design-template-b6101353f0605b9179200e35e650d2e5_screen.jpg\" />', NULL, 0, 1, 'no', '2024-10-01 09:20:45');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (9, 'manual', 0, 'page', 'page/page', 'page', 'page', '', '', '', '', '<iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/6EukZDFE_Zg?rel=0\" width=\"420\"></iframe>', NULL, 0, 1, 'no', '2025-04-08 11:59:26');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (10, 'manual', 0, 'Events', 'page/events', 'page', 'events', '', '', '', '', 'Events', NULL, 0, NULL, 'no', '2025-04-26 06:01:44');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (11, 'manual', 0, 'News', 'page/news', 'page', 'news', '', '', '', 'https://dev1.webfeb.com/shqratfa/1746079223-19784063368130df70c6e5!images.jpeg', 'News', NULL, 0, NULL, 'no', '2025-05-01 06:00:43');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (12, 'manual', 0, 'title', 'page/title', 'page', 'title', '', '', '', '', 'format<iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/6EukZDFE_Zg?rel=0\" width=\"420\"></iframe>', NULL, 0, NULL, 'no', '2025-04-29 12:17:21');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (13, 'manual', 0, 'TITLE PAGE', 'page/title-page', 'page', 'title-page', '', '', '', '', 'ADD', NULL, 0, NULL, 'no', '2025-05-05 12:19:23');
INSERT INTO `front_cms_pages` (`id`, `page_type`, `is_homepage`, `title`, `url`, `type`, `slug`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `description`, `publish_date`, `publish`, `sidebar`, `is_active`, `created_at`) VALUES (14, 'manual', 0, 'PAGE', 'page/page-1', 'page', 'page-1', '', '', '', '', '<img src=\"https://dev1.webfeb.com/shqratfa/1746447759-11951884286818ad8f86880!ki (1) (1) (1) (1) (1).jpg\" />', NULL, 0, NULL, 'no', '2025-05-05 12:23:05');


#
# TABLE STRUCTURE FOR: front_cms_program_photos
#

DROP TABLE IF EXISTS `front_cms_program_photos`;

CREATE TABLE `front_cms_program_photos` (
  `id` int NOT NULL AUTO_INCREMENT,
  `program_id` int DEFAULT NULL,
  `media_gallery_id` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `program_id` (`program_id`),
  CONSTRAINT `front_cms_program_photos_ibfk_1` FOREIGN KEY (`program_id`) REFERENCES `front_cms_programs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (1, 6, 1, '2024-10-14 09:04:13');
INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (3, 8, 64, '2024-10-30 07:41:04');
INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (4, 8, 62, '2024-10-30 07:47:03');
INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (15, 8, 92, '2025-03-24 07:49:40');
INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (16, 23, 80, '2025-04-17 12:44:11');
INSERT INTO `front_cms_program_photos` (`id`, `program_id`, `media_gallery_id`, `created_at`) VALUES (17, 8, 93, '2025-04-17 12:46:50');


#
# TABLE STRUCTURE FOR: front_cms_programs
#

DROP TABLE IF EXISTS `front_cms_programs`;

CREATE TABLE `front_cms_programs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(50) DEFAULT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `url` mediumtext,
  `title` varchar(200) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `event_start` date DEFAULT NULL,
  `event_end` date DEFAULT NULL,
  `event_venue` mediumtext,
  `description` mediumtext,
  `is_active` varchar(10) DEFAULT 'no',
  `meta_title` mediumtext,
  `meta_description` mediumtext,
  `meta_keyword` mediumtext,
  `feature_image` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `publish_date` date DEFAULT NULL,
  `publish` varchar(10) NOT NULL DEFAULT '0',
  `sidebar` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (1, 'events', 'camp', 'read/camp', 'camp', NULL, '2024-10-01', '2024-10-01', 'hospital', '<p>hospital camp</p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-01 09:26:43');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (2, 'events', 'event', 'read/event', 'EVENT', NULL, '2024-10-05', '2024-10-05', 'HOSPITAL', '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/4kFg2EqEIv8?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-05 09:53:51');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (3, 'gallery', 'gallery-image', 'read/gallery-image', 'GALLERY IMAGE', NULL, NULL, NULL, NULL, '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/kbvHM2S2_bk?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-05 09:55:25');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (4, 'notice', 'news', 'read/news', 'NEWS', '2024-10-05', NULL, NULL, NULL, '<p>NEWS</p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-05 09:56:31');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (5, 'events', 'hospital-camp', 'read/hospital-camp', 'Hospital camp', NULL, '2024-10-14', '2024-10-14', 'hospital', '<p><span style=\"font-size: 13px;\">Hospital camp</span><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/kbvHM2S2_bk?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-14 09:01:57');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (6, 'gallery', 'hospital-image', 'read/hospital-image', 'HOSPITAL IMAGE', NULL, NULL, NULL, NULL, '<p><span xss=\"removed\">HOSPITAL IMAGE</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-14 09:04:13');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (7, 'notice', 'hospital-news', 'read/hospital-news', 'HOSPITAL NEWS', '2024-10-14', NULL, NULL, NULL, '<p><span xss=removed>HOSPITAL NEWS</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2024-10-14 09:05:06');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (8, 'banner', NULL, NULL, 'Banner Images', NULL, NULL, NULL, NULL, NULL, 'no', NULL, NULL, NULL, NULL, NULL, '0', 0, '2024-10-30 07:15:56');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (11, 'events', 'title-test', 'read/title-test', 'Title test', NULL, '2024-11-28', '2024-11-28', 'test Venue', '<p>test tes test test test<img src=\"https://dev1.webfeb.com/shqratfa/1732770072-8820217076747f918b5f72!K (5).png\" /></p>', 'no', '', '', '', 'https://dev1.webfeb.com/shqratfa/1732770020-13109750556747f8e4d4e4f!tset (7).png', NULL, '0', NULL, '2024-11-28 05:02:14');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (13, 'notice', 'test-test-test1111111111', 'read/test-test-test1111111111', 'test test test1111111111', '2024-11-28', NULL, NULL, NULL, '<p><img src=\"https://dev1.webfeb.com/shqratfa/1732771342-7046558506747fe0ea4c23!K (6) (1).png\"></p>', 'no', '', '', '', 'https://dev1.webfeb.com/shqratfa/1732770300-9583677096747f9fcdbfa4!tset (4) (1).png', NULL, '0', NULL, '2024-11-28 05:27:27');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (15, 'gallery', 'testing-1', 'read/testing-1', 'TESTING', NULL, NULL, NULL, NULL, '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/6EukZDFE_Zg?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-03-03 12:20:30');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (16, 'notice', 'testing-2', 'read/testing-2', 'TESTING', '2025-03-03', NULL, NULL, NULL, '<p><img src=\"https://dev1.webfeb.com/shqratfa/1733486342-19366142176752e706d7012!visitor-new (4).jpg\"></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-03-03 12:21:38');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (17, 'events', 'event-list', 'read/event-list', 'event list', NULL, '2025-03-24', '2025-03-24', 'venue', '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/6EukZDFE_Zg?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', 1, '2025-03-24 07:34:54');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (18, 'gallery', 'gallery', 'read/gallery', 'gallery', NULL, NULL, NULL, NULL, '<p><img src=\"https://dev1.webfeb.com/shqratfa/1732951791-954593105674abeefd60ee!16 (1).png\"></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-03-24 07:38:39');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (19, 'notice', 'eye-check-up-camp', 'page/', 'Eye Check-up Camp', '2025-05-01', NULL, NULL, NULL, '<p>The objective of this camp was to spread awareness on eye disorders, early detection of ailments, and to detect refractive errors and provide corrective glasses free of cost to the underprivileged communities. yes</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-05-01 06:15:10');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (20, 'events', 'evant', 'read/evant', 'evant', NULL, '2025-04-08', '2025-04-08', 'venue', '<p>adding</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-08 12:02:48');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (21, 'gallery', 'adding', 'read/adding', 'adding', NULL, NULL, NULL, NULL, '<p>adding<iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/tZ5Jc8ZRjR0?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-08 12:03:47');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (22, 'events', 'event-1', 'read/event-1', 'event', NULL, '2025-04-17', '2025-04-17', 'hospital', '<p><iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/6EukZDFE_Zg?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', 1, '2025-04-17 12:42:23');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (23, 'gallery', 'title', 'read/title', 'title', NULL, NULL, NULL, NULL, '<p><img src=\"https://dev1.webfeb.com/shqratfa/1732951866-1324331623674abf3a23661!ki.jpg\"></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-17 12:44:11');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (24, 'events', 'heart-disease-awareness-campaign', 'read/heart-disease-awareness-campaign', 'Heart Disease Awareness campaign', NULL, '2025-04-01', '2025-04-03', 'Hospital Hall Room', '<p><span style=\"font-family: \"Open Sans\", Helvetica, Arial, sans-serif; font-size: 14px;\">A national health education program that raises awareness about heart disease and encourages people to live a heart-healthy lifestyle</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-26 05:59:16');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (25, 'events', 'control-diabetes-for-a-healthy-heart-camp', 'read/control-diabetes-for-a-healthy-heart-camp', 'Control diabetes for a healthy heart Camp', NULL, '2025-04-07', '2025-04-10', ' heart Camp', '<p><span font-size:=\"\" open=\"\" style=\"font-family: \">Diabetes has reached an epidemic level worldwide. Type 2 diabetes is marked by high levels of blood sugar. Over time, high blood sugar damages small blood vessels throughout the body. This is called microvascular disease.&nbsp;</span></p>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</p>\r\n\r\n<p>&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;<iframe allowfullscreen=\"\" frameborder=\"0\" height=\"315\" id=\"video\" src=\"//www.youtube.com/embed/lfaGF8HxoQ0?rel=0\" width=\"420\"></iframe></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-05-07 07:33:30');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (26, 'events', 'eye-donation-day-celebration', 'read/eye-donation-day-celebration', 'Eye Donation Day Celebration', NULL, '2025-04-16', '2025-04-18', 'Hall Room', '<p><span style=\"font-family: \"Open Sans\", Helvetica, Arial, sans-serif; font-size: 14px;\">The joyously celebrated Eye Donation Day with a meaningful and engaging event dedicated to raising awareness about the importance of eye donation.&nbsp;</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-26 06:07:54');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (27, 'events', 'healthcare-diagnostics-summit-campaign', 'read/healthcare-diagnostics-summit-campaign', 'Healthcare Diagnostics Summit campaign', NULL, '2025-04-20', '2025-04-22', 'Summit campaign', '<p><span font-size:=\"\" open=\"\" style=\"font-family: \">Diagnostics Summit is poised to be an unparalleled event centered on the theme \"Diagnosing Tomorrow: Advancing Healthcare Through Innovation.\"</span></p>', 'no', '', '', '', 'https://dev1.webfeb.com/shqratfa/1745649100-1285150182680c7dcc74341!images (6).jpg', NULL, '0', NULL, '2025-04-26 06:31:55');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (28, 'events', 'free-bls-cpr-training-camp', 'read/free-bls-cpr-training-camp', 'FREE BLS & CPR TRAINING CAMP', NULL, '2025-04-22', '2025-04-24', 'TRAINING CAM', '<p><span style=\"font-family: \"Open Sans\", Helvetica, Arial, sans-serif; font-size: 14px;\">Free of cost Life saving training of Basic Life Support (BLS) and CPR was given to more than 200 people from the general public</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-26 06:13:18');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (29, 'notice', 'training-cam', 'read/training-cam', 'TRAINING CAM', '2025-04-26', NULL, NULL, NULL, '<p><span xss=removed>Free of cost Life saving training of Basic Life Support (BLS) and CPR was given to more than 200 people from the general public</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-26 06:14:30');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (30, 'notice', 'healthcare-diagnostics-summit-campaign-1', 'page/', 'Healthcare Diagnostics Summit campaign', NULL, NULL, NULL, NULL, '<p>Diagnostics Summit is poised to be an unparalleled event centered on the theme \"Diagnosing Tomorrow: Advancing Healthcare Through Innovation.\"</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-29 12:18:23');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (32, 'notice', 'bypass-surgery-for-coronary-artery-disease', 'read/bypass-surgery-for-coronary-artery-disease', 'Bypass surgery for Coronary Artery Disease', '2025-04-29', NULL, NULL, NULL, '<p><span xss=removed>Hospitals’ services have benefitted all sections of society from the young to the elderly.</span></p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-29 09:50:56');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (33, 'notice', 'world-health-day-seminar', 'page/', 'World Health Day seminar', '2025-04-29', NULL, NULL, NULL, '<p>World Health Day is a global health awareness day celebrated every year on 7 April,​</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-29 12:23:07');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (34, 'events', 'control-diabetes-for-a-healthy-heart-camp-1', 'read/control-diabetes-for-a-healthy-heart-camp-1', 'Control diabetes for a healthy heart Camp', NULL, '2025-04-25', '2025-04-28', 'Hospital  hall Room', '<p>Control diabetes for a healthy heart Camp</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-29 12:28:03');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (35, 'events', 'free-bls-cpr-training-camp-1', 'read/free-bls-cpr-training-camp-1', 'FREE BLS & CPR TRAINING CAMP', NULL, '2025-04-27', '2025-04-29', 'Hospital Campus', '<p>FREE BLS & CPR TRAINING CAMP</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-29 12:28:47');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (36, 'events', 'cath-lab-and-physiology-lab', 'read/cath-lab-and-physiology-lab', 'Cath lab and physiology lab', NULL, '2025-04-28', '2025-04-29', 'Lab Room', '<p>A cath lab, or cardiac catheterization laboratory, is a specialized hospital area where a range of cardiac procedures and tests are performed.</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-29 12:29:27');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (37, 'events', 'eye-donation-day-celebration-1', 'read/eye-donation-day-celebration-1', 'Eye Donation Day Celebration', NULL, '2025-04-23', '2025-04-29', 'Hall Room', '<p>Eye Donation Day Celebration</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-29 12:30:23');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (39, 'events', 'test', 'read/test', 'test', NULL, '2025-04-30', '2025-05-10', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-30 12:13:49');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (40, 'events', 'test-1', 'read/test-1', 'test', NULL, '2025-04-30', '2025-04-30', '', '<p>s</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-30 12:13:59');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (41, 'events', 'test-2', 'read/test-2', 'test', NULL, '2025-04-30', '2025-04-30', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-30 12:14:06');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (42, 'events', 'test-3', 'read/test-3', 'test', NULL, '2025-04-30', '2025-04-30', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-30 12:14:14');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (43, 'events', 'test-4', 'read/test-4', 'test', NULL, '2025-04-30', '2025-04-30', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-30 12:14:20');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (44, 'events', 'test-5', 'read/test-5', 'test', NULL, '2025-04-30', '2025-04-30', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-30 12:14:25');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (45, 'events', 'test-6', 'read/test-6', 'test', NULL, '2025-04-30', '2025-04-30', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-30 12:14:31');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (46, 'events', 'test-7', 'read/test-7', 'test', NULL, '2025-04-30', '2025-04-30', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-04-30 12:15:04');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (47, 'events', 'yrdy', 'read/yrdy', 'yrdy', NULL, '2025-05-01', '2025-05-01', '', '<p>ry</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-05-01 06:35:24');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (48, 'events', 'test-8', 'read/test-8', 'test', NULL, '2025-05-01', '2025-05-01', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-05-01 06:35:29');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (49, 'events', 'test-9', 'read/test-9', 'test', NULL, '2025-05-01', '2025-05-01', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-05-01 06:35:32');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (50, 'events', 'test-10', 'read/test-10', 'test', NULL, '2025-05-01', '2025-05-01', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-05-01 06:35:36');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (51, 'events', 'test-11', 'read/test-11', 'test', NULL, '2025-05-01', '2025-05-01', '', '<p>test</p>', 'no', '', '', '', '', NULL, '0', NULL, '2025-05-01 06:35:41');
INSERT INTO `front_cms_programs` (`id`, `type`, `slug`, `url`, `title`, `date`, `event_start`, `event_end`, `event_venue`, `description`, `is_active`, `meta_title`, `meta_description`, `meta_keyword`, `feature_image`, `publish_date`, `publish`, `sidebar`, `created_at`) VALUES (52, 'notice', 'happy-news', 'read/happy-news', 'happy news', '2025-05-13', NULL, NULL, NULL, '<p>news</p>', 'no', '', '', '', 'https://dev1.webfeb.com/shqratfa/1747111468-5776609486822ce2c4c585!(4) (5).jpg', NULL, '0', NULL, '2025-05-13 09:33:43');


#
# TABLE STRUCTURE FOR: front_cms_settings
#

DROP TABLE IF EXISTS `front_cms_settings`;

CREATE TABLE `front_cms_settings` (
  `id` int NOT NULL AUTO_INCREMENT,
  `theme` varchar(50) DEFAULT NULL,
  `is_active_rtl` int DEFAULT '0',
  `is_active_front_cms` int DEFAULT '0',
  `is_active_online_appointment` int DEFAULT NULL,
  `is_active_sidebar` int DEFAULT '0',
  `logo` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `contact_us_email` varchar(100) DEFAULT NULL,
  `complain_form_email` varchar(100) DEFAULT NULL,
  `sidebar_options` mediumtext,
  `fb_url` varchar(200) NOT NULL,
  `twitter_url` varchar(200) NOT NULL,
  `youtube_url` varchar(200) NOT NULL,
  `google_plus` varchar(200) NOT NULL,
  `instagram_url` varchar(200) NOT NULL,
  `pinterest_url` varchar(200) NOT NULL,
  `linkedin_url` varchar(200) NOT NULL,
  `google_analytics` mediumtext,
  `footer_text` varchar(500) DEFAULT NULL,
  `fav_icon` varchar(250) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `front_cms_settings` (`id`, `theme`, `is_active_rtl`, `is_active_front_cms`, `is_active_online_appointment`, `is_active_sidebar`, `logo`, `contact_us_email`, `complain_form_email`, `sidebar_options`, `fb_url`, `twitter_url`, `youtube_url`, `google_plus`, `instagram_url`, `pinterest_url`, `linkedin_url`, `google_analytics`, `footer_text`, `fav_icon`, `created_at`) VALUES (1, 'material_pink', NULL, 1, 1, NULL, '', '', '', '[\"news\",\"complain\"]', '', '', '', '', '', '', '', '', '', '', '2024-12-07 10:55:17');


#
# TABLE STRUCTURE FOR: gateway_ins
#

DROP TABLE IF EXISTS `gateway_ins`;

CREATE TABLE `gateway_ins` (
  `id` int NOT NULL AUTO_INCREMENT,
  `online_appointment_id` int DEFAULT NULL,
  `type` varchar(30) NOT NULL COMMENT 'patient_bill,appointment	',
  `gateway_name` varchar(50) NOT NULL,
  `module_type` varchar(255) NOT NULL,
  `unique_id` varchar(255) NOT NULL,
  `parameter_details` mediumtext NOT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_type` (`type`),
  KEY `index_gateway_name` (`gateway_name`),
  KEY `index_module_type` (`module_type`),
  KEY `index_unique_id` (`unique_id`),
  KEY `online_appointment_id` (`online_appointment_id`),
  CONSTRAINT `gateway_ins_ibfk_1` FOREIGN KEY (`online_appointment_id`) REFERENCES `appointment` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=utf8mb3;

INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (7, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741175202507', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741175202507\",\"items\":\"Patient Fees\",\"currency\":\"INR\",\"amount\":256,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-05 11:46:42');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (8, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741175282489', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741175282489\",\"items\":\"Patient Fees\",\"currency\":\"INR\",\"amount\":256,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-05 11:48:02');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (9, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741175312421', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741175312421\",\"items\":\"Patient Fees\",\"currency\":\"INR\",\"amount\":256,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-05 11:48:32');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (10, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741176113646', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741176113646\",\"items\":\"Patient Fees\",\"currency\":\"INR\",\"amount\":246,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-05 12:01:53');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (27, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741413368865', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741413368865\",\"items\":\"Patient Fees\",\"currency\":\"USD\",\"amount\":246,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-08 05:56:08');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (30, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741414908574', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741414908574\",\"items\":\"Patient Fees\",\"currency\":\"USD\",\"amount\":246,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-08 06:21:48');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (31, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741415281485', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741415281485\",\"items\":\"Patient Fees\",\"currency\":\"USD\",\"amount\":246,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-08 06:28:01');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (32, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741415321366', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741415321366\",\"items\":\"Patient Fees\",\"currency\":\"USD\",\"amount\":246,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-08 06:28:41');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (40, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741598402870', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741598402870\",\"items\":\"Patient Fees\",\"currency\":\"INR\",\"amount\":246,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-10 09:20:02');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (41, NULL, 'patient_bill', 'payhere', 'patient_bill', '1741598887976', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/onlineappointment\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741598887976\",\"items\":\"Patient Fees\",\"currency\":\"INR\",\"amount\":246,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"suresh@gmail.com\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-10 09:28:07');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (49, NULL, 'patient_bill', 'payfast', 'patient_bill', '17416991097581741699109', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"Suresh\",\"email_address\":\"test@gmail.com\",\"m_payment_id\":\"17416991097581741699109\",\"amount\":\"2530.00\",\"item_name\":\"reference_id#83\",\"signature\":\"6cc3d4f15a9e663ca68a4bc199d99440\"}', 'processing', '2025-03-11 13:18:29');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (50, NULL, 'patient_bill', 'payfast', 'patient_bill', '17417557891781741755789', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"Suresh\",\"email_address\":\"test@gmail.com\",\"m_payment_id\":\"17417557891781741755789\",\"amount\":\"2530.00\",\"item_name\":\"reference_id#83\",\"signature\":\"f066cd6231adfdf705872405d6aaeb2a\"}', 'processing', '2025-03-12 05:03:09');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (51, NULL, 'patient_bill', 'skrill', 'patient_bill', '1741757329137', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741757329137\",\"items\":\"Student Fees\",\"currency\":\"INR\",\"amount\":2310,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-12 05:28:49');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (52, NULL, 'patient_bill', 'skrill', 'patient_bill', '1741757344843', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741757344843\",\"items\":\"Student Fees\",\"currency\":\"INR\",\"amount\":50,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-12 05:29:04');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (53, NULL, 'patient_bill', 'skrill', 'patient_bill', '1741757597357', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1741757597357\",\"items\":\"Student Fees\",\"currency\":\"INR\",\"amount\":50,\"first_name\":\"Suresh\",\"last_name\":\"\",\"email\":\"\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-03-12 05:33:17');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (54, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1741765611', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1741765611\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1741765611\",\"session_ID\":\"A3D1741765611\",\"pay_from_email\":\"test@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"60.00\",\"currency\":\"INR\",\"firstname\":\"Suresh\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-03-12 07:46:51');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (55, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1741765643', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1741765643\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1741765643\",\"session_ID\":\"A3D1741765643\",\"pay_from_email\":\"test@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"60.00\",\"currency\":\"INR\",\"firstname\":\"Suresh\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-03-12 07:47:23');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (56, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1741765669', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1741765669\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1741765669\",\"session_ID\":\"A3D1741765669\",\"pay_from_email\":\"test@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"60.00\",\"currency\":\"INR\",\"firstname\":\"Suresh\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-03-12 07:47:49');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (57, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741774634908', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":55,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741774634908\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"tfh\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:17:14');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (58, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741774665889', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":110,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741774665889\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"345435345\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:17:46');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (59, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741774716908', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":110,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741774716908\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"434353\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:18:36');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (60, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741775246214', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":55,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741775246214\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"45646\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:27:26');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (61, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741775279209', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":55,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741775279209\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"435\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:27:59');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (62, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741775320251', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":55,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741775320251\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"435\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:28:40');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (63, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741775344246', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":55,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741775344246\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"435\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:29:04');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (64, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741775381173', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":55,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741775381173\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"33543\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:29:41');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (65, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741775401577', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":55,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741775401577\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"33543\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:30:02');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (66, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1741775418902', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":55,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1741775418902\",\"billTo\":\"Suresh\",\"billEmail\":\"test@gmail.com\",\"billPhone\":\"213\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-03-12 10:30:19');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (70, NULL, 'patient_bill', 'payfast', 'patient_bill', '17453172345561745317234', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"@\\/\\/Mukesh__@##!\",\"email_address\":\"mukesh@gmail.com\",\"m_payment_id\":\"17453172345561745317234\",\"amount\":\"110.00\",\"item_name\":\"reference_id#127\",\"signature\":\"d9296312e6337dcb0b4b1abf8691878a\"}', 'processing', '2025-04-22 10:20:34');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (71, NULL, 'patient_bill', 'payfast', 'patient_bill', '17453173229031745317322', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"@\\/\\/Mukesh__@##!\",\"email_address\":\"mukesh@gmail.com\",\"m_payment_id\":\"17453173229031745317322\",\"amount\":\"55.00\",\"item_name\":\"reference_id#127\",\"signature\":\"2efa5e7052093cdd33c70f59039dfe89\"}', 'processing', '2025-04-22 10:22:02');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (72, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1745317468273', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":110,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1745317468273\",\"billTo\":\"@\\/\\/Mukesh__@##!\",\"billEmail\":\"mukesh@gmail.com\",\"billPhone\":\"97896757896\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-04-22 10:24:29');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (76, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1745318020', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1745318020\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1745318020\",\"session_ID\":\"A3D1745318020\",\"pay_from_email\":\"mukesh@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"255.00\",\"currency\":\"INR\",\"firstname\":\"@\\/\\/Mukesh__@##!\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-04-22 10:33:40');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (77, NULL, 'patient_bill', 'skrill', 'patient_bill', '1745318533798', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1745318533798\",\"items\":\"Student Fees\",\"currency\":\"INR\",\"amount\":110,\"first_name\":\"@\\/\\/Mukesh__@##!\",\"last_name\":\"\",\"email\":\"\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-04-22 10:42:13');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (78, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1745389438', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1745389438\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1745389438\",\"session_ID\":\"A3D1745389438\",\"pay_from_email\":\"uu@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"10.00\",\"currency\":\"INR\",\"firstname\":\"@\\/\\/Mukesh__@##!\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-04-23 06:23:58');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (79, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1745394911', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1745394911\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1745394911\",\"session_ID\":\"A3D1745394911\",\"pay_from_email\":\"mulkesh@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"100.00\",\"currency\":\"INR\",\"firstname\":\"@\\/\\/Mukesh__@##!\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-04-23 07:55:11');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (80, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1745394984', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1745394984\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1745394984\",\"session_ID\":\"A3D1745394984\",\"pay_from_email\":\"mukesh@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"57.50\",\"currency\":\"INR\",\"firstname\":\"@\\/\\/Mukesh__@##!\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-04-23 07:56:24');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (81, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1745405317', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1745405317\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1745405317\",\"session_ID\":\"A3D1745405317\",\"pay_from_email\":\"mukesh@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"115.00\",\"currency\":\"INR\",\"firstname\":\"@\\/\\/Mukesh__@##!\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-04-23 10:48:37');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (84, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1745407773', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1745407773\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1745407773\",\"session_ID\":\"A3D1745407773\",\"pay_from_email\":\"email@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"0.00\",\"currency\":\"INR\",\"firstname\":\"@\\/\\/Mukesh__@##!\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-04-23 11:29:33');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (86, NULL, 'patient_bill', 'payfast', 'patient_bill', '17461020624361746102062', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"CHARAN\",\"email_address\":\"gmail.com\",\"m_payment_id\":\"17461020624361746102062\",\"amount\":\"1039.39\",\"item_name\":\"reference_id#44\",\"signature\":\"c9c1446736e2b8b4a84c97e9a37551a1\"}', 'processing', '2025-05-01 12:21:02');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (87, NULL, 'patient_bill', 'payfast', 'patient_bill', '17461689556771746168955', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"CHARAN\",\"email_address\":\"superadmin@gmail.com\",\"m_payment_id\":\"17461689556771746168955\",\"amount\":\"0.00\",\"item_name\":\"reference_id#44\",\"signature\":\"1f8ae3cbfa0428ae365007e715e377d5\"}', 'processing', '2025-05-02 06:55:55');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (88, NULL, 'patient_bill', 'payfast', 'patient_bill', '17461885725391746188572', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"CHARAN\",\"email_address\":\"gmail\",\"m_payment_id\":\"17461885725391746188572\",\"amount\":\"336.60\",\"item_name\":\"reference_id#44\",\"signature\":\"93c177e2dc8fec209565ecb64cfd0781\"}', 'processing', '2025-05-02 12:22:52');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (89, NULL, 'patient_bill', 'payfast', 'patient_bill', '17461886121011746188612', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"CHARAN\",\"email_address\":\"sahu.laxmi54@gmail.com\",\"m_payment_id\":\"17461886121011746188612\",\"amount\":\"336.60\",\"item_name\":\"reference_id#44\",\"signature\":\"42b60fb5a28440dd06874af3d599b8c1\"}', 'COMPLETE', '2025-05-02 12:24:01');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (90, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1746188813646', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":1039.3899999999999,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1746188813646\",\"billTo\":\"CHARAN\",\"billEmail\":\"sahu.laxmi54@gmail.com\",\"billPhone\":\"9826244698\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-05-02 12:26:54');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (91, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1746188957485', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":1039.3899999999999,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1746188957485\",\"billTo\":\"CHARAN\",\"billEmail\":\"sahu.laxmi@gmail.com\",\"billPhone\":\"1234567890\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-05-02 12:29:17');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (92, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1746189711', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1746189711\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1746189711\",\"session_ID\":\"A3D1746189711\",\"pay_from_email\":\"sahu.laxmi@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"1086.64\",\"currency\":\"INR\",\"firstname\":\"CHARAN\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-05-02 12:41:51');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (93, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1746189859', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1746189859\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1746189859\",\"session_ID\":\"A3D1746189859\",\"pay_from_email\":\"sahu.laxmi@54gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"1086.64\",\"currency\":\"INR\",\"firstname\":\"CHARAN\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-05-02 12:44:19');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (94, NULL, 'patient_bill', 'skrill', 'patient_bill', '1746189924235', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1746189924235\",\"items\":\"Student Fees\",\"currency\":\"INR\",\"amount\":954.9,\"first_name\":\"CHARAN\",\"last_name\":\"\",\"email\":\"\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-05-02 12:45:24');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (97, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1746781416868', '{\"userSecretKey\":\"DFsB+A3fAN8C9WMiE+IsFJUuGkY=\",\"categoryCode\":null,\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":336.6,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1746781416868\",\"billTo\":\"chunnibai test\",\"billEmail\":\"sahu.laxmi54@gmail.cm\",\"billPhone\":\"4545566\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-05-09 09:03:37');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (98, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1746781426667', '{\"userSecretKey\":\"DFsB+A3fAN8C9WMiE+IsFJUuGkY=\",\"categoryCode\":null,\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":336.6,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1746781426667\",\"billTo\":\"chunnibai test\",\"billEmail\":\"sahu.laxmi54@gmail.cm\",\"billPhone\":\"4545566\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-05-09 09:03:46');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (99, NULL, 'patient_bill', 'toyyibpay', 'patient_bill', '1746782083747', '{\"userSecretKey\":\"f6q6can8-axnc-vgqn-f9y0-abdioojk8o6c\",\"categoryCode\":\"z49u1a6j\",\"billName\":\"Patient Bill\",\"billDescription\":\"Patient Bill\",\"billPriceSetting\":1,\"billPayorInfo\":1,\"billAmount\":847,\"billReturnUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/toyyibpay\\/success\",\"billCallbackUrl\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/toyyibpay\",\"billExternalReferenceNo\":\"1746782083747\",\"billTo\":\"suresh\",\"billEmail\":\"sahu.laxmi54@gmail.com\",\"billPhone\":\"9826244698\",\"billSplitPayment\":0,\"billSplitPaymentArgs\":\"\",\"billPaymentChannel\":\"0\",\"billContentEmail\":\"Thank you for fees submission!\",\"billChargeToCustomer\":1}', 'processing', '2025-05-09 09:14:44');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (102, NULL, 'patient_bill', 'skrill', 'patient_bill', 'A1746783874', '{\"pay_to_email\":\"demoqco@sun-fish.com\",\"transaction_id\":\"A1746783874\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/skrill\\/cancel\",\"status_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/skrill\",\"language\":\"EN\",\"merchant_fields\":\"customer_number,session_id\",\"customer_number\":\"C1746783874\",\"session_ID\":\"A3D1746783874\",\"pay_from_email\":\"suresh@gmail.com\",\"amount2_description\":\"\",\"amount2\":\"\",\"amount3_description\":\"\",\"amount3\":\"\",\"amount4_description\":\"\",\"amount4\":\"\",\"amount\":\"234.14\",\"currency\":\"INR\",\"firstname\":\"Mukesh patel\",\"lastname\":\"\",\"address\":\"\",\"postal_code\":\"\",\"city\":\"\",\"country\":\"\",\"detail1_description\":\"\",\"detail1_text\":\"\",\"detail2_description\":\"\",\"detail2_text\":\"\",\"detail3_description\":\"\",\"detail3_text\":\"\"}', 'processing', '2025-05-09 09:44:34');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (104, NULL, 'patient_bill', 'skrill', 'patient_bill', '1747224266476', '{\"merchant_id\":\"test\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/user\\/gateway\\/payhere\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/gateway_ins\\/payhere\",\"order_id\":\"1747224266476\",\"items\":\"Student Fees\",\"currency\":\"INR\",\"amount\":14.16,\"first_name\":\"suresh\",\"last_name\":\"\",\"email\":\"\",\"phone\":\"\",\"address\":\"\",\"city\":\"\",\"country\":\"\"}', 'processing', '2025-05-14 12:04:26');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (105, NULL, 'patient_bill', 'payfast', 'patient_bill', '17472243987391747224398', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"suresh\",\"email_address\":\"kirantest@gmail.com\",\"m_payment_id\":\"17472243987391747224398\",\"amount\":\"12.98\",\"item_name\":\"reference_id#155\",\"signature\":\"cf3ad2b0ebde3bb91ec238f1dd85052b\"}', 'COMPLETE', '2025-05-14 12:06:56');
INSERT INTO `gateway_ins` (`id`, `online_appointment_id`, `type`, `gateway_name`, `module_type`, `unique_id`, `parameter_details`, `payment_status`, `created_at`) VALUES (106, NULL, 'patient_bill', 'payfast', 'patient_bill', '17473107585721747310758', '{\"merchant_id\":\"10000100\",\"merchant_key\":\"46f0cd694581a\",\"return_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/success\",\"cancel_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/payment\\/payfast\\/cancel\",\"notify_url\":\"https:\\/\\/dev1.webfeb.com\\/shqratfa\\/patient\\/gateway_ins\\/payfast\",\"name_first\":\"New Patient\",\"email_address\":\"test@gmail.com\",\"m_payment_id\":\"17473107585721747310758\",\"amount\":\"0.00\",\"item_name\":\"reference_id#172\",\"signature\":\"a0535f0c26191b6d3f1e7322a1f1eb2b\"}', 'processing', '2025-05-15 12:05:58');


#
# TABLE STRUCTURE FOR: gateway_ins_response
#

DROP TABLE IF EXISTS `gateway_ins_response`;

CREATE TABLE `gateway_ins_response` (
  `id` int NOT NULL AUTO_INCREMENT,
  `gateway_ins_id` int DEFAULT NULL,
  `posted_data` text,
  `response` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `gateway_ins_id` (`gateway_ins_id`),
  CONSTRAINT `gateway_ins_response_ibfk_1` FOREIGN KEY (`gateway_ins_id`) REFERENCES `gateway_ins` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

#
# TABLE STRUCTURE FOR: general_calls
#

DROP TABLE IF EXISTS `general_calls`;

CREATE TABLE `general_calls` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `contact` varchar(12) NOT NULL,
  `date` date NOT NULL,
  `description` text,
  `follow_up_date` date DEFAULT NULL,
  `call_duration` varchar(50) NOT NULL,
  `note` mediumtext,
  `call_type` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_contact` (`contact`),
  KEY `index_date` (`date`),
  KEY `index_call_duration` (`call_duration`),
  KEY `index_follow_up_date` (`follow_up_date`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;

INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (5, 'mahi', '437654567', '2024-11-05', '', NULL, '', '', 'Outgoing', '2024-11-05 12:46:47');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (9, 'test', '678967879', '2024-12-04', 'sddfgsd', '2024-12-05', '', '', 'Outgoing', '2025-04-16 07:48:31');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (11, 'add', '', '2025-03-01', '', NULL, '', '', 'Incoming', '2025-03-01 11:38:27');
INSERT INTO `general_calls` (`id`, `name`, `contact`, `date`, `description`, `follow_up_date`, `call_duration`, `note`, `call_type`, `created_at`) VALUES (13, 'add', '', '2025-04-07', '', NULL, '', '', 'Incoming', '2025-04-07 11:39:56');


#
# TABLE STRUCTURE FOR: global_shift
#

DROP TABLE IF EXISTS `global_shift`;

CREATE TABLE `global_shift` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `start_time` time NOT NULL,
  `end_time` time NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_name` (`name`),
  KEY `index_start_time` (`start_time`),
  KEY `index_end_time` (`end_time`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb3;

INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (1, 'Morning', '09:30:00', '13:30:00', '2024-09-26 07:15:31');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (2, 'Evening', '13:00:00', '20:00:00', '2025-03-21 09:07:59');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (3, 'night', '20:00:00', '23:00:00', '2024-09-27 09:15:56');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (4, 'night', '20:00:00', '23:00:00', '2024-09-27 09:15:56');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (5, 'morning2', '09:00:00', '12:00:00', '2024-09-27 09:17:41');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (6, 'afternoon', '18:00:00', '19:00:00', '2025-03-17 10:16:11');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (8, 'night', '20:00:00', '23:00:00', '2024-11-20 10:10:43');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (19, 'shift', '17:51:00', '18:51:00', '2025-04-17 12:22:07');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (20, 'shift2', '16:12:00', '20:12:00', '2025-05-01 10:42:33');
INSERT INTO `global_shift` (`id`, `name`, `start_time`, `end_time`, `date_created`) VALUES (21, 'earlymornig', '04:27:00', '10:28:00', '2025-05-07 08:58:13');


#
# TABLE STRUCTURE FOR: google_authenticator
#

DROP TABLE IF EXISTS `google_authenticator`;

CREATE TABLE `google_authenticator` (
  `id` int NOT NULL AUTO_INCREMENT,
  `use_authenticator` int DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

INSERT INTO `google_authenticator` (`id`, `use_authenticator`, `created_at`) VALUES (1, 1, '2024-09-30 12:34:50');


#
# TABLE STRUCTURE FOR: income
#

DROP TABLE IF EXISTS `income`;

CREATE TABLE `income` (
  `id` int NOT NULL AUTO_INCREMENT,
  `inc_head_id` int DEFAULT NULL,
  `name` varchar(50) DEFAULT NULL,
  `invoice_no` varchar(200) NOT NULL,
  `date` date DEFAULT NULL,
  `amount` float(10,2) DEFAULT '0.00',
  `note` text,
  `is_deleted` varchar(10) DEFAULT 'no',
  `documents` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `generated_by` int DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `inc_head_id` (`inc_head_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_name` (`name`),
  KEY `index_invoice_no` (`invoice_no`),
  KEY `index_date` (`date`),
  KEY `index_amount` (`amount`),
  CONSTRAINT `income_ibfk_1` FOREIGN KEY (`inc_head_id`) REFERENCES `income_head` (`id`) ON DELETE CASCADE,
  CONSTRAINT `income_ibfk_2` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb3;

INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (4, 2, 'medical income soruce', '', '2024-10-11', '20000.00', '', 'no', NULL, 1, 'yes', '2024-10-11 11:59:51');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (5, 1, 'Hospital Building rent', '6785', '2024-10-29', '250.00', '', 'no', NULL, 1, 'yes', '2024-10-29 05:53:44');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (6, 3, 'test income', '5567576', '2024-11-04', '5000.00', '', 'no', NULL, 1, 'yes', '2024-11-04 11:18:13');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (10, 2, 'hello', '', '2024-11-14', '200.00', '', 'no', NULL, 1, 'yes', '2024-11-15 07:49:34');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (12, 1, 'KIRAN', 'test325', '2024-11-26', '34.00', 'test', 'no', 'uploads/hospital_income/12.png', 1, 'yes', '2024-11-27 11:07:38');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (14, 1, 'test test test tes', '435435', '2024-11-26', '344.00', '4535', 'no', 'uploads/hospital_income/1732603512-15267800867456e78d4845!tset.png', 1, 'yes', '2024-11-26 06:45:12');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (16, 2, 'TES TES TES TEST T', 'SETSETES', '2024-11-27', '100.00', '', 'no', '1732705838-14837020226746fe2e5a7aa!K (5).png', 1, 'yes', '2024-12-04 11:38:39');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (17, 1, 'KIRAN 1', '', '2024-11-27', '45.00', '', 'no', '1732705859-3623274446746fe435d6de!K (5).png', 1, 'yes', '2024-11-27 11:10:59');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (21, 1, 'income', '', '2024-12-03', '2000.00', 'hello', 'no', 'uploads/hospital_income/1733227411-1250625954674ef3934f31b!AVYAAN_100 (1).pdf', 1, 'yes', '2024-12-03 12:03:31');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (22, 1, 'test', '', '2024-12-04', '2000.00', '', 'no', 'uploads/hospital_income/1733312237-174467718067503eed197c6!7.jpg', 1, 'yes', '2024-12-04 11:37:17');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (23, 1, 'income', '5454566', '2025-03-01', '1000.00', '', 'no', 'uploads/hospital_income/1740818391-188141233767c2c7d7c2080!4.JPG', 1, 'yes', '2025-03-01 08:39:51');
INSERT INTO `income` (`id`, `inc_head_id`, `name`, `invoice_no`, `date`, `amount`, `note`, `is_deleted`, `documents`, `generated_by`, `is_active`, `created_at`) VALUES (30, 1, 'OPD Test', '534545', '2025-04-18', '250.00', '', 'no', NULL, 1, 'yes', '2025-04-18 11:18:49');


#
# TABLE STRUCTURE FOR: income_head
#

DROP TABLE IF EXISTS `income_head`;

CREATE TABLE `income_head` (
  `id` int NOT NULL AUTO_INCREMENT,
  `income_category` varchar(255) DEFAULT NULL,
  `description` text,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `is_deleted` varchar(10) NOT NULL DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_income_category` (`income_category`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3;

INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (1, 'Opd income', 'hospital', 'yes', 'no', '2024-10-11 12:03:29');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (2, 'Ipd income', '', 'yes', 'no', '2024-10-11 12:03:08');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (3, 'Medical income', '', 'yes', 'no', '2024-10-07 12:08:33');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (4, 'Pathology income', 'Pathology income', 'yes', 'no', '2024-10-11 12:02:51');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (10, 'income', '', 'yes', 'no', '2025-04-17 12:11:08');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (11, 'ambulance', '', 'yes', 'no', '2025-05-01 10:23:16');
INSERT INTO `income_head` (`id`, `income_category`, `description`, `is_active`, `is_deleted`, `created_at`) VALUES (13, 'Income Head', '', 'yes', 'no', '2025-05-07 08:39:50');


#
# TABLE STRUCTURE FOR: ipd_details
#

DROP TABLE IF EXISTS `ipd_details`;

CREATE TABLE `ipd_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `patient_id` int DEFAULT NULL,
  `case_reference_id` int DEFAULT NULL,
  `height` varchar(5) DEFAULT NULL,
  `weight` varchar(5) DEFAULT NULL,
  `pulse` varchar(200) NOT NULL,
  `temperature` varchar(200) NOT NULL,
  `respiration` varchar(200) NOT NULL,
  `bp` varchar(20) DEFAULT NULL,
  `bed` int DEFAULT NULL,
  `bed_group_id` int DEFAULT NULL,
  `case_type` varchar(100) NOT NULL,
  `casualty` varchar(100) NOT NULL,
  `symptoms` longtext NOT NULL,
  `known_allergies` varchar(200) DEFAULT NULL,
  `patient_old` varchar(50) NOT NULL,
  `note` text,
  `refference` varchar(200) NOT NULL,
  `cons_doctor` int DEFAULT NULL,
  `organisation_id` int DEFAULT NULL,
  `credit_limit` varchar(100) NOT NULL,
  `payment_mode` varchar(100) NOT NULL,
  `date` datetime DEFAULT NULL,
  `discharged` varchar(200) NOT NULL,
  `live_consult` varchar(50) DEFAULT NULL,
  `generated_by` int DEFAULT NULL,
  `is_antenatal` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `patient_id` (`patient_id`),
  KEY `case_reference_id` (`case_reference_id`),
  KEY `cons_doctor` (`cons_doctor`),
  KEY `bed_group_id` (`bed_group_id`),
  KEY `bed` (`bed`),
  CONSTRAINT `ipd_details_ibfk_1` FOREIGN KEY (`patient_id`) REFERENCES `patients` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_2` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_3` FOREIGN KEY (`case_reference_id`) REFERENCES `case_references` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_4` FOREIGN KEY (`cons_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_5` FOREIGN KEY (`bed_group_id`) REFERENCES `bed_group` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_details_ibfk_6` FOREIGN KEY (`bed`) REFERENCES `bed` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (2, 3, 9, NULL, NULL, '', '', '', NULL, 3, 3, '', 'No', '', NULL, '', NULL, '', 2, NULL, '20000', '', '2024-09-28 13:38:00', 'yes', 'no', 1, 1, '2024-10-28 12:54:24');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (3, 5, 23, NULL, NULL, '', '', '', NULL, 2, 2, '', 'No', 'Constant or severe abdominal pain\r\nDiseases that affect the digestive system can also cause chronic abdominal pain. The most common are: gastroesophageal reflux disease (GERD) irritable bowel syndrome or spastic colon.', NULL, '', NULL, '', 2, NULL, '20000', '', '2024-10-01 10:06:00', 'yes', 'no', 1, 1, '2024-10-29 10:27:28');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (4, 7, 26, NULL, NULL, '', '', '', NULL, 4, 2, '', 'No', '', NULL, 'Yes', '', '', 2, NULL, '20000', '', '2024-10-08 13:19:00', 'yes', 'no', 1, NULL, '2024-11-04 07:14:18');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (5, 3, 32, NULL, NULL, '', '', '', NULL, 3, 1, '', 'Yes', '', NULL, 'Yes', '', '', 2, NULL, '20000', '', '2024-10-09 14:02:00', 'yes', 'no', 1, NULL, '2024-10-30 08:46:21');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (6, 6, 37, NULL, NULL, '', '', '', NULL, 5, 1, '', 'Yes', '', '', '', '', '', 2, NULL, '20000', '', '2024-11-01 12:45:00', 'yes', 'no', 2, NULL, '2024-11-02 06:46:54');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (8, 6, 40, NULL, NULL, '', '', '', NULL, 4, 2, '', 'No', '', NULL, '', NULL, '', 8, NULL, '20000', '', '2024-11-04 12:57:00', 'yes', 'no', 1, NULL, '2024-11-21 12:36:30');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (10, 3, 43, NULL, NULL, '', '', '', NULL, 4, 2, '', 'Yes', '', NULL, '', NULL, '', 8, NULL, '10000', '', '2024-11-04 17:45:00', 'yes', 'no', 1, 1, '2024-11-05 06:00:03');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (13, 3, 98, NULL, NULL, '', '', '', NULL, 4, 2, '10', 'Yes', '', '', '', '', '', 2, NULL, '20000', '', '2024-10-09 14:02:00', 'yes', 'no', 1, 1, '2025-04-08 05:41:02');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (17, 7, 142, NULL, NULL, '', '', '', NULL, 11, 3, '', 'No', '', NULL, '', NULL, '', 2, NULL, '20000', '', '2024-11-27 17:10:00', 'no', 'no', 1, NULL, '2024-11-26 11:41:16');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (51, 155, 338, NULL, NULL, '', '', '', NULL, 20, 3, '', 'No', '', NULL, '', NULL, '', 2, NULL, '20000', '', '2025-05-05 16:47:00', 'no', 'no', 1, NULL, '2025-05-05 11:17:47');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (53, 158, 343, NULL, NULL, '', '', '', NULL, 13, 3, '', 'Yes', 'Muscle Joint\r\nMuscle pain: Muscle spasms, cramps and injuries can all cause muscle pain. Some infections or tumors may also lead to muscle pain. \r\n\r\ncramps and injuries\r\nMuscle pain: Muscle spasms, cramps and injuries can all cause muscle pain. Some infections or tumors may also lead to muscle pain. Tendon and ligament pain: Ligaments and tendons are strong bands of tissue that connect your joints and bones', 'Muscle Joint\r\nMuscle pain: Muscle spasms, cramps and injuries can all cause muscle pain. Some infections or tumors may also lead to muscle pain. \r\n\r\ncramps and injuries\r\nMuscle pain: Muscle spasms, cr', '', '', '', 2, NULL, '20000', '', '2025-05-06 12:06:00', 'yes', 'no', 1, NULL, '2025-05-08 08:24:11');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (54, 164, 349, NULL, NULL, '', '', '', NULL, 16, 4, '', 'Yes', '', '', '', '', '', 2, NULL, '20000', '', '2025-05-07 12:02:00', 'no', 'no', 1, 1, '2025-05-07 06:33:03');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (55, 165, 352, NULL, NULL, '', '', '', NULL, 14, 3, '108', 'No', '', NULL, '', NULL, '', 2, NULL, '1000', '', '2025-05-08 11:46:00', 'yes', 'no', 1, NULL, '2025-05-15 11:35:04');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (56, 167, 358, NULL, NULL, '', '', '', NULL, 18, 3, '', 'No', 'Muscle Joint\r\nMuscle pain: Muscle spasms, cramps and injuries can all cause muscle pain. Some infections or tumors may also lead to muscle pain. ', NULL, '', NULL, '', 2, NULL, '20000', '', '2025-05-10 12:44:00', 'no', 'no', 1, NULL, '2025-05-10 07:15:45');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (59, 172, 382, NULL, NULL, '', '', '', NULL, 30, 3, '', 'No', 'Urinary TEST\r\nUrinary incontinence — the loss of bladder control — is a common and often embarrassing problem. The severity ranges from occasionally leaking urine', NULL, 'Yes', '', '', 2, NULL, '20000', '', '2025-05-15 15:27:00', 'no', 'no', 1, NULL, '2025-05-15 09:59:20');
INSERT INTO `ipd_details` (`id`, `patient_id`, `case_reference_id`, `height`, `weight`, `pulse`, `temperature`, `respiration`, `bp`, `bed`, `bed_group_id`, `case_type`, `casualty`, `symptoms`, `known_allergies`, `patient_old`, `note`, `refference`, `cons_doctor`, `organisation_id`, `credit_limit`, `payment_mode`, `date`, `discharged`, `live_consult`, `generated_by`, `is_antenatal`, `created_at`) VALUES (60, 161, 387, NULL, NULL, '', '', '', NULL, 13, 3, '', 'Yes', '', '', '', '', '', 2, NULL, '20000', '', '2025-05-15 15:57:00', 'yes', 'no', 1, NULL, '2025-05-15 12:07:19');


#
# TABLE STRUCTURE FOR: ipd_doctors
#

DROP TABLE IF EXISTS `ipd_doctors`;

CREATE TABLE `ipd_doctors` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipd_id` int NOT NULL,
  `consult_doctor` int NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `consult_doctor` (`consult_doctor`),
  CONSTRAINT `ipd_doctors_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_doctors_ibfk_2` FOREIGN KEY (`consult_doctor`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_doctors` (`id`, `ipd_id`, `consult_doctor`, `created_at`) VALUES (1, 8, 2, '2024-11-04 09:28:49');


#
# TABLE STRUCTURE FOR: ipd_prescription_basic
#

DROP TABLE IF EXISTS `ipd_prescription_basic`;

CREATE TABLE `ipd_prescription_basic` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipd_id` int DEFAULT NULL,
  `visit_details_id` int DEFAULT NULL,
  `attachment` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `attachment_name` text NOT NULL,
  `header_note` text,
  `footer_note` text,
  `finding_description` text,
  `is_finding_print` varchar(100) DEFAULT NULL,
  `date` date NOT NULL,
  `generated_by` int DEFAULT NULL,
  `prescribe_by` int DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_id` (`ipd_id`),
  KEY `visit_details_id` (`visit_details_id`),
  KEY `generated_by` (`generated_by`),
  KEY `index_date` (`date`),
  KEY `prescribe_by` (`prescribe_by`),
  CONSTRAINT `ipd_prescription_basic_ibfk_1` FOREIGN KEY (`ipd_id`) REFERENCES `ipd_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_2` FOREIGN KEY (`visit_details_id`) REFERENCES `visit_details` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_3` FOREIGN KEY (`generated_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_basic_ibfk_4` FOREIGN KEY (`prescribe_by`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=338 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (1, NULL, 2, '', '', '', '', '', 'yes', '2024-09-26', 1, 2, '2024-09-26 13:06:21');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (2, NULL, 5, '', '', '', '', '', 'yes', '2024-09-27', 1, 2, '2024-09-27 10:11:54');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (3, NULL, 6, '', '', '', '', ' ', 'yes', '2024-09-27', 1, 2, '2024-09-27 12:41:00');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (4, NULL, 7, '', '', '', '', '', 'yes', '2024-09-28', 1, 2, '2024-09-28 07:11:02');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (5, NULL, 9, '', '', '', '', '', 'yes', '2024-09-28', 1, 2, '2024-09-28 07:30:37');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (6, 2, NULL, '', '', '', '', ' ', 'yes', '2024-09-28', 1, 2, '2024-09-28 10:33:48');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (7, NULL, 1, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-09-30', 1, 2, '2024-09-30 04:40:45');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (15, 3, NULL, '', '', '', '', '', 'yes', '2024-10-01', 1, 2, '2024-10-01 11:19:23');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (16, 3, NULL, '', '', '', '', '', 'yes', '2024-10-01', 1, 2, '2024-10-01 11:19:43');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (17, NULL, 25, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-08', 1, 2, '2024-10-08 08:02:38');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (18, NULL, 27, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-08', 1, 2, '2024-10-08 10:41:57');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (19, NULL, 30, '', '', '', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-10-09', 1, 2, '2024-10-09 08:34:00');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (21, 4, NULL, '', '', '', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-10-09', 1, 2, '2024-10-09 09:59:24');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (23, 4, NULL, '', '', '', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-10-09', 1, 2, '2024-10-09 09:59:37');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (24, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (25, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:43');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (26, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:51');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (27, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:54');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (28, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (29, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (30, 4, NULL, '', '', '', '', 'fever\r\n ', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:11:09');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (31, 4, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-10-09', 1, 2, '2024-10-09 10:21:50');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (32, NULL, 29, '', '', '', '', 'fever\r\n', 'yes', '2024-10-16', 7, 2, '2024-10-16 07:10:24');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (33, NULL, 33, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-28', 1, 2, '2024-10-28 12:45:52');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (34, 4, NULL, '', '', '', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-10-28', 1, 2, '2024-10-28 12:47:21');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (35, NULL, 31, '', '', '', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-10-28', 1, 2, '2024-10-28 12:48:06');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (36, 5, NULL, '', '', '', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-10-28', 1, 2, '2024-10-28 12:57:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (37, NULL, 35, '', '', '<p>sdfdsf</p>', '<p>sdfsf</p>', 'rfsd', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:02:29');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (38, NULL, 10, '', '', '<p>34te</p>', '<p>ertret</p>', '    ', 'yes', '2024-11-19', 1, 2, '2024-11-19 06:41:48');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (39, NULL, 34, '', '', '<p>5YRYR</p>', '<p>RYTRY</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-29', 1, 8, '2024-10-29 09:27:08');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (42, NULL, 28, '', '', '<p>TEST TTTTTTTTTTTTTTTTTTTTTTTTTTTTTT</p>', '<p>\r\n\r\nTESTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', NULL, '2024-10-29', 1, 2, '2024-10-29 09:28:30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (43, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', '', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:14');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (44, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', '', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:17');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (45, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', '', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (46, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', '', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (47, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', '', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:19');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (48, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (49, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:32');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (50, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:32');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (51, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:32');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (52, 5, NULL, '', '', '<p>IPD PRESSCRIPTION</p>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:29:42');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (53, 5, NULL, '', '', '<h2>IPD PRESSCRIPTION</h2>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:30:04');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (54, 5, NULL, '', '', '<h2>IPD PRESSCRIPTION</h2>', '<p>\r\n\r\nIPD PRESSCRIPTION\r\n\r\n<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:30:20');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (55, 5, NULL, '', '', '<p>KIRAN</p>', '<p>\r\n\r\nKIRAN\r\n\r\n<br></p>', '', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:32:28');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (56, 5, NULL, '', '', '', '<p>XCV</p>', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:42:35');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (57, 5, NULL, '17301952674105281526720af436406e.pdf', 'class 1 exam o_2023-24_Class  1st_A (3).pdf', '<p>sadadad</p>', '<p>asdasd</p>', '', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:47:47');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (58, NULL, 13, '', '', '<p>sfs</p>', '<p>fsdf</p>', '', 'yes', '2024-10-29', 1, 2, '2024-10-29 09:48:19');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (59, 4, NULL, '', '', '', '', '', 'yes', '2024-10-30', 2, 2, '2024-10-30 09:39:06');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (60, NULL, 37, '', '', '', '', '', 'yes', '2024-11-02', 1, 2, '2024-11-02 05:47:23');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (62, NULL, 38, '', '', '', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-11-04', 1, 2, '2024-11-04 08:08:40');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (85, 8, NULL, '', '', 'add', '<p>test</p>', 'fever\r\n\r\nElevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit.      ', 'yes', '2024-11-12', 1, 8, '2024-11-12 10:50:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (86, 8, NULL, '', '', '<p>test</p>', '<p>test</p>', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-11-04', 1, 8, '2024-11-04 11:57:41');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (87, NULL, 24, '', '', '<p>test</p>', '<p>test</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-04', 1, 2, '2024-11-04 12:01:45');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (88, NULL, 42, '', '', '<p>sdf</p>', '', '', 'yes', '2024-11-04', 1, 8, '2024-11-04 12:52:54');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (89, 8, NULL, '', '', '<p>arwar</p>', '<p>rwar</p>', 'Damaged Hair\r\nDamaged Hair	', 'yes', '2024-11-05', 1, 8, '2024-11-05 11:46:55');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (90, 8, NULL, '', '', '<p>rwar</p>', '<p>rwarrwar</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-05', 1, 8, '2024-11-05 11:47:11');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (91, 8, NULL, '', '', '<p>dgdfg</p>', '<p>dfgdg</p>', '', 'yes', '2024-11-05', 1, 8, '2024-11-05 11:54:54');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (92, 8, NULL, '', '', '<p>dgdfg</p>', '<p>dfgdg</p>', '', 'yes', '2024-11-05', 1, 8, '2024-11-05 11:54:54');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (93, 8, NULL, '', '', '<p>dgdg</p>', '<p>dfgdfg</p>', '', 'yes', '2024-11-05', 1, 8, '2024-11-05 11:55:12');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (99, 8, NULL, '', '', '<p>asdsad</p>', '<p>asdd</p>', '', 'yes', '2024-11-05', 1, 8, '2024-11-05 12:01:02');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (100, 8, NULL, '', '', '<p>adasd</p>', '<p>dadad</p>', '', 'yes', '2024-11-05', 1, 8, '2024-11-05 12:05:53');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (101, 8, NULL, '', '', '<p>test</p>', '<p>test</p>', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-11-05', 1, 8, '2024-11-05 12:06:37');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (105, NULL, 49, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-07', 1, 2, '2024-11-07 11:31:15');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (106, NULL, 50, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', 'yes', '2024-11-08', 1, 8, '2024-11-08 10:56:24');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (107, NULL, 52, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-08', 1, 8, '2024-11-08 11:05:40');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (108, NULL, 53, '', '', '', '', '', 'yes', '2024-11-08', 1, 8, '2024-11-08 11:47:13');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (109, 8, NULL, '', '', '<p>tet</p>', '<p>tst</p>', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-11-11', 1, 8, '2024-11-11 12:12:30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (110, 8, NULL, '', '', '<p>test</p>', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-11', 1, 8, '2024-11-11 12:13:29');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (119, 8, NULL, '', '', '<p>test</p>', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-11-11', 1, 8, '2024-11-11 12:14:42');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (120, 8, NULL, '', '', '<p>test</p>', '<p>test</p>', '', 'yes', '2024-11-11', 1, 8, '2024-11-11 12:23:17');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (121, 8, NULL, '', '', '', '', '', 'yes', '2024-11-11', 1, 8, '2024-11-11 12:29:03');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (122, 8, NULL, '', '', '', '', '', 'yes', '2024-11-11', 1, 8, '2024-11-11 12:29:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (123, 8, NULL, '', '', 'add', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. \r\nEczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', 'yes', '2024-11-12', 1, 8, '2024-11-12 10:37:09');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (124, NULL, 58, '', '', '<p>Medicine</p>', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.\r\nOsteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both. ', 'yes', '2024-11-12', 1, 2, '2024-11-12 11:01:30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (125, NULL, 54, '', '', '', '', '', 'yes', '2024-11-12', 1, 2, '2024-11-12 10:13:48');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (126, NULL, 43, '', '', '', '', '  ', 'yes', '2024-11-12', 1, 8, '2024-11-12 10:19:04');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (128, 8, NULL, '', '', 'add', '', 'Damaged Hair\r\n	\r\nDamaged Hair\r\nDamaged Hair	 ', 'yes', '2024-11-12', 1, 2, '2024-11-12 10:51:39');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (130, NULL, 60, '', '', '<p>add</p>', '', 'fever\r\n\r\nElevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-11-13', 1, 2, '2024-11-13 07:05:17');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (131, NULL, 63, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-13', 1, 2, '2024-11-13 07:56:43');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (132, 8, NULL, '', '', '', '', 'fever\r\n', 'yes', '2024-11-13', 1, 2, '2024-11-13 08:34:05');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (136, NULL, 65, '', '', '', '', '', 'yes', '2024-11-13', 1, 2, '2024-11-13 13:21:16');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (137, NULL, 64, '', '', '', '', '', 'yes', '2024-11-13', 1, 2, '2024-11-13 13:21:53');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (138, NULL, 61, '', '', '', '', '', 'yes', '2024-11-14', 1, 2, '2024-11-14 06:53:48');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (141, NULL, 69, '', '', '', '', '  ', 'yes', '2024-11-15', 1, 2, '2024-11-15 11:01:01');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (142, NULL, 68, '', '', '', '', '', 'yes', '2024-11-15', 1, 2, '2024-11-15 11:36:11');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (143, NULL, 67, '173167066912649539626737328dc5e29.jpg', 'test.jpg', '<p>test</p>', '<p>test</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.  ', 'yes', '2024-11-15', 1, 2, '2024-11-15 11:53:40');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (144, NULL, 70, '', '', '', '', '   ', 'yes', '2024-11-15', 1, 2, '2024-11-15 12:03:03');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (145, NULL, 71, '', '', '', '', '', 'yes', '2024-11-15', 1, 2, '2024-11-15 12:36:11');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (146, NULL, 66, '', '', '<p>test</p>', '', '', 'yes', '2024-11-15', 1, 2, '2024-11-15 12:37:57');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (147, NULL, 72, '', '', '<p>test test&nbsp; test test test test test test test test test test test test test test&nbsp;</p>', '', '', 'yes', '2024-11-15', 1, 2, '2024-11-15 12:38:57');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (148, NULL, 73, '', '', '<p>test</p>', '<p>test</p>', '', 'yes', '2024-11-15', 1, 2, '2024-11-15 12:42:25');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (149, NULL, 74, '', '', '<p>test test test test test test test test test test</p>', '<p>\r\n\r\ntest test test test test test test test test test\r\n\r\n<br></p>', '             ', 'yes', '2024-11-16', 1, 2, '2024-11-16 05:52:42');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (150, NULL, 75, '', '', '<p>test</p>', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.           ', 'yes', '2024-11-16', 1, 2, '2024-11-16 07:55:33');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (151, NULL, 76, '', '', '<p><i>kiran</i></p>', '<p>\r\n\r\nkiran\r\n\r\n<br></p>', 'Damaged Hair\r\nDamaged Hair	        ', 'yes', '2024-11-16', 1, 2, '2024-11-16 11:30:02');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (152, NULL, 59, '', '', '<p>hello world how are you</p>', '<p>test test test test test test test</p>', '    ', 'yes', '2024-11-16', 1, 2, '2024-11-16 11:44:19');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (153, NULL, 77, '', '', '<p>salman khan test&nbsp;\r\n\r\nsalman khan test\r\n\r\n</p>', '<p>\r\n\r\nsalman khan test&nbsp;\r\n\r\nsalman khan test\r\n\r\n<br></p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.  \r\nOsteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.         ', 'yes', '2024-11-16', 1, 2, '2024-11-16 12:29:23');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (154, NULL, 78, '', '', '', '', '', 'yes', '2024-11-16', 1, 2, '2024-11-16 12:30:30');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (164, NULL, 80, '', '', '<p>test 1 test 2</p>', '<p>test 1 test 2</p>', '          ', 'yes', '2024-11-18', 1, 2, '2024-11-18 07:14:47');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (165, NULL, 81, '', '', '<p>test 123</p>', '<p>\r\n\r\ntest 123\r\n\r\n<br></p>', '             ', 'yes', '2024-11-18', 1, 2, '2024-11-18 07:23:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (166, NULL, 82, '', '', '', '', '    ', 'yes', '2024-11-18', 1, 2, '2024-11-18 09:15:11');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (167, NULL, 83, '', '', '', '', '  ', 'yes', '2024-11-18', 1, 2, '2024-11-18 09:27:16');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (169, NULL, 79, '', '', '', '', '', 'yes', '2024-11-18', 1, 2, '2024-11-18 09:24:29');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (172, NULL, 85, '', '', '', '', '', 'yes', '2024-11-18', 1, 2, '2024-11-18 10:40:06');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (173, NULL, 86, '', '', '', '', '', 'yes', '2024-11-18', 1, 2, '2024-11-18 10:43:53');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (174, NULL, 84, '', '', '<p>test</p>', '', '', 'yes', '2024-11-19', 1, 2, '2024-11-19 05:20:13');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (175, NULL, 87, '', '', '', '', '', 'yes', '2024-11-19', 1, 2, '2024-11-19 05:29:07');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (176, NULL, 88, '', '', '', '', '', 'yes', '2024-11-19', 1, 2, '2024-11-19 05:32:55');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (177, NULL, 89, '', '', '', '', '          ', 'yes', '2024-11-19', 1, 2, '2024-11-19 06:02:01');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (178, NULL, 90, '', '', '<p>test test test test test</p>', '<p>test test test</p>', '        ', 'yes', '2024-11-19', 1, 2, '2024-11-19 07:26:13');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (179, NULL, 91, '', '', '<p>tset</p>', '', '      ', 'yes', '2024-11-19', 1, 8, '2024-11-19 07:17:23');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (180, NULL, 92, '', '', '', '', '       ', 'yes', '2024-11-19', 1, 8, '2024-11-19 08:00:57');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (181, NULL, 95, '', '', '', '', '   ', 'yes', '2024-11-19', 1, 2, '2024-11-19 07:42:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (182, NULL, 96, '', '', '', '', '   ', 'yes', '2024-11-19', 1, 2, '2024-11-19 07:46:14');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (183, NULL, 55, '', '', '<p>test test test test test</p>', '<p>test test test</p>', '     ', 'yes', '2024-11-19', 1, 2, '2024-11-19 08:00:01');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (184, NULL, 97, '', '', '', '', '   ', 'yes', '2024-11-19', 1, 2, '2024-11-19 08:03:52');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (185, NULL, 98, '', '', '', '', '     ', 'yes', '2024-11-19', 1, 2, '2024-11-19 08:06:54');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (189, NULL, 99, '', '', '', '', '       ', 'yes', '2024-11-19', 1, 8, '2024-11-19 09:21:49');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (190, NULL, 100, '', '', '', '', '   ', 'yes', '2024-11-19', 1, 8, '2024-11-19 09:25:36');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (191, NULL, 101, '', '', '', '', '      ', 'yes', '2024-11-19', 1, 2, '2024-11-19 09:31:56');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (192, NULL, 103, '', '', '<p>add</p>', '<p>add</p>', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both. \r\n\r\nEczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.\r\nDamaged Hair\r\nDamaged Hair	 ', 'yes', '2024-11-21', 1, 2, '2024-11-21 05:44:51');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (194, NULL, 57, '', '', '', '', 'Damaged Hair\r\nDamaged Hair	', 'yes', '2024-11-20', 2, 2, '2024-11-20 13:07:16');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (195, NULL, 105, '', '', '<p>TEST TEST TEST TEST</p>', '<p>TEST TEST TEST TEST TEST TEST</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-21', 1, 8, '2024-11-21 05:46:39');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (196, NULL, 106, '', '', '', '', '  ', 'yes', '2024-11-21', 1, 8, '2024-11-21 12:41:52');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (197, NULL, 108, '', '', '', '', '  ', 'yes', '2024-11-21', 1, 8, '2024-11-21 10:40:04');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (199, NULL, 109, '17321873091486610863673f14ad9486a.docx', 'Audit Trail Test Report.docx', '', '', '      ', 'yes', '2024-11-21', 1, 8, '2024-11-21 11:28:01');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (200, NULL, 44, '', '', '<p>test</p>', '<p>test</p>', '', 'yes', '2024-11-21', 1, 2, '2024-11-21 11:40:51');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (201, NULL, 14, '', '', '', '', '', 'yes', '2024-11-21', 1, 2, '2024-11-21 11:43:44');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (202, NULL, 110, '', '', '<p>ha ha ha ha</p>', '<p>test</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-21', 1, 2, '2024-11-21 12:51:29');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (203, NULL, 111, '', '', '', '', ' ', 'yes', '2024-11-21', 1, 8, '2024-11-21 13:14:05');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (206, NULL, 112, '1732513398174413817867440e76d0c24.png', 'K.png', '<p>te</p>', '<p>test</p>', '', 'yes', '2024-11-25', 1, 2, '2024-11-25 05:43:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (207, NULL, 113, '', '', '<p>ggd</p>', '<p>fdg</p>', '', 'yes', '2024-11-25', 1, 2, '2024-11-25 05:44:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (208, NULL, 114, '', '', '', '', '', 'yes', '2024-11-25', 1, 8, '2024-11-25 06:01:03');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (209, NULL, 26, '1732514464-374857400674412a0597a9!Error.jpg', 'Error.jpg', '<p>sfsf</p>', '<p>sdfsf</p>', '', 'yes', '2024-11-25', 1, 2, '2024-11-25 06:01:04');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (210, NULL, 16, '1732514513-45177836674412d1a6285!tset.png', 'tset.png', '<p>test</p>', '', '', 'yes', '2024-11-25', 1, 2, '2024-11-25 06:01:53');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (211, NULL, 15, '1732514803-1261813990674413f337050!images (1) (1).jpg', 'images (1) (1).jpg', '<p>test</p>', '', '', 'yes', '2024-11-25', 1, 2, '2024-11-25 06:06:43');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (212, NULL, 116, '', '', '', '', '', 'yes', '2024-11-25', 1, 8, '2024-11-25 06:15:20');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (213, NULL, 117, '1732515539-1742318390674416d3037c8!K (1).png', 'K (1).png', '<p>est</p>', '', '', 'yes', '2024-11-25', 1, 2, '2024-11-25 06:18:59');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (214, NULL, 118, '1732518371-624763118674421e3e5275!aa.jpg', 'aa.jpg', '', '', '', 'yes', '2024-11-25', 1, 8, '2024-11-25 07:06:11');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (215, NULL, 119, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-25', 7, 8, '2024-11-25 08:51:23');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (218, NULL, 47, '1732526812-988692469674442dc1b222!s.png', 's.png', '<p>test test test test tes</p>', '<p>test test test test</p>', '', 'yes', '2024-11-25', 1, 8, '2024-11-25 09:26:52');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (219, NULL, 120, '1732527241-8799547446744448928210!ss.jpg', 'ss.jpg', '<p>hhhhhhhhhhhh</p>', '<p>hh</p>', ' ', 'yes', '2024-11-25', 1, 2, '2024-11-25 09:34:01');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (221, NULL, 121, '', '', '<p>add</p>', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-11-25', 1, 8, '2024-11-25 09:51:57');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (222, NULL, 122, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-25', 7, 2, '2024-11-25 10:41:45');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (223, NULL, 104, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-25', 7, 2, '2024-11-25 10:43:44');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (224, 13, NULL, '', '', '', '', 'Elevated temperature (above 100.4°)\r\nThe medical community generally defines a fever as a body temperature above 100.4 degrees Fahrenheit. ', 'yes', '2024-11-25', 7, 2, '2024-11-25 10:52:20');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (225, NULL, 124, '', '', '<p>add</p>', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-25', 1, 2, '2024-11-25 11:23:13');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (227, NULL, 125, '', '', '<p>add</p>', '', '', 'yes', '2024-11-25', 1, 2, '2024-11-25 12:56:27');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (228, NULL, 128, '1732607280-117158762767457d3083526!Your Hospital Name (57).png', 'Your Hospital Name (57).png', '<p>add</p>', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both. ', 'yes', '2024-11-26', 1, 2, '2024-11-26 07:58:58');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (229, NULL, 133, '', '', '', '', ' ', 'yes', '2024-11-26', 1, 2, '2024-11-26 09:11:10');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (232, 13, NULL, '', '', '', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-11-26', 1, 2, '2024-11-26 10:34:37');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (233, NULL, 142, '1732619636-18946691276745ad74c5aac!test.jpg', 'test.jpg', '<p>fdgfdg</p>', '<p>dgd</p>', '  ', 'yes', '2024-11-26', 1, 8, '2024-11-26 11:13:56');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (235, NULL, 145, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-11-28', 1, 2, '2024-11-28 07:19:31');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (236, NULL, 146, '1732783752-164507390767482e889ad3a!png (26)', 'png (26)', '<p>add</p>', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2024-11-28', 1, 2, '2024-11-28 08:49:12');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (241, NULL, 151, '', '', '<p>add</p>', '', '', 'yes', '2024-11-29', 1, 2, '2024-11-29 12:56:55');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (242, NULL, 152, '1732954556-1191843097674ac9bc15ac8!Your Hospital Name (3).webm', 'Your Hospital Name (3).webm', '<p>add</p>', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', 'yes', '2024-11-30', 1, 2, '2024-11-30 08:18:05');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (247, 13, NULL, '', '', '', '', '', 'yes', '2024-12-02', 1, 2, '2024-12-02 09:43:58');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (248, NULL, 155, '', '', '', '', ' ', 'yes', '2024-12-02', 1, 2, '2024-12-02 12:25:42');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (249, NULL, 159, '1733209732-875805301674eae84af893!Upload image  (2).txt', 'Upload image  (2).txt', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', 'yes', '2024-12-03', 1, 2, '2024-12-03 07:09:35');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (250, NULL, 160, '1733210166-1844773517674eb036024c2!Upload image  (2) (1).txt', 'Upload image  (2) (1).txt', '<p>add</p>', '', '\r\nDamaged Hair	', 'yes', '2024-12-03', 1, 2, '2024-12-03 07:16:06');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (251, NULL, 162, '1733211686-717924814674eb626bcc04!Your Hospital Name (79) (1).png', 'Your Hospital Name (79) (1).png', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', 'yes', '2024-12-03', 1, 8, '2024-12-03 07:52:34');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (252, NULL, 161, '', '', '<p>fdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfd</p>', '<p>fdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfdfd</p>', ' ', 'yes', '2024-12-03', 1, 8, '2024-12-03 08:19:13');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (254, NULL, 167, '1733219147-1110370764674ed34b4555f!tset (1) (1).png', 'tset (1) (1).png', '<p>yry yr yr yr yrd yrdy yrdy yyrdy</p>', '', '     ', 'yes', '2024-12-03', 1, 2, '2024-12-03 09:49:55');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (255, NULL, 153, '', '', '<p>TEST TEST TEST TEST TES TEST TEST TEST TEST TST TEST TESTT</p>', '<p>TES</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-12-03', 1, 2, '2024-12-03 09:45:28');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (258, NULL, 158, '1733220685-1857750645674ed94d11391!tset (1) (1) (1).png', 'tset (1) (1) (1).png', '', '', ' ', 'yes', '2024-12-03', 1, 2, '2024-12-03 10:11:44');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (259, NULL, 180, '1733388611-116860964675169431a4c9!7 (1) (2) (1).jpg', '7 (1) (2) (1).jpg', '<p>add</p>', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2024-12-05', 1, 2, '2024-12-05 08:50:11');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (260, NULL, 188, '1740738522-142884765367c18fdabdcaf!14.JPG', '14.JPG', '<p>testing</p>', '', '', 'yes', '2025-02-28', 1, 2, '2025-02-28 10:28:42');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (261, NULL, 189, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.  ', 'yes', '2025-02-28', 1, 8, '2025-02-28 12:18:13');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (264, NULL, 201, '', '', '', '', '', 'yes', '2025-03-07', 2, 8, '2025-03-07 11:28:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (265, NULL, 205, '1741423249-20878767367cc0291bf9d9!3.JPG', '3.JPG', '', '<p>add</p>', ' \r\nEczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-03-08', 1, 2, '2025-03-08 08:44:21');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (266, NULL, 202, '', '', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-03-08', 1, 8, '2025-03-08 08:41:28');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (268, NULL, 214, '1741594634-54595949967cea00ae8466!ki (1) (1) (1) (2).jpg', 'ki (1) (1) (1) (2).jpg', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-03-10', 1, 8, '2025-03-10 08:17:14');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (272, NULL, 223, '1741764061-156249318567d135ddad13b!WhatsApp Image 2025-03-11 at 16.45.59.jpeg', 'WhatsApp Image 2025-03-11 at 16.45.59.jpeg', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.  ', 'yes', '2025-03-12', 1, 2, '2025-03-12 08:08:26');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (273, NULL, 240, '', '', '', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2025-03-19', 1, 8, '2025-03-19 10:53:16');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (274, NULL, 241, '', '', '<p>test</p>', '', '', 'yes', '2025-03-19', 1, 2, '2025-03-19 10:54:05');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (275, NULL, 254, '1742469996-124254383367dbfb6c1b359!Your-Hospital-Name-03-20-2025_04_40_PM.png', 'Your-Hospital-Name-03-20-2025_04_40_PM.png', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', 'yes', '2025-03-20', 1, 2, '2025-03-20 11:26:52');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (277, NULL, 249, '1742471138-149775847467dbffe2410aa!4.JPG', '4.JPG', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-03-20', 1, 2, '2025-03-20 11:45:38');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (278, NULL, 253, '1742540589-43296614567dd0f2d652e7!WhatsApp Image 2025-03-20 at 17.55.51.jpeg', 'WhatsApp Image 2025-03-20 at 17.55.51.jpeg', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-03-21', 1, 2, '2025-03-21 07:03:09');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (280, NULL, 263, '1743839132-153329449467f0df9c45598!tset (3) (1) (2) (4).png', 'tset (3) (1) (2) (4).png', '', '<p>add</p>', '', 'yes', '2025-04-05', 1, 2, '2025-04-05 07:45:32');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (281, NULL, 264, '', '', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-04-05', 1, 2, '2025-04-05 08:26:42');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (284, NULL, 272, '', '', '', '', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2025-04-10', 1, 2, '2025-04-10 08:01:40');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (285, NULL, 275, '1744371284-59816280267f8fe5456f16!1714739908.jpg', '1714739908.jpg', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-04-11', 1, 2, '2025-04-11 11:34:44');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (288, NULL, 290, '', '', '<p>test</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-04-14', 1, 2, '2025-04-14 08:06:09');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (289, NULL, 291, '1744620033-213476335267fcca0178fc5!Capture.PNG', 'Capture.PNG', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-04-14', 1, 2, '2025-04-14 08:40:33');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (292, NULL, 296, '', '', '', '', ' ', 'yes', '2025-04-16', 1, 8, '2025-04-16 07:43:16');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (295, NULL, 302, '', '', '<p>header</p>', '<p>footer</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', 'yes', '2025-04-21', 1, 8, '2025-04-21 07:27:46');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (296, NULL, 303, '1745220936-10942894066805f548a2695!1(1).png', '1(1).png', '', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-04-21', 1, 8, '2025-04-21 07:35:36');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (301, NULL, 306, '', '', '', '', '   ', 'yes', '2025-04-25', 1, 8, '2025-04-25 06:22:18');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (302, NULL, 307, '1745406466-3721625516808ca029ab82!K.png', 'K.png', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-04-23', 1, 8, '2025-04-23 11:07:46');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (305, NULL, 313, '', '', '', '', ' \r\nEczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-04-25', 1, 8, '2025-04-25 06:19:48');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (306, NULL, 316, '', '', '', '', ' ', 'yes', '2025-04-25', 1, 2, '2025-04-25 11:06:05');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (307, NULL, 314, '', '', '', '', '', 'yes', '2025-04-25', 1, 2, '2025-04-25 11:01:43');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (308, NULL, 317, '1745652792-1345373916680c8c38c6920!WhatsApp Image 2025-04-21 at 22.44.11.jpeg', 'WhatsApp Image 2025-04-21 at 22.44.11.jpeg', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-04-26', 1, 2, '2025-04-26 07:33:12');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (309, NULL, 318, '1745656077-1484316142680c990d6c684!image.png', 'image.png', '<p>add</p>', '<p>ass</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress. ', 'yes', '2025-04-26', 1, 2, '2025-04-26 08:31:45');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (311, NULL, 321, '', '', '', '', '', 'yes', '2025-04-26', 1, 2, '2025-04-26 17:50:41');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (313, NULL, 320, '', '', '', '', '', 'yes', '2025-04-28', 1, 2, '2025-04-28 07:39:32');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (316, NULL, 325, '', '', '', '', '', 'yes', '2025-04-29', 1, 2, '2025-04-29 05:19:22');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (318, NULL, 323, '', '', '', '', ' ', 'yes', '2025-04-29', 1, 2, '2025-04-29 07:15:01');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (319, NULL, 326, '', '', '', '', '', 'yes', '2025-04-29', 1, 2, '2025-04-29 07:17:40');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (320, NULL, 327, '', '', '', '', '', 'yes', '2025-04-29', 1, 2, '2025-04-29 09:29:37');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (321, NULL, 329, '', '', '', '', '', 'yes', '2025-05-01', 1, 2, '2025-05-01 11:00:50');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (323, NULL, 331, '1746256316-4670086076815c1bcb32a9!fevicon.PNG', 'fevicon.PNG', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-05-03', 1, 2, '2025-05-03 07:11:56');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (324, NULL, 332, '1746258388-1344066386815c9d4a7bc7!08.PNG', '08.PNG', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-05-03', 1, 2, '2025-05-03 07:46:28');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (327, NULL, 347, '', '', '<p>dsfsf</p>', '<p>SD</p>', '', 'yes', '2025-05-06', 1, 2, '2025-05-06 06:40:46');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (328, NULL, 354, '', '', '<p>add</p>', '<p>add</p>', 'Osteoporosis\r\nBone density problems may occur because the body loses too much bone tissue, makes too little of it, or some combination of both.', 'yes', '2025-05-07', 1, 2, '2025-05-07 09:32:57');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (329, 51, NULL, '1746613757-1381584681b35fd8b106!Capture.PNG', 'Capture.PNG', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-05-07', 1, 2, '2025-05-07 10:29:17');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (330, NULL, 358, '1746793163-734168509681df2cbef6f7!Smart-Hospital-05-08-2025_05_40_PM (1).png', 'Smart-Hospital-05-08-2025_05_40_PM (1).png', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.  ', 'yes', '2025-05-09', 1, 2, '2025-05-09 12:24:10');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (331, 56, NULL, '1746861660-147420826681efe5c18863!8.PNG', '8.PNG', '<p>note</p>', '<p>add</p>', 'fevers\r\n ', 'yes', '2025-05-10', 1, 2, '2025-05-10 07:21:58');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (332, 56, NULL, '1747024234-3484946076821796aa86b0!(4) (2).jpg', '(4) (2).jpg', '', '', '', 'yes', '2025-05-12', 1, 2, '2025-05-12 04:30:34');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (334, NULL, 372, '', '', '', '', ' ', 'yes', '2025-05-14', 1, 2, '2025-05-14 11:31:28');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (335, NULL, 375, '1747299662-16530343606825ad4ed9efa!Smart-Hospital-05-10-2025_01_05_PM (1) (1).png', 'Smart-Hospital-05-10-2025_01_05_PM (1) (1).png', '<p>add</p>', '<p>add</p>', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.  ', 'yes', '2025-05-15', 1, 2, '2025-05-15 09:01:02');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (336, NULL, 376, '1747299866-17675024736825ae1a14902!Smart-Hospital-05-10-2025_01_05_PM (1).png', 'Smart-Hospital-05-10-2025_01_05_PM (1).png', '<p>add</p>', '', 'Eczema.\r\nEczema (atopic dermatitis) is caused by a combination of immune system activation, genetics, environmental triggers and stress.', 'yes', '2025-05-15', 1, 2, '2025-05-15 09:04:26');
INSERT INTO `ipd_prescription_basic` (`id`, `ipd_id`, `visit_details_id`, `attachment`, `attachment_name`, `header_note`, `footer_note`, `finding_description`, `is_finding_print`, `date`, `generated_by`, `prescribe_by`, `created_at`) VALUES (337, 59, NULL, '1747308368-18687168286825cf50c7e3e!Smart-Hospital-05-15-2025_02_58_PM.png', 'Smart-Hospital-05-15-2025_02_58_PM.png', '<p>add</p>', '', 'fevers\r\n ', 'yes', '2025-05-15', 1, 2, '2025-05-15 11:26:08');


#
# TABLE STRUCTURE FOR: ipd_prescription_details
#

DROP TABLE IF EXISTS `ipd_prescription_details`;

CREATE TABLE `ipd_prescription_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `basic_id` int DEFAULT NULL,
  `pharmacy_id` int DEFAULT NULL,
  `dosage` int DEFAULT NULL,
  `dose_interval_id` int DEFAULT NULL,
  `dose_duration_id` int DEFAULT NULL,
  `instruction` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `basic_id` (`basic_id`),
  KEY `pharmacy_id` (`pharmacy_id`),
  KEY `index_dosage` (`dosage`),
  KEY `index_dose_interval_id` (`dose_interval_id`),
  KEY `index_dose_duration_id` (`dose_duration_id`),
  CONSTRAINT `ipd_prescription_details_ibfk_1` FOREIGN KEY (`basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_2` FOREIGN KEY (`pharmacy_id`) REFERENCES `pharmacy` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_3` FOREIGN KEY (`dose_interval_id`) REFERENCES `dose_interval` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_details_ibfk_4` FOREIGN KEY (`dose_duration_id`) REFERENCES `dose_duration` (`id`) ON DELETE CASCADE ON UPDATE RESTRICT
) ENGINE=InnoDB AUTO_INCREMENT=496 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (31, 31, 1, 1, 2, NULL, '', '2024-10-09 10:21:50');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (34, 34, 3, 2, 2, NULL, '', '2024-10-28 12:47:21');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (78, 85, 8, 5, 5, 2, '324', '2024-11-04 11:57:06');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (109, 119, 3, 2, 2, NULL, '', '2024-11-11 12:14:42');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (110, 120, 1, 1, NULL, NULL, 'test', '2024-11-11 12:23:17');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (111, 122, 1, 1, NULL, NULL, '', '2024-11-11 12:29:31');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (114, 125, 3, 2, 5, 5, '', '2024-11-12 10:13:48');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (119, 85, 2, 1, 2, 5, '123', '2024-11-12 10:26:35');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (132, 136, 1, 1, 3, NULL, '', '2024-11-13 13:21:16');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (133, 137, 1, 1, 2, NULL, '', '2024-11-13 13:21:53');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (137, 141, 3, 2, 2, NULL, '', '2024-11-15 10:58:14');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (156, 150, 1, 1, 2, 2, '', '2024-11-16 07:55:33');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (157, 150, 3, 2, 3, NULL, '', '2024-11-16 07:55:33');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (161, 151, 8, 5, 5, 5, 'fsfdsfsf', '2024-11-16 11:30:02');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (172, 153, 1, 1, 2, 2, 'test 6', '2024-11-16 12:28:56');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (204, 164, 3, 2, 3, 2, 'test 4', '2024-11-18 07:14:20');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (217, 166, 1, 1, 2, NULL, '', '2024-11-18 09:14:44');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (218, 166, 8, 5, 5, NULL, '', '2024-11-18 09:14:44');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (246, 174, 8, 5, 2, 2, 'test 2', '2024-11-19 05:20:13');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (260, 177, 2, 4, 5, 3, 'test 2', '2024-11-19 05:58:31');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (265, 178, 1, 1, 2, 3, 'tset 1', '2024-11-19 06:04:04');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (288, 179, 3, 2, 2, 2, '', '2024-11-19 07:17:23');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (289, 179, 8, 5, 2, 2, '', '2024-11-19 07:17:23');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (304, 181, 8, 5, 3, 2, '', '2024-11-19 07:42:31');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (305, 182, 3, 2, 2, 2, '', '2024-11-19 07:43:29');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (340, 189, 1, 1, 3, 3, '', '2024-11-19 09:21:49');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (346, 191, 3, 2, 3, 5, '', '2024-11-19 09:31:35');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (352, 196, 1, 1, 3, 3, '', '2024-11-21 09:29:12');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (353, 196, 3, 2, 3, NULL, '', '2024-11-21 09:29:12');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (355, 196, 8, 5, 3, NULL, '', '2024-11-21 09:29:12');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (356, 196, 3, 2, 6, NULL, '', '2024-11-21 09:29:12');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (357, 196, 1, 1, 3, NULL, '', '2024-11-21 09:30:31');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (358, 196, 3, 2, 2, NULL, '', '2024-11-21 09:30:31');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (360, 197, 1, 1, 2, NULL, '', '2024-11-21 09:37:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (361, 197, 3, 2, 3, NULL, '', '2024-11-21 09:37:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (371, 199, 1, 1, 2, NULL, '', '2024-11-21 11:00:20');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (372, 199, 8, 5, 5, NULL, '', '2024-11-21 11:00:20');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (374, 199, 4, 2, 2, 2, '', '2024-11-21 11:00:20');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (377, 199, 3, 2, 2, NULL, '', '2024-11-21 11:03:07');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (379, 199, 3, 2, 2, NULL, '', '2024-11-21 11:04:11');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (381, 199, 1, 1, 3, NULL, '', '2024-11-21 11:08:29');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (382, 199, 3, 2, 2, NULL, '', '2024-11-21 11:08:29');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (389, 203, 1, 1, 3, NULL, '', '2024-11-21 13:08:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (390, 203, 3, 2, 3, NULL, '', '2024-11-21 13:08:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (391, 203, 1, 1, 3, NULL, '', '2024-11-21 13:08:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (392, 203, 3, 2, 3, NULL, '', '2024-11-21 13:08:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (393, 203, 1, 1, 3, NULL, '', '2024-11-21 13:08:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (394, 203, 3, 2, 2, NULL, '', '2024-11-21 13:08:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (395, 203, 1, 1, 3, NULL, '', '2024-11-21 13:14:05');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (399, 215, 3, 2, 3, 2, '2', '2024-11-25 08:51:23');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (413, 228, 3, 2, 3, 2, '2', '2024-11-26 07:58:58');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (424, 241, 3, 2, 3, 2, '2', '2024-11-29 12:56:55');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (437, 260, 3, 2, 2, 2, '', '2025-02-28 10:28:42');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (439, 261, 3, 2, 2, 2, '', '2025-02-28 10:29:38');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (444, 264, 1, 1, 2, 2, '', '2025-03-07 11:28:18');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (445, 264, 4, 2, 2, 2, '', '2025-03-07 11:28:18');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (446, 264, 4, 2, 3, 2, '', '2025-03-07 11:28:18');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (448, 264, 8, 5, 7, 2, '', '2025-03-07 11:28:18');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (449, 265, 3, 2, 2, 2, '', '2025-03-08 08:40:49');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (450, 265, 1, 1, 3, 3, '', '2025-03-08 08:40:49');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (452, 266, 1, 1, 2, 2, '', '2025-03-08 08:41:28');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (454, 268, 4, 2, 3, 3, '', '2025-03-10 08:17:14');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (458, 272, 1, 1, 2, 2, '', '2025-03-12 07:21:01');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (459, 272, 4, 2, 7, 5, '', '2025-03-12 07:39:54');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (461, 273, 1, 1, 2, 2, '12345', '2025-03-19 10:53:16');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (462, 274, 1, 1, 2, NULL, '', '2025-03-19 10:54:05');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (463, 275, 1, 1, 2, 2, '', '2025-03-20 11:26:36');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (465, 277, 1, 1, 2, 2, '', '2025-03-20 11:45:38');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (466, 278, 1, 1, 2, 2, '', '2025-03-21 07:03:09');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (468, 280, 3, 2, 2, NULL, '', '2025-04-05 07:45:32');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (469, 281, 3, 2, 2, 2, '', '2025-04-05 08:26:42');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (473, 284, 8, 5, 6, 7, '', '2025-04-10 08:01:40');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (474, 285, 1, 4, 2, 2, '', '2025-04-11 11:34:44');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (476, 288, 4, 2, 2, 2, '', '2025-04-14 08:06:09');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (477, 289, 1, 4, 3, 2, '', '2025-04-14 08:40:33');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (487, 292, 18, 2, 2, 5, '', '2025-04-16 07:43:16');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (489, 292, 16, 5, 6, 5, '', '2025-04-16 07:43:16');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (493, 295, 3, 2, 3, NULL, '', '2025-04-21 07:27:46');
INSERT INTO `ipd_prescription_details` (`id`, `basic_id`, `pharmacy_id`, `dosage`, `dose_interval_id`, `dose_duration_id`, `instruction`, `created_at`) VALUES (495, 296, 3, 2, 6, 3, '', '2025-04-21 07:35:36');


#
# TABLE STRUCTURE FOR: ipd_prescription_test
#

DROP TABLE IF EXISTS `ipd_prescription_test`;

CREATE TABLE `ipd_prescription_test` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ipd_prescription_basic_id` int DEFAULT NULL,
  `pathology_id` int DEFAULT NULL,
  `radiology_id` int DEFAULT NULL,
  `created_at` datetime DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `ipd_prescription_basic_id` (`ipd_prescription_basic_id`),
  KEY `pathology_id` (`pathology_id`),
  KEY `radiology_id` (`radiology_id`),
  CONSTRAINT `ipd_prescription_test_ibfk_1` FOREIGN KEY (`ipd_prescription_basic_id`) REFERENCES `ipd_prescription_basic` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_2` FOREIGN KEY (`pathology_id`) REFERENCES `pathology` (`id`) ON DELETE CASCADE,
  CONSTRAINT `ipd_prescription_test_ibfk_3` FOREIGN KEY (`radiology_id`) REFERENCES `radio` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=282 DEFAULT CHARSET=utf8mb3;

INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (10, 18, 4, NULL, '2024-10-08 10:41:57');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (21, 24, 4, NULL, '2024-10-09 10:01:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (23, 25, 4, NULL, '2024-10-09 10:01:43');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (25, 26, 4, NULL, '2024-10-09 10:01:51');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (27, 27, 4, NULL, '2024-10-09 10:01:54');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (29, 28, 4, NULL, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (31, 29, 4, NULL, '2024-10-09 10:01:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (33, 30, 4, NULL, '2024-10-09 10:04:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (37, 32, 4, NULL, '2024-10-16 07:10:24');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (41, 34, 4, NULL, '2024-10-28 12:47:21');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (45, 36, 4, NULL, '2024-10-28 12:57:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (47, 38, 4, NULL, '2024-10-29 09:12:16');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (49, 39, 4, NULL, '2024-10-29 09:27:08');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (50, 56, 4, NULL, '2024-10-29 09:42:35');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (52, 57, 5, NULL, '2024-10-29 09:47:47');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (56, 59, 4, NULL, '2024-10-30 09:39:06');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (78, 87, 4, NULL, '2024-11-04 12:01:45');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (79, 88, 5, NULL, '2024-11-04 12:52:54');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (80, 89, 5, NULL, '2024-11-05 11:46:55');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (82, 91, 4, NULL, '2024-11-05 11:54:54');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (83, 92, 4, NULL, '2024-11-05 11:54:54');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (84, 101, 4, NULL, '2024-11-05 12:06:37');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (86, 105, 4, NULL, '2024-11-07 11:31:15');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (90, 109, 4, NULL, '2024-11-11 12:12:30');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (92, 119, 4, NULL, '2024-11-11 12:14:42');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (94, 120, 4, NULL, '2024-11-11 12:23:17');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (96, 121, 4, NULL, '2024-11-11 12:29:03');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (100, 85, 4, NULL, '2024-11-12 10:50:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (106, 132, 4, NULL, '2024-11-13 08:34:05');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (108, 143, 4, NULL, '2024-11-15 11:53:40');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (109, 144, 5, NULL, '2024-11-15 12:02:45');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (110, 145, 5, NULL, '2024-11-15 12:36:11');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (111, 146, 6, NULL, '2024-11-15 12:37:57');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (112, 147, 4, NULL, '2024-11-15 12:38:57');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (113, 148, 6, NULL, '2024-11-15 12:42:25');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (116, 149, 5, NULL, '2024-11-16 05:52:42');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (121, 151, 6, NULL, '2024-11-16 11:29:09');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (122, 152, 6, NULL, '2024-11-16 11:44:19');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (125, 153, 6, NULL, '2024-11-16 12:28:08');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (127, 154, 6, NULL, '2024-11-16 12:30:30');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (142, 164, 6, NULL, '2024-11-18 07:13:01');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (152, 166, 5, NULL, '2024-11-18 09:13:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (154, 169, 5, NULL, '2024-11-18 09:24:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (158, 173, 5, NULL, '2024-11-18 10:43:53');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (161, 179, 6, NULL, '2024-11-19 07:14:16');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (163, 184, 6, NULL, '2024-11-19 08:03:21');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (165, 185, 6, NULL, '2024-11-19 08:05:26');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (169, 189, 6, NULL, '2024-11-19 09:21:33');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (172, 192, 5, NULL, '2024-11-20 13:02:24');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (173, 192, NULL, 5, '2024-11-20 13:02:24');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (176, 195, 5, NULL, '2024-11-21 05:46:39');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (177, 199, 5, NULL, '2024-11-21 10:57:53');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (178, 200, 6, NULL, '2024-11-21 11:40:51');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (179, 201, 5, NULL, '2024-11-21 11:43:44');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (180, 202, 6, NULL, '2024-11-21 12:51:29');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (183, 206, 6, NULL, '2024-11-25 05:43:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (185, 208, 5, NULL, '2024-11-25 06:01:03');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (186, 209, 5, NULL, '2024-11-25 06:01:04');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (187, 210, 5, NULL, '2024-11-25 06:01:53');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (189, 212, 5, NULL, '2024-11-25 06:15:20');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (190, 213, 6, NULL, '2024-11-25 06:18:59');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (191, 214, 5, NULL, '2024-11-25 07:06:11');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (192, 215, 5, NULL, '2024-11-25 08:51:23');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (193, 215, NULL, 5, '2024-11-25 08:51:23');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (196, 218, 5, NULL, '2024-11-25 09:26:52');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (197, 219, 5, NULL, '2024-11-25 09:30:03');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (199, 221, 4, NULL, '2024-11-25 09:51:57');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (200, 221, NULL, 4, '2024-11-25 09:51:57');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (201, 222, 5, NULL, '2024-11-25 10:41:45');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (202, 222, NULL, 4, '2024-11-25 10:41:45');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (203, 223, 4, NULL, '2024-11-25 10:43:44');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (204, 223, NULL, 4, '2024-11-25 10:43:44');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (205, 224, 5, NULL, '2024-11-25 10:52:20');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (206, 224, NULL, 4, '2024-11-25 10:52:20');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (208, 227, 4, NULL, '2024-11-25 12:56:27');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (209, 227, NULL, 4, '2024-11-25 12:56:27');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (210, 228, 5, NULL, '2024-11-26 07:48:00');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (211, 228, NULL, 4, '2024-11-26 07:48:00');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (212, 229, 5, NULL, '2024-11-26 08:02:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (213, 229, NULL, 4, '2024-11-26 08:02:50');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (218, 232, 5, NULL, '2024-11-26 10:34:37');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (219, 232, NULL, 4, '2024-11-26 10:34:37');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (220, 233, 6, NULL, '2024-11-26 10:52:51');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (222, 235, 5, NULL, '2024-11-28 07:19:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (223, 235, NULL, 5, '2024-11-28 07:19:31');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (224, 236, 5, NULL, '2024-11-28 08:49:12');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (225, 236, NULL, 5, '2024-11-28 08:49:12');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (232, 241, 5, NULL, '2024-11-29 12:56:55');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (233, 241, NULL, 4, '2024-11-29 12:56:55');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (238, 247, 5, NULL, '2024-12-02 09:43:58');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (239, 247, NULL, 5, '2024-12-02 09:43:58');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (240, 248, 6, NULL, '2024-12-02 12:25:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (241, 248, NULL, 4, '2024-12-02 12:25:34');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (242, 249, 5, NULL, '2024-12-03 07:08:52');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (244, 250, 6, NULL, '2024-12-03 07:16:06');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (246, 251, 6, NULL, '2024-12-03 07:41:26');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (247, 251, NULL, 4, '2024-12-03 07:41:26');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (248, 252, 6, NULL, '2024-12-03 08:19:01');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (253, 255, NULL, 4, '2024-12-03 09:45:28');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (256, 258, 5, NULL, '2024-12-03 10:11:25');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (257, 260, 4, NULL, '2025-02-28 10:28:42');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (258, 260, NULL, 9, '2025-02-28 10:28:42');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (259, 261, 6, NULL, '2025-02-28 10:29:38');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (261, 261, NULL, 7, '2025-02-28 10:31:57');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (262, 264, 6, NULL, '2025-03-07 11:28:18');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (263, 265, 5, NULL, '2025-03-08 08:40:49');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (266, 274, 5, NULL, '2025-03-19 10:54:05');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (267, 274, 10, NULL, '2025-03-19 10:54:05');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (268, 274, NULL, 7, '2025-03-19 10:54:05');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (271, 284, 5, NULL, '2025-04-10 08:01:40');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (272, 284, NULL, 7, '2025-04-10 08:01:40');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (275, 292, 5, NULL, '2025-04-15 11:44:16');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (280, 295, 5, NULL, '2025-04-21 07:26:06');
INSERT INTO `ipd_prescription_test` (`id`, `ipd_prescription_basic_id`, `pathology_id`, `radiology_id`, `created_at`) VALUES (281, 295, NULL, 14, '2025-04-21 07:26:06');


#
# TABLE STRUCTURE FOR: item
#

DROP TABLE IF EXISTS `item`;

CREATE TABLE `item` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_category_id` int DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `unit` varchar(200) NOT NULL,
  `item_photo` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `description` text,
  `quantity` int NOT NULL,
  `date` date DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `index_name` (`name`),
  KEY `index_unit` (`unit`),
  KEY `index_quantity` (`quantity`),
  KEY `index_date` (`date`),
  CONSTRAINT `item_ibfk_1` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (1, 1, 'cotton', '20-30', NULL, '', 0, NULL, '2024-09-30 13:00:45');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (2, 3, 'injection', '20', NULL, '', 0, NULL, '2024-10-05 09:09:44');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (3, 2, 'dr.OT dress', '10', NULL, '', 0, NULL, '2024-10-11 12:44:21');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (4, 4, 'All OT items', '50', NULL, '', 0, NULL, '2024-10-11 12:50:22');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (6, 3, 'injection rt', '100', NULL, '', 0, NULL, '2024-10-29 05:59:22');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (9, 1, 'COTTON', '4000', NULL, '', 0, NULL, '2025-03-03 11:28:59');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (10, 3, 'tesing', '2', NULL, '', 0, NULL, '2025-03-03 11:30:16');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (15, 4, 'Medical', '1000', NULL, '', 0, NULL, '2025-05-10 11:36:26');
INSERT INTO `item` (`id`, `item_category_id`, `name`, `unit`, `item_photo`, `description`, `quantity`, `date`, `created_at`) VALUES (16, 1, 'add item', '2', NULL, '', 0, NULL, '2025-05-13 09:16:26');


#
# TABLE STRUCTURE FOR: item_category
#

DROP TABLE IF EXISTS `item_category`;

CREATE TABLE `item_category` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_category` varchar(255) DEFAULT NULL,
  `is_active` varchar(10) NOT NULL DEFAULT 'yes',
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_item_category` (`item_category`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (1, 'cotten', 'yes', '', '2024-09-30 12:56:40');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (2, 'DR.drees', 'yes', '', '2024-09-30 12:56:40');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (3, 'sirenge', 'yes', '', '2024-09-30 12:56:40');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (4, 'equiepment', 'yes', '', '2024-11-20 08:07:39');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (5, 'hand glapes', 'yes', '', '2024-10-07 12:14:02');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (6, 'Microscopey', 'yes', 'mini', '2024-11-20 08:10:16');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (7, 'gloves', 'yes', 'all size', '2024-11-20 08:10:16');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (11, 'item', 'yes', '', '2025-04-17 12:23:48');
INSERT INTO `item_category` (`id`, `item_category`, `is_active`, `description`, `created_at`) VALUES (12, 'item2', 'yes', 'adding', '2025-05-01 10:44:00');


#
# TABLE STRUCTURE FOR: item_issue
#

DROP TABLE IF EXISTS `item_issue`;

CREATE TABLE `item_issue` (
  `id` int NOT NULL AUTO_INCREMENT,
  `issue_type` int DEFAULT NULL,
  `issue_to` int DEFAULT NULL,
  `issue_by` varchar(100) DEFAULT NULL,
  `issue_date` date DEFAULT NULL,
  `return_date` date DEFAULT NULL,
  `item_category_id` int DEFAULT NULL,
  `item_id` int DEFAULT NULL,
  `quantity` int NOT NULL,
  `note` text,
  `is_returned` int NOT NULL DEFAULT '1',
  `is_active` varchar(10) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `item_category_id` (`item_category_id`),
  KEY `issue_to` (`issue_to`),
  KEY `index_issue_date` (`issue_date`),
  KEY `index_return_date` (`return_date`),
  KEY `index_quantity` (`quantity`),
  KEY `index_is_returned` (`is_returned`),
  CONSTRAINT `item_issue_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_2` FOREIGN KEY (`item_category_id`) REFERENCES `item_category` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_issue_ibfk_3` FOREIGN KEY (`issue_to`) REFERENCES `staff` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `is_active`, `created_at`) VALUES (5, 3, 8, 'Super Admin', '2024-11-27', '2024-12-04', 2, 3, 0, '', 0, 'no', '2024-12-04 12:02:10');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `is_active`, `created_at`) VALUES (8, 1, 16, 'Super Admin', '2025-04-08', '2025-04-08', 1, 9, 0, '', 0, 'no', '2025-04-08 11:29:31');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `is_active`, `created_at`) VALUES (10, 4, 38, 'Super Admin', '2025-04-14', '2025-04-14', 4, 4, 0, '', 0, 'no', '2025-04-14 06:39:18');
INSERT INTO `item_issue` (`id`, `issue_type`, `issue_to`, `issue_by`, `issue_date`, `return_date`, `item_category_id`, `item_id`, `quantity`, `note`, `is_returned`, `is_active`, `created_at`) VALUES (11, 3, 8, 'Ajay Verma', '2025-04-14', '2025-04-15', 2, 3, 0, '', 0, 'no', '2025-04-15 05:18:19');


#
# TABLE STRUCTURE FOR: item_stock
#

DROP TABLE IF EXISTS `item_stock`;

CREATE TABLE `item_stock` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_id` int DEFAULT NULL,
  `supplier_id` int DEFAULT NULL,
  `symbol` varchar(10) NOT NULL DEFAULT '+',
  `store_id` int DEFAULT NULL,
  `quantity` int DEFAULT NULL,
  `purchase_price` float(10,2) DEFAULT '0.00',
  `date` date DEFAULT NULL,
  `attachment` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci,
  `description` text,
  `generated_by` int DEFAULT NULL,
  `is_active` varchar(10) DEFAULT 'yes',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `item_id` (`item_id`),
  KEY `supplier_id` (`supplier_id`),
  KEY `store_id` (`store_id`),
  KEY `index_quantity` (`quantity`),
  KEY `index_purchase_price` (`purchase_price`),
  KEY `index_date` (`date`),
  CONSTRAINT `item_stock_ibfk_1` FOREIGN KEY (`item_id`) REFERENCES `item` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_2` FOREIGN KEY (`supplier_id`) REFERENCES `item_supplier` (`id`) ON DELETE CASCADE,
  CONSTRAINT `item_stock_ibfk_3` FOREIGN KEY (`store_id`) REFERENCES `item_store` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (12, 3, 1, '+', 1, 11, '10.00', '2024-11-27', 'uploads/inventory_items/12.png', '', 1, 'yes', '2024-11-27 09:39:46');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (13, 3, 1, '+', 1, 100, '500.00', '2024-11-27', 'uploads/inventory_items/13.png', '', 1, 'yes', '2024-11-27 09:49:24');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (14, 3, 1, '+', 1, 3, '3.00', NULL, 'uploads/inventory_items/1732707774-1284531662674705be8e5ea!K (6).png', '', 1, 'yes', '2024-11-27 11:42:54');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (15, 6, 1, '+', NULL, 2, '20.00', '2024-12-04', 'uploads/inventory_items/1744799762-200672864367ff8812bf96d!2.JPG', 'hello', 1, 'yes', '2025-04-16 10:36:02');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (16, 9, 1, '+', 1, 2, '5.00', '2025-03-22', NULL, '', 1, 'yes', '2025-03-22 11:45:17');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (18, 9, 3, '+', 1, 50, '100.00', '2025-04-14', NULL, '', 1, 'yes', '2025-04-14 05:19:18');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (19, 4, 2, '+', 3, 15, '50.00', '2025-04-14', NULL, '', 1, 'yes', '2025-04-14 06:00:08');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (20, 3, 3, '+', 3, 2, '150.00', '2025-04-14', NULL, '', 2, 'yes', '2025-04-14 06:19:10');
INSERT INTO `item_stock` (`id`, `item_id`, `supplier_id`, `symbol`, `store_id`, `quantity`, `purchase_price`, `date`, `attachment`, `description`, `generated_by`, `is_active`, `created_at`) VALUES (21, 9, 1, '+', 1, 2, '20.00', '2025-04-16', NULL, '', 1, 'yes', '2025-04-16 10:35:35');


#
# TABLE STRUCTURE FOR: item_store
#

DROP TABLE IF EXISTS `item_store`;

CREATE TABLE `item_store` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_store` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_item_store` (`item_store`),
  KEY `index_code` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (1, 'hospital store', '12345', 'abelible', '2024-09-30 12:57:14');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (2, 'medicine store', '123', '', '2024-10-05 09:14:30');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (3, 'Medicine store', '123', 'abilable', '2024-11-20 08:12:57');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (4, 'Item store', '12', '', '2024-11-20 08:14:08');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (5, 'ant store', '', '', '2025-03-05 10:33:09');
INSERT INTO `item_store` (`id`, `item_store`, `code`, `description`, `created_at`) VALUES (9, 'name', '', '', '2025-04-17 12:24:23');


#
# TABLE STRUCTURE FOR: item_supplier
#

DROP TABLE IF EXISTS `item_supplier`;

CREATE TABLE `item_supplier` (
  `id` int NOT NULL AUTO_INCREMENT,
  `item_supplier` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `contact_person_name` varchar(255) NOT NULL,
  `contact_person_phone` varchar(255) NOT NULL,
  `contact_person_email` varchar(255) NOT NULL,
  `description` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `index_item_supplier` (`item_supplier`),
  KEY `index_phone` (`phone`),
  KEY `index_email` (`email`),
  KEY `index_address` (`address`),
  KEY `index_contact_person_name` (`contact_person_name`),
  KEY `index_contact_person_phone` (`contact_person_phone`),
  KEY `index_contact_person_email` (`contact_person_email`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (1, 'ashok supllier', '54566756567', '', '', '45756677867', '', '', '', '2024-09-30 12:57:48');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (2, 'pharma pvt. lmt', '78895789768', '', '', '413573567', '', '', '', '2024-10-05 09:17:28');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (3, 'Medicine pvt.lmt', '34675699', '', '', 'abhi', '354576458', '', '', '2024-11-20 08:21:04');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (5, 'name', '', '', '', '', '', '', '', '2025-04-17 12:25:26');
INSERT INTO `item_supplier` (`id`, `item_supplier`, `phone`, `email`, `address`, `contact_person_name`, `contact_person_phone`, `contact_person_email`, `description`, `created_at`) VALUES (6, 'supplier', '', '', 'jbp', '556556666', '', '', '', '2025-05-01 10:46:43');


#
# TABLE STRUCTURE FOR: lab
#

DROP TABLE IF EXISTS `lab`;

CREATE TABLE `lab` (
  `id` int NOT NULL AUTO_INCREMENT,
  `lab_name` varchar(100) DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3;

INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (1, 'X-Rays (Conventional Radiology)', '2024-09-27 11:41:12');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (2, 'Mastology (Mammography)', '2024-09-27 11:41:47');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (3, 'Angiography', '2024-09-27 11:42:10');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (4, 'CT Scan', '2024-09-27 11:42:33');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (5, 'M. R. C. P.', '2024-09-27 11:43:07');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (6, 'XRAY', '2024-10-08 10:55:25');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (8, 'Angioplasty', '2024-11-19 09:18:41');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (11, 'radiology', '2025-04-10 10:15:00');
INSERT INTO `lab` (`id`, `lab_name`, `created_at`) VALUES (13, ' radio name', '2025-04-17 11:46:29');


#
# TABLE STRUCTURE FOR: languages
#

DROP TABLE IF EXISTS `languages`;

CREATE TABLE `languages` (
  `id` int NOT NULL AUTO_INCREMENT,
  `language` varchar(50) DEFAULT NULL,
  `short_code` varchar(255) NOT NULL,
  `country_code` varchar(255) NOT NULL,
  `is_deleted` varchar(10) NOT NULL DEFAULT 'yes',
  `is_rtl` varchar(10) NOT NULL DEFAULT 'no',
  `is_active` varchar(255) DEFAULT 'no',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `updated_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `index_language` (`language`),
  KEY `index_short_code` (`short_code`),
  KEY `index_country_code` (`country_code`),
  KEY `index_is_deleted` (`is_deleted`),
  KEY `index_is_rtl` (`is_rtl`)
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8mb3;

INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (1, 'Azerbaijan', 'az', 'az', 'no', 'no', 'no', '2021-09-28 09:51:22', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (2, 'Albanian', 'sq', 'al', 'no', 'yes', 'no', '2025-04-19 09:47:50', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (3, 'Amharic', 'am', 'am', 'no', 'yes', 'no', '2025-04-19 09:47:46', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (4, 'English', 'en', 'us', 'no', 'no', 'no', '2025-03-08 07:25:03', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (5, 'Arabic', 'ar', 'sa', 'no', 'yes', 'no', '2025-04-19 09:47:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (6, 'Afrikaans', 'af', 'af', 'no', 'yes', 'no', '2025-04-19 11:04:55', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (7, 'Basque', 'eu', 'es', 'no', 'no', 'no', '2021-09-24 06:58:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (8, 'Bengali', 'bn', 'in', 'no', 'yes', 'no', '2025-04-19 09:47:03', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (9, 'Bosnian', 'bs', 'bs', 'no', 'no', 'no', '2021-09-24 06:58:28', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (10, 'Welsh', 'cy', 'cy', 'no', 'yes', 'no', '2024-12-06 11:15:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (11, 'Hungarian', 'hu', 'hu', 'no', 'no', 'no', '2021-09-24 06:58:35', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (12, 'Vietnamese', 'vi', 'vi', 'no', 'no', 'no', '2021-09-24 06:58:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (13, 'Haitian', 'ht', 'ht', 'no', 'no', 'no', '2021-09-24 06:58:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (14, 'Galician', 'gl', 'gl', 'no', 'no', 'no', '2021-09-24 06:58:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (15, 'Dutch', 'nl', 'nl', 'no', 'no', 'no', '2021-09-24 06:58:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (16, 'Greek', 'el', 'gr', 'no', 'no', 'no', '2021-09-24 06:58:53', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (17, 'Georgian', 'ka', 'ge', 'no', 'no', 'no', '2021-09-24 06:58:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (18, 'Gujarati', 'gu', 'in', 'no', 'no', 'no', '2021-09-24 06:58:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (19, 'Danish', 'da', 'dk', 'no', 'no', 'no', '2021-09-24 06:59:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (20, 'Hebrew', 'he', 'il', 'no', 'no', 'no', '2021-09-24 06:59:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (21, 'Yiddish', 'yi', 'il', 'no', 'no', 'no', '2021-09-24 06:59:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (22, 'Indonesian', 'id', 'id', 'no', 'no', 'no', '2021-09-24 06:59:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (23, 'Irish', 'ga', 'ga', 'no', 'no', 'no', '2021-09-24 06:59:14', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (24, 'Italian', 'it', 'it', 'no', 'no', 'no', '2021-09-24 06:59:17', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (25, 'Icelandic', 'is', 'is', 'no', 'no', 'no', '2021-09-24 06:59:20', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (26, 'Spanish', 'es', 'es', 'no', 'no', 'no', '2021-09-24 06:59:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (27, 'Kannada', 'kn', 'kn', 'no', 'no', 'no', '2021-09-24 06:59:32', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (28, 'Catalan', 'ca', 'ca', 'no', 'no', 'no', '2021-09-24 06:59:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (29, 'Chinese', 'zh', 'cn', 'no', 'no', 'no', '2021-09-24 06:59:36', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (30, 'Korean', 'ko', 'kr', 'no', 'no', 'no', '2021-09-24 06:59:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (31, 'Xhosa', 'xh', 'ls', 'no', 'no', 'no', '2021-09-24 06:59:42', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (32, 'Latin', 'la', 'la', 'no', 'no', 'no', '2021-09-24 06:59:45', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (33, 'Latvian', 'lv', 'lv', 'no', 'no', 'no', '2021-09-24 06:59:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (34, 'Lithuanian', 'lt', 'lt', 'no', 'no', 'no', '2021-09-24 06:59:50', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (35, 'Malagasy', 'mg', 'mg', 'no', 'no', 'no', '2021-09-24 06:59:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (36, 'Malay', 'ms', 'ms', 'no', 'no', 'no', '2021-09-24 07:00:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (37, 'Malayalam', 'ml', 'ml', 'no', 'no', 'no', '2021-09-24 07:00:05', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (38, 'Maltese', 'mt', 'mt', 'no', 'no', 'no', '2021-09-24 07:00:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (39, 'Macedonian', 'mk', 'mk', 'no', 'no', 'no', '2021-09-24 07:00:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (40, 'Maori', 'mi', 'nz', 'no', 'no', 'no', '2021-09-24 07:00:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (41, 'Marathi', 'mr', 'in', 'no', 'no', 'no', '2021-09-24 07:00:51', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (42, 'Mongolian', 'mn', 'mn', 'no', 'no', 'no', '2021-09-24 07:01:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (43, 'German', 'de', 'de', 'no', 'no', 'no', '2021-09-24 07:01:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (44, 'Nepali', 'ne', 'ne', 'no', 'no', 'no', '2021-09-24 07:01:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (45, 'Norwegian', 'no', 'no', 'no', 'no', 'no', '2021-09-24 07:01:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (46, 'Punjabi', 'pa', 'in', 'no', 'no', 'no', '2021-09-24 07:01:43', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (47, 'Persian', 'fa', 'ir', 'no', 'no', 'no', '2021-09-24 07:01:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (48, 'Portuguese', 'pt', 'pt', 'no', 'no', 'no', '2021-09-24 07:01:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (49, 'Romanian', 'ro', 'ro', 'no', 'no', 'no', '2021-09-24 07:01:56', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (50, 'Russian', 'ru', 'ru', 'no', 'no', 'no', '2021-09-24 07:01:59', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (51, 'Cebuano', 'ceb', 'ph', 'no', 'no', 'no', '2021-09-24 07:02:02', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (52, 'Sinhala', 'si', 'si', 'no', 'no', 'no', '2021-09-24 07:02:04', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (53, 'Slovakian', 'sk', 'sk', 'no', 'no', 'no', '2021-09-24 07:02:07', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (54, 'Slovenian', 'sl', 'sl', 'no', 'no', 'no', '2021-09-24 07:02:10', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (55, 'Swahili', 'sw', 'ke', 'no', 'no', 'no', '2021-09-24 07:02:12', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (56, 'Sundanese', 'su', 'sd', 'no', 'no', 'no', '2021-09-24 07:02:15', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (57, 'Thai', 'th', 'th', 'no', 'no', 'no', '2021-09-24 07:02:18', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (58, 'Tagalog', 'tl', 'tl', 'no', 'no', 'no', '2021-09-24 07:02:21', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (59, 'Tamil', 'ta', 'in', 'no', 'no', 'no', '2021-09-24 07:02:23', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (60, 'Telugu', 'te', 'in', 'no', 'no', 'no', '2021-09-24 07:02:26', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (61, 'Turkish', 'tr', 'tr', 'no', 'no', 'no', '2021-09-24 07:02:29', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (62, 'Uzbek', 'uz', 'uz', 'no', 'no', 'no', '2021-09-24 07:02:31', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (63, 'Urdu', 'ur', 'pk', 'no', 'no', 'no', '2021-09-24 07:02:34', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (64, 'Finnish', 'fi', 'fi', 'no', 'no', 'no', '2021-09-24 07:02:37', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (65, 'French', 'fr', 'fr', 'no', 'no', 'no', '2021-09-24 07:02:39', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (66, 'Hindi', 'hi', 'in', 'no', 'no', 'no', '2024-12-05 11:09:38', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (67, 'Czech', 'cs', 'cz', 'no', 'no', 'no', '2021-09-24 07:02:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (68, 'Swedish', 'sv', 'sv', 'no', 'no', 'no', '2021-09-24 07:02:46', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (69, 'Scottish', 'gd', 'gd', 'no', 'no', 'no', '2021-09-24 07:02:49', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (70, 'Estonian', 'et', 'et', 'no', 'no', 'no', '2021-09-24 07:02:52', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (71, 'Esperanto', 'eo', 'br', 'no', 'no', 'no', '2021-09-24 07:02:55', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (72, 'Javanese', 'jv', 'id', 'no', 'no', 'no', '2021-09-24 07:02:58', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (73, 'Japanese', 'ja', 'jp', 'no', 'no', 'no', '2021-09-24 07:03:01', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (74, 'Polish', 'pl', 'pl', 'no', 'no', 'no', '2021-09-28 06:39:06', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (75, 'Croatia', 'hr', 'hr', 'no', 'no', 'no', '2021-10-25 07:56:41', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (76, 'Kurdish', 'ku', 'iq', 'no', 'no', 'no', '2021-10-25 07:56:44', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (77, 'Lao', 'lo', 'la', 'no', 'no', 'no', '2021-10-25 07:56:47', NULL);
INSERT INTO `languages` (`id`, `language`, `short_code`, `country_code`, `is_deleted`, `is_rtl`, `is_active`, `created_at`, `updated_at`) VALUES (78, 'chines', 'ch', 'ch', 'yes', 'no', 'no', '2024-10-15 07:22:01', NULL);


#
# TABLE STRUCTURE FOR: leave_types
#

DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(200) NOT NULL,
  `is_active` varchar(50) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;

INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (2, 'Casual', 'yes', '2024-09-26 07:19:26');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (3, 'deparmental leave', 'yes', '2024-09-30 11:07:26');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (4, 'mendetary leave', 'yes', '2024-09-30 11:17:25');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (5, 'meternity leave', 'yes', '2024-10-07 12:09:31');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (6, 'Sick leave', 'yes', '2024-10-11 10:26:23');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (7, 'Medical', 'yes', '2024-11-19 12:36:53');
INSERT INTO `leave_types` (`id`, `type`, `is_active`, `created_at`) VALUES (11, 'leave', 'yes', '2025-04-17 12:15:23');


#
# TABLE STRUCTURE FOR: logs
#

DROP TABLE IF EXISTS `logs`;

CREATE TABLE `logs` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message` text,
  `record_id` int NOT NULL,
  `user_id` int DEFAULT NULL,
  `action` varchar(50) NOT NULL,
  `ip_address` varchar(50) NOT NULL,
  `platform` varchar(50) NOT NULL,
  `agent` varchar(50) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13812 DEFAULT CHARSET=utf8mb3;

INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (1, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 05:34:50', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (2, 'Record updated For Menu Item id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 05:35:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (3, 'Record deleted On Front Cms Page Contents id 1', 1, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 07:07:17', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (4, 'Record updated On Front Cms Pages id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 07:07:17', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (5, 'New Record inserted On Charge Units id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (6, 'New Record inserted On Charge Units id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:26', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (7, 'New Record inserted On Charge Units id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:33', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (8, 'New Record inserted On Charge Units id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (9, 'New Record inserted On Charge Units id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:40', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (10, 'New Record inserted On Charge Units id 6', 6, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:07:46', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (11, 'New Record inserted On Tax Category id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:08:06', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (12, 'New Record inserted On Tax Category id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:08:16', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (13, 'New Record inserted On Charge Categories id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:08:43', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (14, 'New Record inserted On Charge Categories id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:09:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (15, 'New Record inserted On Charge Categories id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:09:09', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (16, 'New Record inserted On Charge Categories id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:09:22', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (17, 'New Record inserted On Charge Categories id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:09:35', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (18, 'New Record inserted For Organisation id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:11:03', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (19, 'New Record inserted For Organisation id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:11:17', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (20, 'Record updated On Tax Category id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:12:26', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (21, 'Record updated On Tax Category id 1', 1, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:13:08', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (22, 'New Record inserted On Global Shift id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:15:31', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (23, 'New Record inserted On Global Shift id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:15:57', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (24, 'New Record inserted On Specialist id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:16:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (25, 'New Record inserted On Specialist id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:16:47', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (26, 'New Record inserted On Specialist id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:16:59', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (27, 'New Record inserted On Specialist id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:17:22', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (28, 'New Record inserted On Staff Designation id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:17:33', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (29, 'New Record inserted On Staff Designation id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:17:40', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (30, 'New Record inserted On Staff Designation id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:17:49', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (31, 'New Record inserted On Staff Designation id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (32, 'New Record inserted On Staff Designation id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:08', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (33, 'New Record inserted On Staff Designation id 6', 6, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:26', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (34, 'New Record inserted On Department id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:39', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (35, 'New Record inserted On Department id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:45', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (36, 'New Record inserted On Department id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:18:53', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (37, 'New Record inserted On Department id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:19:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (38, 'New Record inserted On Department id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:19:08', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (39, 'New Record inserted On Leave Types id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:19:20', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (40, 'New Record inserted On Leave Types id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:19:26', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (41, 'Record updated For Staff id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:28:19', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (42, 'Record updated For Staff id 3', 3, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:29:52', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (43, 'New Record inserted On Shift Details id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:30:33', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (44, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:30:45', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (45, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:30:56', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (46, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:31:05', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (47, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:31:17', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (48, 'Record updated On Shift Details id 2', 2, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:31:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (49, 'New Record inserted On Patient id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:36:51', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (50, 'Record updated On Patient id 1', 1, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:36:51', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (51, 'New Record inserted On Appointment Created 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:37:05', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (52, 'New Record inserted On Ambulance id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:39:39', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (53, 'New Record inserted On Ambulance id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:40:09', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (54, 'New Record inserted On Transactions id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:40:24', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (55, 'New Record inserted For Blood Donor id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:47:57', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (56, 'New Record inserted For Blood Donor id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:18', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (57, 'New Record inserted On Read System Notification id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (58, 'New Record inserted On Read System Notification id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:27', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (59, 'New Record inserted On Read System Notification id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:28', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (60, 'New Record inserted On Read System Notification id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:48:32', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (61, 'New Record inserted For Blood Donor id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (62, 'New Record inserted On Blood Donor  id 1', 1, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:31', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (63, 'New Record inserted On Transactions id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:31', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (64, 'New Record inserted On Blood Donor  id 2', 2, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:50', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (65, 'New Record inserted On Transactions id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:49:50', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (66, 'New Record inserted On Blood Donor  id 3', 3, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:13', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (67, 'New Record inserted On Transactions id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:13', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (68, 'New Record inserted On Blood Donor  id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (69, 'New Record inserted On Transactions id 6', 6, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:37', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (70, 'New Record inserted On Blood Donor  id 5', 5, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:59', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (71, 'New Record inserted On Transactions id 7', 7, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:50:59', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (72, 'New Record inserted On Transactions id 8', 8, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:51:28', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (73, 'New Record inserted On Blood Donor  id 6', 6, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:53:05', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (74, 'New Record inserted On Blood Donor  id 7', 7, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:53:05', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (75, 'New Record inserted On Transactions id 9', 9, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 07:53:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (76, 'Record updated On Settings id 1', 1, 0, 'Update', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 08:03:43', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (77, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 08:09:54', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (78, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 08:10:16', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (79, 'New Record inserted For Blood Donor id 4', 4, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 13:43:32', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (80, 'New Record inserted On Blood Donor  id 8', 8, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 13:44:39', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (81, 'New Record inserted On Transactions id 10', 10, 0, 'Insert', '1.22.246.241', 'Windows 10', 'Firefox 130.0', '2024-09-26 13:44:39', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (82, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 09:28:45', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (83, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 09:30:55', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (84, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 09:37:12', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (85, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:13:20', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (86, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:13:34', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (87, 'New Record inserted On Patient id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:22:58', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (88, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:22:58', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (89, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:24:19', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (90, 'New Record inserted On Transactions id 11', 11, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:24:19', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (91, 'New Record inserted On Read System Notification id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:37:59', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (92, 'New Record inserted On Read System Notification id 6', 6, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:38:01', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (93, 'New Record inserted On Read System Notification id 7', 7, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:38:04', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (94, 'New Record inserted On Read System Notification id 8', 8, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:38:13', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (95, 'New Record inserted On Read System Notification id 9', 9, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:38:15', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (96, 'Record updatedOn Appointment Updated 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 15:41:48', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (97, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:08:06', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (98, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:12:04', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (99, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:13:02', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (100, 'New Record inserted On Read System Notification id 10', 10, 0, 'Insert', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:13:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (101, 'New Record inserted On Read System Notification id 11', 11, 0, 'Insert', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:13:37', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (102, 'New Record inserted On Read System Notification id 12', 12, 0, 'Insert', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-26 17:14:11', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (103, 'New Record inserted On Floor id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:30:24', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (104, 'New Record inserted On Bed Group id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:30:46', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (105, 'New Record inserted On Bed id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:31:09', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (106, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:32:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (107, 'New Record inserted On IPD id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:32:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (108, 'Record updated On Bed id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:32:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (109, 'New Record inserted On Patient bed history id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:32:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (110, 'New Record inserted On Medicine Category id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:34:41', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (111, 'New Record inserted On Medicine Supplier id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:36:00', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (112, 'New Record inserted On Unit id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:02', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (113, 'New Record inserted On Unit id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:14', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (114, 'New Record inserted On Unit id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (115, 'New Record inserted On Dose Interval id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:36', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (116, 'New Record inserted On Medicine Dosage id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:37:54', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (117, 'New Record inserted On Company id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:38:10', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (118, 'New Record inserted On medicine group id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:38:53', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (119, 'New Record inserted On Dose Duration id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 17:46:40', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (120, 'Record updated For Staff id 2', 2, 0, 'Update', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:08:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (121, 'Record updated For Staff id 2', 2, 0, 'Update', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:08:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (122, 'Record updated For Staff id 2', 2, 0, 'Update', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:08:25', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (123, 'New Record inserted On Staff Attendance id 1', 1, 0, 'Insert', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:17:15', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (124, 'New Record inserted On Staff Attendance id 2', 2, 0, 'Insert', '1.22.246.70', 'Windows 10', 'Firefox 130.0', '2024-09-26 18:17:15', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (125, 'Record updated On Transactions id 11', 11, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 18:33:41', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (126, 'Record updated On Visit Details id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 18:33:41', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (127, 'New Record inserted On Pharmacy id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 18:35:58', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (128, 'New Record inserted On Ipd Prescription Basic id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-26 18:36:21', '2024-09-26');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (129, 'New Record inserted On Duty Roster Shift id1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:26:13', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (130, 'New Record inserted On Duty Roster Shift id2', 2, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:26:48', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (131, 'New Record inserted On Duty Roster Shift id3', 3, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:27:18', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (132, 'New Record inserted On Duty Roster Shift id1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:27:46', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (133, 'New Record inserted On Duty Roster Shift id2', 2, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:27:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (134, 'New Record inserted On duty_roster_assign id1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (135, 'New Record inserted On duty_roster_assign id2', 2, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (136, 'New Record inserted On duty_roster_assign id3', 3, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (137, 'New Record inserted On duty_roster_assign id4', 4, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (138, 'New Record inserted On duty_roster_assign id5', 5, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (139, 'New Record inserted On duty_roster_assign id6', 6, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (140, 'New Record inserted On duty_roster_assign id7', 7, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 10:45:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (141, 'Record updated On Patient id card id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:21:39', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (142, 'Record updated On Staff id card id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:22:04', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (143, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:24:10', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (144, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:24:15', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (145, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 13:26:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (146, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 14:09:09', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (147, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 14:33:13', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (148, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 14:33:46', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (149, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 14:41:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (150, 'New Record inserted On Global Shift id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:45:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (151, 'New Record inserted On Global Shift id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:45:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (152, 'New Record inserted On Global Shift id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:47:41', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (153, 'Record updated On Shift Details id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:48:20', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (154, 'Record updated On Shift Details id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:52:30', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (155, 'New Record inserted On Appointment Created 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 14:59:15', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (156, 'New Record inserted On Staff Timeline id 1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:00:09', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (157, 'Record updated On Staff Timeline id 1', 1, 0, 'Update', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:00:09', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (158, 'New Record inserted On Appointment Created 3', 3, 0, 'Insert', '171.60.162.80', 'Android', 'Chrome 124.0.0.0', '2024-09-27 15:16:06', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (159, 'Record deleted On Appointment Deleted id 2', 2, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:17:32', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (160, 'Record updatedOn Appointment Updated 3', 3, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:17:56', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (161, 'New Record inserted On Transactions id 14', 14, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:18:41', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (162, 'New Record inserted On  holiday master  id 1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:19:09', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (163, 'New Record inserted On  holiday master  id 2', 2, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:19:39', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (164, 'Record updated On Transactions id 14', 14, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:20:01', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (165, 'Record updated On Visit Details id 5', 5, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:20:01', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (166, 'New Record inserted On Pathology Category id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:22:25', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (167, 'New Record inserted On Pathology Category id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:22:40', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (168, 'New Record inserted On Pathology Category id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:23:01', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (169, 'New Record inserted On Unit id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:24:36', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (170, 'New Record inserted On Pathology Parameter id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:26:16', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (171, 'New Record inserted On Pathology Parameter id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:28:02', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (172, 'New Record inserted On Ipd Prescription Basic id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 15:41:54', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (173, 'New Record inserted On Read System Notification id 13', 13, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 16:46:53', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (174, 'New Record inserted On Charge Categories id 6', 6, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 16:51:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (175, 'New Record inserted On pathology Test id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 16:53:57', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (176, 'New Record inserted On pathology Test id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 16:55:06', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (177, 'New Record inserted On pathology Test id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:02:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (178, 'Record deleted On  Pathology Test  id 1', 1, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:02:25', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (179, 'New Record inserted On Lab id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:11:12', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (180, 'New Record inserted On Lab id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:11:47', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (181, 'New Record inserted On Lab id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:12:10', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (182, 'New Record inserted On Lab id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:12:33', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (183, 'New Record inserted On Lab id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:13:07', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (184, 'New Record inserted On Unit id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:13:55', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (185, 'New Record inserted On Unit id 6', 6, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:14:03', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (186, 'Record updated On Unit id 6', 6, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:14:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (187, 'Record deleted On Unit id 6', 6, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:14:19', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (188, 'New Record inserted On Unit id 7', 7, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:14:42', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (189, 'New Record inserted On Unit id 8', 8, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:15:16', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (190, 'New Record inserted On Radiology Parameter id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:16:45', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (191, 'New Record inserted On Radiology Parameter id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:17:15', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (192, 'New Record inserted On Charge Categories id 7', 7, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:23:40', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (193, 'New Record inserted On Tax Category id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:25:46', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (194, 'New Record inserted On Radio id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:35:35', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (195, 'New Record inserted On Radiology Billing id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:38:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (196, 'New Record inserted On Transactions id 15', 15, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:38:14', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (197, 'New Record inserted On Blood Donor  id 9', 9, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:42:41', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (198, 'New Record inserted On Transactions id 16', 16, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:42:41', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (199, 'New Record inserted On Blood Donor  id 10', 10, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:43:44', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (200, 'New Record inserted On Blood Donor  id 11', 11, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:43:44', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (201, 'New Record inserted On Payment Settings id 1', 1, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:50:42', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (202, 'New Record inserted On Transactions id 17', 17, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:52:58', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (203, 'Record deleted On Transactions id 17', 17, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:53:25', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (204, 'New Record inserted On Transactions id 18', 18, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:54:36', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (205, 'Record updated On Transactions id 14', 14, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:57:22', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (206, 'Record updated On Visit Details id 5', 5, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:57:23', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (207, 'New Record inserted On Transactions id 19', 19, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:57:40', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (208, 'New Record inserted On Visit Details id 6', 6, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:57:40', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (209, 'New Record inserted On Ipd Prescription Basic id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:58:04', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (210, 'Record updated On Transactions id 19', 19, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:58:18', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (211, 'Record updated On Visit Details id 6', 6, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 17:58:18', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (212, 'New Record inserted On Staff Attendance id 3', 3, 0, 'Insert', '1.22.246.1', 'Windows 10', 'Firefox 130.0', '2024-09-27 18:06:47', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (213, 'New Record inserted On Transactions id 20', 20, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:14:45', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (214, 'Record deleted On Transactions id 18', 18, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:14:49', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (215, 'Record deleted On Transactions id 20', 20, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:14:52', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (216, 'New Record inserted On Transactions id 21', 21, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:15:01', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (217, 'New Record inserted On Transactions id 22', 22, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-27 18:24:05', '2024-09-27');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (218, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:39:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (219, 'New Record inserted On Transactions id 23', 23, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:39:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (220, 'New Record inserted On Ipd Prescription Basic id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:41:02', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (221, 'Record updated On Transactions id 23', 23, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:42:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (222, 'Record updated On Visit Details id 7', 7, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:42:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (223, 'Record deleted On  OPD  id 6', 6, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:42:43', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (224, 'New Record inserted On Transactions id 24', 24, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:43:50', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (225, 'Record updated On Patient id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:43:50', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (226, 'New Record inserted On Radiology Billing id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:53:22', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (227, 'New Record inserted On Transactions id 25', 25, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 12:53:22', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (228, 'New Record inserted On Transactions id 26', 26, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:16', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (229, 'New Record inserted On Visit Details id 9', 9, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:16', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (230, 'New Record inserted On Ipd Prescription Basic id 5', 5, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (231, 'Record updated On Transactions id 26', 26, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:57', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (232, 'Record updated On Visit Details id 9', 9, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:00:57', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (233, 'New Record inserted On Medication Report id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:01:27', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (234, 'Record updated On Radiology Billing id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:12:49', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (235, 'New Record inserted On Medication Report id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:17:43', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (236, 'Record updated On Medication Report id 2', 2, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:17:56', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (237, 'Record deleted On  Medication Report  id 2', 2, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:18:21', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (238, 'New Record inserted On  content_types id 1', 1, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (239, 'New Record inserted On operation_category id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:26', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (240, 'New Record inserted On  upload_contents id 1', 1, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (241, 'New Record inserted On  upload_contents id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (242, 'New Record inserted On operation_category id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:21:55', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (243, 'New Record inserted On operation_category id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:09', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (244, 'New Record inserted On  upload_contents id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:11', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (245, 'Record deleted On upload_contents id 1', 1, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (246, 'Record deleted On upload_contents id 1', 1, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:21', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (247, 'Record deleted On upload_contents id 2', 2, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:26', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (248, 'Record deleted On upload_contents id 2', 2, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (249, 'New Record inserted On operation_category id 4', 4, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:22:34', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (250, 'New Record inserted On Operation id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:24:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (251, 'New Record inserted On Operation id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:24:45', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (252, 'New Record inserted On Operation id 3', 3, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:25:29', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (253, 'New Record inserted On Operation Theatre id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:26:15', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (254, 'Record updated On Operation Theatre id 1', 1, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:26:46', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (255, 'Record deleted On  Operation Theatre  id 1', 1, 0, 'Delete', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:26:51', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (256, 'New Record inserted On Operation Theatre id 2', 2, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:27:07', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (257, 'Record updated On Patient Charges id 8', 8, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:27:31', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (258, 'Record updated On Patient Charges id 8', 8, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:27:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (259, 'Record updated On Transactions id 24', 24, 0, 'Update', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:28:16', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (260, 'Record updated For Staff id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:28:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (261, 'Record updated For Staff id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:28:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (262, 'Record updated For Staff id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:28:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (263, 'Record updated On QR Attendance settings id 1', 1, 0, 'Update', '152.58.57.96', 'Android', 'Chrome 128.0.0.0', '2024-09-28 13:29:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (264, 'New Record inserted On Patient Timeline id 1', 1, 0, 'Insert', '171.60.162.80', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:31:36', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (265, 'New Record inserted On Bed Group id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:36:06', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (266, 'New Record inserted On Floor id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:36:17', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (267, 'New Record inserted On Bed Group id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:36:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (268, 'New Record inserted On Bed id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:37:01', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (269, 'New Record inserted On Bed id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:37:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (270, 'New Record inserted On Patient id 3', 3, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:11', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (271, 'Record updated On Patient id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:11', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (272, 'Record updated On Patient id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (273, 'New Record inserted On IPD id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (274, 'Record updated On Bed id 3', 3, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (275, 'New Record inserted On Patient bed history id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:38:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (276, 'New Record inserted On Custom Fields id 1', 1, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:39:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (277, 'Record updated On Custom Field Values id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:41:07', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (278, 'New Record inserted On Custom Fields id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:42:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (279, 'Record updated On Custom Fields id 2', 2, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:43:06', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (280, 'Record updated On Custom Field Values id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:43:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (281, 'New Record inserted On Custom Field Values id 2', 2, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 13:43:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (282, 'New Record inserted On  upload_contents id 4', 4, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:28:40', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (283, 'New Record inserted On  upload_contents id 5', 5, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:30:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (284, 'Record deleted On upload_contents id 5', 5, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:32:54', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (285, 'Record deleted On upload_contents id 4', 4, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:34:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (286, 'New Record inserted On  upload_contents id 6', 6, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:34:57', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (287, 'Record deleted On upload_contents id 6', 6, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:35:49', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (288, 'New Record inserted On  upload_contents id 7', 7, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:09', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (289, 'New Record inserted On  upload_contents id 8', 8, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (290, 'New Record inserted On  upload_contents id 9', 9, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:17', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (291, 'New Record inserted On  upload_contents id 10', 10, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:25', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (292, 'New Record inserted On  upload_contents id 11', 11, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:36:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (293, 'Record deleted On upload_contents id 11', 11, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (294, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:15', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (295, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:17', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (296, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (297, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:18', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (298, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (299, 'Record deleted On upload_contents id 10', 10, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:40:19', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (300, 'Record deleted On upload_contents id 9', 9, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:44:41', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (301, 'Record deleted On upload_contents id 8', 8, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:44:46', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (302, 'Record deleted On upload_contents id 7', 7, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:48:15', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (303, 'New Record inserted On  upload_contents id 12', 12, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (304, 'New Record inserted On  upload_contents id 13', 13, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:29', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (305, 'New Record inserted On  upload_contents id 14', 14, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:32', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (306, 'New Record inserted On  upload_contents id 15', 15, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:36', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (307, 'New Record inserted On  upload_contents id 16', 16, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:42', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (308, 'New Record inserted On  upload_contents id 17', 17, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:46', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (309, 'New Record inserted On  upload_contents id 18', 18, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:50:52', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (310, 'Record deleted On upload_contents id 15', 15, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:53:43', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (311, 'Record deleted On upload_contents id 16', 16, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:54:37', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (312, 'New Record inserted On  upload_contents id 19', 19, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:54:58', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (313, 'New Record inserted On  upload_contents id 20', 20, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:55:01', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (314, 'New Record inserted On  upload_contents id 21', 21, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:55:45', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (315, 'New Record inserted On  upload_contents id 22', 22, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:55:51', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (316, 'New Record inserted On  upload_contents id 23', 23, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:56:00', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (317, 'Record deleted On upload_contents id 20', 20, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:56:07', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (318, 'New Record inserted On  upload_contents id 24', 24, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:56:27', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (319, 'Record updated On Patient Timeline id 1', 1, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:57:08', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (320, 'Record updated On Transactions id 24', 24, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:57:35', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (321, 'Record updated On Visit Details id 8', 8, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:57:35', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (322, 'Record deleted On upload_contents id 24', 24, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:59:45', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (323, 'Record deleted On upload_contents id 22', 22, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 14:59:53', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (324, 'New Record inserted On  upload_contents id 25', 25, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:00', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (325, 'New Record inserted On  upload_contents id 26', 26, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:05', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (326, 'New Record inserted On  upload_contents id 27', 27, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:08', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (327, 'New Record inserted On  upload_contents id 28', 28, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:12', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (328, 'New Record inserted On  upload_contents id 29', 29, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:17', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (329, 'New Record inserted On  upload_contents id 30', 30, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:22', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (330, 'Record updated On Transactions id 24', 24, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (331, 'Record updated On Visit Details id 8', 8, 0, 'Update', '27.57.136.37', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:23', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (332, 'New Record inserted On  upload_contents id 31', 31, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:26', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (333, 'New Record inserted On  upload_contents id 32', 32, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:30', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (334, 'New Record inserted On  upload_contents id 33', 33, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:34', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (335, 'New Record inserted On  upload_contents id 34', 34, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:39', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (336, 'New Record inserted On  upload_contents id 35', 35, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:44', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (337, 'Record deleted On upload_contents id 26', 26, 0, 'Delete', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:02:54', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (338, 'Record updated On Front Cms Settings id 1', 1, 0, 'Update', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:03:09', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (339, 'New Record inserted On  upload_contents id 36', 36, 0, 'Insert', '1.22.246.120', 'Windows 10', 'Chrome 129.0.0.0', '2024-09-28 15:03:36', '2024-09-28');
INSERT INTO `logs` (`id`, `message`, `record_id`, `user_id`, `action`, `ip_address`, `platform`, `agent`, `time`, `created_at`) VALUES (340, 'Record updated On Radiology 